/* ====================================================================
 *      :	RenderSystem.h
 *      :	Ӻ긮 ׷ Wrapping̸鼭   
 *    :	̹
 *    :	2006.12
 * 
 * ǻ :	
 * =================================================================== */

#pragma once

#include "Renderer.h"

class cAppWindow;
//class cShaderHelper;
class cFontAgent;
class cLightAgent;
class cFogAgent;
class cSceneManager;

class cBrightShader;

const unsigned int DEFAULT_WIDTH = 1024;
const unsigned int DEFAULT_HEIGHT = 768;
const unsigned int DEFAULT_BPP = 32;


class cPostProcess
{
public:
	cPostProcess();
	~cPostProcess();

	bool Init( cRenderer* r );
	void Recreate( cRenderer* r, unsigned int width, unsigned int height, unsigned char bpp );

	void Render( cRenderer* r );

	inline NiRenderTargetGroup* GetRenderTarget() { return mpRenderTargetGroup; }

protected:
	void RenderImmediate( cRenderer* r );

protected:

	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration;
	LPDIRECT3DVERTEXBUFFER9 mPosCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 mTexCoordBuffer;

	NiRenderedTexturePtr	mpRenderedTexture;
	NiRenderTargetGroupPtr	mpRenderTargetGroup;

public:
	cBrightShader* mShader;
};

///  ý
class cRenderSystem
{
	static cRenderSystem* mpSingleton;

public:
	/// ü 
	static cRenderSystem* GetSingleton();

public:
	cRenderSystem( cAppWindow* pwindow );
	~cRenderSystem();

	///  ɼ
	struct sRenderOption
	{
		/// Window Width Height
		unsigned int						Width;
		unsigned int						Height;
		unsigned int						Bpp;

		/// Gamebryo Option
		unsigned int						Flags;

		/// ׷ ī
		unsigned int						Adapter;

		/// ̽ ɼ
		NiDX9Renderer::DeviceDesc			DevDesc;

		///  
		NiDX9Renderer::FrameBufferFormat	FBformat;

		/// Depth Stencil 
		NiDX9Renderer::DepthStencilFormat	DSformat;

		/// 
		NiDX9Renderer::PresentationInterval Interval;

		///
		NiDX9Renderer::SwapEffect			Swapeffect;

		///  
		NiDX9Renderer::FramebufferMode		FBmode;

		/// 
		unsigned int						Backbuffercount;

		/// 
		unsigned int						Refreshrate;

		sRenderOption()
		{
			Width				= 1024;	//= 1280;
			Height				= 768;	//= 1024;
			Bpp					= 32;

			Flags				= NiDX9Renderer::USE_FULLSCREEN | NiDX9Renderer::USE_STENCIL | NiDX9Renderer::USE_MULTITHREADED;

			Adapter				= D3DADAPTER_DEFAULT;
			DevDesc				= NiDX9Renderer::DEVDESC_PURE;
			FBformat			= NiDX9Renderer::FBFMT_X8R8G8B8;
			DSformat			= NiDX9Renderer::DSFMT_D24S8;
			Interval			= NiDX9Renderer::PRESENT_INTERVAL_IMMEDIATE;
			Swapeffect			= NiDX9Renderer::SWAPEFFECT_DEFAULT;
			FBmode				= NiDX9Renderer::FBMODE_DEFAULT;
//			FBmode				= NiDX9Renderer::FBMODE_MULTISAMPLES_4;
			Backbuffercount		= 1;
			Refreshrate			= NiDX9Renderer::REFRESHRATE_DEFAULT;
		}
	};

	/// ʱȭ
	bool	Init();

	/// 
	void	Exit();

	void RenderOnce( NiTexture* tex );

	///  ǥ
	void	Render();

	/// ɼ    ġ 
	bool	Reset( unsigned int width, unsigned int height, unsigned char bpp, bool winmode );

	/// ġ ҽǿ  ó ƾ
	void Invalidate();
	void Restore();

	inline void	SetClearColor( NiColor color ) { mClearColor = color; }

	/// ũ    ɼ 
	void			ToggleFullScreenMode();

	/// 
	cRenderer* GetRenderer() const;

	/// ɼ  Լ
	inline sRenderOption*			GetOption()			{ return &mRenderOption; }
	inline unsigned int				GetScreenWidth()	{ return mRenderOption.Width; }
	inline unsigned int				GetScreenHeight()	{ return mRenderOption.Height; }

	inline tArray<void*>*			GetResolutionArr() { return &mResolutionArr; };
	inline NiDX9AdapterDesc::ModeDesc* GetCurrentMode() { return mCurrentMode; }
	inline NiDX9AdapterDesc*	GetCurrentAdapter() { return mCurrentAdapter; }

	/// ũ 尪 üũ
	inline const bool				IsFullScreenMode()	{ return (mRenderOption.Flags & NiDX9Renderer::USE_FULLSCREEN)? true:false; }

	///  ڵ ȹѴ.
	HWND GetHWND();

	/// ̴
	//NiShader* GetShadowShader();

	bool mReCreateContinue;

	void SetWorldRendering( bool set ) { mWorldRendering = set; }

	void SetBrightness( float br );

	/// post process
protected:

	cPostProcess*				mPostProcess;

private:
	/// Ӻ긮  Ѵ.
	bool CreateRenderer();

	/// ġ  
	bool EnumAdapters();
	void EnumResolutions( unsigned int curWidth, unsigned int curheight, unsigned int curBpp, bool windowed );
	void EnumMultisamples();

private:

	///  ɼ
	sRenderOption mRenderOption;

	/// 
	cRendererPtr mRenderer;

	///   
	cAppWindow* mpWindowRef;

	/// Font 
	cFontAgent* mpFontAgent;

	/// Ʈ 
	cLightAgent* mpLightAgent;

	/// Ȱ 
	cFogAgent* mpFogAgent;

	/// ̴
	//cShaderHelper* mpShaderHelper;
	//NiShaderPtr mShadowShader;

	NiColor		mClearColor;


	/// ġ  
	typedef tArray<void*>	cArray;

	/// adapter and device
	cArray	mAdapterArr;
	NiDX9AdapterDesc*	mCurrentAdapter;
	NiDX9DeviceDesc*	mCurrentDevice;

	/// mode
	cArray	mResolutionArr;
	NiDX9AdapterDesc::ModeDesc*	mCurrentMode;

	/// multi sample
	cArray	mMultisampleArr;

	bool mWorldRendering;

};

inline
cRenderer* cRenderSystem::GetRenderer() const
{
	return mRenderer;
}

//inline
//NiShader* cRenderSystem::GetShadowShader()
//{
//	return mShadowShader;
//}

inline cRenderSystem* cRenderSystem::GetSingleton()
{
	return mpSingleton;
}

///    Լ
/// ŷ Ÿ Ѵ.
class cResolutionCompare
{
public:
	bool operator () ( const void* left, const void* right ) const
	{
		if( ((NiDX9AdapterDesc::ModeDesc*)left)->m_uiWidth  > ((NiDX9AdapterDesc::ModeDesc*)right)->m_uiWidth )
		{
			return false;
		}
		else if( ((NiDX9AdapterDesc::ModeDesc*)left)->m_uiWidth == ((NiDX9AdapterDesc::ModeDesc*)right)->m_uiWidth )
		{
			 if( ((NiDX9AdapterDesc::ModeDesc*)left)->m_uiHeight > ((NiDX9AdapterDesc::ModeDesc*)right)->m_uiHeight )
			 {
				 return false;
			 }
			 else if( ((NiDX9AdapterDesc::ModeDesc*)left)->m_uiHeight == ((NiDX9AdapterDesc::ModeDesc*)right)->m_uiHeight )
			 {
				 if( ((NiDX9AdapterDesc::ModeDesc*)left)->m_uiBPP >= ((NiDX9AdapterDesc::ModeDesc*)right)->m_uiBPP )
					 return false;
				 else
					 return true;
			 }
			 else
				 return true;
		}
		else
			return true;
	};
};

#define RENDERSYS cRenderSystem::GetSingleton()
