/* ====================================================================
 *      :	 ׷ ҽ  ε ̽    ޸ 
 *    :	̹
 *    :	2006.01
 * ǻ :	 ̽  뵵̹Ƿ   Ѵ.
 *				̰ εǴ ü ؽĴ  ϴ.
 * =================================================================== */
#pragma once

#include "TexturePalette.h"
#include "ModelInstance.h"

#ifndef _OBJ_LINK_INFO
#define _OBJ_LINK_INFO
enum eLINK
{
	eLINK_HEAD = 0,
	eLINK_BODY,
	eLINK_FOOT,
	eLINK_RHAND,
	eLINK_LHAND,
	eLINK_LARM,

	eLINK_RWEAPON = 10,
	eLINK_LWEAPON,
};

enum ePART
{
	ePART_HAIR = 0,
	ePART_FACE,
	ePART_BODY1,
	ePART_BODY2,
	ePART_HAND,
	ePART_FOOT,

	ePART_MAX,

	///  иü
	ePART_EAR = 100,
};
#endif

class cCallbackStreamPACK;
class cMonsterSceneNode;

/// ҽ 
class cResourceManager
{
	static cResourceManager* mpSingleton;

public:
	cResourceManager();
	~cResourceManager();

	enum
	{
		eCHARACTEREFFECT = 0,
		eOBJECTEFFECT,

		/// Ͽ   ״ Ѵ.
		eFILEEFFECT,
	};

	/// ʱȭ
	bool Init();

	void Close();

	/// 
	void Exit();

	/// ⺻ ü ε Լ
	bool LoadNIF( const cString& pathName, NiAVObject** nifRoot = 0);
	bool LoadMapNIF( const cString& pathName );

	/// 带 ̿ ü ε(  Ѵ)
	void LoadThreadNIF( const char* fileName );

	/// ε  
	void FinishThread();

	/// ؽó
	void ChangeStageImageTexture( NiTexture* tex );

	NiTexture* LoadTexture( const cString& pathName, bool useMipMap = true );
	LPDIRECT3DTEXTURE9 LoadD3DTexture( const cString& pathName, bool useMipMap = true, DWORD filter = D3DX_FILTER_LINEAR, DWORD mipFilter = D3DX_FILTER_LINEAR );
	LPDIRECT3DTEXTURE9 GetD3DTexture( const cString& pathName );

	NiTexture* LoadMapTexture( const cString& pathName, bool useMipMap = true );

	/// 帶ũ ؽ
	NiTexture* LoadGuildMark( const cString& pathName, cFileToRead* file, bool tempMark = false, bool useMipMap = true );

	/// 
	NiAudioSource* LoadStageSound( const cString& fileName );
	NiAudioSource* LoadTotalSound( const cString& fileName );

	///  ó
	void Process();

	/// ε nif ü  ߰Ѵ.
	void AddObject( NiNode* n, const cString& pathName );

	/// ü ſ ̽
	void RemoveObject( const char* objectName );
	void RemoveAllMapTexture();
	void RemoveAllTexture();

	/// ü  ̽
	NiNode*				GetObjectByName( const cString& pathName );

	NiAudioSource*		GetStageSoundByName( const cString& fileName );
	NiAudioSource*		GetTotalSoundByName( const cString& fileName );

	/// ü  ̽
	NiNode*				CloneObjectByName( const cString& pathName );
	NiAudioSource*		CloneStageSoundByName( const cString& fileName );
	NiAudioSource*		CloneTotalSoundByName( const cString& fileName );

	/// kfm  
	cModelInstance* LoadKFM( const cString& pathName );
	void AddModel( cModelInstance* model, const cString& pathName );
	void RemoveAllModels();

	/// ׸ ؽó
	NiTexture* GetShadowTexture() const;
	NiTexture* GetFieldTargetTexture() const;

	cModelInstance* GetModelByName( const cString& pathName );

	///
	const char* GetManagedPartName( unsigned int partIdx );
	const char* GetManagedDummyName( unsigned int dummyIdx );

public:
	/// ü 
	static cResourceManager* GetSingleton();

protected:
	///  ε Ŭ
	cCallbackStreamPACK* mpStreamPAK;

	/// ũƼ 
	static NiCriticalSection mObjectListCriticalSection;
	static NiCriticalSection mTexturePaletteCriticalSection;
	static NiCriticalSection mSoundListCriticalSection;

	/// ؽó ȷƮ
	cTexturePalettePtr mTexturePalette;
	cTexturePalettePtr mMapTexturePalette;

	/// 3D Ʈ
	NiTStringPointerMap<NiNodePtr> mObjectMap;
	tArray<cString> mMapObjNameArray;

	/// 
	NiTStringPointerMap<cModelInstance*> mModelMap;

	/// 
	typedef tPointerHashMap<cString, NiAudioSource*> cSoundMap;
	cSoundMap mStageSound; // stage change - clear
	cSoundMap mTotalSound; // game 

	/// ؽó
	typedef tHashMap<cString, void*> cD3DTextureMap;
	cD3DTextureMap mD3DTextureMap;

	/// ׸ ؽó
	NiTexture* mShadowTexture;
	NiTexture* mFieldTargetTexture;

	NiTexturePtr mStageImageTexture;

	/// ĳ Ʈ  Geomü ̸ (׷ ۽  ̸ Ѵ.)
	NiTPointerMap<unsigned int, const char*> mPartsNameMap;

	///  Dummyü ̸ (׷ ۽  ̸ Ѵ.)
	NiTPointerMap<unsigned int, const char*> mDummyNameMap;
};

inline
NiTexture* cResourceManager::GetShadowTexture() const
{
	return mShadowTexture;
}

inline
NiTexture* cResourceManager::GetFieldTargetTexture() const
{
	return mFieldTargetTexture;
}

inline
cResourceManager* cResourceManager::GetSingleton()
{
	return mpSingleton;
}

#define RESOURCEMAN	cResourceManager::GetSingleton()
