#include "StdAfx.h"
#include "RevivalWindow.h"
#include "Button.h"
#include "Label.h"

#include "GameResourceManager.h"
#include "Player_Common.h"
#include "UIMsgboxEvent.h"

cRevivalWindow::cRevivalWindow()
: mpTownButton(0)
, mpStandButton(0)
, mpTime(0)
, mRestTime(0)
{
}

cRevivalWindow::~cRevivalWindow()
{

}

void cRevivalWindow::OnShow()
{
	cUIWindow::OnShow();

	///  msgbox ݱ 
	UIMAN->CloseAllMsgBox( true );

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.5f);
	SetRelativePos( cUIPos( x, y) );

	/// Ÿ 
	mCheckTime = ULONG_MAX;
	mRestTime = REVIVAL_TIME;

	if( mpTime )
	{
		cStringT tm;
		unsigned int m = ((unsigned int)mRestTime/1000 ) / 60;
		tm.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000809 ), m );
		mpTime->SetText( tm.Cstr() );
	}
}

void cRevivalWindow::OnHide()
{
	cUIWindow::OnHide();
	SetTimer( false );
}

void cRevivalWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.5f);

	SetRelativePos( cUIPos( x, y) );
}

bool cRevivalWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpTime = (cLabel*)GetChild( eUIID_GAME_REVIVAL_TIME );
	mpTownButton = (cButton*)GetChild( eUIID_GAME_REVIVAL_TOWN );
	mpStandButton = (cButton*)GetChild( eUIID_GAME_REVIVAL_STAND );
	
	if( mpTime )
		mpTime->SetTextColor( eCOLOR_RED );
	return true;
}

void cRevivalWindow::OnCommand(cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_REVIVAL_TOWN:
		{
			///  Ȱ
			MSG_REQ_PLAYER_RESURRECTION msg;
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_RESURRECTION_REQ;
			msg.mFlag = eRESURRECTIONTYPE_SAFE;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			///  ɱ
			NetLock();
		}
		break;
	case eUIID_GAME_REVIVAL_STAND:
		{
			/// ڸȰ
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_REVIVAL_STAND, 
								GAMERESOURCEMAN->GetGameText( 901 ),	// 
								GAMERESOURCEMAN->GetGameText( 301 ),	// ˸
								eSKIN_YESNO
								);

		}
		break;
	default:
		assert(0);
		break;
	}
}

void cRevivalWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mVisible == false )
		return;

	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mCheckTime == ULONG_MAX )
		mCheckTime = accumTime;

	unsigned long delta = accumTime-mCheckTime;

	if( mRestTime  <= delta )
	{
		/// Ȥ ڸȰ. ųȰ  ݱ
		UIMAN->SendEventToMsgbox( false, eMBEVENT_REVIVAL_STAND );
		UIMAN->SendEventToMsgbox( false, eMBEVENT_REVIVAL_SKILL );

		///  Ȱ Ŷ
		MSG_REQ_PLAYER_RESURRECTION msg;
		msg.Category = NM_PLAYER;
		msg.Protocol = NM_PLAYER_RESURRECTION_REQ;
		msg.mFlag = eRESURRECTIONTYPE_SAFE;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		///  ɱ
		NetLock();

		Hide();
		return;
	}
	else
	{
		mRestTime -= delta;
		mCheckTime = accumTime;
	}

	unsigned int m = ((unsigned int)mRestTime/1000 ) / 60;
	unsigned int s = ((unsigned int)(mRestTime/1000) % 60) % 60;

	/// ݿø 
	if( m != 0 )
		m++;

	/// дθ ǥ ( 1ϴ ʴ )
	cStringT tm,ts;
	if( m > 0 )
		tm.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000809 ), m );
	else
		ts.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000808 ), s );

	tm += ts;

	if( mpTime )
		mpTime->SetText( tm.Cstr() );
}

void cRevivalWindow::OnNetLock( int lockTry )
{
	if( mpTownButton )
		mpTownButton->NetLock( lockTry );
	if( mpStandButton )
		mpStandButton->NetLock( lockTry );
}

void cRevivalWindow::OnNetUnLock( int lockTry )
{
	if( mpTownButton )
		mpTownButton->NetUnLock( lockTry );
	if( mpStandButton )
		mpStandButton->NetUnLock( lockTry );
}
