/* ==========================================================================
*    : ̼
*    : 2006.12.15
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneTree.h"
#include "CullingProcess.h"
#include "VisibleArray.h"
#include "VisibleArraySorter.h"
#include "IndexGenerator.h"

class cRay;
class cCamera;
class cTerrain;
class cAreaGroup;
class cAreaSceneNode;
class cAreaSceneNodeParam;
class cLightSceneNode;
class cLightSceneNodeParam;
class cSoundSceneNode;
class cSoundSceneNodeParam;
class cStaticSceneNode;
class cManagedStaticSceneNode;
class cStaticSceneNodeParam;
class cDynamicSceneNode;
class cHeroSceneNode;
class cPlayerSceneNode;
class cPlayerSceneNodeParam;
class cMonsterSceneNode;
class cTransMonSceneNode;
class cMonsterSceneNodeParam;
class cRefereeSceneNode;
class cNpcSceneNode;
class cNpcSceneNodeParam;
class cVehicleSceneNode;
class cVehicleSceneNodeParam;
class cEffectSceneNode;
class cEffectSceneNodeParam;
class cDropItemSceneNode;
class cDropItemSceneNodeParam;
class cMapPortalSceneNode;
class cMapPortalSceneNodeParam;
class cCardSceneNode;
class cCardSceneNodeParam;
class cGatheringSceneNode;
class cGatheringSceneNodeParam;

class cDepthPlane;
class cPlane;
class cShadowGeometry;

enum eNameCardOption;

///   
#pragma pack( push, 1 )
class cSceneFileHeader
{
public:
	/// ĺ ڵ
	char mCode[10];

	/// 
	unsigned int mVersion;

	///  Ʈ 
	NiPoint3 mCenter;
	float mMinRadius;
	float mMaxRadius;

	///   
	unsigned int mNumSceneNodes;
};

class cSoundSceneFileHeader
{
public:
	/// ĺ ڵ
	char mCode[10];

	/// 
	unsigned int mVersion;

	///   
	unsigned int mNumSceneNodes;
};
#pragma pack( pop )

///  
///  带 , ϴ ̴.
///  ϰ,
/// 浹 ˻, ü ˻,   ۾ Ѵ.
class cSceneManager
{
	friend class cLightAgent;
	static cSceneManager* mSingleton;

public:
	cSceneManager();
	~cSceneManager();

	/// ø̼    
	bool Init();
	void Exit();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( const NiPoint3& center, float minRadius, float maxRadius );

	/// ε
//	bool Load( const cString& pathName );
	bool LoadEnv6( cFileLoader& loader );
	bool LoadEnv7( cFileLoader& loader );
	bool LoadEnv8( cFileLoader& loader );
	bool LoadEnv9( cFileLoader& loader );
	bool LoadEnv10( cFileLoader& loader );
	bool LoadGlobalArea6( cFileLoader& loader );
	bool LoadGlobalArea7( cFileLoader& loader );
	bool LoadGlobalArea8( cFileLoader& loader );
	bool LoadGlobalArea9( cFileLoader& loader );
	bool LoadGlobalArea10( cFileLoader& loader );
	bool LoadAreaGroup( unsigned int mapIndex );

	/// load process Լ
	bool LoadSceneHeader( cFileLoader& loader, unsigned int& outNum );
	bool LoadSoundSceneHeader( cFileLoader& loader, unsigned int& outNum );

	/// return error event( -1:, 0:εϷ, 1~:)
	int LoadSceneNode( cFileLoader& loader, unsigned int loadCount=1 );
	int LoadSoundSceneNode( cFileLoader& loader, unsigned int loadCount=1 );

	int LoadSceneNode6( cFileLoader& loader, unsigned int loadCount );
	int LoadSceneNode7( cFileLoader& loader, unsigned int loadCount );
	int LoadSceneNode8( cFileLoader& loader, unsigned int loadCount );
	int LoadSceneNode9( cFileLoader& loader, unsigned int loadCount );
	int LoadSceneNode10( cFileLoader& loader, unsigned int loadCount );
	int LoadSceneNode11( cFileLoader& loader, unsigned int loadCount );

	int LoadSoundNode11( cFileLoader& loader, unsigned int loadCount );

	/// ó
	void Process( unsigned long deltaTime, unsigned long accumTime );

	/// 
	void Render();
	void RenderZFalseDamage();
	void RenderShadow();

	/// 2D ü  (ǳ etc.)
	void Render2D();

	///   Ÿ
	void SetLevelDistance( float dist0, float dist1, float dist2 );

	/// ȭ  ǥ ϴ   
	/// ﰢ  ˻Ѵ.
	bool PickStatics( tArray<void*>* pickedArray, int mouseX, int mouseY, bool sortByDistance = false );
	bool PickDynamics( tArray<void*>* pickedArray, int mouseX, int mouseY, bool sortByDistance = false );
	bool PickManagedStatics( tArray<void*>* pickedArray, int mouseX, int mouseY, bool sortByDistance = false );

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool PickStatics( tArray<void*>* pickedArray, const cRay& ray, float maxDistance, bool sortByDistance = false );
	bool PickDynamics( tArray<void*>* pickedArray, const cRay& ray, float maxDistance, bool sortByDistance = false );
	bool PickManagedStatics( tArray<void*>* pickedArray, const cRay& ray, float maxDistance, bool sortByDistance = false );

	///  浹ϴ   
	///   ˻Ѵ.
	bool Pick_Kind( tArray<void*>* pickedArray, const cSphere& sphere, cSceneNode::eType type );
	bool Pick_Type( tArray<void*>* pickedArray, const cSphere& sphere, cSceneNode::eType type );
	bool PickAreas( tArray<void*>* pickedArray, const cSphere& sphere );
	bool PickLights( tArray<void*>* pickedArray, const cSphere& sphere );
	bool PickSounds( tArray<void*>* pickedArray, const cSphere& sphere );

	///   带 
	cAreaSceneNode* CreateArea( const cAreaSceneNodeParam& param );

	///   带 
	cLightSceneNode* CreateLight( const cLightSceneNodeParam& param );

	///   带 
	cSoundSceneNode* CreateMapSound( const cSoundSceneNodeParam& param );
	cSoundSceneNode* CreateEffectSound( const cSoundSceneNodeParam& param );

	void UpdateSoundGain();

	void ActiveSoundNodeAll( bool active );

	///   带 
	cStaticSceneNode* CreateStatic( const cStaticSceneNodeParam& param );
	cDropItemSceneNode* CreateDropItem( const cDropItemSceneNodeParam& param );
	cGatheringSceneNode* CreateGathering( const cGatheringSceneNodeParam& param );
	cMapPortalSceneNode* CreateMapPortal(  unsigned long scriptIdx, NiPoint3 pos, NiMatrix3 rot );
	cCardSceneNode* CreateCard( const cCardSceneNodeParam& param );

	///  ü  ܺ ̽
	cPlayerSceneNode* CreatePlayer( const cPlayerSceneNodeParam& param );
	cMonsterSceneNode* CreateMonster( const cMonsterSceneNodeParam& param );
	cTransMonSceneNode* CreateTransMonster( const cMonsterSceneNodeParam& param, bool IsHero );
	cNpcSceneNode* CreateNPC( const cNpcSceneNodeParam& param );
	cEffectSceneNode* CreateEffect( const cEffectSceneNodeParam& param );
	cEffectSceneNode* CreateSelfEffect( cString pathName, bool distCheck, NiTransform& trans, bool bLoop );
	cEffectSceneNode* CreateDamageEffect( const cEffectSceneNodeParam& param, bool IsMiss, bool zFalse );
	cHeroSceneNode* CreateHero( const cPlayerSceneNodeParam& param );
	cVehicleSceneNode* CreateVehicle( const cVehicleSceneNodeParam& param );

	/// SceneManager  Ƿ /߰ Ѵ.( ex-ŻͿ ũ PlayerSceneNode )
	bool AddPlayer( cPlayerSceneNode* node );
	bool DelPlayer( cPlayerSceneNode* node );

	cRefereeSceneNode* CreateReferee( const cSceneNodeParam& param );

	///  ü ſ ܺ ̽
	bool DestroyDynamic( cSceneNode* node );
	bool DestroyDropItemNode( cSceneNode* node );
	bool DestroyMapPortalNode( cSceneNode* node );
	bool DestroyGathringNode( cSceneNode* node );
	bool DestroyStaticNode( cSceneNode* node );

	/// Deletelist  ʰ ܺο Ƿ ȣϴ  DelListRemove = ture Ͻÿ
	bool DestroyEffectNode( cSceneNode* node );
	bool DestroySoundNode( cSceneNode* node );

	///  Ǿ  Ʈ 忡  ó
	void AddDeleteEffectNode( cEffectSceneNode* node );

	void AddDeleteGatheringNode( cGatheringSceneNode* node );

	///  Ǿ   忡  ó
	void AddDeleteSoundNode( cSoundSceneNode* node );

	///   
	void DestroyAll();

	/// ü  
	cAreaSceneNode* GetGlobalArea();

	/// ׸  Ӽ
	NiZBufferProperty* GetShadowZBuffProperty() const;
	NiAlphaProperty* GetShadowAlphaProperty() const;
	NiTexturingProperty* GetShadowTexProperty() const;

	void AddVisibleShadowGeom( cShadowGeometry* geom );

	void AddPlane( cPlane* pPlane );

	void AddVisibleDynamicNode( cDynamicSceneNode* node );
	///

	inline void SetScreenShotMode( bool enable ) { mScreenShotMode = enable; }
	inline bool IsScreenShotMode() { return mScreenShotMode; }

	inline tArray<void*>& GetVisibleDynamicSceneArray() { return mVisibleDynamicNodeArray; }

	unsigned int CalcVisibleLevel( cStaticSceneNode* n );
	bool CalcDynamicVisibleLevel( cSceneNode* n );


	cEffectSceneNode* GetEffectSceneNode( unsigned long effectIdx );
	cSoundSceneNode* GetSoundSceneNode( unsigned long soundIdx );
	cDynamicSceneNode* GetDynamicSceneNode( unsigned long dynIdx );
	cDropItemSceneNode* GetDropItemSceneNode( unsigned long nodeIdx );
	cGatheringSceneNode* GetGatheringSceneNode( unsigned long nodeIdx );
	cStaticSceneNode* GetStaticSceneNode( unsigned long nodeIdx );

	cManagedStaticSceneNode* GetManagedStaticNode( unsigned int type, unsigned long nodeIdx );

	/// ڵ
	bool IsValidEffectNode( cEffectSceneNode* node );
	bool IsValidEffectNode( unsigned long idx, cEffectSceneNode* node );

	bool IsValidSoundNode( cSoundSceneNode* node );
	bool IsValidSoundNode( unsigned long idx, cSoundSceneNode* node );

	bool IsValidDynamicNode( cDynamicSceneNode* node );
	bool IsValidDynamicNode( unsigned long idx, cDynamicSceneNode* node );

protected:
	/// 带 ߰
	bool AddAreaNode( cSceneNode* node );
	bool AddLightNode( cSceneNode* node );
	bool AddSoundNode( cSceneNode* node );
	bool AddStaticNode( cSceneNode* node );
	bool AddDropItemNode( cSceneNode* node );
	bool AddGatheringNode( cSceneNode* node );
	bool AddMapPotalNode( cSceneNode* node );
	bool AddDynamicNode( cSceneNode* node );
	bool AddEffectNode( cSceneNode* node );

public:
	/// ü 
	static cSceneManager* GetSingleton();

protected:
	/// 
	unsigned int mVersion;

	cIndexGenerator<unsigned long> mAreaNodeIndexGen;
	cIndexGenerator<unsigned long> mLightNodeIndexGen;
	cIndexGenerator<unsigned long> mSoundIndexGen;
	cIndexGenerator<unsigned long> mStaticNodeIndexGen;
	cIndexGenerator<unsigned long> mDropItemNodeIndexGen;
	cIndexGenerator<unsigned long> mGatheringNodeIndexGen;
	cIndexGenerator<unsigned long> mMapPortalNodeIndexGen;
	cIndexGenerator<unsigned long> mDynamicNodeIndexGen;
	cIndexGenerator<unsigned long> mEffectIndexGen;

	typedef tPointerHashMap<unsigned long, void*> cAreaMap;
	typedef tPointerHashMap<unsigned long, void*> cLightMap;
	typedef tPointerHashMap<unsigned long, void*> cSoundMap;
	typedef tPointerHashMap<unsigned long, void*> cNodeMap;


	///  ü   Ƿ 迭 ó Ѵ.
	/// ߰  ,   Ƿ,  ü  ä.
//	typedef tArray<void*> cAreaArray;
//	typedef tArray<void*> cLightArray;
//	typedef tArray<void*> cSoundArray;
//	typedef tArray<void*> cNodeArray;

	/// Ʈ
	///  Ͽ   Ѵ.
	/// 浹 ˻  ø ȿ ϱ Ѵ.
	cSceneTree mNodeTree;

	cAreaMap mAreaArray;
	cLightMap mLightArray;
	cSoundMap mSoundArray;

	/// ĳ (PC, NPC, Monster)
	cNodeMap mDynamicObjectArray;

	/// 
	cNodeMap mDropItemArray;

	/// ä ü
	cNodeMap mGatheringArray;

	/// ̵ Potalü
	cNodeMap	mMapPortalArray;

	/// ȯ ü  迭
	cNodeMap mStaticObjectArray;

	/// Ʈ (Ʈ  ʿ )
	cNodeMap mEffectNodeArray;

	/// Ʈ 
//	typedef tPointerList<cSceneNode*> cDelEffectList;
	typedef tPointerList<void*> cDelEffectList;
	cDelEffectList mDelEffectList;

	/// 	
	typedef tPointerList<void*> cDelGatheringList;
	cDelGatheringList mDelGatheringList;

	///  
	typedef tPointerList<void*> cDelSoundList;
	cDelSoundList mDelSoundList;

	/// 2D  ü 
//	typedef tArray<cPlane*> cPlaneArray;
	typedef tArray<void*> cPlaneArray;
	cPlaneArray	mPlaneArray;

	///  BaseObj  SceneNode Ÿ Sortingϱ Ѵ.
	tArray<void*> mVisibleDynamicNodeArray;

	///   Ÿ
	float mSqaredLevelDistance0;
	float mSqaredLevelDistance1;
	float mSqaredLevelDistance2;

	/// ø
	cCullingProcess mCuller;
	cCullingProcess mDamageCuller;

	///    迭
	cVisibleArray mAlphaArray;
	cVisibleArray mAlphaTestArray;
	cVisibleArray mDamageArray;

	///    迭 
	cAlphaArraySorter mAlphaArraySorter;
	cAlphaArraySorter mDamageSorter;

	///    迭
	cVisibleArray mSolidArray;

	///    迭 
	cSolidArraySorter mSolidArraySorter;

	/// ŷ   迭
	typedef tArray<void*> cPickedArray;
	cPickedArray mPickedArray;

	/// ü  
	cAreaSceneNode* mGlobalArea;

	///  ׷
	typedef tHashMap<unsigned int, void*> cAreaGroupMap;
	cAreaGroupMap mAreaGroupMap;

	/// ؽó 
	typedef tHashMap<unsigned int, void*> cTextureMap;
	cTextureMap mTextureMap;

	/// ׸  Ӽ
	NiZBufferPropertyPtr mShadowZBuffProp;
	NiAlphaPropertyPtr mShadowAlphaProp;
	NiTexturingPropertyPtr mShadowTexProp;

	/// ׸  迭
	typedef tArray<cShadowGeometry*> cShadowGeomArray;
	cShadowGeomArray mShadowGeomArray;

	///
	bool mScreenShotMode;

	NiPoint3 mHeroPos;
};

inline
cAreaSceneNode* cSceneManager::GetGlobalArea()
{
	return mGlobalArea;
}

inline
void cSceneManager::SetLevelDistance( float dist0, float dist1, float dist2 )
{
	mSqaredLevelDistance0 = dist0 * dist0;
	mSqaredLevelDistance1 = dist1 * dist1;
	mSqaredLevelDistance2 = dist2 * dist2;
}

inline
NiZBufferProperty* cSceneManager::GetShadowZBuffProperty() const
{
	return mShadowZBuffProp;
}

inline
NiAlphaProperty* cSceneManager::GetShadowAlphaProperty() const
{
	return mShadowAlphaProp;
}

inline
NiTexturingProperty* cSceneManager::GetShadowTexProperty() const
{
	return mShadowTexProp;
}

inline
void cSceneManager::AddVisibleShadowGeom( cShadowGeometry* geom )
{
	assert( geom );

	mShadowGeomArray.PushBack( geom );
}

inline 
cEffectSceneNode* cSceneManager::GetEffectSceneNode( unsigned long effectIdx ) 
{ 
	return (cEffectSceneNode*)mEffectNodeArray.GetAt( effectIdx ); 
}

inline 
cSoundSceneNode* cSceneManager::GetSoundSceneNode( unsigned long soundIdx ) 
{ 
	return (cSoundSceneNode*)mSoundArray.GetAt( soundIdx ); 
}

inline 
cDynamicSceneNode* cSceneManager::GetDynamicSceneNode( unsigned long dynIdx ) 
{ 
	return (cDynamicSceneNode*)mDynamicObjectArray.GetAt( dynIdx ); 
}

inline 
cDropItemSceneNode* cSceneManager::GetDropItemSceneNode( unsigned long nodeIdx ) 
{ 
	return (cDropItemSceneNode*)mDropItemArray.GetAt( nodeIdx ); 
}

inline 
cGatheringSceneNode* cSceneManager::GetGatheringSceneNode( unsigned long nodeIdx ) 
{ 
	return (cGatheringSceneNode*)mGatheringArray.GetAt( nodeIdx ); 
}

inline 
cStaticSceneNode* cSceneManager::GetStaticSceneNode( unsigned long nodeIdx ) 
{ 
	return (cStaticSceneNode*) mStaticObjectArray.GetAt( nodeIdx ); 
}


inline
cSceneManager* cSceneManager::GetSingleton()
{
	return mSingleton;
}

#define SCENEMAN cSceneManager::GetSingleton()

/*//  ÷
/// ø μ  Ŀ ¡  
class cSceneCuller : public NiCullingProcess
{
public:
	cSceneCuller( const cCamera* cam, const NiPoint3& heroPos, float squaredDist0, float squaredDist1, float squaredDist2 );

	///  
	unsigned int GetVisibleLevel( const NiPoint3& pos );

public:
	const cCamera* mCamera;
	NiPoint3 mHeroPos;
	float mSqaredLevelDistance0;
	float mSqaredLevelDistance1;
	float mSqaredLevelDistance2;
};
//*/
