#include "stdafx.h"
#include "SceneManager.h"

#include "RenderSystem.h"
#include "SoundSystem.h"
#include "ResourceManager.h"
#include "OptionManager.h"

#include "LightAgent.h"
#include "WorldManager.h"
#include "CameraManager.h"
#include "GameResourceManager.h"

#include "AreaGroup.h"
#include "AreaSceneNode.h"
#include "LightSceneNode.h"
#include "SoundSceneNode.h"
#include "StaticSceneNode.h"

#include "ObjectManager.h"
#include "Hero.h"

static const char* gSceneFileCode = "IrisScene";

static unsigned int gNodeNum = 0;
static unsigned int gLoadNodeNum = 0;

static unsigned int gSoundNodeNum = 0;
static unsigned int gLoadSoundNodeNum = 0;


bool cSceneManager::LoadEnv6( cFileLoader& loader )
{
	/// ī޶
	float camFarDist;
	loader.ReadFloat( &camFarDist );
	CAMERAMAN->GetCurrent()->SetFarDistance( camFarDist );

	/// ϴ
	char name[64];
	loader.Read( name, 64 );
	name[63] = 0;

	cString pathName;
	unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
	pathName.Format( "./Map/Map%02d/", folderIdx );
	pathName += name;
	WORLDMAN->LoadSkydome( pathName, 1.0f );

	unsigned int skyEnabled = 0;
	loader.ReadUnsignedInt( &skyEnabled );

	float skyHeight = 0.f;
	loader.ReadFloat( &skyHeight );
	//WORLDMAN->SetSkyHeight( skyHeight );

	/// Ɽ
	NiColor ambient;
	NiColor diffuse;
	float dimmer;
	NiMatrix3 r;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	NiDirectionalLight* light = LIGHTAGENT->GetSceneDirLight( 0 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	light = LIGHTAGENT->GetSceneDirLight( 1 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );
	return true;
}

bool cSceneManager::LoadGlobalArea6( cFileLoader& loader )
{
	/// ü  ⺻ Ӽ ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	loader.ReadUnsignedInt( &type );
	loader.Read( path, 64 );
	loader.Read( name, 64 );
	loader.Read( &translate, sizeof(NiPoint3) );
	loader.Read( &rotate, sizeof(NiMatrix3) );
	loader.ReadFloat( &scale );

	/// ü   ε
	float radius;
	loader.ReadFloat( &radius );

	/// ü  ֺ ε
	NiColor ambient;
	float dimmer;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetSkyAmbient( ambient );
	mGlobalArea->SetSkyDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetTerrainAmbient( ambient );
	mGlobalArea->SetTerrainDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetStaticObjectAmbient( ambient );
	mGlobalArea->SetStaticObjectDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetDynamicObjectAmbient( ambient );
	mGlobalArea->SetDynamicObjectDimmer( dimmer );

	/// ü  Ȱ Ӽ ε
	unsigned int i;
	NiColor fogColor;
	float fogDepth;
	loader.ReadUnsignedInt( &i );
	loader.Read( &fogColor, sizeof(NiColor) );
	loader.ReadFloat( &fogDepth );
	mGlobalArea->SetFogColor( fogColor );
	mGlobalArea->SetFogDepth( fogDepth );

	///  ׷ ε ε
	unsigned int groupIndex;
	loader.ReadUnsignedInt( &groupIndex );
	return true;
}

bool cSceneManager::LoadEnv7( cFileLoader& loader )
{
	/// ī޶
	float camFarDist;
	loader.ReadFloat( &camFarDist );
	CAMERAMAN->GetCurrent()->SetFarDistance( camFarDist );

	/// ϴ
	char name[64];
	loader.Read( name, 64 );
	name[63] = 0;
	cString pathName;
	unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
	pathName.Format( "./Map/Map%02d/", folderIdx );
	pathName += name;

	unsigned int skyEnabled = 0;
	loader.ReadUnsignedInt( &skyEnabled );

	float skyScale = 0.f;
	loader.ReadFloat( &skyScale );
	WORLDMAN->LoadSkydome( pathName, 0.4f );//skyScale );

	/// Ɽ
	NiColor ambient;
	NiColor diffuse;
	float dimmer;
	NiMatrix3 r;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	NiDirectionalLight* light = LIGHTAGENT->GetSceneDirLight( 0 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	light = LIGHTAGENT->GetSceneDirLight( 1 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );
	return true;
}

bool cSceneManager::LoadGlobalArea7( cFileLoader& loader )
{
	/// ü  ⺻ Ӽ ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	loader.ReadUnsignedInt( &type );
	loader.Read( path, 64 );
	loader.Read( name, 64 );
	loader.Read( &translate, sizeof(NiPoint3) );
	loader.Read( &rotate, sizeof(NiMatrix3) );
	loader.ReadFloat( &scale );

	/// ü   ε
	float radius;
	loader.ReadFloat( &radius );

	/// ü  ֺ ε
	NiColor ambient;
	float dimmer;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetSkyAmbient( ambient );
	mGlobalArea->SetSkyDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetTerrainAmbient( ambient );
	mGlobalArea->SetTerrainDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetStaticObjectAmbient( ambient );
	mGlobalArea->SetStaticObjectDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetDynamicObjectAmbient( ambient );
	mGlobalArea->SetDynamicObjectDimmer( dimmer );

	/// ü  Ȱ Ӽ ε
	unsigned int i;
	NiColor fogColor;
	float fogDepth;
	loader.ReadUnsignedInt( &i );
	loader.Read( &fogColor, sizeof(NiColor) );
	loader.ReadFloat( &fogDepth );
	mGlobalArea->SetFogColor( fogColor );
	mGlobalArea->SetFogDepth( fogDepth );

	///  ׷ ε ε
	unsigned int groupIndex;
	loader.ReadUnsignedInt( &groupIndex );
	return true;
}

bool cSceneManager::LoadEnv8( cFileLoader& loader )
{
	/// ī޶
	float camFarDist;
	loader.ReadFloat( &camFarDist );
	CAMERAMAN->GetCurrent()->SetFarDistance( camFarDist );

	///   Ÿ
	float dist0 = 0.0f, dist1 = 0.0f, dist2 = 0.0f;
	loader.ReadFloat( &dist0 );
	loader.ReadFloat( &dist1 );
	loader.ReadFloat( &dist2 );
	SetLevelDistance( dist0, dist1, dist2 );

	/// ϴ
	char name[64];
	loader.Read( name, 64 );
	name[63] = 0;
	cString pathName;
	unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
	pathName.Format( "./Map/Map%02d/", folderIdx );
	pathName += name;

	unsigned int skyEnabled = 0;
	loader.ReadUnsignedInt( &skyEnabled );

	float skyScale = 0.f;
	loader.ReadFloat( &skyScale );
	WORLDMAN->LoadSkydome( pathName, skyScale );

	/// Ɽ
	NiColor ambient;
	NiColor diffuse;
	float dimmer;
	NiMatrix3 r;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	NiDirectionalLight* light = LIGHTAGENT->GetSceneDirLight( 0 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	light = LIGHTAGENT->GetSceneDirLight( 1 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );
	return true;
}

bool cSceneManager::LoadGlobalArea8( cFileLoader& loader )
{
	/// ü  ⺻ Ӽ ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	loader.ReadUnsignedInt( &type );
	loader.Read( path, 64 );
	loader.Read( name, 64 );
	loader.Read( &translate, sizeof(NiPoint3) );
	loader.Read( &rotate, sizeof(NiMatrix3) );
	loader.ReadFloat( &scale );

	/// ü   ε
	float radius;
	loader.ReadFloat( &radius );

	/// ü  ֺ ε
	NiColor ambient;
	float dimmer;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetSkyAmbient( ambient );
	mGlobalArea->SetSkyDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetTerrainAmbient( ambient );
	mGlobalArea->SetTerrainDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetStaticObjectAmbient( ambient );
	mGlobalArea->SetStaticObjectDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetDynamicObjectAmbient( ambient );
	mGlobalArea->SetDynamicObjectDimmer( dimmer );

	/// ü  Ȱ Ӽ ε
	unsigned int i;
	NiColor fogColor;
	float fogDepth;
	loader.ReadUnsignedInt( &i );
	loader.Read( &fogColor, sizeof(NiColor) );
	loader.ReadFloat( &fogDepth );
	mGlobalArea->SetFogColor( fogColor );
	mGlobalArea->SetFogDepth( fogDepth );

	///  ׷ ε ε
	unsigned int groupIndex;
	loader.ReadUnsignedInt( &groupIndex );
	return true;
}

bool cSceneManager::LoadEnv9( cFileLoader& loader )
{
	/// ī޶
	float camFarDist;
	loader.ReadFloat( &camFarDist );
	CAMERAMAN->GetCurrent()->SetFarDistance( camFarDist );

	///   Ÿ
	float dist0 = 0.0f, dist1 = 0.0f, dist2 = 0.0f;
	loader.ReadFloat( &dist0 );
	loader.ReadFloat( &dist1 );
	loader.ReadFloat( &dist2 );
	SetLevelDistance( dist0, dist1, dist2 );

	/// ϴ
	char name[64];
	loader.Read( name, 64 );
	name[63] = 0;
	cString pathName;
	unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
	pathName.Format( "./Map/Map%02d/", folderIdx );
	pathName += name;

	unsigned int skyEnabled = 0;
	loader.ReadUnsignedInt( &skyEnabled );

	float skyScale = 0.f;
	loader.ReadFloat( &skyScale );
	WORLDMAN->LoadSkydome( pathName, skyScale );

	/// Ɽ
	NiColor ambient;
	NiColor diffuse;
	float dimmer;
	NiMatrix3 r;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	NiDirectionalLight* light = LIGHTAGENT->GetSceneDirLight( 0 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	light = LIGHTAGENT->GetSceneDirLight( 1 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );
	return true;
}

bool cSceneManager::LoadGlobalArea9( cFileLoader& loader )
{
	/// ü  ⺻ Ӽ ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	loader.ReadUnsignedInt( &type );
	loader.Read( path, 64 );
	loader.Read( name, 64 );
	loader.Read( &translate, sizeof(NiPoint3) );
	loader.Read( &rotate, sizeof(NiMatrix3) );
	loader.ReadFloat( &scale );

	/// ü   ε
	float radius;
	loader.ReadFloat( &radius );

	/// ü  ֺ ε
	NiColor ambient;
	float dimmer;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetSkyAmbient( ambient );
	mGlobalArea->SetSkyDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetTerrainAmbient( ambient );
	mGlobalArea->SetTerrainDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetStaticObjectAmbient( ambient );
	mGlobalArea->SetStaticObjectDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetDynamicObjectAmbient( ambient );
	mGlobalArea->SetDynamicObjectDimmer( dimmer );

	/// ü  Ȱ Ӽ ε
	unsigned int i;
	NiColor fogColor;
	float fogDepth;
	loader.ReadUnsignedInt( &i );
	loader.Read( &fogColor, sizeof(NiColor) );
	loader.ReadFloat( &fogDepth );
	mGlobalArea->SetFogColor( fogColor );
	mGlobalArea->SetFogDepth( fogDepth );

	///  ׷ ε ε
	unsigned int groupIndex;
	loader.ReadUnsignedInt( &groupIndex );
	return true;
}

bool cSceneManager::LoadEnv10( cFileLoader& loader )
{
	/// ī޶
	float camFarDist;
	loader.ReadFloat( &camFarDist );
	CAMERAMAN->GetCurrent()->SetFarDistance( camFarDist );

	///   Ÿ
	float dist0 = 0.0f, dist1 = 0.0f, dist2 = 0.0f;
	loader.ReadFloat( &dist0 );
	loader.ReadFloat( &dist1 );
	loader.ReadFloat( &dist2 );
	SetLevelDistance( dist0, dist1, dist2 );

	/// ϴ
	char name[64];
	loader.Read( name, 64 );
	name[63] = 0;
	cString pathName;
	unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
	pathName.Format( "./Map/Map%02d/", folderIdx );
	pathName += name;

	unsigned int skyEnabled = 0;
	loader.ReadUnsignedInt( &skyEnabled );

	float skyScale = 0.f;
	loader.ReadFloat( &skyScale );
	WORLDMAN->LoadSkydome( pathName, skyScale );

	/// Ɽ
	NiColor ambient;
	NiColor diffuse;
	float dimmer;
	NiMatrix3 r;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	NiDirectionalLight* light = LIGHTAGENT->GetSceneDirLight( 0 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.Read( &diffuse, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	loader.Read( &r, sizeof(NiMatrix3) );

	light = LIGHTAGENT->GetSceneDirLight( 1 );
	light->SetAmbientColor( ambient );
	light->SetDiffuseColor( diffuse );
	light->SetDimmer( dimmer );
	light->SetRotate( r );
	light->Update( 0.0f );
	return true;
}

bool cSceneManager::LoadGlobalArea10( cFileLoader& loader )
{
	/// ü  ⺻ Ӽ ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	loader.ReadUnsignedInt( &type );
	loader.Read( path, 64 );
	loader.Read( name, 64 );
	loader.Read( &translate, sizeof(NiPoint3) );
	loader.Read( &rotate, sizeof(NiMatrix3) );
	loader.ReadFloat( &scale );

	/// ü   ε
	float radius;
	loader.ReadFloat( &radius );

	/// ü  ֺ ε
	NiColor ambient;
	float dimmer;

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetSkyAmbient( ambient );
	mGlobalArea->SetSkyDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetTerrainAmbient( ambient );
	mGlobalArea->SetTerrainDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetStaticObjectAmbient( ambient );
	mGlobalArea->SetStaticObjectDimmer( dimmer );

	loader.Read( &ambient, sizeof(NiColor) );
	loader.ReadFloat( &dimmer );
	mGlobalArea->SetDynamicObjectAmbient( ambient );
	mGlobalArea->SetDynamicObjectDimmer( dimmer );

	/// ü  Ȱ Ӽ ε
	unsigned int i;
	NiColor fogColor;
	float fogDepth;
	loader.ReadUnsignedInt( &i );
	loader.Read( &fogColor, sizeof(NiColor) );
	loader.ReadFloat( &fogDepth );
	mGlobalArea->SetFogColor( fogColor );
	mGlobalArea->SetFogDepth( fogDepth );

	///  ׷ ε ε
	unsigned int groupIndex;
	loader.ReadUnsignedInt( &groupIndex );
	return true;
}

bool cSceneManager::LoadSceneHeader( cFileLoader& loader, unsigned int& outNum )
{
	///   ε
	cSceneFileHeader header;

	if( loader.Read( &header, sizeof(cSceneFileHeader) ) != sizeof(cSceneFileHeader) )
	{
		assert( 0 && "failed to load scene file header" );
		return false;
	}

	///  ˻
	if( memcmp( header.mCode, gSceneFileCode, 10 ) != 0 )
	{
		assert( 0 && "invalid file type" );
		return false;
	}

	///  Ʈ ʱȭ
	Init( header.mCenter, header.mMinRadius, header.mMaxRadius );

	/// ü   ε
	///  ε
	mVersion = header.mVersion;
	switch( mVersion )
	{
	case 6:
		if( LoadEnv6( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		if( LoadGlobalArea6( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		break;
	case 7:
		if( LoadEnv7( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		if( LoadGlobalArea7( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		break;
	case 8:
		if( LoadEnv8( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		if( LoadGlobalArea8( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		break;
	case 9:
		if( LoadEnv9( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		if( LoadGlobalArea9( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		break;
	case 10:
	case 11:
		if( LoadEnv10( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		if( LoadGlobalArea10( loader ) == false )
		{
			assert( 0 );
			return false;
		}
		break;
	default:
		assert( 0 && "invalid file version" );
		return false;
	}

	gNodeNum = header.mNumSceneNodes;
	outNum = gNodeNum;
	gLoadNodeNum = 0;

	return true;
}

bool cSceneManager::LoadSoundSceneHeader( cFileLoader& loader, unsigned int& outNum )
{
	///   ε
	cSoundSceneFileHeader header;

	if( loader.Read( &header, sizeof(cSoundSceneFileHeader) ) != sizeof(cSoundSceneFileHeader) )
	{
		assert( 0 && "failed to load sound scene file header" );
		return false;
	}

	///  ˻
	if( memcmp( header.mCode, gSceneFileCode, 10 ) != 0 )
	{
		assert( 0 && "invalid file type" );
		return false;
	}

	/// ü   ε
	///  ε
	mVersion = header.mVersion;
	switch( mVersion )
	{
	case 11:
		break;
	default:
		assert( 0 && "invalid file version" );
		return false;
	}

	gSoundNodeNum = header.mNumSceneNodes;
	outNum = gSoundNodeNum;
	gLoadSoundNodeNum = 0;

	return true;
}


int cSceneManager::LoadSceneNode( cFileLoader& loader, unsigned int loadCount )
{
	switch( mVersion )
	{
	case 6:
		return LoadSceneNode6( loader, loadCount );
	case 7:
		return LoadSceneNode7( loader, loadCount );
	case 8:
		return LoadSceneNode8( loader, loadCount );
	case 9:
		return LoadSceneNode9( loader, loadCount );
	case 10:
		return LoadSceneNode10( loader, loadCount );
	case 11:
		return LoadSceneNode11( loader, loadCount );
	default:
		assert( 0 && "invalid file version" );
	}
	return -1;
}

int cSceneManager::LoadSoundSceneNode( cFileLoader& loader, unsigned int loadCount )
{
	switch( mVersion )
	{
	case 11:
		return LoadSoundNode11( loader, loadCount );
	default:
		assert( 0 && "invalid file version" );
	}
	return -1;
}


int cSceneManager::LoadSceneNode6( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eAREA_VER8:
			{
				cAreaSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mSkyAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mSkyDimmer) );
				loader.Read( &(param.mTerrainAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mTerrainDimmer) );
				loader.Read( &(param.mStaticObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mStaticObjectDimmer) );
				loader.Read( &(param.mDynamicObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDynamicObjectDimmer) );

				/// Ȱ Ӽ ε
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				loader.Read( &(param.mFogColor), sizeof(NiColor) );
				loader.ReadFloat( &(param.mFogDepth) );

				/// ׷ ε ε
				loader.ReadUnsignedInt( &(param.mGroupIndex) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cAreaSceneNode* n = CreateArea( param );
				assert( n && "failed to create area scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eLIGHT_VER8:
			{
				cLightSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mAmbient), sizeof(NiColor) );

				///  ε
				loader.Read( &(param.mDiffuse0), sizeof(NiColor) );
				loader.Read( &(param.mDiffuse1), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDiffuseAnimTime) );
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				param.mFlickering = i != 0;

				/// ݻ ε
				loader.Read( &(param.mSpecular), sizeof(NiColor) );

				///   ε
				loader.ReadFloat( &(param.mConstantAtten0) );
				loader.ReadFloat( &(param.mConstantAtten1) );
				loader.ReadFloat( &(param.mConstantAttenAnimTime) );
				loader.ReadFloat( &(param.mLinearAtten) );
				loader.ReadFloat( &(param.mQuadricAtten) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cLightSceneNode* n = CreateLight( param );
				assert( n && "failed to create light scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSOUND_VER8:
			{
				cSoundSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				///  Ÿ ε
				loader.ReadFloat( &(param.mAttenDistance) );

				/// ݺ Ƚ ε
				loader.ReadUnsignedInt( &(param.mLoopCount) );

				///   ε
				loader.ReadFloat( &(param.mLoopInterval) );

				///   ε
				loader.ReadFloat( &(param.mVolumeRatio) );

				/// ⺻ Ӽ ڵ 
				param.mPathName.Format( "./Map/Sound/%s", name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;
				param.mManaged = false;
				param.mVolumeRatio *= OPTIONMAN->GetEnvVolume();
				param.mEffectSound = false;

				/// 带 
				cSoundSceneNode* n = CreateMapSound( param );
				assert( n && "failed to create sound scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSTATIC_VER8:
			{
				cStaticSceneNodeParam param;
				param.mMaterialApplied = true;

				///  Ӽ ε
				loader.Read( &param.mMaterial, sizeof(cMaterialData) );

				///   ε
				loader.ReadUnsignedInt( &(param.mVisibleLevel) );

				///   ε
				loader.ReadUnsignedInt( &(param.mOccludeLevel) );

				/// ⺻ Ӽ ڵ 
				unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
				param.mPathName.Format( "./Map/Map%02d/%s", folderIdx, name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cStaticSceneNode* n = CreateStatic( param );
				assert( n && "failed to create static scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadNodeNum++;
		if( gNodeNum == gLoadNodeNum )
			return 0;
	}
	return 1;
}

int cSceneManager::LoadSceneNode7( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eAREA_VER8:
			{
				cAreaSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mSkyAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mSkyDimmer) );
				loader.Read( &(param.mTerrainAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mTerrainDimmer) );
				loader.Read( &(param.mStaticObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mStaticObjectDimmer) );
				loader.Read( &(param.mDynamicObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDynamicObjectDimmer) );

				/// Ȱ Ӽ ε
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				loader.Read( &(param.mFogColor), sizeof(NiColor) );
				loader.ReadFloat( &(param.mFogDepth) );

				/// ׷ ε ε
				loader.ReadUnsignedInt( &(param.mGroupIndex) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cAreaSceneNode* n = CreateArea( param );
				assert( n && "failed to create area scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eLIGHT_VER8:
			{
				cLightSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mAmbient), sizeof(NiColor) );

				///  ε
				loader.Read( &(param.mDiffuse0), sizeof(NiColor) );
				loader.Read( &(param.mDiffuse1), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDiffuseAnimTime) );
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				param.mFlickering = i != 0;

				/// ݻ ε
				loader.Read( &(param.mSpecular), sizeof(NiColor) );

				///   ε
				loader.ReadFloat( &(param.mConstantAtten0) );
				loader.ReadFloat( &(param.mConstantAtten1) );
				loader.ReadFloat( &(param.mConstantAttenAnimTime) );
				loader.ReadFloat( &(param.mLinearAtten) );
				loader.ReadFloat( &(param.mQuadricAtten) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cLightSceneNode* n = CreateLight( param );
				assert( n && "failed to create light scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSOUND_VER8:
			{
				cSoundSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				///  Ÿ ε
				loader.ReadFloat( &(param.mAttenDistance) );

				/// ݺ Ƚ ε
				loader.ReadUnsignedInt( &(param.mLoopCount) );

				///   ε
				loader.ReadFloat( &(param.mLoopInterval) );

				///   ε
				loader.ReadFloat( &(param.mVolumeRatio) );

				/// ⺻ Ӽ ڵ 
				param.mPathName.Format( "./Sound/%s", name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;
				param.mManaged = false;
				param.mVolumeRatio *= OPTIONMAN->GetEnvVolume();
				param.mEffectSound = false;

				/// 带 
				cSoundSceneNode* n = CreateMapSound( param );
				assert( n && "failed to create sound scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSTATIC_VER8:
			{
				cStaticSceneNodeParam param;
				param.mMaterialApplied = true;

				///  Ӽ ε
				loader.Read( &param.mMaterial, sizeof(cMaterialData) );

				///   ε
				loader.ReadUnsignedInt( &(param.mVisibleLevel) );

				///   ε
				loader.ReadUnsignedInt( &(param.mOccludeLevel) );

				/// Ȱ  θ ε
				unsigned int i = 0;
				loader.ReadUnsignedInt( &i );
				param.mFogApplied = (i != 0);

				/// ⺻ Ӽ ڵ 
				unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
				param.mPathName.Format( "./Map/Map%02d/%s", folderIdx, name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cStaticSceneNode* n = CreateStatic( param );
				assert( n && "failed to create static scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadNodeNum++;
		if( gNodeNum == gLoadNodeNum )
			return 0;
	}
	return 1;
}

int cSceneManager::LoadSceneNode8( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eAREA_VER8:
			{
				cAreaSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mSkyAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mSkyDimmer) );
				loader.Read( &(param.mTerrainAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mTerrainDimmer) );
				loader.Read( &(param.mStaticObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mStaticObjectDimmer) );
				loader.Read( &(param.mDynamicObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDynamicObjectDimmer) );

				/// Ȱ Ӽ ε
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				loader.Read( &(param.mFogColor), sizeof(NiColor) );
				loader.ReadFloat( &(param.mFogDepth) );

				/// ׷ ε ε
				loader.ReadUnsignedInt( &(param.mGroupIndex) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cAreaSceneNode* n = CreateArea( param );
				assert( n && "failed to create area scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eLIGHT_VER8:
			{
				cLightSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mAmbient), sizeof(NiColor) );

				///  ε
				loader.Read( &(param.mDiffuse0), sizeof(NiColor) );
				loader.Read( &(param.mDiffuse1), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDiffuseAnimTime) );
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				param.mFlickering = i != 0;

				/// ݻ ε
				loader.Read( &(param.mSpecular), sizeof(NiColor) );

				///   ε
				loader.ReadFloat( &(param.mConstantAtten0) );
				loader.ReadFloat( &(param.mConstantAtten1) );
				loader.ReadFloat( &(param.mConstantAttenAnimTime) );
				loader.ReadFloat( &(param.mLinearAtten) );
				loader.ReadFloat( &(param.mQuadricAtten) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cLightSceneNode* n = CreateLight( param );
				assert( n && "failed to create light scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSOUND_VER8:
			{
				cSoundSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				///  Ÿ ε
				loader.ReadFloat( &(param.mAttenDistance) );

				/// ݺ Ƚ ε
				loader.ReadUnsignedInt( &(param.mLoopCount) );

				///   ε
				loader.ReadFloat( &(param.mLoopInterval) );

				///   ε
				loader.ReadFloat( &(param.mVolumeRatio) );

				/// ⺻ Ӽ ڵ 
				param.mPathName.Format( "./Sound/%s", name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;
				param.mManaged = false;
				param.mVolumeRatio *= OPTIONMAN->GetEnvVolume();
				param.mEffectSound = false;

				/// 带 
				cSoundSceneNode* n = CreateMapSound( param );
				assert( n && "failed to create sound scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSTATIC_VER8:
			{
				cStaticSceneNodeParam param;
				param.mMaterialApplied = true;

				///  Ӽ ε
				loader.Read( &param.mMaterial, sizeof(cMaterialData) );

				///   ε
				loader.ReadUnsignedInt( &(param.mVisibleLevel) );

				///   ε
				loader.ReadUnsignedInt( &(param.mOccludeLevel) );

				/// Ȱ  θ ε
				unsigned int i = 0;
				loader.ReadUnsignedInt( &i );
				param.mFogApplied = (i != 0);

				/// ⺻ Ӽ ڵ 
				unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
				param.mPathName.Format( "./Map/Map%02d/%s", folderIdx, name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cStaticSceneNode* n = CreateStatic( param );
				assert( n && "failed to create static scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadNodeNum++;
		if( gNodeNum == gLoadNodeNum )
			return 0;
	}
	return 1;
}

int cSceneManager::LoadSceneNode9( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eAREA:
			{
				cAreaSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mSkyAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mSkyDimmer) );
				loader.Read( &(param.mTerrainAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mTerrainDimmer) );
				loader.Read( &(param.mStaticObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mStaticObjectDimmer) );
				loader.Read( &(param.mDynamicObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDynamicObjectDimmer) );

				/// Ȱ Ӽ ε
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				loader.Read( &(param.mFogColor), sizeof(NiColor) );
				loader.ReadFloat( &(param.mFogDepth) );

				/// ׷ ε ε
				loader.ReadUnsignedInt( &(param.mGroupIndex) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cAreaSceneNode* n = CreateArea( param );
				assert( n && "failed to create area scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eLIGHT:
			{
				cLightSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mAmbient), sizeof(NiColor) );

				///  ε
				loader.Read( &(param.mDiffuse0), sizeof(NiColor) );
				loader.Read( &(param.mDiffuse1), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDiffuseAnimTime) );
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				param.mFlickering = i != 0;

				/// ݻ ε
				loader.Read( &(param.mSpecular), sizeof(NiColor) );

				///   ε
				loader.ReadFloat( &(param.mConstantAtten0) );
				loader.ReadFloat( &(param.mConstantAtten1) );
				loader.ReadFloat( &(param.mConstantAttenAnimTime) );
				loader.ReadFloat( &(param.mLinearAtten) );
				loader.ReadFloat( &(param.mQuadricAtten) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cLightSceneNode* n = CreateLight( param );
				assert( n && "failed to create light scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSOUND:
			{
				cSoundSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				///  Ÿ ε
				loader.ReadFloat( &(param.mAttenDistance) );

				/// ݺ Ƚ ε
				loader.ReadUnsignedInt( &(param.mLoopCount) );

				///   ε
				loader.ReadFloat( &(param.mLoopInterval) );

				///   ε
				loader.ReadFloat( &(param.mVolumeRatio) );

				/// ⺻ Ӽ ڵ 
				param.mPathName.Format( "./Sound/%s", name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;
				param.mManaged = false;
				param.mVolumeRatio *= OPTIONMAN->GetEnvVolume();
				param.mEffectSound = false;

				/// 带 
				cSoundSceneNode* n = CreateMapSound( param );
				assert( n && "failed to create sound scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSTATIC:
			{
				cStaticSceneNodeParam param;
				param.mMaterialApplied = true;

				///  Ӽ ε
				loader.Read( &param.mMaterial, sizeof(cMaterialData) );

				///   ε
				loader.ReadUnsignedInt( &(param.mVisibleLevel) );

				///   ε
				loader.ReadUnsignedInt( &(param.mOccludeLevel) );

				/// Ȱ  θ ε
				unsigned int i = 0;
				loader.ReadUnsignedInt( &i );
				param.mFogApplied = (i != 0);

				/// ⺻ Ӽ ڵ 
				unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
				param.mPathName.Format( "./Map/Map%02d/%s", folderIdx, name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cStaticSceneNode* n = CreateStatic( param );
				assert( n && "failed to create static scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadNodeNum++;
		if( gNodeNum == gLoadNodeNum )
			return 0;
	}
	return 1;
}

int cSceneManager::LoadSceneNode10( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eAREA:
			{
				cAreaSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mSkyAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mSkyDimmer) );
				loader.Read( &(param.mTerrainAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mTerrainDimmer) );
				loader.Read( &(param.mStaticObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mStaticObjectDimmer) );
				loader.Read( &(param.mDynamicObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDynamicObjectDimmer) );

				/// Ȱ Ӽ ε
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				loader.Read( &(param.mFogColor), sizeof(NiColor) );
				loader.ReadFloat( &(param.mFogDepth) );

				/// ׷ ε ε
				loader.ReadUnsignedInt( &(param.mGroupIndex) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cAreaSceneNode* n = CreateArea( param );
				assert( n && "failed to create area scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eLIGHT:
			{
				cLightSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mAmbient), sizeof(NiColor) );

				///  ε
				loader.Read( &(param.mDiffuse0), sizeof(NiColor) );
				loader.Read( &(param.mDiffuse1), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDiffuseAnimTime) );
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				param.mFlickering = i != 0;

				/// ݻ ε
				loader.Read( &(param.mSpecular), sizeof(NiColor) );

				///   ε
				loader.ReadFloat( &(param.mConstantAtten0) );
				loader.ReadFloat( &(param.mConstantAtten1) );
				loader.ReadFloat( &(param.mConstantAttenAnimTime) );
				loader.ReadFloat( &(param.mLinearAtten) );
				loader.ReadFloat( &(param.mQuadricAtten) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cLightSceneNode* n = CreateLight( param );
				assert( n && "failed to create light scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSOUND:
			{
				cSoundSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				///  Ÿ ε
				loader.ReadFloat( &(param.mAttenDistance) );

				/// ݺ Ƚ ε
				loader.ReadUnsignedInt( &(param.mLoopCount) );

				///   ε
				loader.ReadFloat( &(param.mLoopInterval) );

				///   ε
				loader.ReadFloat( &(param.mVolumeRatio) );

				/// ⺻ Ӽ ڵ 
				param.mPathName.Format( "./Sound/%s", name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;
				param.mManaged = false;
				param.mVolumeRatio *= OPTIONMAN->GetEnvVolume();
				param.mEffectSound = false;

				/// 带 
				cSoundSceneNode* n = CreateMapSound( param );
				assert( n && "failed to create sound scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSTATIC:
			{
				cStaticSceneNodeParam param;

				/// Ȱ  θ ε
				unsigned int i = 0;
				loader.ReadUnsignedInt( &i );
				param.mFogApplied = (i != 0);

				///   θ ε
				i = 0;
				loader.ReadUnsignedInt( &i );
				param.mMaterialApplied = (i != 0);

				///  Ӽ ε
				loader.Read( &param.mMaterial, sizeof(cMaterialData) );

				///   ε
				loader.ReadUnsignedInt( &(param.mVisibleLevel) );

				///   ε
				loader.ReadUnsignedInt( &(param.mOccludeLevel) );

				/// ⺻ Ӽ ڵ 
				unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
				param.mPathName.Format( "./Map/Map%02d/%s", folderIdx, name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cStaticSceneNode* n = CreateStatic( param );
				assert( n && "failed to create static scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadNodeNum++;
		if( gNodeNum == gLoadNodeNum )
			return 0;
	}
	return 1;
}

int cSceneManager::LoadSceneNode11( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eAREA:
			{
				cAreaSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mSkyAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mSkyDimmer) );
				loader.Read( &(param.mTerrainAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mTerrainDimmer) );
				loader.Read( &(param.mStaticObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mStaticObjectDimmer) );
				loader.Read( &(param.mDynamicObjectAmbient), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDynamicObjectDimmer) );

				/// Ȱ Ӽ ε
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				loader.Read( &(param.mFogColor), sizeof(NiColor) );
				loader.ReadFloat( &(param.mFogDepth) );

				/// ׷ ε ε
				loader.ReadUnsignedInt( &(param.mGroupIndex) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cAreaSceneNode* n = CreateArea( param );
				assert( n && "failed to create area scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eLIGHT:
			{
				cLightSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				/// ֺ ε
				loader.Read( &(param.mAmbient), sizeof(NiColor) );

				///  ε
				loader.Read( &(param.mDiffuse0), sizeof(NiColor) );
				loader.Read( &(param.mDiffuse1), sizeof(NiColor) );
				loader.ReadFloat( &(param.mDiffuseAnimTime) );
				unsigned int i;
				loader.ReadUnsignedInt( &i );
				param.mFlickering = i != 0;

				/// ݻ ε
				loader.Read( &(param.mSpecular), sizeof(NiColor) );

				///   ε
				loader.ReadFloat( &(param.mConstantAtten0) );
				loader.ReadFloat( &(param.mConstantAtten1) );
				loader.ReadFloat( &(param.mConstantAttenAnimTime) );
				loader.ReadFloat( &(param.mLinearAtten) );
				loader.ReadFloat( &(param.mQuadricAtten) );

				/// ⺻ Ӽ ڵ 
				param.mPathName = name;
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cLightSceneNode* n = CreateLight( param );
				assert( n && "failed to create light scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		case cSceneNode::eSTATIC:
			{
				cStaticSceneNodeParam param;

				/// Ȱ  θ ε
				unsigned int i = 0;
				loader.ReadUnsignedInt( &i );
				param.mFogApplied = (i != 0);

				///   θ ε
				i = 0;
				loader.ReadUnsignedInt( &i );
				param.mMaterialApplied = (i != 0);

				///  Ӽ ε
				loader.Read( &param.mMaterial, sizeof(cMaterialData) );

				///   ε
				loader.ReadUnsignedInt( &(param.mVisibleLevel) );

				///   ε
				loader.ReadUnsignedInt( &(param.mOccludeLevel) );

				/// ⺻ Ӽ ڵ 
				unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( HERO->GetMapNum() );
				param.mPathName.Format( "./Map/Map%02d/%s", folderIdx, name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;

				/// 带 
				cStaticSceneNode* n = CreateStatic( param );
				assert( n && "failed to create static scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadNodeNum++;
		if( gNodeNum == gLoadNodeNum )
			return 0;
	}
	return 1;
}

int cSceneManager::LoadSoundNode11( cFileLoader& loader, unsigned int loadCount )
{
	///     ε
	unsigned int type;
	char path[64];
	char name[64];
	NiPoint3 translate;
	NiMatrix3 rotate;
	float scale;

	for( unsigned int i = 0, iend = loadCount; i < iend; ++i )
	{
		/// Ÿ ε
		loader.ReadUnsignedInt( &type );

		/// θ ε
		loader.Read( path, 64 );
		path[63] = 0;

		/// ̸ ε
		loader.Read( name, 64 );
		name[63] = 0;

		/// ġ ε
		loader.Read( &translate, sizeof(NiPoint3) );

		/// ȸ ε
		loader.Read( &rotate, sizeof(NiMatrix3) );

		///  ε
		loader.ReadFloat( &scale );

		///  ŸԿ  ε  
		switch( type )
		{
		case cSceneNode::eSOUND:
			{
				cSoundSceneNodeParam param;

				///  ε
				loader.ReadFloat( &(param.mRadius) );

				///  Ÿ ε
				loader.ReadFloat( &(param.mAttenDistance) );

				/// ݺ Ƚ ε
				loader.ReadUnsignedInt( &(param.mLoopCount) );

				///   ε
				loader.ReadFloat( &(param.mLoopInterval) );

				///   ε
				loader.ReadFloat( &(param.mVolumeRatio) );

				/// ⺻ Ӽ ڵ 
				param.mPathName.Format( "./Sound/%s", name );
				param.mTranslate = translate;
				param.mRotate = rotate;
				param.mScale = scale;
				param.mManaged = false;
				param.mVolumeRatio *= OPTIONMAN->GetEnvVolume();
				param.mEffectSound = false;

				/// 带 
				cSoundSceneNode* n = CreateMapSound( param );
				assert( n && "failed to create sound scene node" );
				//if( n == 0 )
				//	return -1;
			}
			break;
		default:
			assert( 0 && "invalid scene node type" );
			return -1;
		}

		gLoadSoundNodeNum++;
		if( gSoundNodeNum == gLoadSoundNodeNum )
			return 0;
	}
	return 1;
}


bool cSceneManager::LoadAreaGroup( unsigned int mapIndex  )
{
//	mTextureMap.Clear();

	unsigned long folderIdx = GAMERESOURCEMAN->GetMapFolderIdx( mapIndex );

	///  ׷ 
	cAreaGroupMap::cIterator i = mAreaGroupMap.Begin();
	cAreaGroupMap::cIterator iend = mAreaGroupMap.End();

	for( ; i != iend; ++i )
	{
		delete (cAreaGroup*)((*i).mSecond);
	}
	mAreaGroupMap.Clear();

	///  
	cString pathName;
	pathName.Format( "./Script/Resource/%03d_areagroup.txt", folderIdx );

	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", pathName.Cstr() );
	cString str;

	///   ε
	tok.GetNext( &str );

	if( str == "sounds" )
	{
		/// "{"
		tok.GetNext( &str );

		while( tok.IsEnd() == false )
		{
			///  ε
			tok.GetNext( &str );
			if( str == "}" )
				break;

			unsigned int sndIndex = str.ToInt();

			///  ϸ
			tok.GetNext( &str );

			/// ε
			pathName.Format( "./Sound/%s", str.Cstr() );
			NiAudioSource* snd = SOUNDSYS->LoadAreaSound( sndIndex, pathName.Cstr() );

			if( snd == 0 )
				continue;
		}
	}

	///  ̹  ε
	tok.GetNext( &str );

	if( str == "images" )
	{
		/// "{"
		tok.GetNext( &str );

		while( tok.IsEnd() == false )
		{
			/// ̹ ε
			tok.GetNext( &str );
			if( str == "}" )
				break;

			unsigned int texIndex = str.ToInt();

			/// ̹ ϸ
			tok.GetNext( &str );

			/// ε
			pathName.Format( "./Map/map%02d/%s", folderIdx, str.Cstr() );
			NiTexture* tex = RESOURCEMAN->LoadTexture( pathName, false );

			if( tex == 0 )
				continue;

			/// ؽó ʿ ߰
			mTextureMap.Insert( texIndex, tex );
		}
	}

	///
	tok.GetNext( &str );

	if( str == "areaGroups" )
	{
		/// "{"
		tok.GetNext( &str );

		while( tok.IsEnd() == false )
		{
			///  ׷ ε
			tok.GetNext( &str );
			unsigned int groupIndex = str.ToInt();

			///  ε
			tok.GetNext( &str );
			unsigned int sndIndex = str.ToInt();
			NiAudioSource* snd = 0;

			snd = SOUNDSYS->GetAreaSound( sndIndex );

			///  ̹ ε
			tok.GetNext( &str );
			unsigned int texIndex = str.ToInt();
			NiTexture* tex = 0;

			cTextureMap::cIterator ti = mTextureMap.Find( texIndex );
			if( ti != mTextureMap.End() )
				tex = (NiTexture*)(*ti).mSecond;

			///  ̹ ġ, ũ
			tok.GetNext( &str );
			unsigned int tx = str.ToInt();

			tok.GetNext( &str );
			unsigned int ty = str.ToInt();

			tok.GetNext( &str );
			unsigned int tw = str.ToInt();

			tok.GetNext( &str );
			unsigned int th = str.ToInt();

			/// ̸ ε
			tok.GetNext( &str );
			unsigned int nameIndex = str.ToInt();

			///  ׷ 
			cAreaGroupMap::cIterator ai = mAreaGroupMap.Find( groupIndex );

			if( ai == mAreaGroupMap.End() )
			{
				unsigned int x = (RENDERSYS->GetScreenWidth() - tw) / 2;
				unsigned int y = 60;

				cAreaGroup* areaGroup = new cAreaGroup( snd, tex, x, y, tx, ty, tw, th, nameIndex );
				mAreaGroupMap.Insert( groupIndex, areaGroup );

				///  ׷쿡   ߰

				cAreaMap::cIterator i, iend;
				i = mAreaArray.Begin();
				iend = mAreaArray.End();
				for( ; i != iend; ++i )
				{
					cAreaSceneNode* area = (cAreaSceneNode*)(*i).mSecond;

					if( area->GetGroupIndex() == groupIndex )
						areaGroup->AddArea( area );
				}
			}
		}
	}
	return true;
}
