/* ==========================================================================
*    : ̼
*    : 2006.12.08
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Ray.h"
#include "Sphere.h"

class NiCamera;
class NiVisibleArray;
class cSceneCuller;
class cLightSceneNode;

///  Ÿ
class cAlphaData
{
public:
	cAlphaData( bool blendEnabled, bool testEnabled, NiAlphaProperty::TestFunction testFunc, unsigned char testRef, NiAlphaProperty* prop );
	~cAlphaData();

public:
	///  
	bool mBlendEnabled;

	///  ׽
	bool mTestEnabled;
	NiAlphaProperty::TestFunction mTestFunc;
	unsigned char mTestRef;

	///  Ӽ
	NiAlphaProperty* mProp;
};

class cVertexColorData
{
public:
	cVertexColorData( NiVertexColorProperty::SourceVertexMode sourceMode, NiVertexColorProperty::LightingMode lightMode, NiVertexColorProperty* prop );
	~cVertexColorData();

public:
	NiVertexColorProperty::SourceVertexMode mSourceMode;
	NiVertexColorProperty::LightingMode mLightMode;

	NiVertexColorProperty* mProp;
};

///   
class cSceneNodeParam
{
public:
	cSceneNodeParam();

public:
	unsigned long mWoldAccumTime;

	///  ̸
	mutable cString mPathName;

	/// ġ
	mutable NiPoint3 mTranslate;

	/// ȸ
	mutable NiMatrix3 mRotate;

	/// 
	mutable float mScale;

	/// ŷ
	mutable NiPick::PickType mPickType;
	mutable NiPick::SortType mPickSort;
	mutable NiPick::IntersectType mPickIntersect;
	mutable NiPick::CoordinateType mPickCoordinate;
	mutable bool mPickFrontOnly;
	mutable bool mPickReturnTexture;
	mutable bool mPickReturnNormal;
	mutable bool mPickReturnColor;
};

///  
class cSceneNode
{
	friend class cSceneManager;
	friend class cSceneTree;
	friend class cSceneTreeNode;

public:
	///   Ÿ
	enum eType
	{
		eNULL			= 0,
		eRENDERING		= (1 <<  0),

		eAREA			= (1 <<  1),
		eLIGHT			= (1 <<  2),
		eSOUND			= (1 <<  3),
		eSTATIC			= (1 <<  4) | eRENDERING,
		eMANAGEDSTATIC	= (1 <<  5) | eSTATIC,
		eDYNAMIC		= (1 <<  6) | eRENDERING,
		eEFFECT			= (1 <<  7) | eRENDERING,

		eDROPITEM		= (1 <<  8) | eMANAGEDSTATIC,
		eMAPPORTAL		= (1 <<  9) | eMANAGEDSTATIC,
		eGATHERING		= (1 << 10) | eMANAGEDSTATIC,

		ePLAYER			= (1 << 11) | eDYNAMIC,
		eNPC			= (1 << 12) | eDYNAMIC,
		eMONSTER		= (1 << 13) | eDYNAMIC,
		eVEHICLE		= (1 << 14) | eDYNAMIC,

		eHERO			= (1 << 15) | ePLAYER,
	};

	enum eTypeVer8
	{
		eNULL_VER8	= 0,
		eAREA_VER8,
		eLIGHT_VER8,
		eSOUND_VER8,
		eSTATIC_VER8,
		eDYNAMIC_VER8,
	};

public:
	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void ProcessAlpha( unsigned long deltaTime );
	virtual bool OnVisible();

	/// ŷ
	virtual bool Pick( const cRay& ray );

	/// ŷ 
	/// : Pick() ȣ Ŀ ؾ Ѵ.
	const NiPick::Results& GetPickResults();
	const NiPoint3& GetPickPos();
	float GetPickDistance();

	///  
	virtual void SetAlphaBlended( float targetAlpha );
	bool IsAlphaBlended();
	virtual void UpdateAlpha();

	/// Ÿ
	eType GetType();
	bool IsKindof( eType type );

	bool IsEnableFrustumFlag() { return mCheckFrustum; }

	/// ̵
	virtual void Translate( const NiPoint3& move );
	virtual void SetTranslate( const NiPoint3& trans );
	const NiPoint3& GetTranslate();

	virtual void SetWorldTranslate( const NiPoint3& trans );
	virtual const NiPoint3& GetWorldTranslate();

	/// ȸ
	virtual void SetRotate( const NiPoint3& axis, float angle );
	virtual void SetRotate( float xangle, float yangle, float zangle );
	virtual void SetRotate( const NiMatrix3& rot );
	const NiMatrix3& GetRotate();
	const NiMatrix3& GetWorldRotate();

	/// ũ
	virtual void SetScale( float scale );
	float GetScale();
	float GetWorldScale();

	///  
	const cSphere& GetBoundSphere();

	/// ߽
	virtual const NiPoint3& GetCenter();

	/// 
	virtual float GetRadius();

	///  
	virtual unsigned int WhichSide( const NiPlane& plane );

	/// ̸
	const char* GetName();

	static NiGeometry* GetGeom( NiAVObject* obj );
	static void SetAppCulled( NiAVObject* obj, bool cull );

	virtual void SetSelectLightFlag( bool attach );

	virtual void Play( unsigned long ) {}
	virtual void Rew( unsigned long ) {}
	virtual void Stop() {}

	virtual void SetViewNode( bool view );
	virtual bool IsViewNode() { return mViewNode; }

	inline unsigned int GetIndexByManger() { return mIndexByManager; }

	virtual inline NiNode* GetNiNode() { return mSceneNiNode; }
	virtual inline NiAVObject* GetNiObj() { return (NiAVObject*)mSceneNiNode; }

protected:
	cSceneNode( eType = eNULL );
	virtual ~cSceneNode();

	/// ʱȭ
	virtual bool Init( const cSceneNodeParam& param );

	/// ׷  (  ſ䱸 )
	void CollectGeoms( NiAVObject* obj );
	void CollectBillboards( NiAVObject* obj );
	void CollectProperties( NiAVObject* obj ); /// 

	void ClearCollectInfo();

	///  Ʈ  迭 ߰
	virtual void AddToVisibleArray();

	///  
	unsigned int CalcVisibleLevel();

	void LogNiNodeInfo( NiAVObject* obj );

protected:
	/// Ÿ
	eType mType;

	/// ŷ
	///  Ʈ ̿ 浹 ˻  ŷ ϰ,   Ѵ.
	NiPick mPick;
	NiPoint3 mPickPos;
	float mPickDistance;

	/// 
	bool mViewNode;

	///  ʿ 
	bool mNeedUpdateTransform;

	///  
	cSphere mBoundSphere;

	/// 
	bool mEnableAlphaProcess;
	float mTargetAlpha;
	float mAlpha;
	float mAlphaSpeed;

	/// over & select node attach selectLight
	bool mAttachSelectLight;
	bool mUpdateSelectLIght;

	///  迭
	typedef tArray<void*> cLightArray;
	cLightArray mLightArray;

	///  ڿ    ε
	unsigned int mIndexByManager;

	/// ̳ʿ    ݺ
	bool mIteratorValid;
	tPointerList<void*>::cIterator mIteratorByContainer;

	///  Ӽ Ʈ
	typedef tList<void*> cMatPropList;
	cMatPropList mMatPropList;

	///  Ÿ Ʈ
	typedef tList<void*> cAlphaDataList;
	cAlphaDataList mAlphaDataList;

	typedef tList<void*> cVertexColorList;
	cVertexColorList mVertexColorDataList;

	///  Ʈ Ʈ
	typedef tPair<NiGeometry*, int> cGeomPair;
	typedef tList<cGeomPair> cGeomList;
	cGeomList mGeomList;

	///   Ʈ
	typedef tList<void*> cBillboardList;
	cBillboardList mBillboardList;

	///  Ʈ
//	NiAVObjectPtr mNiObject;
	NiNodePtr mSceneNiNode;

	/// ̳
	///  带 ϴ  Ʈ 
	cSceneTreeNode* mContainer;

	bool mCheckFrustum;

protected:
	/// ø
	static NiCamera* mCamera;
	static NiVisibleArray* mSolidArray;
	static NiVisibleArray* mAlphaArray;
	static NiVisibleArray* mAlphaTestArray;
};

inline
const NiPick::Results& cSceneNode::GetPickResults()
{
	return mPick.GetResults();
}

inline
const NiPoint3& cSceneNode::GetPickPos()
{
	return mPickPos;
}

inline
float cSceneNode::GetPickDistance()
{
	return mPickDistance;
}

inline
void cSceneNode::SetAlphaBlended( float targetAlpha )
{
	mTargetAlpha = targetAlpha;

	if( mAlpha != mTargetAlpha )
		mEnableAlphaProcess = true;
}

inline
bool cSceneNode::IsAlphaBlended()
{
	if( mAlpha < 1.0f - FLT_EPSILON )
		return true;
	else
		return false;
}

inline
cSceneNode::eType cSceneNode::GetType()
{
	return mType;
}

inline
bool cSceneNode::IsKindof( eType type )
{
	return (mType & type) == type;
}

inline
const NiPoint3& cSceneNode::GetTranslate()
{
	return GetNiObj()->GetTranslate();
}

inline
const NiMatrix3& cSceneNode::GetRotate()
{
	return GetNiObj()->GetRotate();
}

inline
float cSceneNode::GetScale()
{
	return GetNiObj()->GetScale();
}

inline
const NiPoint3& cSceneNode::GetWorldTranslate()
{
	return GetNiObj()->GetWorldTranslate();
}

inline
const NiMatrix3& cSceneNode::GetWorldRotate()
{
	return GetNiObj()->GetWorldRotate();
}

inline
float cSceneNode::GetWorldScale()
{
	return GetNiObj()->GetWorldScale();
}

inline
const cSphere& cSceneNode::GetBoundSphere()
{
	return mBoundSphere;
}

inline
unsigned int cSceneNode::WhichSide( const NiPlane& plane )
{
	float dist = plane.Distance( GetCenter() );
	float radius = GetRadius();

	if( dist <= -radius )
		return NiPlane::NEGATIVE_SIDE;
	else if( dist >= radius )
		return NiPlane::POSITIVE_SIDE;
	else
		return NiPlane::NO_SIDE;
}

inline
const char* cSceneNode::GetName()
{
	return (const char*)GetNiObj()->GetName();
}

inline
void cSceneNode::SetSelectLightFlag( bool attach )
{
	if( mAttachSelectLight != attach )
	{
		mAttachSelectLight = attach;
		mUpdateSelectLIght = true;

		mNeedUpdateTransform = true;
	}
}

///    Լ
/// ŷ Ÿ Ѵ.
class cSceneNodeCompareForPicking
{
public:
	bool operator () ( const void* left, const void* right ) const
	{
		return ( ((cSceneNode*)left)->GetPickDistance() < ((cSceneNode*)right)->GetPickDistance() );
	};
};
