/* ==========================================================================
*    : ̼
*    : 2006.12.07
*      :  Ʈ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Sphere.h"
#include "SceneNode.h"

class cCamera;
class cSceneTree;
//class cSceneCuller;

/// ׽Ʈ 
///  带  ϴ  ˻ϴµ δ.
class cTestSphere : public cSphere
{
public:
	/// ˻ 
	bool mResult;
};

///  Ʈ 
///    ϴ ̴̳.
class cSceneTreeNode : public cSphere
{
	friend class cSceneTree;

public:
	cSceneTreeNode( cSceneTree* tree, cSceneTreeNode* parent, const NiPoint3& center, float radius );
	cSceneTreeNode( cSceneTree* tree, cSceneTreeNode* parent, const cSphere& sphere );
	~cSceneTreeNode();

	void* operator new( size_t n ); 
	void operator delete( void* p );

	///  带 ߰
	void Push( cSceneNode* node );

	///  带 
	void Remove( cSceneNode* node );

	///   ̵ Ǵ ũ ȭ  
	void Update( cSceneNode* node );

	/// ø
	void Cull();

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool CollideRay_Kind();

	///  浹ϴ   
	///   ˻Ѵ.
	bool CollideSphere_Kind();
	bool CollideSphere_Type();

protected:
	///  迭 ߰
	void AddToVisibleArray() const;

	void PushDirect( cSceneNode* node );

private:
	/// Ʈ
	cSceneTree* mTree;

	/// θ
	cSceneTreeNode* mParent;

	/// ڽ 迭
	cSceneTreeNode* mChild[4];

	/// ׽Ʈ 
	cTestSphere mTestSpheres[4];

	///   Ʈ
	typedef tPointerList<void*> cObjectList;
	cObjectList mObjectList;

	/// ޸ Ǯ
	static tPool<cSceneTreeNode> mPool;

	/// ø
	static NiFrustumPlanes* mFrustum;
	static cSceneNode::eType mPickType;

	/// 浹 ˻
	static const cRay* mRay;
	static float mMaxDistance;
	static const cSphere* mSphere;
	static tArray<void*>* mCollidedArray;
};

///  Ʈ
///      øϰų 浹 ˻縦 ϱ  Ѵ.
class cSceneTree
{
public:
	cSceneTree();
	virtual ~cSceneTree();

	///    
	void Clear();

	/// ʱȭ
	void Init( const NiPoint3& center, float minRadius, float maxRadius );

	///  带 ߰
	void Push( cSceneNode* node );

	/// ø
	void Cull( NiVisibleArray* solidArray, NiVisibleArray* alphaArray, NiVisibleArray* alphaTestArray, cCamera* cam, cSceneNode::eType type );

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool CollideRay_Kind( tArray<void*>* collidableArray, const cRay& ray, float maxDistance, bool sortByDistance, cSceneNode::eType type );

	///  浹ϴ   
	///   ˻Ѵ.
	bool CollideSphere_Kind( tArray<void*>* collidableArray, const cSphere& sphere, cSceneNode::eType type );
	bool CollideSphere_Type( tArray<void*>* collidableArray, const cSphere& sphere, cSceneNode::eType type );

	///  
	const NiPoint3& GetCenter() const;

	/// ּ  
	float GetMinRadius() const;

	/// ִ  
	float GetMaxRadius() const;

	/// ִ θ 
	bool IsEmpty() const;

protected:
	/// Ʈ 
	cSceneTreeNode* mRootNode;

	/// 
	NiPoint3 mCenter;

	/// ּ 
	float mMinRadius;

	/// ִ 
	float mMaxRadius;
};

inline
const NiPoint3& cSceneTree::GetCenter() const
{
	return mCenter;
}

inline
float cSceneTree::GetMinRadius() const
{
	return mMinRadius;
}

inline
float cSceneTree::GetMaxRadius() const
{
	return mMaxRadius;
}

inline
bool cSceneTree::IsEmpty() const
{
	return mRootNode ? false : true;
}
