#include "Stdafx.h"
#include "ScrollBar.h"
#include "Token.h"
#include "UISkinLexer.h"
#include "Parser.h"

#include "UIImage.h"
#include "UIContainer.h"
#include "PlaneObject.h"

#include "Button.h"
#include "BarButton.h"

cScrollBar::cScrollBar( eUINodeType type )
: cUIWindow( type )
, mpScrollImage(0)
, mpUpButton(0)
, mpDownButton(0)
, mpBarButton(0)
{	
}

cScrollBar::~cScrollBar()
{
	SAFE_DELETE( mpScrollImage );

	mpBarButton = 0;
	mpDownButton = 0;
	mpUpButton = 0;
}

void cScrollBar::OnShow()
{
	mpBarButton->Show();
	mpDownButton->Show();
	mpUpButton->Show();

	cUIWindow::OnShow();
}

void cScrollBar::OnHide()
{
	cUIWindow::OnHide();

	mpBarButton->Hide();
	mpDownButton->Hide();
	mpUpButton->Hide();
}

/// ǻ : 
bool cScrollBar::OnCreate( cUINodeProperty* )
{
	mpBarButton = new cBarButton;
	if( mpBarButton->CreateBySkinName( mBarButtonSkin, this, eSCROOLBAR_BARBUTTON ) == false )
	{
		return false;
	}

	mpUpButton = new cButton;
	if( mpUpButton->CreateBySkinName( mUpButtonSkin, this, eSCROOLBAR_UP ) == false )
	{
		return false;
	}

	mpDownButton = new cButton;
	if( mpDownButton->CreateBySkinName( mDownButtonSkin, this, eSCROOLBAR_DOWN ) == false )
	{
		return false;
	}

	/// BAR ư ġ ũѹٸ  
	cUIPos pos;
	pos.mX = 0;
	pos.mY = mpUpButton->GetRelativeRect().mBottom;
	mpBarButton->SetRelativePos( pos );

	return true;
}

/// ǻ : 
bool cScrollBar::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_SCROLLBAR ) == false )
	{
		assert( 0 && "not editbox skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}
	
	cScrollBarSkin* p = (cScrollBarSkin*)pskin;

	mBarButtonSkin = p->mBarButtonSkin;
	mUpButtonSkin = p->mUpButtonSkin;
	mDownButtonSkin = p->mDownButtonSkin;

	cUISkin* pUISkin = UIMAN->GetSkin();
	if( !pskin )
	{
		assert(0);
		return false;
	}

	/// Ų  ȿ ˻
	if( mBarButtonSkin && pUISkin->GetNodeSkin( mBarButtonSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}
	if( mUpButtonSkin && pUISkin->GetNodeSkin( mUpButtonSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}
	if( mDownButtonSkin && pUISkin->GetNodeSkin( mDownButtonSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}

	if( pskin->mpTexture )
	{
		/// ؽó  
		unsigned short w = (unsigned short)pskin->mSkinInfo->mWidth;
		unsigned short h = (unsigned short)pskin->mSkinInfo->mHeight;
		unsigned short tx = (unsigned short)pskin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)pskin->mSkinInfo->mTexY;

		mpScrollImage = new cPlaneObject;
		if( mpScrollImage->Create( pskin->mpTexture, 0, 0, w, h, tx, ty, tx + w, ty + h ) == false )
		{
			assert( 0 && "failed to create scroll back image");
			return false;
		}
	}

	/// ü̹  ؼ ϹǷ ʿ 
	SAFE_DELETE( mpImage );

	return true;
}

/// ǻ : 
bool cScrollBar::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false || mVisible == false )
	{
		return true;
	}

	if( event.mType == eUIEVENT_SCROLLBAR_MOVE )
	{
		UpdateBarButtonPos( event.mPos );
	}
	if( event.mType == eUIEVENT_LBUTTON_DBLCLK )
		return true;
	if( event.mType == eUIEVENT_LBUTTON_DOWN ||
		event.mType == eUIEVENT_MOUSE_MOVE )
		return true;

	return mpParent->HandleEvent( event );
}

/// ǻ : 
void cScrollBar::UpdateSkin()
{
	cUIWindow::UpdateSkin();
	
	/// BAR ư ġ ũѹٸ  
	if( mpUpButton && mpBarButton )
	{
		cUIPos pos;
		pos.mX = 0;
		pos.mY = mpUpButton->GetRelativeRect().mBottom;
		mpBarButton->SetRelativePos( pos );
	}
}

///
void cScrollBar::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpScrollImage )
	{
		mpScrollImage->SetScreenXY( (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop );
	}
}

/// ǻ : 
void cScrollBar::OnRender( cUIFontItemKeeper* pKeeper )
{
	/// ̹ 
	if( mpScrollImage )
	{
		mpScrollImage->Draw();
	}

    /// ڽ 
	cUIWindow::OnRender(pKeeper);
}

/// ǻ : ũѹ ٹư ϰ, 
void cScrollBar::UpdateBarButtonPos( const cUIPos& pos )
{
	/// ũѹٰ ׷ ʴ ¸ 
	if( mpBarButton->IsVisible() == false )
		return;

	cUIRect child = mpBarButton->GetAbsoluteRect();
	cUIPos& oldPos = mpBarButton->GetOldMousePos();

	int uppos = mpUpButton->GetAbsoluteRect().mBottom;
	int downpos = mpDownButton->GetAbsoluteRect().mTop;
	int value = 0;

	///  ̵̸
	cUIRect parentRc = mpParent->GetAbsoluteRect();
	if( parentRc.ContainPoint( pos ) == false )
		return;

	if( pos.mY - oldPos.mY < 0 )
	{
		if( child.mTop > uppos )
		{
			if( child.mTop + pos.mY - oldPos.mY < uppos)
			{
				/// ּ ġ 
				value = uppos - child.mTop;
			}
			else
			{
				/// 콺 ̵ ŭ ̵
				value = pos.mY - oldPos.mY;
			}
		}
		mpBarButton->MoveY( value , pos );
	}
	/// Ʒ ̵̸
	else if( pos.mY - oldPos.mY > 0 )
	{
		if( child.mBottom < downpos )
		{
			/// 
			if( child.mBottom + pos.mY - oldPos.mY >= downpos )
			{
				/// ִ ġ 
				value = downpos - child.mBottom;
			}
			else
			{
				/// 콺 ̵ ŭ ̵
				value = pos.mY - oldPos.mY;
			}
		}
		mpBarButton->MoveY( value , pos );
	}
}

/// ǻ : 
void cScrollBar::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUIWindow::OnLButtonDown( pos, ctrl, alt, shift );

	if( GetCapture() != this )
	{
		SetCapture();
	}
}

/// ǻ : 
void cScrollBar::OnLButtonUp( const cUIPos& pos )
{
	///  ۿ 콺 
	if( mAbsoluteRect.ContainPoint( pos ) == false )
	{
		ReleaseCapture();
	}
}

/// ǻ : ũѹ ʱ X ġ  
void cScrollBar::SetPosX( unsigned int x )
{
	if( mpScrollImage )
	{
		cUIPos pos;
		pos.mX = x;
		pos.mY = GetRelativeRect().mTop;
		SetRelativePos( pos );

		mpScrollImage->SetScreenXY( (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop );
	}
}

void cScrollBar::SetPosY( unsigned int y )
{
	if( mpScrollImage )
	{
		cUIPos pos;
		pos.mX = GetRelativeRect().mLeft;
		pos.mY = y;
		SetRelativePos( pos );

		mpScrollImage->SetScreenXY( (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop );
	}
}

/// ǻ : ũѹ ̰  
void cScrollBar::SetHeight( unsigned int h )
{
	if( mpScrollImage && mpDownButton )
	{
		cUISize size;
		size.mWidth = GetRelativeRect().GetWidth();
		size.mHeight = h;
		SetRelativeSize( size );

		mpScrollImage->SetScreenWH( (short)GetAbsoluteRect().GetWidth(), (short)GetAbsoluteRect().GetHeight() );

		/// DOWN ư ġ ũѹٸ   
		cUIPos pos;
		pos.mX = 0;
		pos.mY = h - mpDownButton->GetRelativeRect().GetHeight();
		mpDownButton->SetRelativePos( pos );
	}
}

/// ǻ : ũѹ ü ̰  ٹư Ⱥش.
void cScrollBar::SetVisibleBarButton( bool visible )
{
	if( !mpBarButton )
		return;

	if( visible )
		mpBarButton->Show();
	else
		mpBarButton->Hide();
}

/// ǻ : ũѹ    (  ư ũ    )
unsigned int cScrollBar::GetScrollBarHeight()
{
	return ( GetAbsoluteRect().GetHeight() - (2 * mpUpButton->GetAbsoluteRect().GetHeight()) );
}

/// ǻ :  ư ġ  
unsigned int cScrollBar::GetBarButtonPosY()
{
	return (mpBarButton->GetRelativeRect().mTop - mpUpButton->GetRelativeRect().GetHeight() );
}

/// ǻ : ũ []   
unsigned int cScrollBar::GetScrollMarginHeight()
{ 
	/// ũѹ  -  ư  - , ٿ ư  
	return ( GetAbsoluteRect().GetHeight() - mpBarButton->GetAbsoluteRect().GetHeight() -
			 (2 * mpUpButton->GetAbsoluteRect().GetHeight()) );
}

/// ǻ :  ư ۾ ִ ּ  
unsigned int cScrollBar::GetMinimumHeight()
{
	return mpUpButton->GetAbsoluteRect().GetHeight();
}

/// ǻ : ũѹ  ư  ó
void cScrollBar::MoveScrollUp( int h )
{
	///  ư top ġ
	int toplimit = mpBarButton->GetAbsoluteRect().mTop;
	/// up ư bottom ġ
	int bottomlimit = mpUpButton->GetAbsoluteRect().mBottom;

	/// top ġ bottom   ư upư հ   ߻
	if( toplimit >= bottomlimit )
	{
		int value = toplimit - bottomlimit;
		///   h  ,
		if( h > value )
		{
			mpBarButton->Move( cUIPos( 0, -value ) );
		}
		else
		{
			mpBarButton->Move( cUIPos( 0, -h ) );
		}
	}
}

/// ǻ : ũѹ Ʒ ư   ó
void cScrollBar::MoveScrollDown( int h )
{
	///  ư bottom ġ
	int bottomlimit = mpBarButton->GetAbsoluteRect().mBottom;
	/// down ư top ġ
	int toplimit = mpDownButton->GetAbsoluteRect().mTop;

	/// bottom ġ top   ư downư հ   ߻
	if( bottomlimit <= toplimit )
	{
		int value = toplimit - bottomlimit;
		///   h  ,
		if( h > value )
		{
			mpBarButton->Move( cUIPos( 0, value ) );
		}
		else
		{
			mpBarButton->Move( cUIPos( 0, h ) );
		}		
	}
}

/////////////////////////////////////////////////////////////////////////
cScrollBarSkin::cScrollBarSkin( eUINodeType type )
: cUINodeSkin( type )
{
}

cScrollBarSkin::~cScrollBarSkin()
{

}

/// ǻ : 
bool cScrollBarSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_BARBUTTONSKIN:
			{
				mBarButtonSkin = parser.ParseString();
			}
			break;
		case eTOKEN_UPBUTTONSKIN:
			{
				mUpButtonSkin = parser.ParseString();
			}
			break;
		case eTOKEN_DOWNBUTTONSKIN:
			{
				mDownButtonSkin = parser.ParseString();
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}		
	}
	return true;
}

