/* ==========================================================================
*      : ScrollBar.h
*      : 
*    : 谡
*    : 2006-10-26
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "UINodeData.h"

class cButton;
class cBarButton;
class cPlaneObject;
class cScrollBar : public cUIWindow
{
public:
	cScrollBar( eUINodeType type = eUINODE_SCROLLBAR );
	virtual ~cScrollBar();

	/// ũѹ ġ  
	void SetPosX( unsigned int x );
	void SetPosY( unsigned int y );

	/// ũѹ ̰  
	void SetHeight( unsigned int h );

	///  ư Ⱥ̰ ϱ( ũѹٰ  ư ϸŭ    )
	void SetVisibleBarButton( bool visible );

	/// ũѹ    (  ư ũ    )
	unsigned int GetScrollBarHeight();

	///  ư ġ   
	unsigned int GetBarButtonPosY();

	///  ư ̵Ҽ ִ  ũ 
	unsigned int GetScrollMarginHeight();

	///  ư   ϱ( ̻ ۾  )
	unsigned int GetMinimumHeight();

	/// ũѹ  ư 
	void MoveScrollUp( int h );

	/// ũѹ  ư ٿ
	void MoveScrollDown( int h );

protected:
	/// ̺Ʈ ó
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	virtual void OnLButtonUp( const cUIPos& pos );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateRect();
	virtual void UpdateSkin();
	virtual void OnShow();
	virtual void OnHide();
	
	/// 
	bool OnCreate( cUINodeProperty* pproperty );

	///  ư ̵ ̺Ʈ ߻ 
	void UpdateBarButtonPos( const cUIPos& pos );

private:
	///  ư Ų ̸
	cString mUpButtonSkin;
	/// ٿ ư Ų ̸
	cString mDownButtonSkin;
	///  ư Ų ̸ 
	cString mBarButtonSkin;

	///  ư
	cButton* mpUpButton;
	/// Ʒ ư 
	cButton* mpDownButton;
	///  ư 
	cBarButton* mpBarButton;

	/// ũѹ  ̹
	cPlaneObject*	mpScrollImage;
};

////////////////////////////////////////////////////////////////////////////
class cScrollBarSkin : public cUINodeSkin
{
public:
	cScrollBarSkin( eUINodeType type = eUINODE_SCROLLBAR );
	virtual ~cScrollBarSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	///  ư Ų ̸
	cString mUpButtonSkin;
	///  ư Ų ̸
	cString mBarButtonSkin;
	/// ٿ ư Ų ̸
	cString mDownButtonSkin;
};

