#include "stdafx.h"
#include "SelectStage.h"
#include "StageManager.h"
#include "MakeStage.h"

#include "ObjectManager.h"
#include "SelectUIManager.h"

#include "SelectWindow.h"
#include "ChannelWindow.h"

#include "UIMsgboxEvent.h"

#include "CameraManager.h"
#include "LookAtCamera.h"

#include "worldmanager.h"
#include "SceneManager.h"
#include "DisplayObject.h"
#include "cardsceneNode.h"

#include "MouseAgent.h"
#include "KeyboardAgent.h"
#include "LightAgent.h"

#include "Application.h"

#include "EffectSceneNode.h"

cSelectStage::cSelectStage()
: mpSelectUIManager(0)
{
	mCurrentSelectIndex = 0;
	mSelectEffectIdx = UINT_MAX;
	mDisplayObject = 0;

	mCardMoving = false;
	mCardMoveState = cCardSceneNode::eCard_Stop;
	mCardMoveCount = 0;
}

cSelectStage::~cSelectStage()
{
	ClearDisplayObject();

	for(unsigned int i=0;i<5; i++)
	{
		mCardDramaObj[i] = 0;
	}
}

void cSelectStage::Init( cStageManager* pStageManager )
{
	mpStageManager = pStageManager;

	for(unsigned int i=0;i<5; i++)
	{
		mCardDramaObj[i] = 0;
	}
	mCardMoveState = cCardSceneNode::eCard_Stop;
}

void cSelectStage::InitStage()
{
	if( mInit )	return;

	/// UI
	mpSelectUIManager = new cSelectUIManager;
	mpSelectUIManager->Init();

	mInit = true;
}

void cSelectStage::Exit()
{
	/// UI
	SAFE_DELETE( mpSelectUIManager );

	mpStageManager = 0;
}

void cSelectStage::Open()
{
	if( !mpStageManager )	return;

//	mCurrentSelectIndex = 0;

	mSelectEffectIdx = UINT_MAX;

	WORLDMAN->Close();

	/// UI
	mpSelectUIManager->Open();

	/// 070406 ߰ - ö [ä & ĳ Ʈ û]
	if ( NETWORK->IsConnected( ) == true )
	{
		MSGROOT msg;

		///// INIT MSGROOT.
		//memset( &msg, 0, sizeof(msg) );
		///// SET MSGROOT [CATEGORY & PROTOCOL].
		//msg.Category    = NM_USER;
		//msg.Protocol    = NM_USER_CHANNEL_LIST_REQ;
		///// SEND MSGROOT.
		//NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		/// INIT MSGROOT.
		memset( &msg, 0, sizeof(msg) );
		/// SET MSGROOT [CATEGORY & PROTOCOL].
		msg.Category = NM_USER;
		msg.Protocol = NM_USER_CHARACTER_LIST_REQ;
		/// SEND MSGROOT.
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		/// Msgbox 
		UIMAN->CreateModal( eStage_Select,
			eMBEVENT_NONE, 
			GAMERESOURCEMAN->GetGameText( 11 ), // ĳ 
			GAMERESOURCEMAN->GetGameText( 2 ), // ˸
			eSKIN_NONE
			);
	}

#ifdef NOCONNECT_SERVER
	mpStageManager->ChangeStage( eStage_Load );
#endif
}

void cSelectStage::Close()
{
	/// UI
	mpSelectUIManager->Close();

	ClearDisplayObject();

//	SCENEMAN->Clear();
//*
	for( unsigned int i=0; i<5;i++ )
	{
		if( mCardDramaObj[i] == 0 )
			continue;

		mCardDramaObj[i]->SetViewNode( false );
	}
	mCardMoveState = cCardSceneNode::eCard_Stop;
//*/
}

void cSelectStage::Process( unsigned long deltaTime, unsigned long accumTime )
{
	if( mCardMoving == true )
	{
		bool cardStop=true;
		for( unsigned int i=0;i<5;i++ )
		{
			if( mCardDramaObj[i]->GetMoveState() != cCardSceneNode::eCard_Stop )
				cardStop = false;

			if( mCardDramaObj[i]->GetCurrentPosIdx() == 0 )
				mCurrentSelectIndex = i;
		}

		if( mCardMoveCount )
		{
			if( mCardMoveState == cCardSceneNode::eCard_Rew )
				RewCard();
			else if( mCardMoveState == cCardSceneNode::eCard_Play )
				PlayCard();

			mCardMoveCount--;
		}
		else
		{
			if( cardStop == true )
			{
				mCardMoveState = cCardSceneNode::eCard_Stop;
				mCardMoving = false;

				cDisplayObject* p = (cDisplayObject*)mDisplayObjectMap.GetAt(mCurrentSelectIndex);
				if( p )
				{
					NiTransform trans;
					trans.MakeIdentity();
					cEffectSceneNode* eff = p->SetLinkdEffect( eLINK_FOOT, "./Map/MapBegin/character_select_effect.nif", &trans, false, true );
					if( eff )
						mSelectEffectIdx = eff->GetIndexByManger();

					/// setting window info
					mpSelectUIManager->SetSelectInfo( (int)p->GetLevel(), p->GetName(), p->GetJob(), p->GetMapNum() );
					mpSelectUIManager->SetSelectWindowFrame( cSelectWindow::eShow_StartButton, true );
				}
				else
					mpSelectUIManager->SetSelectWindowFrame( cSelectWindow::eShow_MakeButton, true );

				mDisplayObject = p;
			}
		}
	}

	/// UI
	mpSelectUIManager->Process( accumTime );

	for( unsigned int i=0;i<5;i++ )
	{
		cDisplayObject* p = (cDisplayObject*)mDisplayObjectMap.GetAt(i);
		if( p )
		{
			assert( mCardDramaObj[i] );

			p->SetPos( mCardDramaObj[i]->GetDummyTrans() );
			p->SetRot( mCardDramaObj[i]->GetDummyRot() );

			p->Update( deltaTime, accumTime );
		}
	}
}

void cSelectStage::ProcessLButtonClick( cMouseAgent* pMouse )
{
	pMouse;
}

void cSelectStage::ProcessLButtonDClick( cMouseAgent* pMouse )
{
	int mouseX = pMouse->GetMouseEventX();
	int mouseY = pMouse->GetMouseEventY();

	/// ѹ ˻ϵ..
	mCollidableArray.Clear();
	if( SCENEMAN->PickDynamics(&mCollidableArray, mouseX, mouseY, true) == true )
	{
		cSceneNode* n = (cSceneNode*)mCollidableArray[0];
/*
		if( n->GetType() == cSceneNode::eCARDDRAMA )
		{
			cSelectStageCardSceneNode* p = (cSelectStageCardSceneNode*)n;
			unsigned int index = p->GetOverIndex();

			if( index != 0 )
			{
				switch( mViewState )
				{
				case eVIEW_LIST:
					{
						mCurrentSelectIndex = index;
						if( mDisplayObjectMap.GetAt( mCurrentSelectIndex ) == 0 )
						{
							if( 0 < mCurrentSelectIndex && mCurrentSelectIndex < 6 )
							{
								STAGEMAN->ChangeStage( eStage_Make );

								cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
								if( p )
									p->SetMakeStandIndex( mCurrentSelectIndex - 1 );
							}

							return;
						}
						SetViewState( eVIEW_GATHERING );
					}
					break;
				case eVIEW_CHANNEL:
					{
						if( 0 < index && index < 6 )
						{
							SetViewState( eVIEW_RETURNING );
							mCurrentSelectIndex = 0;
						}
					}
					break;
				}
			}
		}
*/
	}
}

void cSelectStage::ProcessMouseover( unsigned long /*time*/, cMouseAgent* pMouse )
{
//	if( mViewState <= eVIEW_CHANNEL )
//		return;

	int mouseX = pMouse->GetMouseX();
	int mouseY = pMouse->GetMouseY();

	mCollidableArray.Clear();
	if( SCENEMAN->PickDynamics(&mCollidableArray, mouseX, mouseY, true) == true )
	{
		cSceneNode* n = (cSceneNode*)mCollidableArray[0];
/*
		if( n->GetType() == cSceneNode::eCARDDRAMA )
		{

		}
*/
	}
}

void cSelectStage::NetworkMsgParser( unsigned long /*connectionindex*/, char* pMsg, unsigned long /*length*/ )
{
	MSGROOT* pTemMsg = (MSGROOT*)pMsg;
	switch( pTemMsg->Category )
	{
	case NM_USER:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_USER_CHANNEL_LIST_RES:
				{
					Msg_UserChannelListAck( pTemMsg );
				}
				break;
			case NM_USER_CHARACTER_LIST_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pTemMsg;

					if( pmsg->ErrorCode == 0 )
					{
						Msg_UserCharacterListAck( pTemMsg );
					}
					else
					{
						///  ó..
						return;
					}
				}
				break;
			case NM_USER_CHARACTER_DELETE_RES:
				{
					MSG_RES_CHARACTER_DELETE* pmsg = (MSG_RES_CHARACTER_DELETE*)pTemMsg;
					
					switch( pmsg->ErrorCode )
					{
					case ERROR_CHARACTER_DELETE_SUCCESS:
						{
							///  Ϸ ĳ  û.
							MSGROOT msg;
							/// INIT MSGROOT.
							::memset( &msg, 0, sizeof(msg) );
							/// SET MSGROOT [CATEGORY & PROTOCOL].
							msg.Category = NM_USER;
							msg.Protocol = NM_USER_CHARACTER_LIST_REQ;
							/// SEND MSGROOT.
							NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );


							cDisplayObjectMap::cIterator i = mDisplayObjectMap.Begin();
							cDisplayObjectMap::cIterator end = mDisplayObjectMap.End();
							for( ; i != end; ++i )
							{
								cDisplayObject* p = (cDisplayObject*)(*i).mSecond;
								if( p && p->GetObjectID() == pmsg->CharacterIdx )
								{
									/// option file 
									char name[MAX_NAME_BUFFER_SIZE];	/// ̵
									ConvertToAscii( p->GetName(), name, MAX_NAME_BUFFER_SIZE );

									cString str;
									str.Format( "./Option/%s_%d.opc",  name, p->GetObjectID()%1000 );
									FileRemove( str );
								}
							}
						}
						break;
					case ERROR_CHARACTER_DELETE_FAIL:
						{
							UIMAN->ModalEventFromGameSystem( true );

							/// Msgbox 
							UIMAN->CreateModal( eStage_Select,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 13 ),
								GAMERESOURCEMAN->GetGameText( 2 ),
								eSKIN_OK
								);
						}
						break;
					case ERROR_CHARACTER_DELETE_GUILDMASTER:
						{
							UIMAN->ModalEventFromGameSystem( true );

							UIMAN->CreateModal( eStage_Select,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 27 ),
								GAMERESOURCEMAN->GetGameText( 2 ),
								eSKIN_OK
								);
						}
						break;
					}
				}
				break;
			case NM_USER_COME_IN_GAME_RES:
				{
					/// ӽ  - 0 / 1н 
					MSG_RES_COMEIN_GAME* msg = (MSG_RES_COMEIN_GAME*)pMsg;
					if ( msg->ErrorCode )
					{
						/// н ó
						UIMAN->ModalEventFromGameSystem( false );
						msg->ErrorCode;
					}
				}
				break;
			case NM_USER_GAMESRV_RES:
				{
					/// Ӽ  - 0 / 1н 
					MSG_RES_GAMESRV* msg = (MSG_RES_GAMESRV*)pMsg;
					if ( msg->ErrorCode == 0 )
					{
//						UIMAN->ModalEventFromGameSystem( true );

						MSGROOT msg;

						/// INIT MSGROOT.
						memset( &msg, 0, sizeof(msg) );
						/// SET MSGROOT [CATEGORY & PROTOCOL].
						msg.Category    = NM_USER;
						msg.Protocol    = NM_USER_CHANNEL_LIST_REQ;
						/// SEND MSGROOT.
						NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

						/// INIT MSGROOT.
						//memset( &msg, 0, sizeof(msg) );
						/// SET MSGROOT [CATEGORY & PROTOCOL].
						//msg.Category = NM_USER;
						//msg.Protocol = NM_USER_CHARACTER_LIST_REQ;
						/// SEND MSGROOT.
					    //NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

						/// Msgbox 
						/*UIMAN->CreateModal( eStage_Server,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 11 ),
							GAMERESOURCEMAN->GetGameText( 2 ),
							eSKIN_NONE
							);*/
					}
					else
					{
						UIMAN->ModalEventFromGameSystem( false );
						msg->ErrorCode;
					}
				}
				break;
			case NM_USER_CHARACTER_SELECT_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pTemMsg;
					if( pmsg->ErrorCode == 0 )
					{
						UIMAN->ModalEventFromGameSystem( true );

						/// 
						Msg_HeroSelectAck( pTemMsg );
					}
					else
					{
						UIMAN->ModalEventFromGameSystem( false );

						/// 
						Msg_HeroSelectNack( pTemMsg );
					}
				}
				break;
			}
		}
		break;
	}
	/*
	case NM_HERO:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_HERO_SELECT_ACK:		Msg_HeroSelectAck( pTemMsg );		break;
			case NM_HERO_SELECT_NACK:		Msg_HeroSelectNack( pTemMsg );		break;
			}
		}
		break;
		*/
}

/// msg funtions
void cSelectStage::Msg_UserChannelListAck( MSGROOT* pMsg )
{
	/// äθƮ  -  äθƮ / н  
	MSG_RES_CHANNELLIST* pMsgResChannellist = (MSG_RES_CHANNELLIST*)pMsg;

	/// ä ֱ.
	cChannelWindow* pChannelWindow = (cChannelWindow*)UIMAN->GetContainer( eUIID_CHANNEL_WINDOW );
	if( pChannelWindow )
		pChannelWindow->Clear();

	///  ߶ äο 
	STAGEMAN->SetChannelIdx( pMsgResChannellist->ChannelNo );

	unsigned long color = eCOLOR_GRAY;
	for ( unsigned long i = 0; i < pMsgResChannellist->RowCount; i++ )
	{
		cStringT Name;
		TCHAR   buffer[260];

		UIMAN->GetUIText( &Name, 704);
		::_stprintf( buffer, _T("%02d"), pMsgResChannellist->Channels[ i ].NumOfChannel );
		Name += buffer;

		unsigned int textId = 0;
		switch ( pMsgResChannellist->Channels[ i ].Status )
		{
			/// ʰ
		case 4: textId = 700; color = eCOLOR_RED;
			break;
			/// ȥ
		case 3: textId = 701; color = eCOLOR_ORANGE;
			break;
			/// ȣ
		case 2: textId = 702; color = eCOLOR_GREEN;
			break;
			/// غ
		case 1: 
		default:
			textId = 703; color = eCOLOR_GRAY;
			break;
		}

		if( pChannelWindow && textId > 0 )
		{
			pChannelWindow->AddChannel( pMsgResChannellist->Channels[ i ].NumOfChannel,
				pMsgResChannellist->Channels[ i ].Status,
				Name.Cstr(), UIMAN->GetUIText( textId ), 
				color,
				pMsgResChannellist->ChannelNo == (unsigned long)pMsgResChannellist->Channels[ i ].NumOfChannel
				);			
		}
	}

	if( pChannelWindow )
		pChannelWindow->UpdateButton();

	UIMAN->ModalEventFromGameSystem( true );

	mpSelectUIManager->VisibleChannelState();
}

void cSelectStage::Msg_UserCharacterListAck( MSGROOT* pMsg )
{
	UIMAN->ModalEventFromGameSystem( true );
	ClearDisplayObject();

	mpSelectUIManager->VisibleListState();
	mpSelectUIManager->ClearSelectInfo();
	mpSelectUIManager->SetSelectWindowFrame( cSelectWindow::eShow_MakeButton, true );

	MSG_CHARACTER_LIST* pmsg = (MSG_CHARACTER_LIST*)pMsg;
	if( 0 >= pmsg->CharacterNum )	return;

	MSG_CHARACTER_BASEINFO* pInfo = pmsg->BaseInfo;
	for( unsigned short i=0;i<pmsg->CharacterNum; ++i )
	{
		cDisplayObject* p = new cDisplayObject;
		p->EnableNameCard( true );
		if( !p->Create( &pInfo[i].PlayerInfo, &pInfo[i].WearInfo, &pInfo[i].WeaponInfo, 0, NiPoint3(0.0f, 0.0f, 0.0f)) )
		{
			assert(0);
			SAFE_DELETE(p);
			return;
		}
		p->SetStandIdx( pInfo[i].StandIdx );
		p->SetMapNum( pInfo[i].MapNum );

		///  ..
		if( mDisplayObjectMap.Insert( pInfo[i].StandIdx, p ) == false )
		{
			SAFE_DELETE(p);
			assert(0);
		}

		if( p )
		{
			p->SetPos( mCardDramaObj[ pInfo[i].StandIdx ]->GetDummyTrans() );
			p->SetRot( mCardDramaObj[ pInfo[i].StandIdx ]->GetDummyRot() );

			if( pInfo[i].StandIdx == mCurrentSelectIndex )
			{
				NiTransform trans;
				trans.MakeIdentity();

				cEffectSceneNode* eff = p->SetLinkdEffect( eLINK_FOOT, "./Map/MapBegin/character_select_effect.nif", &trans, false, true );
				if( eff )
					mSelectEffectIdx = eff->GetIndexByManger();

				mpSelectUIManager->SetSelectInfo( (int)p->GetLevel(), p->GetName(), p->GetJob(), p->GetMapNum() );
				mpSelectUIManager->SetSelectWindowFrame( cSelectWindow::eShow_StartButton, true );

				mDisplayObject = p;
			}
		}
	}
}

void cSelectStage::Msg_HeroSelectAck( MSGROOT* pMsg )
{
	MSG_PLAYERINFO* pmsg = (MSG_PLAYERINFO*)pMsg;
	mpStageManager->SetMapIdx( pmsg->MapNum );

	mpStageManager->ChangeStage( eStage_Load );

	///   HEROü 
	OBJECTMANAGER->AddHeroFromServerMsg( pMsg );
}

void cSelectStage::Msg_HeroSelectNack( MSGROOT* /*pMsg*/ )
{
	NiMessageBox( "NM_HERO_SELECT_NACK", "Error!!" );
}

void cSelectStage::ClearDisplayObject()
{
	if( mDisplayObjectMap.GetSize() )
	{
		cDisplayObjectMap::cIterator i = mDisplayObjectMap.Begin();
		cDisplayObjectMap::cIterator end = mDisplayObjectMap.End();
		for( ; i != end; ++i )
		{
			cDisplayObject* p = (cDisplayObject*)(*i).mSecond;
			SAFE_DELETE( p );
		}

		mDisplayObjectMap.Clear();
	}

	if( mSelectEffectIdx != UINT_MAX )
	{
		cEffectSceneNode* eff = SCENEMAN->GetEffectSceneNode( mSelectEffectIdx );
		if( eff )
			eff->Remove();

		mSelectEffectIdx = UINT_MAX;
	}
}

void cSelectStage::CreateSelectMap( bool creatmap )
{
	NiDirectionalLight* light = LIGHTAGENT->GetSceneDirLight( 1 );
	light->SetDimmer( 0.1f );
	light->SetAmbientColor( NiColor(0.2f,0.2f,0.2f) );
	light->SetDiffuseColor( NiColor::BLACK );
	light->SetSpecularColor( NiColor::BLACK );
	light->Update( 0.0f );

	if( creatmap )
	{
		///  
		cStaticSceneNodeParam param;

		/// ⺻ Ӽ ڵ 
		param.mPathName = "./Map/MapBegin/character_select_bg.nif";
		param.mOccludeLevel = 3;
		param.mNoAttachLight = true;
		param.mFogApplied = false;
		param.mDisableAnimation = false;

		///  ʱȭ
		SCENEMAN->Init( NiPoint3::ZERO, 100.0f, 100000.0f );

		/// 带 
		cStaticSceneNode* n = SCENEMAN->CreateStatic( param );
		if( n == 0 )
			return;

		if( n->GetNiObj() == 0 )
		{
			assert(0);
			return;
		}
		NiNode* orien = NiDynamicCast( NiNode, n->GetNiObj()->GetObjectByName("SelectCamera") );
		if( orien == 0 )
		{
			assert(0);
			return;
		}

		NiCamera* cam = 0;
		NiAVObject* child = 0;
		for(unsigned int i=0;i<orien->GetArrayCount();i++)
		{
			child = orien->GetAt(i);
			if( child && NiIsKindOf( NiCamera, child ) == true )
			{
				cam = (NiCamera*)child;
				break;
			}
		}
		if( cam == 0 )
		{
			assert(0);
			return;
		}

		CAMERAMAN->GetCurrent()->ChangeNiCamera( NiSmartPointerCast( NiCamera, cam->CreateDeepCopy() ) );

		NiNode* node = CAMERAMAN->GetCurrent()->GetOrientNode();
		node->SetWorldTranslate( orien->GetWorldTranslate() );
		node->SetWorldRotate( orien->GetWorldRotate() );
		node->SetWorldScale( orien->GetWorldScale() );
		node->SetLocalTransform( orien->GetLocalTransform() );
	}

	cCardSceneNodeParam cparam;
	cparam.mPathName = "./Map/MapBegin/character_select_card.nif";

	bool init = false;
	for(unsigned int i=0;i<5; i++)
	{
		cparam.mCardIndex = i;

		if( mCardDramaObj[i] == 0 )
		{
			mCardDramaObj[i] = SCENEMAN->CreateCard( cparam );
			init = true;
		}

		if( mCardDramaObj[i]->GetCurrentPosIdx() == 0 )
			mCurrentSelectIndex = i;

		mCardDramaObj[i]->SetViewNode( true );
	}

	if( init )
	{
		if( mCardDramaObj[0] )
		{
			mCardDramaObj[0]->UpdateCard( 0.0f );
			mCardDramaObj[0]->SetFrameTime( 0.0f );
		}
		if( mCardDramaObj[1] )
		{
			mCardDramaObj[1]->UpdateCard( 1.0f );
			mCardDramaObj[1]->SetFrameTime( 1.0f );
		}
		if( mCardDramaObj[2] )
		{
			mCardDramaObj[2]->UpdateCard( 50.0f/30.0f );
			mCardDramaObj[2]->SetFrameTime( 50.0f/30.0f );
		}
		if( mCardDramaObj[3] )
		{
			mCardDramaObj[3]->UpdateCard( 70.0f/30.0f );
			mCardDramaObj[3]->SetFrameTime( 70.0f/30.0f );
		}
		if( mCardDramaObj[4] )
		{
			mCardDramaObj[4]->UpdateCard( 3.0f );
			mCardDramaObj[4]->SetFrameTime( 3.0f );
		}
	}
}

void cSelectStage::SendDeleteCharacter()
{
	if( mDisplayObject == 0 )
		return;

	if ( NETWORK->IsConnected( ) == true )
	{
		MSG_REQ_CHARACTER_DELETE msg;
		/// INIT MSGROOT.
		::memset( &msg, 0, sizeof(msg) );
		/// SET MSGROOT [CATEGORY & PROTOCOL].
		msg.Category     = NM_USER;
		msg.Protocol     = NM_USER_CHARACTER_DELETE_REQ;
		/// SET MSG_REQ_COMEIN_GAME.
		msg.CharacterIdx = mDisplayObject->GetObjectID();
		/// SEND MSGROOT
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		/// Msgbox 
		UIMAN->CreateModal( eStage_Select,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 16 ), // ĳ  
							GAMERESOURCEMAN->GetGameText( 2 ), // ˸
							eSKIN_NONE
							);
	}
}

void cSelectStage::SendConnect( long channelNum )
{
	if( mDisplayObject == 0 )
		return;

	if ( NETWORK->IsConnected( ) == true )
	{
		///  ä 
		STAGEMAN->SetChannelIdx( channelNum );

		/// 070404 ߰ - ö [äθƮ û]
		MSG_REQ_COMEIN_GAME msg;
		/// INIT MSGROOT.
		memset( &msg, 0, sizeof(msg) );
		/// SET MSGROOT [CATEGORY & PROTOCOL].
		msg.Category     = NM_USER;
		msg.Protocol     = NM_USER_COME_IN_GAME_REQ;
		/// SET MSG_REQ_COMEIN_GAME.
		msg.NumOfChannel = channelNum;
		msg.CharacterIdx = mDisplayObject->GetObjectID();
		/// SEND MSGROOT
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		///  â 
		UIMAN->CreateModal( eStage_Server,
			eMBEVENT_CONNECT_GAMESRV, 
			GAMERESOURCEMAN->GetGameText( 0 ), //   ޼
			GAMERESOURCEMAN->GetGameText( 2 ), // ˸
			eSKIN_NONE
			);
	}
}

void cSelectStage::PlayCard()
{
	for( unsigned int i=0;i<5; i++)
	{
		if( mCardDramaObj[i] != 0 )
		{
			mCardDramaObj[i]->Play( THEAPP->GetWorldAccumTime() );
		}
	}
}

void cSelectStage::RewCard()
{
	for( unsigned int i=0;i<5; i++)
	{
		if( mCardDramaObj[i] != 0 )
			mCardDramaObj[i]->Rew( THEAPP->GetWorldAccumTime() );
	}
}

void cSelectStage::MoveCard( bool rew )
{
	if( rew )
	{
		if( mCardMoveState == cCardSceneNode::eCard_Play )
			return;

		if( mCardMoveState == cCardSceneNode::eCard_Stop )
			mCardMoveState = cCardSceneNode::eCard_Rew;
	}
	else
	{
		if( mCardMoveState == cCardSceneNode::eCard_Rew )
			return;

		if( mCardMoveState == cCardSceneNode::eCard_Stop )
			mCardMoveState = cCardSceneNode::eCard_Play;
	}

	mCardMoveCount++;
	if( mCardMoveCount > 3 )
		mCardMoveCount = 3;

	if( mCardMoveCount == 1 )
	{
		mCardMoving = true;

		if( mSelectEffectIdx != UINT_MAX )
		{
			cEffectSceneNode* eff = SCENEMAN->GetEffectSceneNode( mSelectEffectIdx );
			if( eff )
				eff->Remove();

			mSelectEffectIdx = UINT_MAX;
		}
/*
		/// effect clear
		for( unsigned int i=0; i<5; i++ )
		{
			cDisplayObject* p = (cDisplayObject*)mDisplayObjectMap.GetAt(i);
			if( p )
				p->ClearEffect();
		}
*/
		/// reset window info
		mpSelectUIManager->ClearSelectInfo();
		mpSelectUIManager->SetSelectWindowFrame( cSelectWindow::eShow_None, false );
	}

	mDisplayObject = 0;
}

void cSelectStage::MoveMakeStage()
{
	STAGEMAN->ChangeStage( eStage_Make );

	cMakeStage* p = (cMakeStage*)STAGEMAN->GetStage( eStage_Make );
	if( p )
		p->SetMakeStandIndex( mCurrentSelectIndex );
}

void cSelectStage::ClearSelectMap()
{
	for( unsigned int i=0;i<5; i++)
		mCardDramaObj[i] = 0;
}

void cSelectStage::CancelChannel()
{
	mpSelectUIManager->VisibleListState();
}

void cSelectStage::MsgBoxEventParser( unsigned int event, unsigned int result, void* exData )
{
	switch( event )
	{
	case eMBEVENT_CHARACTER_DELETE:
		{
			if( result == eMESSAGE_BUTTON_YES )
				SendDeleteCharacter();
		}
		break;
	}
}
