/* ====================================================================
 *      :	
 *      :	
 *    :	
 *    :	2006.08.29
 * ǻ :	
 * =================================================================== */
#pragma once
#include "BaseStage.h"

class cSelectUIManager;

class cCardSceneNode;
class cDisplayObject;

class cSelectStage : public cBaseStage
{
	friend class cMakeStage;

public:
	cSelectStage();
	virtual ~cSelectStage();

	void CreateSelectMap( bool creatmap );
	void ClearSelectMap();

	virtual void Init( cStageManager* pStageManager );
	virtual void InitStage();
	virtual void Exit();
	virtual void Open();
	virtual void Close();
	virtual void Process( unsigned long deltaTime, unsigned long accumTime );

	virtual void ProcessLButtonClick( cMouseAgent* /*pMouse*/ );
	virtual void ProcessLButtonDClick( cMouseAgent* /*pMouse*/ );

	virtual void ProcessMouseover( unsigned long /*time*/, cMouseAgent* /*pMouse*/ );

	virtual void NetworkMsgParser( unsigned long connectionindex, char* pMsg, unsigned long length );
	virtual void MsgBoxEventParser( unsigned int event, unsigned int result, void* exData );

	void SendDeleteCharacter();
	void SendConnect( long channelNum );

	void MoveCard( bool rew );

	void MoveMakeStage();
	void CancelChannel();

	cDisplayObject* GetCurrentDisplayObject() { return mDisplayObject; }

protected:

	/// NM_USER
	void Msg_UserCharacterListAck( MSGROOT* pMsg );		
	void Msg_UserChannelListAck( MSGROOT* pMsg );		

	/// NM_HERO
	void Msg_HeroSelectAck( MSGROOT* pMsg );
	void Msg_HeroSelectNack( MSGROOT* pMsg );

	void ClearDisplayObject();

	void PlayCard();
	void RewCard();

protected:
	/// UI ռ
	cSelectUIManager*		mpSelectUIManager;

	/// collision
	tArray<void*>			mCollidableArray;

	/// 3D object creation info
	typedef tPointerHashMap<unsigned int, void*>	cDisplayObjectMap;
	cDisplayObjectMap		mDisplayObjectMap;

	///
	unsigned int			mCurrentSelectIndex;
	unsigned long			mSelectEffectIdx;

	/// channel state display object
	cDisplayObject*			mDisplayObject;

	cCardSceneNode*			mCardDramaObj[5];

	bool					mCardMoving;
	unsigned char			mCardMoveState;
	unsigned char			mCardMoveCount;
};
