#include "stdafx.h"
#include "SelectUIManager.h"
#include "UISkin.h"
#include "StageManager.h"

#include "SelectWindow.h"
#include "ChannelWindow.h"

#include "Player_Common.h"
#include "GameResourceManager.h"

cSelectUIManager::cSelectUIManager()
: mpSelectWindow(0)
, mpChannelWindow(0)
, mpSelectInfoWindow(0)
, mpSelectButtonWindow(0)
{
}

cSelectUIManager::~cSelectUIManager()
{
	mpChannelWindow = 0;
	mpSelectWindow = 0;
	mpSelectInfoWindow = 0;
	mpSelectButtonWindow = 0;
}

void cSelectUIManager::Init()
{
	UIMAN->SetCurrentStage( eStage_Select );

	/// ĳ  â  
	mpSelectWindow = new cSelectWindow;
	mpSelectWindow->CreateByPropertyName( "P_SelectWindow", 0 );

	mpSelectInfoWindow = new cSelectInfoWindow;
	mpSelectInfoWindow->CreateByPropertyName( "P_SelectInfoWindow", 0 );

	/// ä  â 
	mpChannelWindow = new cChannelWindow;
	mpChannelWindow->CreateByPropertyName( "P_ChannelWindow", 0 );

	///  ư â 
	mpSelectButtonWindow = new cSelectButtonWindow;
	mpSelectButtonWindow->CreateByPropertyName( "P_SelectButtonWindow", 0 );
}

void cSelectUIManager::Open()
{
	UIMAN->SetCurrentStage( eStage_Select );

	mpSelectWindow->Hide();
	mpSelectInfoWindow->Hide();
	mpChannelWindow->Hide();
	mpSelectButtonWindow->Hide();

	mpSelectWindow->UIStageIn();
	mpSelectInfoWindow->UIStageIn();
	mpSelectButtonWindow->UIStageIn();
}

void cSelectUIManager::Close()
{
	UIMAN->SetCurrentStage( eStage_Select );

	mpSelectWindow->Hide();
	mpSelectInfoWindow->Hide();
	mpChannelWindow->Hide();
	mpSelectButtonWindow->Hide();
}

void cSelectUIManager::Process( unsigned long /*accumtime*/ )
{
}

void cSelectUIManager::VisibleListState()
{
	if( mpSelectWindow )
		mpSelectWindow->ShowTop();

	if( mpSelectInfoWindow )
		mpSelectInfoWindow->ShowTop();

	if( mpSelectButtonWindow )
	{
		mpSelectButtonWindow->ShowTop();
		mpSelectButtonWindow->SetEnableDelete( true );
	}

	if( mpChannelWindow )
		mpChannelWindow->Hide( false );
}

void cSelectUIManager::VisibleChannelState()
{
	if( mpSelectWindow )
		mpSelectWindow->Hide();

	if( mpSelectButtonWindow )
	{
		mpSelectButtonWindow->SetEnableDelete( false );
		mpSelectButtonWindow->Hide();
	}

	if( mpChannelWindow )
		mpChannelWindow->ShowTop();
}

void cSelectUIManager::HideAll()
{
	if( mpSelectWindow )
		mpSelectWindow->Hide( false );

	if( mpChannelWindow )
		mpChannelWindow->Hide( false );

	if( mpSelectInfoWindow )
		mpSelectInfoWindow->Hide( false );

	if( mpSelectButtonWindow )
		mpSelectButtonWindow->Hide();
}

void cSelectUIManager::SetSelectInfo( int level, LPCTSTR name, unsigned long jobIdx, unsigned int mapIdx )
{
	mpSelectInfoWindow->SetLevel( level );
	mpSelectInfoWindow->SetName( name );
	mpSelectInfoWindow->SetJob( GAMERESOURCEMAN->GetJobName( jobIdx ) );
	mpSelectInfoWindow->SetMapName( GAMERESOURCEMAN->GetMapName( mapIdx ) );

	if( mpSelectButtonWindow )
		mpSelectButtonWindow->SetEnableDelete( true );
}

void cSelectUIManager::ClearSelectInfo()
{
	mpSelectInfoWindow->ClearInfo();

	if( mpSelectButtonWindow )
		mpSelectButtonWindow->SetEnableDelete( false );
}


long cSelectUIManager::GetCurrentChannelNum()
{
	return mpChannelWindow->GetSelectedChannelParam();
}

void cSelectUIManager::SetSelectWindowFrame( unsigned char state, bool enable )
{
	mpSelectWindow->ShowFrame( state );
	mpSelectWindow->SetEnabled( enable );

	mpSelectButtonWindow->ShowBegin( true );
	mpSelectButtonWindow->SetEnableBegin( true );

	if( state == cSelectWindow::eShow_StartButton )
	{
		mpSelectButtonWindow->SetEnableDelete( true );
	}
	else
	{
		mpSelectButtonWindow->SetEnableDelete( false );
	}
}
