#include "StdAfx.h"
#include "SelectWindow.h"
#include "StageManager.h"
#include "SelectStage.h"

#include "GameResourceManager.h"
#include "UIMsgboxEvent.h"

#include "UIImage.h"
#include "button.h"
#include "Label.h"

#include "DisplayObject.h"

cSelectInfoWindow::cSelectInfoWindow()
: mpLevel(0)
, mpName(0)
, mpJob(0)
, mpMap(0)
, mpBack(0)
{
}

cSelectInfoWindow::~cSelectInfoWindow()
{
}

void cSelectInfoWindow::UIStageIn()
{
	SetExceptEvent( true );

	if( mpLevel )
		mpLevel->Clear();
	if( mpName )
		mpName->Clear();
	if( mpJob )
		mpJob->Clear();
	if( mpMap )
		mpMap->Clear();
}

bool cSelectInfoWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpLevel = (cLabel*)GetChild( eUIID_SELECTINFO_LEVEL );
	mpName = (cLabel*)GetChild( eUIID_SELECTINFO_NAME );
	mpJob = (cLabel*)GetChild( eUIID_SELECTINFO_JOB );
	mpMap = (cLabel*)GetChild( eUIID_SELECTINFO_MAP );

	mpBack = (cButton*)GetChild( eUIID_SELECTINFO_BACK );
	if( mpBack )
		mpBack->SetExceptEvent( true );

	/// ػ󵵿   
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
	{
		int x = ( GetScreenWidth() * winSkin->mSkinInfo->mX ) / mDefaultWidth;
		int y = ( GetScreenHeight() * winSkin->mSkinInfo->mY ) / mDefaultHeight;
		int w = ( GetScreenWidth() * winSkin->mSkinInfo->mWidth ) / mDefaultWidth;
		int h = ( GetScreenHeight() * winSkin->mSkinInfo->mHeight ) / mDefaultHeight;

		SetRelativeRect( cUIRect( x, y, x+w, y+h) );
	}

	if( mpBack )
	{
		cUINodeSkin* pskin = pSkin->GetNodeSkin( mpBack->GetSkinName() );
		if( pskin )
		{
			int x = ( GetScreenWidth() * pskin->mSkinInfo->mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * pskin->mSkinInfo->mY ) / mDefaultHeight;
			mpBack->SetRelativePos( cUIPos( x, y ) );
		}
	}
	return true;
}

void cSelectInfoWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return;
	}

	cUINodeSkin* winSkin = pSkin->GetNodeSkin( mSkinName );
	if( winSkin )
	{
		int x = ( GetScreenWidth() * winSkin->mSkinInfo->mX ) / mDefaultWidth;
		int y = ( GetScreenHeight() * winSkin->mSkinInfo->mY ) / mDefaultHeight;
		int w = ( GetScreenWidth() * winSkin->mSkinInfo->mWidth ) / mDefaultWidth;
		int h = ( GetScreenHeight() * winSkin->mSkinInfo->mHeight ) / mDefaultHeight;

		SetRelativeRect( cUIRect( x, y, x+w, y+h) );
	}

	if( mpBack )
	{
		cUINodeSkin* pskin = pSkin->GetNodeSkin( mpBack->GetSkinName() );
		if( pskin )
		{
			int x = ( GetScreenWidth() * pskin->mSkinInfo->mX ) / mDefaultWidth;
			int y = ( GetScreenHeight() * pskin->mSkinInfo->mY ) / mDefaultHeight;
			mpBack->SetRelativePos( cUIPos( x, y ) );
		}
	}
}

void cSelectInfoWindow::SetLevel( int level )
{
	if( mpLevel )
	{
		TCHAR buf[20] = {0,};
		::swprintf( buf, _T("%d"), level );

		mpLevel->SetText( buf );
	}
}

void cSelectInfoWindow::SetName( LPCTSTR name )
{
	if( mpName )
		mpName->SetText( name );
}

void cSelectInfoWindow::SetJob( LPCTSTR job )
{
	if( mpJob )
		mpJob->SetText( job );
}

void cSelectInfoWindow::SetMapName( LPCTSTR mapName )
{
	if( mpMap )
		mpMap->SetText( mapName );
}

void cSelectInfoWindow::ClearInfo()
{
	if( mpLevel )
		mpLevel->Clear();
	if( mpName )
		mpName->Clear();
	if( mpJob )
		mpJob->Clear();
	if( mpMap )
		mpMap->Clear();
}




////////////////////////////////////////////////////////
cSelectWindow::cSelectWindow()
: mpConnect(0)
, mpMake(0)
, mpBeforeCharacter(0)
, mpNextCharacter(0)
{
}

cSelectWindow::~cSelectWindow()
{
}

void cSelectWindow::UIStageIn()
{
	SetExceptEvent( true );

	if( mpMake )
		mpMake->Hide();
	if( mpConnect )
		mpConnect->Hide();
}


/// ǻ : 
bool cSelectWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpConnect = (cButton*)GetChild( eUIID_SELECT_CONNECT_BUTTON );
	mpMake = (cButton*)GetChild( eUIID_SELECT_CREATE_BUTTON );
	mpBeforeCharacter = (cButton*)GetChild( eUIID_SELECT_LEFTSELECT_BUTTON );
	mpNextCharacter = (cButton*)GetChild( eUIID_SELECT_RIGHTSELECT_BUTTON );
	return true;
}

void cSelectWindow::SetEnabled( bool enabled )
{
	cUIWindow::SetEnabled( enabled );

	if( mpMake )
		mpMake->SetEnabled( enabled );
	if( mpConnect )
		mpConnect->SetEnabled( enabled );
}

void cSelectWindow::ShowFrame( unsigned char showOpt )
{
	switch( showOpt )
	{
	case eShow_StartButton:
		{
			if( mpConnect )
				mpConnect->Show();
			if( mpBeforeCharacter )
				mpBeforeCharacter->Show();
			if( mpNextCharacter )
				mpNextCharacter->Show();

			if( mpMake )
				mpMake->Hide();
		}
		break;
	case eShow_MakeButton:
		{
			if( mpMake )
				mpMake->Show();
			if( mpBeforeCharacter )
				mpBeforeCharacter->Show();
			if( mpNextCharacter )
				mpNextCharacter->Show();

			if( mpConnect )
				mpConnect->Hide();
		}
		break;
	case eShow_None:
		{
			if( mpConnect )
				mpConnect->Hide();
			if( mpMake )
				mpMake->Hide();
			if( mpBeforeCharacter )
				mpBeforeCharacter->Show();
			if( mpNextCharacter )
				mpNextCharacter->Show();
		}
		break;
	default:
		assert(0);
		break;
	}
}

/// ǻ : ư̺Ʈ Ͼ 
void cSelectWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_SELECT_CONNECT_BUTTON:
		{
			///  ư
			MSGROOT msg;
			memset( &msg, 0, sizeof(msg) );
			/// SET MSGROOT [CATEGORY & PROTOCOL].
			msg.Category    = NM_USER;
			msg.Protocol    = NM_USER_CHANNEL_LIST_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			UIMAN->CreateModal( eStage_Select,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 10 ),
							GAMERESOURCEMAN->GetGameText( 2 ),
							eSKIN_NONE
							);

		}
		break;
	case eUIID_SELECT_CREATE_BUTTON:
		{
			/// â ̵
			cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
			if( p )
				p->MoveMakeStage();
		}
		break;
	case eUIID_SELECT_LEFTSELECT_BUTTON:
		{
			/// ĳ ̵
			cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
			if( p )
				p->MoveCard( true );
		}
		break;
	case eUIID_SELECT_RIGHTSELECT_BUTTON:
		{
			/// ĳ ̵
			cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
			if( p )
				p->MoveCard( false );
		}
		break;
	default:
		assert(0);
		break;
	}
}

/////////////////////////////////////////////////////////////////////////
cSelectButtonWindow::cSelectButtonWindow()
: mpDelete(0)
, mpBegin(0)
{

}

cSelectButtonWindow::~cSelectButtonWindow()
{

}

void cSelectButtonWindow::UIStageIn()
{
	SetExceptEvent( true );
}

bool cSelectButtonWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpDelete = (cButton*)GetChild( eUIID_SELECTBUTTON_DELETE );
	mpBegin = (cButton*)GetChild( eUIID_SELECTBUTTON_BEGIN );
	return true;
}

void cSelectButtonWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_SELECTBUTTON_DELETE:
		{
			cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
			if( p )
			{
				cDisplayObject* obj = p->GetCurrentDisplayObject();
				if( obj )
				{
					TCHAR temp[256] = {0,};
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 62 ), obj->GetName() );

					UIMAN->CreateModal( eStage_Select, eMBEVENT_CHARACTER_DELETE, 
						temp, GAMERESOURCEMAN->GetGameText( 2 ), eSKIN_YESNO );
				}
			}
		}
		break;
	case eUIID_SELECTBUTTON_BEGIN:
		{
			/// αâ ̵
			STAGEMAN->ChangeStage( eStage_Login );
		}
		break;
	}
}

void cSelectButtonWindow::SetEnableDelete( bool enabled )
{
	if( mpDelete )
	{
		mpDelete->SetEnabled( enabled );

		if( enabled )
			mpDelete->Show();
		else
			mpDelete->Hide();
	}
}

void cSelectButtonWindow::SetEnableBegin( bool enabled )
{
	if( mpBegin )
		mpBegin->SetEnabled( enabled );
}

void cSelectButtonWindow::ShowBegin( bool show )
{
	if( mpBegin )
	{
		if( show == true )
			mpBegin->Show();
		else
			mpBegin->Hide();
	}
}
