#include "StdAfx.h"
#include "SendNoteWindow.h"
#include "Editbox.h"
#include "MultiEditBox.h"
#include "Chat_Common.h"
#include "Protocol.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "ChatManager.h"
#include "GameResourceManager.h"
#include "Button.h"

cSendNoteWindow::cSendNoteWindow()
: mpNameEdit(0)
, mpMultiEdit(0)
, mpSendButton(0)
{

}

cSendNoteWindow::~cSendNoteWindow()
{

}

/// ǻ : 
bool cSendNoteWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpNameEdit = (cEditBox*)GetChild( eUIID_GAME_SENDNOTE_IDEDIT );
	mpMultiEdit = (cMultiEditBox*)GetChild( eUIID_GAME_SENDNOTE_MULTIEDITBOX );
	mpSendButton = (cButton*)GetChild( eUIID_GAME_SENDNOTE_SEND_BUTTON );
	return true;
}

///
void cSendNoteWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_SENDNOTE_CLOSE_BUTTON:
	case eUIID_GAME_SENDNOTE_CANCEL_BUTTON:
		{
			Hide();
		}
		break;
	case eUIID_GAME_SENDNOTE_SEND_BUTTON:
		{			
			/// 
			if( CheckNote() == true )
			{
				SendNote();
				Hide();
			}
		}
		break;
	}
}

///
bool cSendNoteWindow::CheckNote()
{
	if( !mpNameEdit || !mpMultiEdit )
		return false;

	cStringT Message;

	/// ̵,   
	if( mpNameEdit->GetLength() == 0 || mpMultiEdit->GetLength() == 0 )
		return false;

	/// ڱڽŰ ̸ ϸ  
	int result = ::_tcscmp( HERO->GetName(), mpNameEdit->GetText() );
	if( result == 0 )
	{
		Message.Format( GAMERESOURCEMAN->GetGameText( 35 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		return false;
	}

	///  .
	if( mpMultiEdit->GetLength() <= 0 )
	{
		Message.Format( GAMERESOURCEMAN->GetGameText( 36 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		return false;
	}
	else
	{
		/// 뿡 " "  ڰ ԷµǾ ˻ send
		bool search = false;
		LPCTSTR str = mpMultiEdit->GetText();
		for( int i = 0;i < mpMultiEdit->GetLength(); ++i )
		{
			if( *str != 32 )
			{
				search = true;
				break;
			}
			else
				str++;
		}

		if( search == false )
		{
			Message.Format( GAMERESOURCEMAN->GetGameText( 36 ) );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
			return false;
		}
	}
	return true;
}

void cSendNoteWindow::SendNote()
{
	///    
	MSG_REQ_NOTE_SEND	msg;
	::memset( &msg, 0, sizeof( msg ) );
	msg.Category = NM_CHAT;
	msg.Protocol = NM_CHAT_NOTE_SEND_REQ;
	Sstrncpy( msg.Name, MAX_NAME_BUFFER_SIZE, mpNameEdit->GetText(), MAX_NAME_SIZE );
	Sstrncpy( msg.Message, MAX_NOTE_MESSAGE_BUFFER_SIZE, mpMultiEdit->GetText(), MAX_NOTE_MESSAGE_SIZE );

	NETWORK->SendNetworkMsg( (char*)&msg, (u_short)msg.GetMsgLength() );

	///  ɱ
	NetLock();
}

/// ýۿ   
void cSendNoteWindow::SendNoteBySystem( LPCTSTR name, LPCTSTR message )
{
	if( ::_tcslen( name ) > 0 && ::_tcslen( message ) > 0 )
	{
		MSG_REQ_NOTE_SEND	msg;
		::memset( &msg, 0, sizeof( msg ) );
		msg.Category = NM_CHAT;
		msg.Protocol = NM_CHAT_NOTE_SEND_REQ;
		Sstrncpy( msg.Name, MAX_NAME_BUFFER_SIZE, name, MAX_NAME_SIZE );
		Sstrncpy( msg.Message, MAX_NOTE_MESSAGE_BUFFER_SIZE, message, MAX_NOTE_MESSAGE_SIZE );

		NETWORK->SendNetworkMsg( (char*)&msg, (u_short)msg.GetMsgLength() );

		///  ɱ
		NetLock();
	}
}

///
void cSendNoteWindow::SetName( LPCTSTR name )
{
	if( mpNameEdit )
		mpNameEdit->SetText( name );
}

void cSendNoteWindow::OnShow()
{
	if( mpNameEdit )
		mpNameEdit->SetFocus();

	cUIWindow::OnShow();
}

///
void cSendNoteWindow::OnHide()
{
	cUIWindow::OnHide();

	///
	if( mpNameEdit )
	{
		mpNameEdit->Clear();
		mpNameEdit->ReleaseFocus();
	}

	if( mpMultiEdit )
	{
		mpMultiEdit->Clear();
		mpMultiEdit->ReleaseFocus();
	}
}

void cSendNoteWindow::OnNetLock( int lockTry )
{
	if( mpSendButton )
		mpSendButton->NetLock( lockTry );
}

void cSendNoteWindow::OnNetUnLock( int lockTry )
{
	if( mpSendButton )
		mpSendButton->NetUnLock( lockTry );
}

//////////////////////////////////////////////////////////////////////////
///  ü  
cGuildSendNoteWindow::cGuildSendNoteWindow()
{
}

cGuildSendNoteWindow::~cGuildSendNoteWindow()
{
}

/// ǻ : 
bool cGuildSendNoteWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMultiEdit = (cMultiEditBox*)GetChild( eUIID_GUILDSENDNOTE_MULTIEDIT );
	mpSendButton = (cButton*)GetChild( eUIID_GUILDSENDNOTE_SEND );
	return true;
}

void cGuildSendNoteWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GUILDSENDNOTE_CLOSE:
	case eUIID_GUILDSENDNOTE_CANCEL:
		{
			Hide();
		}
		break;
	case eUIID_GUILDSENDNOTE_SEND:
		{			
			/// 
			if( CheckNote() == true )
			{
				SendNote();
				Hide();
			}
		}
		break;
	}
}

///
bool cGuildSendNoteWindow::CheckNote()
{
	if( !mpMultiEdit )
		return false;

	cStringT Message;

	///   
	if( mpMultiEdit->GetLength() == 0 )
		return false;

	///  .
	if( mpMultiEdit->GetLength() <= 0 )
	{
		Message.Format( GAMERESOURCEMAN->GetGameText( 36 ) );
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
		return false;
	}
	else
	{
		/// 뿡 " "  ڰ ԷµǾ ˻ send
		bool search = false;
		LPCTSTR str = mpMultiEdit->GetText();
		for( int i = 0;i < mpMultiEdit->GetLength(); ++i )
		{
			if( *str != 32 )
			{
				search = true;
				break;
			}
			else
				str++;
		}

		if( search == false )
		{
			Message.Format( GAMERESOURCEMAN->GetGameText( 36 ) );
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
			return false;
		}
	}
	return true;
}

void cGuildSendNoteWindow::SendNote()
{
	///    
	MSG_REQ_NOTE_SEND	msg;
	::memset( &msg, 0, sizeof( msg ) );

	msg.Category = NM_CHAT;
	msg.Protocol = NM_CHAT_GUILDNOTE_SEND_REQ;
	Sstrncpy( msg.Message, MAX_NOTE_MESSAGE_BUFFER_SIZE, mpMultiEdit->GetText(), MAX_NOTE_MESSAGE_SIZE );
	NETWORK->SendNetworkMsg( (char*)&msg, (u_short)msg.GetMsgLength() );

	///  ɱ
	NetLock();
}

void cGuildSendNoteWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mpMultiEdit )
		mpMultiEdit->SetFocus();
}

///
void cGuildSendNoteWindow::OnHide()
{
	cUIWindow::OnHide();

	if( mpMultiEdit )
	{
		mpMultiEdit->Clear();
		mpMultiEdit->ReleaseFocus();
	}
}
