#include "stdafx.h"
#include "ServerStage.h"
#include "ServerUIManager.h"

#include "StageManager.h"
#include "GameResourceManager.h"
#include "IntroStage.h"
#include "GameFile.h"

#include "ServerWindow.h"
#include "UIMsgboxEvent.h"
#include "Application.h"

cServerStage::cServerStage()
: mpServerUIManager(0)
{

}

cServerStage::~cServerStage()
{

}

void cServerStage::Init( cStageManager* pStageManager )
{	
	mpStageManager = pStageManager;
}

void cServerStage::InitStage()
{
	if( mInit )	return;

	if( GAMERESOURCEMAN->InitServer() == false )
	{
		assert(0);
	}

	/// UI
	mpServerUIManager = new cServerUIManager;
	mpServerUIManager->Init();
	mInit = true;
}

void cServerStage::Exit()
{
	GAMERESOURCEMAN->LoadEnd();

	SAFE_DELETE( mpServerUIManager );
	mpStageManager = 0;
}

void cServerStage::Open()
{
	/// ui
	mpServerUIManager->Open();

	mLoadComplete = false;
	mCheckServerComplete = false;

	/// 070404 ߰ - ö [Ʈ û]
	if ( NETWORK->IsConnected( ) == true )
		ReqServerList();

#ifdef NOCONNECT_SERVER
	mpStageManager->ChangeStage( eStage_Intro );
#endif

	cIntroStage* stage = (cIntroStage*)mpStageManager->GetStage( eStage_Intro );
	if( stage )
		stage->ClearBackImage();

	if( GAMERESOURCEMAN->LoadInitData3() == false )
	{
		assert(0);
	}
}

void cServerStage::Close()
{
	/// UI
	mpServerUIManager->Close();
}

void cServerStage::Process( unsigned long /*deltaTime*/, unsigned long accumTime )
{
	unsigned int flag = GAMERESOURCEMAN->CheckInitData();
	if( flag == eData_Error )
	{
		assert(0);
		NiMessageBox( "Failed load gameData. Please reinstall client or patch.", "GameData Error" );
		::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
		::PostQuitMessage(0);
		return;
	}
	else if( flag == eData_End )
	{
		mLoadComplete = true;
		GAMERESOURCEMAN->LoadEnd();
	}

	if( mLoadComplete == true && mCheckServerComplete == true )
	{
		///  ó
		UIMAN->ModalEventFromGameSystem( true );

		///  
		STAGEMAN->ChangeStage( eStage_Select );
	}

	/// UI
	mpServerUIManager->Process( accumTime );
}

void cServerStage::ReqServerList()
{
	MSGROOT msg;
	::memset( &msg, 0, sizeof(msg) );

	msg.Category = NM_USER;
	msg.Protocol = NM_USER_SERVER_LIST_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

	/// Msgbox 
	UIMAN->CreateModal( eStage_Server,
						eMBEVENT_NONE, 
						GAMERESOURCEMAN->GetGameText( 9 ), //  ó 
						GAMERESOURCEMAN->GetGameText( 2 ), // ˸
						eSKIN_NONE
						);
}


void cServerStage::NetworkMsgParser( unsigned long , char* pMsg, unsigned long /*length*/ )
{	
	/// 070404 ߰ - ö [Ʈ & äθƮ &  ]
	MSGROOT* pMsgRoot = (MSGROOT*)pMsg;

	switch( pMsgRoot->Category )
	{
	case NM_USER:
		{
			switch( pMsgRoot->Protocol )
			{
			case NM_USER_SERVER_LIST_RES:
				{
					/// Ʈ  -  Ʈ / н  
					MSG_RES_SERVERLIST*  pMsgResServerlist = (MSG_RES_SERVERLIST*)pMsg;
					unsigned long        rowServerNo       = 0;

					cServerWindow* pSrvWindow  = (cServerWindow*)UIMAN->GetContainer( eUIID_SERVER_WINDOW );

					/// Ʈ .
					if( pSrvWindow )
						pSrvWindow->Clear();

					unsigned long color = eCOLOR_GRAY;
					for ( unsigned long i = 0; i < pMsgResServerlist->RowCount; i++ )
					{
						unsigned int textId = 0;
						switch ( pMsgResServerlist->Servers[ i ].Status )
						{
							/// ʰ
						case 4: textId = 700; color = eCOLOR_RED;
							break;
							/// ȥ
						case 3: textId = 701; color = eCOLOR_ORANGE;
							break;
							/// ȣ
						case 2: textId = 702; color = eCOLOR_GREEN;
							break;
							/// غ
						case 1: 
						default:
							textId = 703; color = eCOLOR_GRAY;
							break;
						}

						if( pSrvWindow && textId > 0 )
						{
							pSrvWindow->AddServer( pMsgResServerlist->Servers[ i ].NumOfServer,
												   pMsgResServerlist->Servers[ i ].Status,
												   pMsgResServerlist->Servers[ i ].Name,
												   UIMAN->GetUIText( textId ), color );
						}

						if ( pMsgResServerlist->Servers[ i ].NumOfServer == (long)pMsgResServerlist->ServerNo )
							rowServerNo = i;
					}

					if( pSrvWindow )
					{
						pSrvWindow->UpdateButton();
						pSrvWindow->SelectServer( rowServerNo );
					}

					///   
					UIMAN->ModalEventFromGameSystem( true );

					///  Ȱȭ
					mpServerUIManager->Visible();

					/// btn Ȱȭ
					if( pMsgResServerlist->RowCount == 0 )
					{
						mpServerUIManager->EnableConnectBtn( false );
					}
					else
					{
						mpServerUIManager->EnableConnectBtn( true );
					}
				}
				break;
/*
			case NM_USER_SERVER_SELECT_RES:
				{
					/// 0 ƴϸ Ȱȭ
					MSG_ERROR* msg = (MSG_ERROR*)pMsg;

					if( msg->ErrorCode == 0 )
						mpServerUIManager->EnableConnectBtn( true );

					UIMAN->ModalEventFromGameSystem( true );
				}
				break;
*/
			case NM_USER_COME_IN_GAME_RES:
				{
					/// ӽ  - 0 / 1н 
					MSG_RES_COMEIN_GAME* msg = (MSG_RES_COMEIN_GAME*)pMsg;
					if ( msg->ErrorCode == ERROR_COMEIN_GAME_SUCCESS )
					{
						///
					}
					else
					{
						/// н ó
						UIMAN->ModalEventFromGameSystem( false );

						///   û
						ReqServerList();
					}
				}
				break;
			case NM_USER_GAMESRV_RES:
				{
					/// Ӽ  - 0 / 1н 
					MSG_RES_GAMESRV* msg = (MSG_RES_GAMESRV*)pMsg;
					if ( msg->ErrorCode == 0 )
					{
						mCheckServerComplete = true;
						if( mLoadComplete == true )
						{
							///  ó
							UIMAN->ModalEventFromGameSystem( true );

							///  
							STAGEMAN->ChangeStage( eStage_Select );
						}
					}
					else
					{
						UIMAN->ModalEventFromGameSystem( false );
						msg->ErrorCode;
					}
				}
				break;
			}
		}
		break;
	}
}
