#include "StdAfx.h"
#include "ServerWindow.h"
#include "StageManager.h"

#include "ListBox.h"
#include "UIMsgboxEvent.h"

cServerWindow::cServerWindow()
: mpServerList(0)
{
	for( int i = 0; i < MAXPAGE_NUM; ++i )
		mpRadioNode[i] = 0;

	mCheckRect.Set( 0, 0, 0, 0 );
}

cServerWindow::~cServerWindow()
{
	Clear();
}

void cServerWindow::Clear()
{
	if( mpServerList )
		mpServerList->Clear();

	for( unsigned int i = 0; i < mServerData.GetSize(); ++i )
	{
		delete (sServerData*)mServerData[i];
	}
	mServerData.Clear();

	for( int i = 0 ; i < MAXPAGE_NUM; ++i )
	{
		if( mpRadioNode[i] )
			mpRadioNode[i]->Hide();
	}
}

void cServerWindow::OnShow()
{
	cUIWindow::OnShow();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = GetRelativeRect().mTop;
	SetRelativePos( cUIPos( x, y) );
}

/// ǻ : 
bool cServerWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;
	
	/// Ʈ ڽ 
	mpServerList = (cListBox*)GetChild( eUIID_SERVER_SERVERLIST );

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/// Ŀ
	cUINodeSkin* pRectSkin = pSkin->GetNodeSkin( "Server_ButtonRect" );
	if( pRectSkin )
	{
		mCheckRect.mLeft = pRectSkin->mSkinInfo->mX;
		mCheckRect.mTop = pRectSkin->mSkinInfo->mY;
		mCheckRect.mRight = mCheckRect.mLeft + pRectSkin->mSkinInfo->mWidth;
		mCheckRect.mBottom = mCheckRect.mTop + pRectSkin->mSkinInfo->mHeight;
	}

	for( int i = 0; i < MAXPAGE_NUM; ++i )
	{
		mpRadioNode[i] = GetChild( eUIID_SERVER_SERVERPAGE1 + i );
		if( mpRadioNode[i] )
			mpRadioNode[i]->Hide();
	}

	//for( int i = 0; i < 5; ++i )
	//	AddServer( 0, 0, _T("dasdfasdf"), _T(""), eCOLOR_WHITE );
	return true;
}

void cServerWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = GetRelativeRect().mTop;
	SetRelativePos( cUIPos( x, y) );

	UpdateButton();
}

///
void cServerWindow::OnRadioPressed( cUINode*, unsigned int id )
{
	int row = 0;
	switch( id )
	{
	case eUIID_SERVER_SERVERPAGE1:	row = 0; break;
	case eUIID_SERVER_SERVERPAGE2:	row = 10; break;
	case eUIID_SERVER_SERVERPAGE3:	row = 20; break;
	case eUIID_SERVER_SERVERPAGE4:	row = 30; break;
	case eUIID_SERVER_SERVERPAGE5:	row = 40; break;
	default: assert(0); return;
	}	

	if( mpServerList )
		mpServerList->ChangeTopIndex( row );
}

/// ǻ : 
void cServerWindow::OnCommand( cUINode*, unsigned int id )
{
	switch(id)
	{
	case eUIID_SERVER_CONNECT_BUTTON:
		{
			if(  NETWORK->IsConnected( ) == false ) 
				return;

			if( GetSelectedServerStatus() <= 0 )
				return;

			MSG_REQ_COMEIN_GAME msg;
			::memset( &msg, 0, sizeof(msg) );

			msg.Category     = NM_USER;
			msg.Protocol     = NM_USER_COME_IN_GAME_REQ;
			msg.NumOfServer	 = GetSelectedServerParam();
			msg.NumOfChannel = 0;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			///  â 
			UIMAN->CreateModal( eStage_Server,
								eMBEVENT_CONNECT_GAMESRV, 
								GAMERESOURCEMAN->GetGameText( 0 ), //   ޼
								GAMERESOURCEMAN->GetGameText( 2 ), // ˸
								eSKIN_NONE
								);
		}
		break;
	case eUIID_SERVER_CANCEL_BUTTON:
		{	
			STAGEMAN->ChangeStage( eStage_Login );
		}
		break;
	}
}

/// ǻ : 
void cServerWindow::OnListBoxChanged( cUINode*, unsigned int id )
{
	if( id == eUIID_SERVER_SERVERLIST )
	{
		if( GetSelectedServerStatus() == 0 )
			SetEnableConnectBtn( false );
		else
			SetEnableConnectBtn( true );
	}
}

void cServerWindow::OnListBoxSelected( cUINode*, unsigned int id )
{
	if( id == eUIID_SERVER_SERVERLIST )
	{
		if(  NETWORK->IsConnected( ) == false ) 
			return;

		if( GetSelectedServerStatus() <= 0 )
			return;

		/// 
		MSG_REQ_COMEIN_GAME msg;
		memset( &msg, 0, sizeof(msg) );

		msg.Category     = NM_USER;
		msg.Protocol     = NM_USER_COME_IN_GAME_REQ;
		msg.NumOfServer	 = GetSelectedServerParam();
		msg.NumOfChannel = 0;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		///  â 
		UIMAN->CreateModal( eStage_Server,
							eMBEVENT_CONNECT_GAMESRV, 
							GAMERESOURCEMAN->GetGameText( 0 ), //   ޼
							GAMERESOURCEMAN->GetGameText( 2 ), // ˸
							eSKIN_NONE
							);

		SetEnableConnectBtn( false );
	}
}

/// ǻ : Ʈ  Ѵ 
void cServerWindow::AddServer( long param, int status, LPCTSTR servername, LPCTSTR condition, unsigned long color )
{
	///    
	sServerData* data = new sServerData;
	data->mParam = param;
	data->mStatus = status;
	mServerData.PushBack( data );

	/// Ʈڽ  
	int row = mpServerList->AddRow( servername, mDefaultColor, data );
	if( row == -1 )
	{
		assert(0);
	}

	if( mpServerList )
		mpServerList->AddColume( row, condition, color );
}

void cServerWindow::UpdateButton()
{
	if( !mpServerList )
	{
		assert(0);
		return;
	}

	/// ư ̰ Ⱥ̰ ϱ
	int total = mpServerList->GetRowCount() - 1;
	int page = ( total / 10 );

	for( int i = 0; i < MAXPAGE_NUM; ++i )
	{
		if( mpRadioNode[i] )
		{
			if( i <= page )
				mpRadioNode[i]->Show();
			else
				mpRadioNode[i]->Hide();
		}
	}

	/// ġ 
	if( mpRadioNode[0] )
	{
		int w = mpRadioNode[0]->GetAbsoluteRect().GetWidth();	
		int x = mCheckRect.mLeft + (int)((mCheckRect.GetWidth() - (w*(page+1))) * 0.5f);
		for( int i = 0; i <= page; ++i )
		{
			cUIPos pos;
			pos.mX = x + (w*i);
			pos.mY = mpRadioNode[i]->GetRelativeRect().mTop;
			mpRadioNode[i]->SetRelativePos( pos );
		}

		mpRadioNode[0]->SetPress( true );
	}
}

void cServerWindow::SelectServer(unsigned int rowServerNo)
{
	if( mpServerList )
		mpServerList->ChangeSelectRow( rowServerNo );
}

long cServerWindow::GetSelectedServerParam()
{
	sServerData* pData = (sServerData*)mpServerList->GetExtraData( mpServerList->GetSelectIndex() );
	if( pData )
		return pData->mParam;
	return -1;
}

///
int cServerWindow::GetSelectedServerStatus()
{
	sServerData* pData = (sServerData*)mpServerList->GetExtraData( mpServerList->GetSelectIndex() );
	if( pData )
		return pData->mStatus;
	return -1;
}

///
void cServerWindow::SetEnableConnectBtn( bool enable )
{
	cUINode* pConnectBtn = GetChild( eUIID_SERVER_CONNECT_BUTTON );
	if( pConnectBtn )
		pConnectBtn->SetEnabled( enable );
}