#include "stdafx.h"
#include "shadowAgent.h"
#include "CameraManager.h"

cShadowAgent*	cShadowAgent::mpShadowAgent = NULL;

cShadowAgent::cShadowAgent() 
: mDrawingShadow(100)
{
	mpShadowAgent = this;
}

cShadowAgent::~cShadowAgent()
{
	mDrawingShadow.RemoveAll();
}

/* ------------------------------------------------------------------
 * Լ̸ :	Process( float time )
 *      :	ó
 * ǻ :	
 * ------------------------------------------------------------------ */
void cShadowAgent::Process( float /*time*/ )
{
	NiCamera* pCamera = CAMERAMAN->GetCurrentNi();
	if( !pCamera )
	{
		return;
	}

	unsigned int shadowNum = mDrawingShadow.GetSize();
	cShadowGeometry* pShadow = NULL;
	for( unsigned int i=0; i<shadowNum; ++i )
	{
		pShadow = mDrawingShadow.GetAt( i );
		if( pShadow )
			pShadow->Process( 0.0f, pCamera );
		else
		{
			int a=0;
			a=1;
		}
	}
}

/* ------------------------------------------------------------------
 * Լ̸ :	Render( NiRenderer* pRenderer )
 *      :	º
 * ǻ :	
 * ------------------------------------------------------------------ */
void cShadowAgent::Render( NiRenderer* pRenderer )
{
	NiPropertyState* pState = pRenderer->GetPropertyState();
   	pRenderer->SetPropertyState( mpPropertyState );

	unsigned int shadowNum = mDrawingShadow.GetSize();
	cShadowGeometry* pShadow = NULL;
	for( unsigned int i=0; i<shadowNum; ++i )
	{
		pShadow = mDrawingShadow.GetAt( i );
		if( pShadow ) 
			pShadow->GetShadowGeometry()->RenderImmediate( pRenderer );
	}

	pRenderer->SetPropertyState( pState );

	///  ó Ǹ ϴ.
	mDrawingShadow.RemoveAll();
}

/* ------------------------------------------------------------------
 * Լ̸ :	AddDrawingShadow( cShadowGeometry* pShadow )
 *      :	 ӿ ׷  ׸ ü 
 * ǻ :	
 * ------------------------------------------------------------------ */
void cShadowAgent::AddDrawingShadow( cShadowGeometry* pShadow )
{
	mDrawingShadow.Add( pShadow );
}

/* ------------------------------------------------------------------
 * Լ̸ :	CreateShadow( unsigned int detail, unsigned int maxTriangleCount )
 *      :	׸ ü  ̽ 
 * ǻ :	
 * ------------------------------------------------------------------ */
cShadowGeometry* cShadowAgent::CreateShadow( unsigned int detail, unsigned int maxTriangleCount )
{
	cShadowGeometry* pGeom = cShadowGeometry::Create( this, detail, maxTriangleCount );

	return pGeom;
}