/* ==========================================================================
*    : ̼
*    : 2007.11.23
*      : ׸ 
* ǻ : 
*===========================================================================*/
#pragma once

class cDynamicSceneNode;

/// ׸ 
class cShadowGeometry
{
	friend class cShadowGeomCompareForRendering;

public:
	cShadowGeometry();
	~cShadowGeometry();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( NiTexture* tex, float maxRadius, float height = 2.0f );

	/// ó
	void Process( bool needUpdate, const NiPoint3& center, float alpha );

	///
	NiTriShape* GetTriShape() const;

	///
	void SetTexture( NiTexture* tex );
	NiTexture* GetTexture() const;

	void SetRadius( float r );

protected:
	void AddShadowTriangle( NiPoint3* v );
	void CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, float x, float y, float radius );

protected:
	/// 
	float mMaxRadius;
	float mRadius;

	/// ǥκ 
	float mHeight;

	///
	int mLineCount;

	/// ִ ﰢ 
	unsigned int mMaxTris;

	///
	NiPoint3 mCenter;
	float mOOWidth;

	/// İ
	float mAlpha;

	/// ׸ ﰢ
	NiTriShapePtr mTris;
	NiTexturingPropertyPtr mTexProp;
	NiTexture* mTex;
};

inline
NiTriShape* cShadowGeometry::GetTriShape() const
{
	return mTris;
}

inline
NiTexture* cShadowGeometry::GetTexture() const
{
	return mTex;
}

inline
void cShadowGeometry::SetRadius( float r )
{
	if( r > mMaxRadius )
		mRadius = mMaxRadius;
	else
		mRadius = r;
}

/// ׸   Լ
class cShadowGeomCompareForRendering
{
public:
	bool operator () ( const cShadowGeometry* left, const cShadowGeometry* right ) const
	{
		return left->mTex > right->mTex;
	};
};
