#include "StdAfx.h"
#include ".\signboard.h"

#include "Application.h"
#include "RenderSystem.h"
#include "ResourceManager.h"
#include "FontAgent.h"
#include "CameraManager.h"


static unsigned int TITLE_TEX_LEN = 13;

//////////////////////////////////////////////////////////////////////////
// cSignboard
cSignboard::cSignboard()
: mpBoxElement(0)
, mActive(false)
{
	mSignHeight = 0;
}

cSignboard::~cSignboard()
{
	SAFE_NIDELETE(mpBoxElement);
}

void cSignboard::Draw()
{
	if( mpBoxElement )
	{
		NiRenderer* pRenderer = NiRenderer::GetRenderer();
		mpBoxElement->Draw(pRenderer);
	}
}

/*
void cSignboard::Update( NiPoint3& pos, unsigned long time )
{
	if( IsActive() == false )
		return;

	/// ǥ   Update
	float x = 0.0f;
	float y = 0.0f;
	float w = 0.0f;
	float h = 0.0f;
	int screenX, screenY;
	WorldPtToScreenPt( CAMERAMAN->GetCurrentNi(), pos, x, y );

	screenX = (int)( x * RENDERSYS->GetScreenWidth() );
	screenY = (int)( (1.0f - y) * RENDERSYS->GetScreenHeight() );

	/// ġ   
	screenX = screenX - mSignWidth/2;
	screenY = screenY - mSignHeight;

	///
	if( mScreenPosX == screenX && mScreenPosY == screenY )
		return;

	mScreenPosX = screenX;
	mScreenPosY = screenY;

	x = (float)screenX / (float)RENDERSYS->GetScreenWidth();
	y = (float)screenY / (float)RENDERSYS->GetScreenHeight();
	w = (float)mSignWidth / (float)RENDERSYS->GetScreenWidth();
	h = (float)mSignHeight / (float)RENDERSYS->GetScreenHeight();

	mpBoxElement->SetRectangle( 0, x, y, w, h );
}
*/

void cSignboard::SetPos( int screenX, int screenY )
{
	/// ǥ   Update
	float x = 0.0f;
	float y = 0.0f;
	float w = 0.0f;
	float h = 0.0f;

	/// ġ   
	screenX = screenX - mSignWidth/2;
	screenY = screenY - mSignHeight;

	///
	if( mScreenPosX == screenX && mScreenPosY == screenY )
		return;

	mScreenPosX = screenX;
	mScreenPosY = screenY;

	x = (float)screenX / (float)RENDERSYS->GetScreenWidth();
	y = (float)screenY / (float)RENDERSYS->GetScreenHeight();
	w = (float)mSignWidth / (float)RENDERSYS->GetScreenWidth();
	h = (float)mSignHeight / (float)RENDERSYS->GetScreenHeight();

	mpBoxElement->SetRectangle( 0, x, y, w, h );
}


//////////////////////////////////////////////////////////////////////////
// cTarotSignboard
cTarotSignboard::cTarotSignboard()
{
	NiTexture* pTex = RESOURCEMAN->LoadTexture( "./Data/2DData/depthplane.tga", false );
	if( pTex )
	{
		float texWid = (float)pTex->GetWidth();
		float texHei = (float)pTex->GetHeight();

		mpBoxElement = NiNew NiScreenElements( NiNew NiScreenElementsData(false, true, 1) );

		/// Property Ѵ.
		NiTexturingProperty* pTextureProp = NiNew NiTexturingProperty;
		pTextureProp->SetBaseTexture( pTex );
		pTextureProp->SetApplyMode( NiTexturingProperty::APPLY_MODULATE );
		mpBoxElement->AttachProperty( pTextureProp );

		NiVertexColorProperty* pVertex = NiNew NiVertexColorProperty;
		pVertex->SetSourceMode( NiVertexColorProperty::SOURCE_EMISSIVE );
		pVertex->SetLightingMode( NiVertexColorProperty::LIGHTING_E );
		mpBoxElement->AttachProperty( pVertex );

		NiAlphaProperty* pAlphaProp = NiNew NiAlphaProperty;
		pAlphaProp->SetAlphaBlending( true );
		mpBoxElement->AttachProperty( pAlphaProp );

		/// 
		mpBoxElement->UpdateProperties();
		mpBoxElement->Update( 0.0f );

		mpBoxElement->Insert( 4 );

		// 0	156 190	77
		float localTexL,localTexT,localTexR,localTexB;
		localTexL = 0.0f / texWid;
		localTexR = localTexL + 190.0f/texWid;
		localTexT = 156.0f/texHei;
		localTexB = localTexT + 77.0f/texHei;

		mpBoxElement->SetRectangle( 0, 0.0f, 0.0f, 0.0f, 0.0f );
		mpBoxElement->SetTextures( 0, 0, localTexL, localTexT, localTexR, localTexB );
		mpBoxElement->SetColors( 0, NiColorA(1.0f, 1.0f, 1.0f, 1.0f) );

		mSignWidth = 190;
		mSignHeight = 77;
		mAllowTextWidth = 190-26;
	}
}

cTarotSignboard::~cTarotSignboard()
{
}

void cTarotSignboard::Active( LPTSTR name, LPTSTR title, unsigned long color, bool loop )
{
	DeActive();

	int len = ::_tcslen( title );
	if( len <= 0 )
	{
		assert( 0 );
		return;
	}

	///  
	unsigned int extW = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, title, len );
	for( unsigned int i=0;i<2; i++ )
	{
		unsigned int curlen = len;
		while( extW > mAllowTextWidth )
		{
			curlen--;
			extW = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, title, curlen );
		}

		assert( curlen < 128 );
		Sstrncpy( mTitle[i].mString, 128, title, curlen );
		mTitle[i].mStrLen = curlen;
		mTitle[i].mColor = 0xFFFFFFFF;

		len -= curlen;
		title += curlen;

		if( *title == _T(' ') ) 
		{
			///    ̽ ŵ
			++title;
			len--;
		}

		if( len <= 0)
			break;
	}

	len = ::_tcslen( name );
	if( len )
	{
		assert(len < 128);
		Sstrncpy( mName.mString, 128, name, len );
		mName.mStrLen = len;
		mName.mColor = color;
	}

	mActive = true;
}


void cTarotSignboard::DeActive()
{
	cSignboard::DeActive();

	_tcscpy( mName.mString, _T("") );
	mName.mStrLen = 0;

	_tcscpy( mTitle[0].mString, _T("") );
	mTitle[0].mStrLen = 0;

	_tcscpy( mTitle[1].mString, _T("") );
	mTitle[1].mStrLen = 0;
}

void cTarotSignboard::Draw()
{
	if( IsActive() == false )
		return;

	cSignboard::Draw();

	POINT pos;

	/// name
	pos.x = mScreenPosX + 33;
	pos.y = mScreenPosY + 15;
	FONTAGENT->DrawText( cFontAgent::eFont_Chat, mName.mString, mName.mStrLen, pos.x, pos.y, mName.mColor );

	/// title
	if( mTitle[0].mStrLen )
	{
		pos.x = mScreenPosX + 16;
		pos.y = mScreenPosY + 36;
		FONTAGENT->DrawText( cFontAgent::eFont_Chat, mTitle[0].mString, mTitle[0].mStrLen, pos.x, pos.y, mTitle[0].mColor );

		if( mTitle[1].mStrLen )
		{
			pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_Chat );
			FONTAGENT->DrawText( cFontAgent::eFont_Chat, mTitle[1].mString, mTitle[1].mStrLen, pos.x, pos.y, mTitle[1].mColor );
		}
	}
}



//////////////////////////////////////////////////////////////////////////
// cUseSellSignboard
cUseSellSignboard::cUseSellSignboard()
{
	NiTexture* pTex = RESOURCEMAN->LoadTexture( "./Data/2DData/depthplane.tga", false );
	if( pTex )
	{
		float texWid = (float)pTex->GetWidth();
		float texHei = (float)pTex->GetHeight();

		mpBoxElement = NiNew NiScreenElements( NiNew NiScreenElementsData(false, true, 1) );

		/// Property Ѵ.
		NiTexturingProperty* pTextureProp = NiNew NiTexturingProperty;
		pTextureProp->SetBaseTexture( pTex );
		pTextureProp->SetApplyMode( NiTexturingProperty::APPLY_MODULATE );
		mpBoxElement->AttachProperty( pTextureProp );

		NiVertexColorProperty* pVertex = NiNew NiVertexColorProperty;
		pVertex->SetSourceMode( NiVertexColorProperty::SOURCE_EMISSIVE );
		pVertex->SetLightingMode( NiVertexColorProperty::LIGHTING_E );
		mpBoxElement->AttachProperty( pVertex );

		NiAlphaProperty* pAlphaProp = NiNew NiAlphaProperty;
		pAlphaProp->SetAlphaBlending( true );
		mpBoxElement->AttachProperty( pAlphaProp );

		/// 
		mpBoxElement->UpdateProperties();
		mpBoxElement->Update( 0.0f );

		mpBoxElement->Insert( 4 );

		// Ǹų - 0 0 190 77
		// Գ - 0 78 190 77
		float localTexL,localTexT,localTexR,localTexB;
		localTexL = 0.0f / texWid;
		localTexR = localTexL + 190.0f/texWid;
		localTexT = 78.0f/texHei;
		localTexB = localTexT + 77.0f/texHei;

		mpBoxElement->SetRectangle( 0, 0.0f, 0.0f, 0.0f, 0.0f );
		mpBoxElement->SetTextures( 0, 0, localTexL, localTexT, localTexR, localTexB );
		mpBoxElement->SetColors( 0, NiColorA(1.0f, 1.0f, 1.0f, 1.0f) );

		mSignWidth = 190;
		mSignHeight = 77;

		mAllowTextWidth = 190-26;
	}
}

cUseSellSignboard::~cUseSellSignboard()
{
}

void cUseSellSignboard::Active( LPTSTR name, LPTSTR title, unsigned long color, bool loop )
{
	DeActive();

	int len = ::_tcslen( title );
	if( len <= 0 )
	{
		assert( 0 );
		return;
	}

	///  
	unsigned int extW = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, title, len );
	for( unsigned int i=0;i<2; i++ )
	{
		unsigned int curlen = len;
		while( extW > mAllowTextWidth )
		{
			curlen--;
			extW = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, title, curlen );
		}

		assert(curlen < 128);
		Sstrncpy( mTitle[i].mString, 128, title, curlen );
		mTitle[i].mStrLen = curlen;
		mTitle[i].mColor = 0xFFFFFFFF;

		len -= curlen;
		title += curlen;

		if( *title == _T(' ') ) 
		{
			///    ̽ ŵ
			++title;
			len--;
		}

		if( len <= 0)
			break;
	}

	len = ::_tcslen( name );
	if( len )
	{
		assert(len < 128);
		Sstrncpy( mName.mString, 128, name, len );
		mName.mStrLen = len;
		mName.mColor = color;
	}

	mActive = true;
}

void cUseSellSignboard::DeActive()
{
	cSignboard::DeActive();

	_tcscpy( mName.mString, _T("") );
	mName.mStrLen = 0;

	_tcscpy( mTitle[0].mString, _T("") );
	mTitle[0].mStrLen = 0;

	_tcscpy( mTitle[1].mString, _T("") );
	mTitle[1].mStrLen = 0;
}


void cUseSellSignboard::Draw()
{
	if( IsActive() == false )
		return;

	cSignboard::Draw();

	POINT pos;

	/// name
	pos.x = mScreenPosX + 33;
	pos.y = mScreenPosY + 15;
	FONTAGENT->DrawText( cFontAgent::eFont_Chat, mName.mString, mName.mStrLen, pos.x, pos.y, mName.mColor );

	/// title
	if( mTitle[0].mStrLen )
	{
		pos.x = mScreenPosX + 16;
		pos.y = mScreenPosY + 36;
		FONTAGENT->DrawText( cFontAgent::eFont_Chat, mTitle[0].mString, mTitle[0].mStrLen, pos.x, pos.y, mTitle[0].mColor );

		if( mTitle[1].mStrLen )
		{
			pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_Chat );
			FONTAGENT->DrawText( cFontAgent::eFont_Chat, mTitle[1].mString, mTitle[1].mStrLen, pos.x, pos.y, mTitle[1].mColor );
		}
	}
}