#pragma once
#include "DepthPlane.h"


class cSignboard : public cPlane
{
public:
	virtual ~cSignboard();
	virtual void Draw();

	inline unsigned int GetBoardHeight() { return mSignHeight; }

	inline virtual void Active( LPTSTR name, LPTSTR title, unsigned long color, bool loop = false ) = 0;
	inline virtual void DeActive() { mActive = false; }

	inline bool IsActive() { return mActive; }

	void SetPos( int screenX, int screenY );

protected:
	cSignboard();

protected:
	bool				mActive;

	NiScreenElements*	mpBoxElement;
	unsigned int		mSignWidth;
	unsigned int		mSignHeight;

	unsigned int		mAllowTextWidth;

	struct sSignString
	{
		TCHAR			mString[128];
		int				mStrLen;
		unsigned long	mColor;

		sSignString()
		{
			_stprintf( mString, _T("%s"), _T("") );
			mStrLen = ::_tcslen(mString);
			mColor = 0xFFFFFFFF;
		}
	};

	sSignString		mTitle[2];
	sSignString		mName;

	int	mScreenPosX;
	int	mScreenPosY;
};

class cTarotSignboard : public cSignboard
{
public:
	cTarotSignboard();
	virtual ~cTarotSignboard();

	void Active( LPTSTR name, LPTSTR title, unsigned long color, bool loop = false );
	void DeActive();

	void Draw();
};

class cUseSellSignboard : public cSignboard
{
public:
	cUseSellSignboard();
	virtual ~cUseSellSignboard();

	void Active( LPTSTR name, LPTSTR title, unsigned long color, bool loop = false );
	void DeActive();

	void Draw();

};