#include "StdAfx.h"
#include ".\simpletipwindow.h"

#include "PlaneObject.h"
#include "FontAgent.h"


cSimpleTipWindow::cSimpleTipWindow()
{
}

cSimpleTipWindow::~cSimpleTipWindow()
{
}


void cSimpleTipWindow::Show( bool onsound )
{
	cTipWindow::Show( onsound );
}

void cSimpleTipWindow::Hide( bool onsound )
{
	cTipWindow::Hide( onsound );

	mTimerEnabled = false;
}

void cSimpleTipWindow::OnRender( cUIFontItemKeeper* fontKeeper )
{
	if( mVisible == false )
		return;

	/// 
	mMiddleBack->Draw();

	int px = mX + GAP_SIZE;
	int py = mY;

	///   
	for( unsigned int row = 0; row < mIndex; ++row )
	{
		cStringT& str = mToolTip[row].mString;
		if( str.IsEmpty() )
			continue;

		py += mToolTip[row].mGapCount * GAP_SIZE;

		///   
		unsigned int color = mToolTip[row].mColor;
		fontKeeper->AddFontItem( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), px, py, color );

		py += mLineHeight;
	}

	px = mX + GAP_SIZE + mMaxWidth;
	py = mY;

	///
	fontKeeper->DrawAll();
}

bool cSimpleTipWindow::SetSimpleTip( const cUIPos& pos, cStringT str )
{
	Clear();

	AddGap(1);
	SetText( str.Cstr(), eCOLOR_WHITE );

	/// ּ ʺ  
	if( mMaxWidth < mLimitMinWidth )
		mMaxWidth = mLimitMinWidth;

	/// ִ ʺ  
	if( mMaxWidth > mLimitMaxWidth )
		mMaxWidth = mLimitMaxWidth;

	/// 
	mX = pos.mX + 25;
	mY = pos.mY + 25;

	unsigned int w = mMaxWidth + GAP_SIZE * 2; 
	unsigned int h = mIndex * mLineHeight + (mGapCount+1)*GAP_SIZE;

	/// ȭ ȹ 
	if( mX + w > GetScreenWidth() )
	{	
		mX -= ((mX + w) - GetScreenWidth());
	}

	if( mY + h > GetScreenHeight() )
	{
		mY -= ((mY + h) - GetScreenHeight());
	}

	mMiddleBack->SetScreenRect( (short)mX, (short)mY, (unsigned short)w, (unsigned short)h );
	mMiddleBack->SetColorA( 0.6f, 0.6f, 0.6f, 0.6f );
	SetRelativePos( cUIPos( mX, mY ) );

	return true;
}