#include "stdafx.h"
#include "SkillExecuter.h"

#include "SkillManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "monster.h"
#include "protocol.h"

#include "skillscript.h"
#include "TotemScript.h"
#include "GameUIManager.h"
#include "SkillWindow.h"

#include "ItemManager.h"
#include "chatmanager.h"
#include "GameResourceManager.h"
#include "QuickManager.h"
#include "UICursor.h"
#include "CastingBar.h"

#include "DuelManager.h"
#include "PVPManager.h"

//////////////////////////////////////////////////////////////////////////
unsigned int cAttackPattern::GetAttackFlag()
{
	bool newPattern = false;
	if( mPatternIdx < 0 || mPatternIdx > 2 )
		newPattern = true;
	if( mProgressIdx > 5 )
		newPattern = true;

	if( newPattern == true )
	{
		///  
		unsigned int r = ::rand()%1000;
		if( r < 330 )		mPatternIdx = 0;
		else if( r < 660 )	mPatternIdx = 1;
		else				mPatternIdx = 2;

		mProgressIdx = 0;
	}
	else
	{
		if( mPattern[mPatternIdx][mProgressIdx] == -1 )
		{
			///  
			unsigned int r = ::rand()%1000;
			if( r < 330 )		mPatternIdx = 0;
			else if( r < 660 )	mPatternIdx = 1;
			else				mPatternIdx = 2;

			mProgressIdx = 0;
		}
	}

	int curIdx = mPattern[mPatternIdx][mProgressIdx];
	if( mOldAttackIdx == curIdx )
	{
		mProgressIdx++;

		if( mProgressIdx > 5 )
		{
			assert(0);
		}

		if( curIdx == mPattern[mPatternIdx][mProgressIdx] )
		{
			int a = 0;
			a = 1;
		}

	}

	mOldAttackIdx = mPattern[mPatternIdx][mProgressIdx];
	mProgressIdx++;

	return (unsigned int)mOldAttackIdx;
}

//////////////////////////////////////////////////////////////////////////
cSkillExecuter* cSkillExecuter::mpExec = NULL;

cSkillExecuter::cSkillExecuter()
{
	if(mpExec) assert(0);
	mpExec = this;

	mIsCharge = false;
	mIsFieldCheck = false;

	mChargeSkillIdx = ULONG_MAX;
	mSkillRange = FLT_MAX;

	mAttackTarget.index = 0;
	mAttackTarget.type = eOBJECTTYPE_NONE;

	mpCurrentHeroSkillObject = 0;
}

cSkillExecuter::~cSkillExecuter()
{
}

void cSkillExecuter::Close()
{
	mIsCharge = false;
	mIsFieldCheck = false;

	mChargeSkillIdx = ULONG_MAX;
	mSkillRange = FLT_MAX;

	mAttackTarget.index = 0;
	mAttackTarget.type = eOBJECTTYPE_NONE;

	mpCurrentHeroSkillObject = 0;
}

bool cSkillExecuter::AutoAttack( cBaseObject* pTarget )
{
	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return true;

	if( pTarget == 0 )
		return false;

	if( HERO->IsTransformMonster() )
	{
		unsigned long skillIdx = GenerateTransMonsAttackIdx();
		if( skillIdx > eMONSTERATTACK_NORMAL2 )
		{
			assert(0);
		}

		return AutoAttack_TransMon( skillIdx, pTarget );
	}

	/// ų  Ұ
	if( HERO->IsCantSkill( NORMAL_ATTACK_SKILL ) == true )
		return false;


	/// target  üũ..
	unsigned char type = pTarget->GetObjectType();
	switch( type )
	{
	case eOBJECTTYPE_PLAYER:
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetState() == eOBJECT_STATE_DIE )
				return false;

			///   Ǵ
			if( DUELMAN->IsDuelEnemy( pPlayer ) != true && 
				PVPMAN->IsEnableAttack( pPlayer ) != true )
				return false;
		}
		break;
	case eOBJECTTYPE_MONSTER:
		{
			cMonster* pMon = (cMonster*)pTarget;
			if( pMon->GetState() == eOBJECT_STATE_DIE )
				return false;
		}
		break;
	default:
		return false;
	}

	/// ⺻  ε  - ,  ε
	ChargeOn( NORMAL_ATTACK_SKILL );

	///  Ÿ üũ - ó
	HERO->AfterAttack( pTarget );

	return true;
}

bool cSkillExecuter::ExecuteAttack( cBaseObject* pTarget  )
{
	HERO->SetWaitMoveFlag( false );

	/// 080508 PKH  ϶ Ϲݰ ϸ ϸ̼ ٲ üũ
	if( HERO->GetState() == eOBJECT_STATE_DIE || HERO->GetState() == eOBJECT_STATE_STOP )
		return false;

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return false;

	if( pTarget == 0 )
		return false;

	if( HERO->IsTransformMonster() )
	{
		unsigned long skillIdx = GenerateTransMonsAttackIdx();
		if( skillIdx > eMONSTERATTACK_NORMAL2 )
		{
			assert(0);
		}

		return ExecuteAttack_TransMon( skillIdx, pTarget );
	}

	///   Target  Target ϴ 
	cBaseObject* pBeforeTarget = OBJECTMAN->GetObject( &mAttackTarget );
	if( pTarget == pBeforeTarget )
	{
		/// cooltime check
		if( SKILLMAN->IsUsedKeepSkill( NORMAL_ATTACK_SKILL ) == false )
			return false;
	}
	else
	{
		/// target window  hero Ÿ 
		HERO->SetTargetObject( pTarget->GetObjectType(), pTarget->GetObjectID() );
	}

	sAfterAction* p = HERO->GetCurrentAfterAction();
	if( p->mActionType == eAfterAction_Attack &&
		p->mTarget.index == pTarget->GetObjectID() )
		return false;

	/// target  üũ..
	unsigned char type = pTarget->GetObjectType();

	switch( type )
	{
	case eOBJECTTYPE_PLAYER:
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetState() == eOBJECT_STATE_DIE )
				return false;

			///   Ǵ
			if( DUELMAN->IsDuelEnemy( pPlayer ) != true &&
				PVPMAN->IsEnableAttack( pPlayer ) != true )
				return false;
		}
		break;
	case eOBJECTTYPE_MONSTER:
		{
			cMonster* pMon = (cMonster*)pTarget;
			if( pMon->GetState() == eOBJECT_STATE_DIE )
				return false;
		}
		break;
	default:
		return false;
	}

	/// ⺻  ε  - ,  ε
	ChargeOn( NORMAL_ATTACK_SKILL );

	///  Ÿ üũ - ó
	HERO->AfterAttack( pTarget );

	ResetAttackFlag();

	mAttackTarget.index = pTarget->GetObjectID();
	mAttackTarget.type = pTarget->GetObjectType();
	return true;
}

/// Ÿ   ų 
void cSkillExecuter::ExecuteSkill( unsigned long skillIdx, cBaseObject* pTarget )
{
	if( HERO->IsTransformMonster() )
	{
		ExecuteSkill_TransMon( skillIdx, pTarget );
		return;
	}

	HERO->SetWaitMoveFlag( false );

	ChargeOff( mChargeSkillIdx );

	/// 080508 PKH  ϶ Ϲݰ ϸ ϸ̼ ٲ üũ
	if( HERO->GetState() == eOBJECT_STATE_DIE || HERO->GetState() == eOBJECT_STATE_STOP )
		return;

	/// ų  ȹѴ.
	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}

	if( pInfo->mShotType == eSHOTTYPE_CASTING )
	{
		cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
		if( pWin && pWin->IsVisible() )
			return;
	}

	if( pInfo->mShotType == eSHOTTYPE_AURA )
	{
		cSkillWindow* pSkillWindow = GAMEUI->GetSkillWindow();
		if( pSkillWindow == 0 )
		{
			assert(0);
			return;
		}

		unsigned long uniqueIdx = pSkillWindow->GetAuraUniqueIdx( skillIdx );
		if( uniqueIdx )
		{
			MSG_REQ_INFLUENCE_AURA_DELETE msg;

			msg.Category = NM_SKILL;
			msg.Protocol = NM_SKILL_INFLUENCE_AURA_DELETE_REQ;
			msg.mUniqueIdx = uniqueIdx;
			msg.mSkillClassIdx = skillIdx;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
			return;
		}
	}

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return;

	if( skillIdx < NORMAL_ATTACK_SKILL_MAX )
	{
		assert(0);
		return;
	}


	///    üũ
	if( IsPossibleUseSkill( skillIdx ) == false )
		return;

	/// 
	bool targetCheck = true;
	if( pTarget == 0 )
		pTarget = HERO->GetTargetObject();

	if( pInfo->mBoundType == eBOUNDTYPE_FIELD )
	{
		/// field base skill
		if( HERO->IsReadyUseSkill() )
			FieldSkillOn( skillIdx );
		return;
	}
	else if( pInfo->mBoundType == eBOUNDTYPE_SELF_NOTARGET )
	{
		/// active
		targetCheck = false;
	}
	else if( pInfo->mBoundType == eBOUNDTYPE_NONE )
	{
		if( pInfo->mApplyType == eAPPLYTYPE_SELF )
			pTarget = HERO;

		targetCheck = true;
	}

	if( targetCheck )
	{
		///  Ÿ ƴ  charge
		if( IsPossibleUseSkillTarget( skillIdx, pTarget ) == false )
		{
			ChargeOn( skillIdx );
			return;
		}

		/// 
		cBaseObject* pBeforeTarget = OBJECTMAN->GetObject( &mAttackTarget );
		if( pTarget == pBeforeTarget )
		{
			/// cooltime check
			if( SKILLMAN->IsUsedKeepSkill( skillIdx ) == false )
				return;
		}

		sAfterAction* p = HERO->GetCurrentAfterAction();
		if( p->mActionType == eAfterAction_UseTargetSkill &&
			p->mExData1 == skillIdx &&
			p->mTarget.index == pTarget->GetObjectID() )
			return;
	}

	/// ų ߵ
	ChargeOn( skillIdx );
	HERO->AfterUseSkill( pTarget );

	if( pTarget )
		mAttackTarget = *(pTarget->GetTargetInfo());
}

/// BOUNDTYPE = eBOUNDTYPE_FIELD 
void cSkillExecuter::ExecuteSkill( unsigned long skillIdx, NiPoint3 applyPos )
{
	if( HERO->IsTransformMonster() )
	{
		ExecuteSkill_TransMon( skillIdx, applyPos );
		return;
	}

	HERO->SetWaitMoveFlag( false );

	ChargeOff( mChargeSkillIdx );

	if( HERO->GetState() == eOBJECT_STATE_DIE )
		return;

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return;

	if( skillIdx < NORMAL_ATTACK_SKILL_MAX )
	{
		assert(0);
		return;
	}

	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}

	if( pInfo->mShotType == eSHOTTYPE_CASTING )
	{
		cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
		if( pWin && pWin->IsVisible() )
			return;
	}

	///    üũ
	if( IsPossibleUseSkill( skillIdx ) == false )
		return;

	if( pInfo->mBoundType != eBOUNDTYPE_FIELD )
		return;

	sAfterAction* p = HERO->GetCurrentAfterAction();
	if( p->mActionType == eAfterAction_UseFieldSkill &&
		p->mExData1 == skillIdx )
		return;

	ChargeOn( skillIdx );
	HERO->AfterUseSkill( applyPos );
}

bool cSkillExecuter::IsPossibleUseSkill( unsigned long skillIdx )
{
	if( HERO->IsTransformMonster() )
		return IsPossibleUseSkill_TransMon( skillIdx );

	if( HERO->GetState() == eOBJECT_STATE_DIE )
		return false;

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return false;

	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return false;
	}

	/// TODO :  ų üũ  Ÿ üũ
	if( SKILLMAN->IsUsedKeepSkill( skillIdx ) == false )
		return false;

	sKeepSkill* keep =  SKILLMAN->GetKeepInfo( skillIdx );
	if( keep == 0 )
	{
		assert(0);
		return false;
	}
	if( pInfo->mStepCount <= keep->mStep )
	{
		assert(0);
		return false;
	}

	sPlayerSkillStepInfo* pStepInfo = &pInfo->mpSetpInfoArray[keep->mStep];

	/// Ҹ    üũ
	if( pInfo->mUseItem )
	{
		/// κ üũ
		unsigned int count = ITEMMAN->GetItemCount( pInfo->mUseItem );
		if( count < pStepInfo->mUseItemCount )
			return false;
	}

	if( HERO->GetLevel() < pStepInfo->mPlayerLevel )
		return false;

	///   ´ üũ
	if( pInfo->mUseEquipment )
	{
		eWEAPON_STATE weaponState = HERO->GetWeaponState();

		///   üũ
		switch( pInfo->mUseEquipment )
		{
		case eEQUIPTYPE_SWORD:
			if( weaponState != eWEAPON_STATE_SWORD &&
				weaponState != eWEAPON_STATE_SWORD_SHEILD )
				return false;
			break;
		case eEQUIPTYPE_LONGSWORD:
			if( weaponState != eWEAPON_STATE_LONGSWORD )
				return false;
			break;
		case eEQUIPTYPE_DOUBLESWORD:
			if( weaponState != eWEAPON_STATE_DOUBLESWORD )
				return false;
			break;
		case eEQUIPTYPE_SHORTSWORD:
			if( weaponState != eWEAPON_STATE_SHORTSWORD )
				return false;
			break;
		case eEQUIPTYPE_GUN:
			if( weaponState != eWEAPON_STATE_GUN )
				return false;
			break;
		case eEQUIPTYPE_STAFF:
			if( weaponState != eWEAPON_STATE_STAFF )
				return false;
			break;
		case eEQUIPTYPE_SHIELD:
			if( weaponState != eWEAPON_STATE_SHEILD &&
				weaponState != eWEAPON_STATE_SWORD_SHEILD )
				return false;
			break;
		case eEQUIPTYPE_SWORD_LONGSWORD:
			if( weaponState != eWEAPON_STATE_SWORD &&
				weaponState != eWEAPON_STATE_SWORD_SHEILD &&
				weaponState != eWEAPON_STATE_LONGSWORD )
				return false;
			break;
		case eEQUIPTYPE_SWORD_DOUBLESWORD:
			if( weaponState != eWEAPON_STATE_SWORD &&
				weaponState != eWEAPON_STATE_SWORD_SHEILD &&
				weaponState != eWEAPON_STATE_DOUBLESWORD )
				return false;
			break;
		case eEQUIPTYPE_LONGSWORD_DOUBLESWORD:
			if( weaponState != eWEAPON_STATE_LONGSWORD &&
				weaponState != eWEAPON_STATE_DOUBLESWORD )
				return false;
			break;
		case eEQUIPTYPE_SWORD_LONGSWORD_DOUBLESWORD:
			if( weaponState != eWEAPON_STATE_SWORD &&
				weaponState != eWEAPON_STATE_SWORD_SHEILD &&
				weaponState != eWEAPON_STATE_LONGSWORD &&
				weaponState != eWEAPON_STATE_DOUBLESWORD )
				return false;
			break;
		case eEQUIPTYPE_SHORTSWORD_GUN:
			if( weaponState != eWEAPON_STATE_SHORTSWORD &&
				weaponState != eWEAPON_STATE_GUN )
				return false;
			break;
		case eEQUIPTYPE_CLOTH:
			if( HERO->GetArmorSets() != ARMOR_SETS_ROBES )
				return false;
			break;
		case eEQUIPTYPE_LIGHTARMOR:
			if( HERO->GetArmorSets() != ARMOR_SETS_LIGHT_ARMOR )
				return false;
			break;
		case eEQUIPTYPE_HEAVYARMOR:
			if( HERO->GetArmorSets() != ARMOR_SETS_HEAVY_ARMOR )
				return false;
			break;
		}
	}

	///  ° ´ üũ
	if( pInfo->mUseState )
	{
		/// ĳ  üũ
		pStepInfo->mUseStateValue;
	}

	/// Ҹ HP, MP üũ
	if( HERO->GetHP() < pStepInfo->mUseHP )
	{
		return false;
	}
	if( HERO->GetMP() < pStepInfo->mUseMP )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 6001 ) );
		return false;
	}

//	if( pInfo->mBoundType == eBOUNDTYPE_FIELD )
//		return true;

	return true;
}

bool cSkillExecuter::IsPossibleUseSkillTarget( unsigned long skillIdx, cBaseObject* pTarget )
{
	if( HERO->IsTransformMonster() )
		return IsPossibleUseSkillTarget_TransMon( skillIdx, pTarget );

	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return false;
	}

	/// Ÿ  ߵϴ ų
	/// 1. Ÿ ڱ ڽ 
	/// 2. Ÿ   ų 
	///  ܴ  ߵ Ұ
	if( pInfo->mApplyType != eAPPLYTYPE_SELF &&
		pInfo->mBoundType != eBOUNDTYPE_SELF_NOTARGET )
	{
		if( pTarget == 0 )
			return false;

		if( pInfo->mApplyType == eAPPLYTYPE_DIEBUDDY )
		{
			if( pTarget->GetState() == eOBJECT_STATE_DIE )
			{
				if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
				{
					///  Ʊ 
					if( DUELMAN->IsDuelEnemy( (cPlayer*)pTarget ) ||
						PVPMAN->IsEnableAttack( (cPlayer*)pTarget ) )
						return false;

					return true;
				}
			}
			return false;
		}
		else
		{
			if( pTarget->GetState() == eOBJECT_STATE_DIE )
			{
				return false;
			}
		}

		unsigned char type = pTarget->GetObjectType();
		switch( type )
		{
		case eOBJECTTYPE_HERO:
			{
				if( pInfo->mApplyType == eAPPLYTYPE_ENEMY )
					return false;
			}
			break;
		case eOBJECTTYPE_MONSTER:
			{
				if( pInfo->mApplyType != eAPPLYTYPE_ENEMY )
					return false;
			}
			break;
		case eOBJECTTYPE_PLAYER:
			{
//				if( pInfo->mApplyType == eAPPLYTYPE_PARTY )
//				{
//					return false;
//				}
//				else if( pInfo->mApplyType == eAPPLYTYPE_BUDDY )
//				{
//					/// ̳?
//					return false;
//				}
//				else if( pInfo->mApplyType == eAPPLYTYPE_ENEMY )
				if( pInfo->mApplyType == eAPPLYTYPE_ENEMY )
				{
					if( DUELMAN->IsDuelEnemy( (cPlayer*)pTarget ) ||
						PVPMAN->IsEnableAttack( (cPlayer*)pTarget ) )
						return true;

					return false;
				}
			}
			break;
		default: 
			return false;
		}
	}

	return true;
}

void cSkillExecuter::ChargeOn( unsigned long skillIdx )
{
	if( IsSkillCharge() )
	{
		ChargeOff( mChargeSkillIdx );
		return;
	}

	/// 
	if( HERO->IsTransformMonster() )
	{
		ChargeOn_TransMon( skillIdx );
		return;
	}

	if( skillIdx < NORMAL_ATTACK_SKILL_MAX )
	{
		unsigned int state = (unsigned int)HERO->GetWeaponState();
		if( state > eWEAPON_STATE_MAX )
			state -= eWEAPON_STATE_SHEILD;

		unsigned int flag = 0;//mAttackPattern.GetAttackFlag();
		mChargeSkillIdx = flag*10 + state + 1;
	}
	else
	{
		mChargeSkillIdx = skillIdx;
	}
	
	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( mChargeSkillIdx );
	assert(pInfo);

	if( SKILLMAN->IsUsedKeepSkill( skillIdx ) == false )
	{
//		assert(0);
		return;
	}
	sKeepSkill* keep =  SKILLMAN->GetKeepInfo( skillIdx );
	if( keep == 0 )
	{
		assert(0);
		return;
	}
	if( pInfo->mStepCount <= keep->mStep )
	{
		assert(0);
		return;
	}

	/// skill step ȹѴ. ߰ؾ Ѵ.
	mSkillRange = pInfo->mpSetpInfoArray[keep->mStep].mTargetDist;

	/// 080225 PKH ų++ȿ Ÿ
	mSkillRange = HERO->CalcStatusSkillRange( mSkillRange, pInfo->mRangeType, mChargeSkillIdx < NORMAL_ATTACK_SKILL_MAX );

	///  ų  
	QUICKMAN->SetCharge( skillIdx, true );
	CURSOR->SetCursor( eCURSOR_SKILL );

	mIsCharge = true;
}

void cSkillExecuter::ChargeOff( unsigned long skillIdx )
{
	/// 
	if( HERO->IsTransformMonster() )
	{
		ChargeOff_TransMon( skillIdx );
		return;
	}

	if( mChargeSkillIdx != skillIdx )
		return;

	mIsCharge = false;
	mIsFieldCheck = false;

	///  ų  
	QUICKMAN->SetCharge( skillIdx, false );
	CURSOR->SetCursor( eCURSOR_DEFAULT );
}

bool cSkillExecuter::IsSkillCharge()
{
	if( mIsCharge == false )
		return false;

	if( HERO->IsTransformMonster() )
	{
		if( mChargeSkillIdx < eMONSTERATTACK_SKILL1 )
			return false;
	}
	else
	{
		if( mChargeSkillIdx < NORMAL_ATTACK_SKILL_MAX )
			return false;
	}

	return true;
}

unsigned long cSkillExecuter::GetChargeSkill()
{
	/// 
	if( HERO->IsTransformMonster() )
		return mChargeSkillIdx;


	if( mChargeSkillIdx < NORMAL_ATTACK_SKILL_MAX )
	{
		unsigned int state = (unsigned int)HERO->GetWeaponState();
		if( state > eWEAPON_STATE_MAX )
			state -= eWEAPON_STATE_SHEILD;

		unsigned int flag = mAttackPattern.GetAttackFlag();
		unsigned long skillIdx = flag*10 + state + 1;

		if( skillIdx != mChargeSkillIdx )
		{
			/// Ⱑ ü  Ÿ 
			mChargeSkillIdx = skillIdx;

			sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( mChargeSkillIdx );
			assert(pInfo);

			if( pInfo->mStepCount == 0 )
			{
				assert(0);
			}

			mSkillRange = pInfo->mpSetpInfoArray[0].mTargetDist;

			/// 080225 PKH ų++ȿ Ÿ
			mSkillRange = HERO->CalcStatusSkillRange( mSkillRange, pInfo->mRangeType, true );

		}
	}
	return mChargeSkillIdx;
}

///

unsigned long cSkillExecuter::GenerateTransMonsAttackIdx()
{
	unsigned long monsterClassIdx = HERO->GetTransMonsterClassIdx();

	/// monster skill
	unsigned long rd = ::rand() % mTotalMonsterAttackPer + 1;

	sMonsterSkillScript* info;
	/// ⺻ ߿  ϴ  Ѵ.
	for( unsigned int i=0;i<eMONSTERATTACK_SKILL1;i++ )
	{
		if( mMonsterAttackInfo[i].mUsePer == 0 )
			continue;

		info = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)i );
		if( info == 0 )
			continue;
		if( info->mUseMP > HERO->GetMP() )
			continue;

		if( mMonsterAttackInfo[i].mUsePer <= rd )
			return i;
	}

	return eMONSTERATTACK_NORMAL1;
}

void cSkillExecuter::ChargeOn_TransMon( unsigned long skillIdx )
{
	if( skillIdx >= eMONSTERATTACK_MAX )
	{
		assert(0);
		return;
	}

	mIsCharge = true;
	CURSOR->SetCursor( eCURSOR_SKILL );

	mChargeSkillIdx = skillIdx;

	mSkillRange = mMonsterAttackInfo[mChargeSkillIdx].mRange;

	QUICKMAN->SetMonCharge( skillIdx, true );
}

void cSkillExecuter::ChargeOff_TransMon( unsigned long skillIdx )
{
	if( mIsCharge == false )
		return;

	if( skillIdx >= eMONSTERATTACK_MAX )
	{
		assert(0);
		return;
	}

	mIsCharge = false;
	mIsFieldCheck = false;

	CURSOR->SetCursor( eCURSOR_DEFAULT );
	QUICKMAN->SetMonCharge( skillIdx, false );
}

void cSkillExecuter::SetMonsterSkillInfo( unsigned long monsterClassIdx )
{
	mTotalMonsterAttackPer = 0;

	sMonsterSkillScript* info;
	for( unsigned int i=0;i<eMONSTERATTACK_MAX;i++ )
	{
		mMonsterAttackInfo[i].mUsePer = 0;

		info = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)i );
		if( info == 0 )
			continue;

		mMonsterAttackInfo[i].mUsePer = info->mSkillUsePer;
		mMonsterAttackInfo[i].mRange = info->mTargetDist;

		if( i < eMONSTERATTACK_SKILL1 )
			mTotalMonsterAttackPer += mMonsterAttackInfo[i].mUsePer;
	}
}

bool cSkillExecuter::IsPossibleUseSkill_TransMon( unsigned long skillIdx )
{
	if( HERO->GetState() == eOBJECT_STATE_DIE )
		return false;

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return false;

	unsigned long monsterClassIdx = HERO->GetTransMonsterClassIdx();
	if( monsterClassIdx == 0 )
		return false;

	sMonsterSkillScript* pInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)skillIdx );
	if( pInfo == 0 )
		return false;

	/// Ҹ MP üũ
	if( HERO->GetMP() < pInfo->mUseMP )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 6001 ) );
		return false;
	}
//	if( pInfo->mBoundType == eBOUNDTYPE_FIELD )
//		return true;

	return true;
}

bool cSkillExecuter::IsPossibleUseSkillTarget_TransMon( unsigned long skillIdx, cBaseObject* pTarget )
{
	unsigned long monsterClassIdx = HERO->GetTransMonsterClassIdx();
	if( monsterClassIdx == 0 )
		return false;

	sMonsterSkillScript* pInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)skillIdx );
	if( pInfo == 0 )
		return false;

	/// Ÿ  ߵϴ ų
	/// 1. Ÿ ڱ ڽ 
	/// 2. Ÿ   ų 
	///  ܴ  ߵ Ұ
	if( pInfo->mApplyType != eAPPLYTYPE_SELF &&
		pInfo->mBoundType != eBOUNDTYPE_SELF_NOTARGET )
	{
		if( pTarget == 0 )
			return false;

		if( pInfo->mApplyType == eAPPLYTYPE_DIEBUDDY )
		{
			if( pTarget->GetState() == eOBJECT_STATE_DIE )
			{
				if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
				{
					///  Ʊ 
					if( DUELMAN->IsDuelEnemy( (cPlayer*)pTarget ) != true &&
						PVPMAN->IsEnableAttack( (cPlayer*)pTarget ) != true )
						return false;

					return true;
				}
			}
			return false;
		}
		else
		{
			if( pTarget->GetState() == eOBJECT_STATE_DIE )
			{
				return false;
			}
		}

		unsigned char type = pTarget->GetObjectType();
		switch( type )
		{
		case eOBJECTTYPE_HERO:
			{
				if( pInfo->mApplyType == eAPPLYTYPE_ENEMY )
					return false;
			}
			break;
		case eOBJECTTYPE_MONSTER:
			{
				if( pInfo->mApplyType != eAPPLYTYPE_ENEMY )
					return false;
			}
			break;
		case eOBJECTTYPE_PLAYER:
			{
//				if( pInfo->mApplyType == eAPPLYTYPE_PARTY )
//				{
//					return false;
//				}
//				else if( pInfo->mApplyType == eAPPLYTYPE_BUDDY )
//				{
//					/// ̳?
//					return false;
//				}
//				else if( pInfo->mApplyType == eAPPLYTYPE_ENEMY )
				if( pInfo->mApplyType == eAPPLYTYPE_ENEMY )
				{
					if( DUELMAN->IsDuelEnemy( (cPlayer*)pTarget ) ||
						PVPMAN->IsEnableAttack( (cPlayer*)pTarget ) )
						return true;

					return false;
				}
			}
			break;
		default: 
			return false;
		}
	}

	return true;
}

bool cSkillExecuter::AutoAttack_TransMon( unsigned long skillIdx, cBaseObject* pTarget )
{
	/// target  üũ..
	unsigned char type = pTarget->GetObjectType();
	switch( type )
	{
	case eOBJECTTYPE_PLAYER:
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetState() == eOBJECT_STATE_DIE )
				return false;

			///   Ǵ
			if( DUELMAN->IsDuelEnemy( pPlayer ) != true &&
				PVPMAN->IsEnableAttack( pPlayer ) != true )
				return false;
		}
		break;
	case eOBJECTTYPE_MONSTER:
		{
			cMonster* pMon = (cMonster*)pTarget;
			if( pMon->GetState() == eOBJECT_STATE_DIE )
				return false;
		}
		break;
	default:
		return false;
	}

	/// ⺻  ε  - ,  ε
	ChargeOn( skillIdx );

	///  Ÿ üũ - ó
	HERO->AfterAttack( pTarget );

	return true;
}

bool cSkillExecuter::ExecuteAttack_TransMon( unsigned long skillIdx, cBaseObject* pTarget )
{
	/// target window  hero Ÿ 
	HERO->SetTargetObject( pTarget->GetObjectType(), pTarget->GetObjectID() );

	sAfterAction* p = HERO->GetCurrentAfterAction();
	if( p->mActionType == eAfterAction_Attack &&
		p->mTarget.index == pTarget->GetObjectID() )
		return false;

	/// target  üũ..
	unsigned char type = pTarget->GetObjectType();

	switch( type )
	{
	case eOBJECTTYPE_PLAYER:
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetState() == eOBJECT_STATE_DIE )
				return false;

			///   Ǵ
			if( DUELMAN->IsDuelEnemy( pPlayer ) != true &&
				PVPMAN->IsEnableAttack( pPlayer ) != true )
				return false;
		}
		break;
	case eOBJECTTYPE_MONSTER:
		{
			cMonster* pMon = (cMonster*)pTarget;
			if( pMon->GetState() == eOBJECT_STATE_DIE )
				return false;
		}
		break;
	default:
		return false;
	}

	/// ⺻  ε  - ,  ε
	ChargeOn( skillIdx );

	///  Ÿ üũ - ó
	HERO->AfterAttack( pTarget );

	ResetAttackFlag();

	mAttackTarget.index = pTarget->GetObjectID();
	mAttackTarget.type = pTarget->GetObjectType();
	return true;
}

bool cSkillExecuter::ExecuteSkill_TransMon( unsigned long skillIdx, cBaseObject* pTarget )
{
	HERO->SetWaitMoveFlag( false );

	ChargeOff( mChargeSkillIdx );

	if( HERO->GetState() == eOBJECT_STATE_DIE )
		return false;

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return false;

	unsigned long monsterClassIdx = HERO->GetTransMonsterClassIdx();
	if( monsterClassIdx == 0 )
		return false;

	sMonsterSkillScript* pInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)skillIdx );
	if( pInfo == 0 )
		return false;

	///    üũ
	if( IsPossibleUseSkill( skillIdx ) == false )
		return false;

	/// 
	bool targetCheck = true;
	if( pTarget == 0 )
		pTarget = HERO->GetTargetObject();

	if( pInfo->mBoundType == eBOUNDTYPE_FIELD )
	{
		/// field base skill
		FieldSkillOn_TransMon( monsterClassIdx, skillIdx );
		return true;
	}
	else if( pInfo->mBoundType == eBOUNDTYPE_SELF_NOTARGET )
	{
		/// active
		targetCheck = false;
	}
	else if( pInfo->mBoundType == eBOUNDTYPE_NONE )
	{
		if( pInfo->mApplyType == eAPPLYTYPE_SELF )
			pTarget = HERO;

		targetCheck = true;
	}

	if( targetCheck )
	{
		///  Ÿ ƴ  charge
		if( IsPossibleUseSkillTarget( skillIdx, pTarget) == false )
		{		
			ChargeOn( skillIdx );
			return false;
		}

		sAfterAction* p = HERO->GetCurrentAfterAction();
		if( p->mActionType == eAfterAction_UseTargetSkill &&
			p->mExData1 == skillIdx &&
			p->mTarget.index == pTarget->GetObjectID() )
			return false;
	}

	/// ų ߵ
	ChargeOn( skillIdx );
	HERO->AfterUseSkill( pTarget );

	if( pTarget )
		mAttackTarget = *(pTarget->GetTargetInfo());

	return true;
}

bool cSkillExecuter::ExecuteSkill_TransMon( unsigned long skillIdx, NiPoint3 applyPos )
{
	HERO->SetWaitMoveFlag( false );

	ChargeOff( mChargeSkillIdx );

	if( HERO->GetState() == eOBJECT_STATE_DIE )
		return false;

	/// κ ⱳüϷ ޼ ޱ ų  Ұ
	if( HERO->IsWeaponChanging() == true )
		return false;

	unsigned long monsterClassIdx = HERO->GetTransMonsterClassIdx();
	if( monsterClassIdx == 0 )
		return false;

	sMonsterSkillScript* pInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)skillIdx );
	if( pInfo == 0 )
		return false;

	///    üũ
	if( IsPossibleUseSkill( skillIdx ) == false )
		return false;

	if( pInfo->mBoundType != eBOUNDTYPE_FIELD )
		return false;

	sAfterAction* p = HERO->GetCurrentAfterAction();
	if( p->mActionType == eAfterAction_UseFieldSkill &&
		p->mExData1 == skillIdx )
		return false;

	ChargeOn( skillIdx );
	HERO->AfterUseSkill( applyPos );

	return true;
}

void cSkillExecuter::FieldSkillOn( unsigned long skillIdx )
{
	if( HERO->IsTransformMonster() == true )
		return;

	if( IsPossibleUseSkill( skillIdx ) == false )
		return;

	sPlayerSkillBaseInfo* pInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}
	if( SKILLMAN->IsUsedKeepSkill( skillIdx ) == false )
		return;

	sKeepSkill* keep =  SKILLMAN->GetKeepInfo( skillIdx );
	if( keep == 0 )
		return;
	if( pInfo->mStepCount <= keep->mStep )
	{
		assert(0);
		return;
	}

	sPlayerSkillStepInfo* pStepInfo = &pInfo->mpSetpInfoArray[keep->mStep];

	if( pInfo->mType == eSKILLTYPE_TOTEM )
	{
		sTotemScript* totemInfo = TOTEMSCRIPT->GetTotemInfo( pStepInfo->mInfulenceIdx );
		if( totemInfo == 0 )
		{
			assert(0);
			HERO->SetFieldEffRadius( (float)pStepInfo->mBoundDist );
		}
		else
		{
			HERO->SetFieldEffRadius( (float)totemInfo->mApplyRange );
		}
	}
	else
		HERO->SetFieldEffRadius( (float)pStepInfo->mBoundDist );

	mIsFieldCheck = true;
	ChargeOn( skillIdx );

	::SetCursor(NULL);
}

void cSkillExecuter::FieldSkillOn_TransMon( unsigned long monsterClassIdx, unsigned long skillIdx )
{
	if( HERO->IsTransformMonster() == false )
		return;

	if( IsPossibleUseSkill( skillIdx ) == false )
		return;

	sMonsterSkillScript* pInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, (eMONSTERATTACK_TYPE)skillIdx );
	if( pInfo == 0 )
		return;

	HERO->SetFieldEffRadius( (float)pInfo->mBoundDist );

	mIsFieldCheck = true;
	ChargeOn( skillIdx );
}
