/* =====================================================================
*      :	SkillExecuter.h , SkillExecuter.cpp
*      :	ų  ° ϵ Ѵ.
*    :	
*    :    2007 3 26
*
* ߰ :
*		߰¥    ۾	  ߰
* 
* ǻ : Ű  쳪 콺 Ŭ, Ŭ Ǿ 쿡 ȴ.
*			 ũũ ޽ , ó   ۿ  ʴ´.
*		 	 ų 뿡    üũ,  üũ  ̷.
* =======================================================================*/

#pragma once
#include "BaseObject_Common.h"
#include "skill_common.h"

struct sTransMonSkillInfo
{
	unsigned int mUsePer;
	float mRange;
};

class cSkillObject;

class cAttackPattern
{
public:
	cAttackPattern()
	{
		::memset( mPattern, -1, sizeof(int)*3*6 );

		///  
		mPattern[0][0] = 0;mPattern[0][1] = 1;mPattern[0][2] = 2;mPattern[0][3] = 0;mPattern[0][4] = 2;mPattern[0][5] = 1;
		mPattern[1][0] = 1;mPattern[1][1] = 0;mPattern[1][2] = 2;mPattern[1][3] = 1;mPattern[1][4] = 2;mPattern[1][5] = 0;
		mPattern[2][0] = 2;mPattern[2][1] = 1;mPattern[2][2] = 0;mPattern[2][3] = 1;mPattern[1][4] = 0;mPattern[1][5] = 2;

		mPatternIdx = 0;
		mProgressIdx = 0;
		mOldAttackIdx = -1;
	}
	~cAttackPattern() {}

	unsigned int GetAttackFlag();
	void ResetPatternIdx() { mPatternIdx = -1; }

protected:

	int	mPattern[3][6];

	///  ȣ
	int	mPatternIdx;
	int mOldAttackIdx;

	///  ܰ
	unsigned int	mProgressIdx;
};


class cSkillExecuter
{
public:
	static cSkillExecuter* mpExec;
public:
	cSkillExecuter();
	~cSkillExecuter();

	void Close();

	bool AutoAttack( cBaseObject* pTarget );

	/// ⺻  ߵ
	bool ExecuteAttack( cBaseObject* pTarget );

	/// ų ߵ
	void ExecuteSkill( unsigned long skillIdx, cBaseObject* pTarget = 0 );

	/// 
	void ExecuteSkill( unsigned long skillIdx, NiPoint3 fieldPos );

	void ResetAttackFlag() { mAttackPattern.ResetPatternIdx(); }

	///  
	void ChargeOff( unsigned long skillIdx );

	unsigned long	GetChargeSkill();
	float 			GetChargeSkillRange() { return mSkillRange; }

	bool IsSkillCharge();
	bool IsFieldSkillCharge() { return mIsFieldCheck; }

	bool IsPossibleUseSkill( unsigned long skillIdx );
	bool IsPossibleUseSkillTarget( unsigned long skillIdx, cBaseObject* pTarget );

	void ReCharge() { ChargeOn( NORMAL_ATTACK_SKILL ); }

	///   ų ¸ ϱ  ̽
	inline cSkillObject* GetCurrentHeroSkillObject() { return mpCurrentHeroSkillObject; }
	inline void SetCurrentHeroSkillObject( cSkillObject* p ) { mpCurrentHeroSkillObject = p; }

	void SetMonsterSkillInfo( unsigned long monsterClassIdx );

protected:

	/// ų 
	void ChargeOn( unsigned long skillIdx );
	void FieldSkillOn( unsigned long skillIdx );

	///
	unsigned long GenerateTransMonsAttackIdx();
	void ChargeOn_TransMon( unsigned long skillIdx );
	void ChargeOff_TransMon( unsigned long skillIdx );

	bool IsPossibleUseSkill_TransMon( unsigned long skillIdx );
	bool IsPossibleUseSkillTarget_TransMon( unsigned long skillIdx, cBaseObject* pTarget );

	bool AutoAttack_TransMon( unsigned long skillIdx,cBaseObject* pTarget );
	bool ExecuteAttack_TransMon( unsigned long skillIdx, cBaseObject* pTarget );
	bool ExecuteSkill_TransMon( unsigned long skillIdx, cBaseObject* pTarget );
	bool ExecuteSkill_TransMon( unsigned long skillIdx, NiPoint3 applyPos );

	void FieldSkillOn_TransMon( unsigned long monsterClassIdx, unsigned long skillIdx );

protected:

	///   ų ü
	cSkillObject*	mpCurrentHeroSkillObject;

	/// ٴ   ų  
	bool			mIsFieldCheck;

	bool			mIsCharge;

	unsigned long	mChargeSkillIdx;
	float			mSkillRange;

	///  ݴ  Ÿٰ 񱳸  
	sObject			mAttackTarget;

	/// ⺻  
	cAttackPattern	mAttackPattern;

	sTransMonSkillInfo mMonsterAttackInfo[eMONSTERATTACK_MAX];
	unsigned long mTotalMonsterAttackPer;
};

#define SKILLEXECUTER cSkillExecuter::mpExec