/* ======================================================================================
*      :	SkillManager.h , SkillManager.cpp
*      :	ų 
*    :	̹
*    :    2007 07 06
*
* ߰ :
*		߰¥    ۾	  ߰
* 
* ǻ : skillobject dummy  -> server   -> managed 
			 influenceobject    θ ȴ.
* ======================================================================================*/
#pragma once
#include "IndexGenerator.h"
#include "SkillObject.h"

class cSkillExecuter;
class cDamagePrintManager;

struct sHaveSkill;
struct sKeepSkill
{
	unsigned char	mStep;
	unsigned long	mCastingTime;

	unsigned long	mRestTime;

	/// ų ũƮ  Ѵð
	unsigned long	mTotalTime;

	/// 
	unsigned long	mStartTime;
};

class cSkillManager
{
public:
	static cSkillManager* mpSkillManager;

public:
	cSkillManager();
	~cSkillManager();

	bool				Init();

	void				Open();
	void				Close();

	void				Process( unsigned long deltaTime, unsigned long accumTime );

	/// Է ó
	bool				ProcessLButtonClick( int mouseX, int mouseY );
	bool				ProcessLButtonDClick( int mouseX, int mouseY );

	cSkillObject*		AllocSkillObject();
	void				FreeSkillObject( cSkillObject* ptr );

	cInfluenceObject*	AllocInfluenceObject();
	void				FreeInfluenceObject(cInfluenceObject* ptr);

	cApplyObject*		AllocApplyObject();
	void				FreeApplyObject(cApplyObject* ptr);

	unsigned long		CreateHeroSkillObject( unsigned long skillIdx, cBaseObject* pUser, cBaseObject* pTarget, float speedFactor = 1.0f );
	unsigned long		CreateHeroSkillObject( unsigned long skillIdx, cBaseObject* pUser, NiPoint3 fieldPos, float speedFactor = 1.0f );
	unsigned long		CreateHeroMapChangeSkillObject( unsigned long skillIdx, cBaseObject* pUser );
	unsigned long		CreateHeroVehicleSkillObject( unsigned long skillIdx, cBaseObject* pUser );

	void				CreateSkillObject( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pUser, cBaseObject* pTarget, float speedFactor = 1.0f );
	void				CreateSkillObject( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pUser, NiPoint3 fieldPos, float speedFactor = 1.0f );
	void				CreateMapChangeSkillObject( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pUser );
	void				CreateVehicleSkillObject( unsigned long uIdx, unsigned long skillIdx, cBaseObject* pUser );


	cSkillObject* 		CreateRevisionSkillObject( unsigned long uIdx, unsigned long skillIdx, unsigned char attackerType, unsigned long dramaKey, bool tranMon );

	void				DeleteSkillObject( cSkillObject* p );

	cInfluenceObject*	CreateInfluenceObject( unsigned long uIdx, unsigned long infIdx, unsigned long skillIdx, cBaseObject* pTarget, bool dieDelete );

	void				DeleteInfluenceObject( cInfluenceObject* p );
	void				DeleteInfluenceObject( unsigned long uniqueIdx );
	void				UpdateInfluenceObject();
	void				DamageInfluenceObject();

	cInfluenceObject*	GetInfluenceObject( unsigned long uniqueIdx );

	cApplyObject*		CreateApplyObject( cBaseObject* pUser, cBaseObject* pTarget, unsigned char weaponType, eAPPLYDRAMA_TYPE type );
	cApplyObject*		CreateApplyObject( cBaseObject* pTarget, unsigned long influenceIdx );
	void				DeleteApplyObject( cApplyObject* p );

	/// Hero  ų 
	void InitKeepSkill( sHaveSkill* pdata );
	void AddKeepSkill( unsigned long skillIdx, unsigned char skillStep );
	void ClearAllKeepSkill();
	void UpdateAllSkill();

	bool IsUsedKeepSkill( unsigned long skillIdx );
	bool IsUsedMonsterSkill( unsigned long skillIdx );

	void StartCoolTime( unsigned long skillIdx, unsigned long restTime = ULONG_MAX, float speedFactor = 1.0f );
	void StartCoolTime_Mon( unsigned long skillIdx, unsigned long restTime = ULONG_MAX, float speedFactor = 1.0f );

	///   ų üũѴ.
	bool CheckBuySkill( unsigned long skillIdx, unsigned char skillStep );

	sKeepSkill*		GetKeepInfo( unsigned long skillIdx );

	void UpdateSkillStep( unsigned long idx, unsigned char step );

	///	network msg parser
	void NetworkMsgParser( char* pMsg );

	/// 071024 PKH ͽ ⿡ 
	tPointerHashMap<unsigned long, void*>* GetInfluenceMap()	{ return &mInfluenceMap; }
	tPointerHashMap<unsigned long, void*>* GetKeepSkillMap()	{ return &mKeepSkillMap; }

	unsigned long GetDummySkillCount() { return mDummySkillMap.GetSize(); }
	unsigned long GetSkillCount() { return mSkillObjectMap.GetSize(); }
	unsigned long GetInfluenceCount() { return mInfluenceMap.GetSize(); }
	unsigned long GetApplyCount() { return mApplyObjectMap.GetSize(); }


protected:
	void DeleteProcess();

	void UpdateExtraCooltime( unsigned long skillIdx, unsigned long restTime, unsigned long groupIdx );

protected:
	/// memory
	tPool<cSkillObject>			mSkillObjectPool;
	tPool<cInfluenceObject>		mInfluenceObjectPool;
	tPool<cApplyObject>			mApplyObjectPool;

	//////////////////////////////////////////////////////////////////////////
	// skill process
	typedef tPointerHashMap<unsigned long, void*> cSkillObjectMap;
	typedef tArray<void*>	cDeleteArray;

	///    ޱ  ó ü (HERO)
	cSkillObjectMap					mDummySkillMap;
	cIndexGenerator<unsigned long>	mDummyIndexGen;
	cIndexGenerator<unsigned long>	mApplyIndexGen;

	///  ü key = server create index
	cSkillObjectMap					mSkillObjectMap;
	cSkillObjectMap					mInfluenceMap;
	cSkillObjectMap					mApplyObjectMap;

	///  ü
	cDeleteArray					mDeleteSkillArray;
	cDeleteArray					mDeleteInfluenceArray;
	cDeleteArray					mDeleteApplyObjectArray;
	//////////////////////////////////////////////////////////////////////////

	typedef cSkillObjectMap	cSkillMap;
	cSkillMap						mKeepSkillMap;

	/// ų 
	cSkillExecuter*	mpSkillExecuter;

	///  
	cDamagePrintManager* mpDamagePrintManager;

};

#define SKILLMAN	cSkillManager::mpSkillManager

inline cSkillObject* cSkillManager::AllocSkillObject()
{
	return mSkillObjectPool.Alloc();
}

inline void cSkillManager::FreeSkillObject(cSkillObject* ptr)
{
	mSkillObjectPool.Free(ptr);
}

inline cInfluenceObject*	cSkillManager::AllocInfluenceObject()
{
	return mInfluenceObjectPool.Alloc();
}

inline void	cSkillManager::FreeInfluenceObject(cInfluenceObject* ptr)
{
	mInfluenceObjectPool.Free(ptr);
}

inline cApplyObject* cSkillManager::AllocApplyObject()
{
	return mApplyObjectPool.Alloc();
}

inline void cSkillManager::FreeApplyObject(cApplyObject* ptr)
{
	mApplyObjectPool.Free(ptr);
}

inline void cSkillManager::DeleteSkillObject( cSkillObject* p )
{
	if( p )
	{
		if( p->IsRemoved() == false )
		{
			p->Removed();
			mDeleteSkillArray.PushBack( p );
		}
	}
}

inline void cSkillManager::DeleteApplyObject( cApplyObject* p )
{
	if( p )
	{
		if( p->IsRemoved() == false )
		{
			p->Removed();
			mDeleteApplyObjectArray.PushBack( p );
		}
	}
}


inline sKeepSkill* cSkillManager::GetKeepInfo( unsigned long skillIdx )
{
	return (sKeepSkill*)mKeepSkillMap.GetAt( skillIdx );
}

inline cInfluenceObject* cSkillManager::GetInfluenceObject( unsigned long uniqueIdx )
{
	return (cInfluenceObject*) mInfluenceMap.GetAt( uniqueIdx );
}
