/* =====================================================================
*      :	SkillObject.h , SkillObject.cpp
*      :	 ų ü ,  ޾ Ѵ.
*    :	̹
*    :    2007 7 13
*
* ߰ :
*		߰¥    ۾	  ߰
* 
* ǻ :	.
* =======================================================================*/
#pragma once
#include "BaseObject_Common.h"
#include "DramaturgyInfo.h"
#include "Skill_Common.h"

struct sTargetDamage;
struct sTargetHeal;

enum eAPPLYDRAMA_TYPE;

class cEffectSceneNode;
class cSoundSceneNode;
struct sTrailInfo;

class cBaseObject;
class cBulletObj;

struct sApplyDrama
{
	sObject mTargetObj;
	cDramaturgyInfo* mpInfo;
};

struct sLoopEffect
{
	unsigned long mIdxByManager;
	cEffectSceneNode* mEffectNode;

	sLoopEffect()
	{
		mIdxByManager = (unsigned long)-1;
		mEffectNode = 0;
	}
};

struct sLoopSound
{
	unsigned long mIdxByManager;
	cSoundSceneNode* mSoundNode;

	sLoopSound()
	{
		mIdxByManager = (unsigned long)-1;
		mSoundNode = 0;
	}
};

///
class cDramaturgyObject 
{
public:
	virtual ~cDramaturgyObject();

	virtual void Process( unsigned long time ) = 0;

	/// TODO:
	/// 󿡰 ü ũ ϸ鼭
	///  ϴ ƾ ־ Ѵ.
	/// Thread ɸ鼭 ߰ ó Ѵ.

	/// TODO : 
	///    Լ
	inline eDRAMASTATE GetDramaState() { return mCurrentState; }
	inline void SetDramaState( eDRAMASTATE state ) { mCurrentState = state; }

	inline unsigned long	GetManagedKey() { return mManagedKey; }
	inline unsigned long	GetSkillIdx() { return mSkillIdx; }

	void	Removed() { mRemoved = true; }
	bool	IsRemoved() { return mRemoved; }

protected:
	virtual void UpdateDramaObject( sDramaActionBase* pBase, cBaseObject* pChar, const NiPoint3& dir = -NiPoint3::UNIT_Y );
	virtual void UpdateTrailObject( sDramaActionBase* pBase, cBaseObject* pChar );
	virtual void AddLoopEffect( cEffectSceneNode* pNode );
	virtual void AddLoopSound( cSoundSceneNode* pNode );
	virtual void AddLoopTrail( sTrailInfo* pInfo );

	void ChangeDramaState( eDRAMASTATE state );

protected:
	cDramaturgyObject();

	///    ü
	struct sDramaStateController
	{
		sDramaStateController()
			: pAct(0), startTime(ULONG_MAX)
		{
			animationIdx = UINT_MAX;
		}
		sDramaActionBase*	pAct;
		unsigned int		animationIdx;


		unsigned long	startTime;

		tPointerList<void*>	mLoopEffect;
		tPointerList<void*>	mLoopSound;
		tPointerList<void*>	mLoopTrail;
	};

	/// ü ҿ   
	unsigned long			mManagedKey;

	/// ų 
	unsigned long			mSkillIdx;

	///  
	eDRAMASTATE				mCurrentState;
	cDramaturgyInfo*		mpDramaInfo;

	/// Ÿ 
	sObject					mTargetObj;

	///   
	sDramaStateController	mApplyController;

	bool			mRemoved;

};

//////////////////////////////////////////////////////////////////////////
enum eSPECIAL
{
	eSpecial_None = 0,
	eSpecial_Field,

	eSpecial_MapChange,
	eSpecial_Vehicle,
};

///
class cSkillObject : public cDramaturgyObject
{
public:
	cSkillObject();
	virtual ~cSkillObject();

	void*			operator new( size_t n ); 
	void			operator delete( void* ptr );

	enum eVERIFY
	{
		eVerify_Faile = 0,
		eVerify_Wait,
		eVerify_Success,
	};

	virtual bool Init( unsigned long skillIdx, cBaseObject* pUser, cBaseObject* pTarget, float speedFactor );
	virtual bool InitField( unsigned long skillIdx, cBaseObject* pUser, NiPoint3 fieldPos, float speedFactor );
	virtual bool InitMapChange( unsigned long skillIdx, cBaseObject* pUser );
	virtual bool InitVehicle( unsigned long skillIdx, cBaseObject* pUser );
	virtual bool RevisionInit( unsigned long skillIdx, unsigned char userType, unsigned long dramaKey, bool transMon );

	virtual void Process( unsigned long time );

	void			SetManagedKey( unsigned long key, bool isDummy ) { mManagedKey = key; mIsDummy = isDummy; }
	bool			IsDummySkill() { return mIsDummy; }

	void			VerifyFaile( bool setIdle = false );
	void			VerifySuccess();

	void			WaitCancel();

	unsigned int	GetSpecialType() { return mSpecialType; }

	///
	void			AddDamageTargetInfo( sTargetDamage* dInfo );
	void			AddHealTargetInfo( sTargetHeal* dInfo );
	void			AddTargetInfo( sObject* dInfo );

	void			EndCast();

	cBaseObject* GetUser();

protected:
	/// ĳ ó
	void			ProcessCasting( unsigned long time );
	/// ߵ ó
	void			ProcessActivity( unsigned long time );
	///  ó
	void			ProcessApply( unsigned long time );

	void			ApplyDamage( const sDramaActionBase* pAct );
	void			ApplyHeal( const sDramaActionBase* pAct );

	virtual void	AddLoopEffect( cEffectSceneNode* pNode );
	virtual void	AddLoopSound( cSoundSceneNode* pNode );
	virtual void	AddLoopTrail( sTrailInfo* pInfo );

	void FadeOutAllLoopEffect();
	void FadeOutAllSoundEffect();
	void RemoveAllTrail();

	void			ChangeDramaState( eDRAMASTATE state );

	/// ߻ü
	void AddBulletObject( sDramaActionBase* pBase );

	void BulletProcess( unsigned long time );

protected:
	struct sDamageInfo
	{
		tArray<void*> damageArr;
		sObject obj;

		unsigned int viewCnt;

		sDamageInfo() : viewCnt(0) {}

		~sDamageInfo()
		{
			if( damageArr.IsEmpty() == false )
			{
				for( unsigned int i = 0, end = damageArr.GetSize(); i < end; ++i )
				{
					delete (sTargetDamageDetail*)damageArr[i];
				}
				damageArr.Clear();
			}
		}
	};

	enum
	{
		ePRINT_NONE =0,
		ePRINT_DAMAGE,
		ePRINT_HEAL,
	};

	///  
	bool					mIsDummy;

	eVERIFY					mVerifyState;

	/// ĳ  
	sDramaStateController	mCastingController;

	/// ߵ  
	sDramaStateController	mActivityController;

	///  
	sObject					mUserObj;
	unsigned char			mUserWeapon;

	bool					mTransformMonSkill;

	/// damage  Ÿ
	unsigned char			mPrintType;
	tArray<void*>			mTargetObjArray;

	/// ߻ü 
	tPointerList<void*>		mBulletList;
	tArray<void*>			mDelBulletArray;

	/// Apply Drama 
	tPointerList<void*>		mApplyDramaList;

	///  speed 
	float	mSpeedFactor;

	unsigned long mCastingTime;

	bool	mUsedAnimation;

	eSPECIAL	mSpecialType;
	NiPoint3 mFieldPos;

//	bool	mUseFieldTarget;
};
//////////////////////////////////////////////////////////////////////////

///
class cInfluenceObject : public cDramaturgyObject
{
public:
	cInfluenceObject();
	virtual ~cInfluenceObject();

	void*			operator new( size_t n ); 
	void			operator delete( void* ptr );

	virtual bool Init( unsigned long uniqueIdx, unsigned long influenceIdx, unsigned long skillIdx, bool isbuff, cBaseObject* pTarget, bool dieDelete );

	void  Init_TargetUpdate();

	/// 뿡  ó 
	virtual void Process( unsigned long time );

	///  processϴ Ÿ̹ 
	void StartProcess( long restTime = -1, bool onlyLoopEffect = false );

	enum
	{
		eTick_HP,
		eTick_MP,
	};

	void SetTickInfo( unsigned char tickType, long value );

	inline unsigned long GetRestTime() { return mRestTime; }

	inline unsigned long	GetInfluenceIdx() { return mInfluenceIdx; }

	/// hero ȿ  ó ؼ
	inline bool IsHeroInfluence() { return mIsHeroInfluce; }
	inline bool IsAuraType() { return mInfluenceType == eINFLUENCETYPEDETAIL_AURA; }
	inline bool IsStatic() { return mStaticInfluence; }

	/// Ÿ  ȿ  
	bool DieDelete()	{ return mDieDelete; }

protected:
	void ApplyHP( sDramaActionBase* pAct );
	void ApplyMP( sDramaActionBase* pAct );

protected:
	bool			mIsBuff;

	/// 081014 PKH ĳ   ȿ  
	bool			mDieDelete;

	bool			mCheckBlink;
	bool			mIsHeroInfluce;
	bool			mOnlyShowLoopEffect;
	unsigned long	mBlinkTime;

	unsigned long	mStartTime;
	unsigned long	mLifeTime;

	unsigned long	mRestTime;

	bool			mStartTimeCheck;

	unsigned long	mInfluenceIdx;
	bool			mStaticInfluence;
	unsigned long	mInfluenceType;

	/// tickȿ  Ѵ.
	bool			mTickInit; /// ʿ⿡ ܽŰ..
	bool			mTickInfluence;
	unsigned char	mTickType;
	float			mTickValue;
};

class cApplyObject : public cDramaturgyObject
{
public:
	cApplyObject();
	virtual ~cApplyObject();

	void*			operator new( size_t n ); 
	void			operator delete( void* ptr );

	/// apply drama  ȹѴ.
	virtual bool Init( unsigned long managedKey, sObject* user, sObject* target, unsigned char weaponType, eAPPLYDRAMA_TYPE type );

	/// ȿȣ Apply ´.(item ȿ  )
	virtual bool Init( unsigned long managedKey, cBaseObject* pTarget, unsigned long influenceIdx );

	virtual void Process( unsigned long time );

private:

	enum
	{
		eINDEX_DRAMA,
		eINDEX_INFLUENCE,
	};

	sObject				mUserObj;
	unsigned char		mUserWeapon;

	/// drama or influence
	unsigned char		mIndexType;
	///
	unsigned long		mApplyIndex;

//	eAPPLYDRAMA_TYPE	mApplyType;
//	unsigned long		mInfluenceIdx;
};