#pragma once
#include "uiwindow.h"
#include "Icon.h"

class cSkillTree;
class cSkillIcon;

class cSkillSheetWindow : public cUIWindow
{
public:
	cSkillSheetWindow( eUINodeType type = eUINODE_TABSHEET );
	virtual ~cSkillSheetWindow();

	void Clear();

	void InitSkillSheetInfo( unsigned long jobIdx, cSkillTree* pTree );
	
	cSkillIcon* GetSkillIcon( unsigned long idx );
	unsigned long GetJobIdx() { return mJobIdx; }

	void DisableAllIcon();

	void UpdateTree();

protected:
	void OnIconDragged( cUINode* pcaller, unsigned int id, const cUIPos& pos, bool shift );
	void OnIconDoubleClicked( cUINode* pcaller, unsigned int id );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool /*shiftPress*/ );
	void UpdateSkin();

protected:
	typedef tPointerHashMap<unsigned long, void*> cSkillIconList;
	cSkillIconList mManagedIcon;

	NiTexture*			mBackTex;

	unsigned long		mJobIdx;

	cSkillTree*			mpTreeInfo;
};

inline cSkillIcon* cSkillSheetWindow::GetSkillIcon( unsigned long idx )
{
	return (cSkillIcon*)mManagedIcon.GetAt( idx );
}


/////// Ȱų Ʈ
class cCommuSheetWindow : public cUIWindow
{
public:
	cCommuSheetWindow( eUINodeType type = eUINODE_TABSHEET );
	virtual ~cCommuSheetWindow();

	/// Ŀ´Ƽ ų ߵ û
	void RequestCommuSkill( unsigned long skillIndex );

	void RequestLifeCommand( unsigned long comIdx, LPCTSTR value1, LPCSTR value2 );

protected:
	bool OnCreate( cUINodeProperty* property );
	void OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift );
	void OnIconDoubleClicked( cUINode* caller, unsigned int id );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool /*shiftPress*/ );
	void UpdateSkin();

protected:
	typedef tPointerHashMap<unsigned long, void*> cCommuIconList;
	cCommuIconList mManagedIcon;
};