/* ==========================================================================
*      : SkillStoreWindow.h
*      : 
*    : ̹
*    : 2007-10-31
* ǻ :
*===========================================================================*/
#pragma once

#include "uiwindow.h"
#include "RadioButton.h"
#include "UIImage.h"

class cListBox;
class cLabel;
class cSkillStoreWindow : public cUIWindow
{
public:
	cSkillStoreWindow();
	virtual ~cSkillStoreWindow();

	virtual void UpdateSkin();

	void Show( unsigned long npcIndex );
	void SetMoney( unsigned int money );
	void UpdateSkillPoint();

	///    
	inline void UpdatePage() { ChangePage( mCurPageIdx, true ); }

	struct sSkillRowData
	{
		unsigned long	mSkillIdx;		/// skill Idx
		cUIImage		mImage;			/// skill icon image

		LPCTSTR			mName;			/// skill name
		unsigned char	mTrainStep;		///  ܰ
		unsigned long	mMoney;			/// Ҹ ݾ
		unsigned long	mSp;			/// Ҹ sp
		unsigned long	mMaxstep;		/// max step
		bool			mMaster;
	};

protected:
	virtual void OnMouseLeft( const cUIPos& pos );

	bool OnCreate( cUINodeProperty* pproperty );
	void OnRadioPressed( cUINode* pcaller, unsigned int id );
	void OnProcess(unsigned long deltaTime, unsigned long accumTime);
	void OnHide();

	void OnCommand( cUINode* pcaller, unsigned int id );
	void OnListBoxSelected( cUINode* caller, unsigned int id );
	void OnListBoxRowHovered( cUINode* caller, unsigned int id, const cUIPos& pos, void* extraData );
	void OnListBoxImageHorvered( cUINode* caller, unsigned int id, const cUIPos& pos, void* extraData );
	void OnListBoxImageLeft( cUINode* caller, unsigned int id );

	void InitPageData( unsigned int pageIdx, unsigned long jobIdx );
	void ExitPageData();

	void ChangePage( unsigned int pageIdx, bool useCurSel = false );

	void CheckBuyListColor();

	struct sPageData
	{
		cRadioButton			mRadio;
		tPointerArray<void*>	mRowArray;
		~sPageData()
		{
			if( mRowArray.IsEmpty() == false )
			{
				for( unsigned int i=0; i<mRowArray.GetSize(); i++ )
				{
					sSkillRowData* p = (sSkillRowData*)mRowArray[i];
					delete p;
				}
				mRowArray.Clear();
			}
		}
	};

private:
	cListBox*				mpGoodList;

	unsigned int			mCurPageIdx;
	tPointerArray<void*>	mPageArray;

	/// 
	cLabel*		mpMoney;

	/// ų Ʈ
	cLabel*		mpSkillPoint;

	bool		mCheckBuySkillList;
};



