/* ==========================================================================
*      : SkillTipWindow.h
*      : 
*    : 谡
*    : 2007-09-06
* ǻ :
*===========================================================================*/
#pragma once
#include "TipWindow.h"

const int MAX_RIGHT_TIP = 20;

struct sPlayerSkillBaseInfo;
struct sPlayerSkillStepInfo;

/// ۿ  
class cSkillTipWindow : public cTipWindow
{
public:
	cSkillTipWindow();
	virtual ~cSkillTipWindow();

	///
	bool SetSkill( eTip_Kind tipkind, const cUIPos& pos, unsigned long skillIndex, char skillStep, bool store );

protected:
	void OnRender( cUIFontItemKeeper* fontKeeper );
	void Clear();
	void OnTimer();
	void OnHide();

	void CalcRightMaxWidth( const cStringT& str );

	////
	bool SetNormalTip( unsigned long skillIdx, char skillStep, bool store = true );
	bool SetQuickTip( unsigned long skillIdx, char skillStep );

	///
	void SetName( sPlayerSkillBaseInfo* pInfo, unsigned long color );
	void SetShotType( sPlayerSkillBaseInfo* pInfo, unsigned long color );
	void SetEquip( sPlayerSkillBaseInfo* pInfo, unsigned long color );
	void SetCastingTime( sPlayerSkillBaseInfo* pInfo, sPlayerSkillStepInfo* pStepInfo, unsigned long color );
	void SetCoolTime( sPlayerSkillStepInfo* pStepInfo, unsigned long color, unsigned long skillIdx );
	void SetUsedValue( sPlayerSkillBaseInfo* pInfo, sPlayerSkillStepInfo* pStepInfo, unsigned long color );
	void SetInfluence( unsigned long influenceIdx );

	/// 
	void SetRightAttribute( sPlayerSkillBaseInfo* pInfo, unsigned long color ); 
	void SetRightStepInfo( sPlayerSkillBaseInfo* pInfo, unsigned int curStep, unsigned long color ); 
	void SetRightTargetDist( sPlayerSkillBaseInfo* pInfo, sPlayerSkillStepInfo* pStepInfo, unsigned long color, unsigned long skillIdx ); 
	void SetRightBound( sPlayerSkillStepInfo* pStepInfo, unsigned long color ); 

	void AddRightGap( unsigned int count );

private:
	///  ķ پִ ߰  
	cTipParam	mRightTip[MAX_RIGHT_TIP];

	unsigned int mRightMaxWidth;
	unsigned int mRightIndex;

	///  ó   ƾ ǥϱ  ÷
	unsigned int mBottomIndex;
	unsigned int mBottomRightIndex;

	cTipParam		mRequireValue[MAX_RIGHT_TIP][4];
	unsigned int	mRequireIndex;

	/// ð, ð  
	unsigned int mTimeTipIdx;
	cStringT	mSaveCoolTime;
	unsigned long mSaveSkillIndex;
};
