/* ==========================================================================
*      : SmallMiniMapWindow.h
*      : 
*    : 谡
*    : 2007-05-21
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

/// ̴쿡  ̹ ۵Ǿϴ ǥ &  ̹   
const int MAP_X = 10;
const int MAP_Y = 34;
const int MAP_W = 150;
const int MAP_H = 150;

const float MAX_PERCENT = 50.f;
const float MIN_PERCENT = 20.f;		
const float ADD_PERCENT = 20.f;		/// ߰ ҵǴ 

const int NPCICON_SIZE = 16;		/// 
const int MAINTAIN_TIME = 60000;

struct sNpcData;
struct sAniParam;
class cUITransformImage;
class cPartyData;
class cIconParam;
class cLabel;


enum 
{
	eTYPE_NONE = 0,
	eTYPE_HERO,
	eTYPE_CAMERA,
	eTYPE_NPC,
	eTYPE_PORTAL,
	eTYPE_PARTY,
	eTYPE_DEATHMATCH,
	eTYPE_USERSELL,
};

struct sBaseImageData
{
	unsigned char			mType;
	cUITransformImage*		mpImage;
	cUIPos					mPos;		/// ǥ
	cUIPos					mScreenPos;	/// ũǥ
	cUISize					mSize;
	bool					mShow;
	cStringT				mName;

	sBaseImageData()
	{
		mType = eTYPE_NONE;
		mpImage = 0;
		mPos.mX = 0;
		mPos.mY = 0;
		mScreenPos.mX = 0;
		mScreenPos.mY = 0;
		mSize.mWidth = 0;
		mSize.mHeight = 0;
		mShow = true;
	}
	virtual ~sBaseImageData(){}
};

/// npc ̹ 
struct sNpcImageData : sBaseImageData
{
	unsigned long	mClassIndex;
	unsigned long	mNpcIndex;
	unsigned char	mQuestStatus;	/// Ʈ  
	sAniParam*		mAniParam;
	cUITransformImage*		mpAniImage;
	cStringT				mJobName;
	
	sNpcImageData()
	{
		mClassIndex = 0;
		mNpcIndex = 0;
		mQuestStatus = 0;
		mAniParam = 0;
		mpAniImage = 0;
	}
	~sNpcImageData(){}
};

/// Ż ̹ 
struct sPortalImageData : sBaseImageData
{
	int				mTargetMapNum;

	sPortalImageData()
	{
		mTargetMapNum = 0;
	}
	~sPortalImageData(){}
};


/// ٸ  (Ƽ, )
struct sUserImageData : sBaseImageData
{
	int				mOldX;
	int				mOldY;
	int				mMapNum;
	unsigned long	mUserIndex;
	cUINodeSkin*	mpInSkin;		/// ⺻Ų
	cUINodeSkin*	mpOutSkin;		///   ܺο  Ų(ȭǥ)
	
	sUserImageData()
	{
		mOldX = 0;
		mOldY = 0;
		mMapNum = 0;
		mpInSkin = 0;
		mpOutSkin = 0;
	}
	~sUserImageData(){}
};

/// 
struct sUserSellImageData : sUserImageData
{
	unsigned long	mStartTime;			/// ǥ ۽ð

	sUserSellImageData()
	{
		mStartTime = 0;
	}
};

class cSmallMiniMapWindow : public cUIWindow
{
public:
	cSmallMiniMapWindow();
	virtual ~cSmallMiniMapWindow();

	/// ̴ϸ ε
	void UIStageIn();
	void Clear();
	void ClearParty();

	///  ٰ º 
	virtual void SetMapData();

	/// npcindex : objectmanager  ε
	void AddNpc( sNpcData* data, bool IsSmall );
	void RemoveNpc( unsigned long index );
	void SetNpcQuestStatus( unsigned long index, unsigned char status );

	/// Ƽ 
	virtual void AddPartyUser( cPartyData* data );
	void RemovePartyUser( unsigned long userIndex );
	void SetPosParty( unsigned long userIndex, float posX, float posY );
	void SetMapNumParty( int mapnum, unsigned long userIndex );

	///   
	virtual void AddDMUser( unsigned long userIndex, cStringT name, float posX, float posY );
	void RemoveDMUser( unsigned long userIndex );
	void SetPosDMUser( unsigned long userIndex, float posX, float posY );


	///   
	void AddUserSell( cStringT name, int mapnum, float xpos, float ypos );
	void RemoveUserSell( sBaseImageData* data );

	float GetImagePercent() { return mPercent; }
	void SetImagePercent( float per );

protected:
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );	
	void OnCommand( cUINode* pnode, unsigned int id );
	void OnMouseMove( const cUIPos& pos );
	void OnMouseLeft( const cUIPos& pos );
	void UpdateRect();
	void UpdateSkin();
	void OnHide();

	/// ̴ϸ ε
	virtual bool LoadMiniMap( const cString& pathName );

	/// ̸ ġ Ʈ
	virtual void UpdateNamePos();

	virtual void AddPortal( unsigned long index );

	/// Ʈ ִϸ̼ 
	void UpdateQuestAni( sNpcImageData* data, unsigned long accumTime );

protected:
	/// ʱ ؽ  
	unsigned short mOriginTexW, mOriginTexH;

	///   ۼƮ  ؽ  
	double mPerTexW, mPerTexH;

	///  ۼƮ ( 100 %  : ü  )
	float mPercent;

	/// Ʈ  
	bool mNeedUpdate;

	/// ̸  
	cStringT mName;
	cStringT mJobName;
	cUIPos mNamePos;
	cUIPos mJobPos;

	/// ̹ ͸
	typedef tPointerList<void*> cImageDataList;
	cImageDataList	mImageDataList;

	/// ̴ϸ ̹ 
	cUITransformImage*	mpMiniMapImage;
	sBaseImageData*		mHeroData;		/// hero 
	sBaseImageData*		mCameraData;	/// ī޶ 
	sBaseImageData*		mCoverData;		/// ̴ϸ Ʋ
	sBaseImageData*		mHoverData;

	///  Ÿ	
	sUserSellImageData* mUserSellData;	

	/// 
	NiPoint3 mHeroDir;
	NiPoint3 mCameraDir;

	/// ȭ  hero ġ 
	float mOldX, mOldY;
	int mHeroX, mHeroY;

	/// Ʈ ̹ Ų
	cUINodeSkin*	mpQuestNew;
	cUINodeSkin*	mpQuestPlay;
	cUINodeSkin*	mpQuestComplete;

	cLabel*		mpMapName;
	cLabel*		mpChannelNum;

	/// Ƽ Ų̸
	cString		mPartyInSkinName;
	cString		mPartyOutSkinName;
};

