/* ==========================================================================
*    : ̼
*    : 2007.01.23
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"
#include "Sphere.h"

class cDynamicSceneNode;

///    
class cSoundSceneNodeParam : public cSceneNodeParam
{
public:
	cSoundSceneNodeParam();

public:
	/// 
	float mRadius;

	///  Ÿ
	float mAttenDistance;

	/// ݺ Ƚ
	unsigned int mLoopCount;

	///  
	float mLoopInterval;

	///   [0, 1]
	float mVolumeRatio;

	/// ResourceManager  Ǵ
	bool mManaged;

	bool mEffectSound;

	/// follow ü
	cDynamicSceneNode* mpOwnerSceneNode;
};

inline
cSoundSceneNodeParam::cSoundSceneNodeParam()
: mRadius( 1000.0f )
, mAttenDistance( 100.0f )
, mLoopCount( 0 )
, mLoopInterval( 0.0f )
, mVolumeRatio( 1.0f )
, mpOwnerSceneNode(0)
{
	mPickType = NiPick::FIND_FIRST;
	mPickSort = NiPick::NO_SORT;
	mPickIntersect = NiPick::BOUND_INTERSECT;
	mPickFrontOnly = false;

	mEffectSound = false;
}

///   
class cSoundSceneNode : public cSceneNode
{
	friend class cSceneManager;
	friend class cSoundEditor;

public:
	/// ó
	void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	void OnListenerEntered( const cSphere& sphere );

	/// ŷ
	bool Pick( const cRay& ray );

	/// ߽
	virtual const NiPoint3& GetCenter();

	/// 
	void SetRadius( float radius );
	virtual float GetRadius();

	///  Ÿ
	void SetAttenDistance( float dist );
	float GetAttenDistance() const;

	///  Լ
	inline bool IsRemoved() { return mRemoved; }

	void Remove();
	void ParentNodeRemove();

	inline void FadeOut() { mFadeOut = true; }

	void ActiveSound( bool active );

	void UpdatVolumeRatio();

	virtual inline NiNode* GetNiNode() { return 0; }
	virtual inline NiAVObject* GetNiObj() { return (NiAVObject*)mSound; }

protected:
	cSoundSceneNode( eType type = eSOUND );
	virtual ~cSoundSceneNode();

	/// ʱȭ
	virtual bool Init( const cSoundSceneNodeParam& param );

	/// ݺ Ƚ
	void SetLoopCount( unsigned int count );
	int GetLoopCount() const;

	///  
	void SetLoopInterval( float interval );
	float GetLoopInterval() const;

	/// 
	void SetVolumeRatio( float ratio );
	float GetVolumeRatio() const;

	void RemoveSelf();

protected:
	void SetRemoveFlag( bool val ) { mRemoved = val; }

protected:
	///  
	NiAudioSourcePtr mSound;

	///   
	bool mListenerEntered;
	bool mOldListenerEntered;

	/// 
	float mRadius;

	///  Ÿ
	float mAttenDistance;

	/// ݺ ȸ
	unsigned int mLoopCount;
	unsigned int mTempCount;

	///  
	float mLoopInterval;
	float mTempInterval;

	/// 
	float mVolumeRatio;
	float mGain;
	float mTargetGain;

	///  
	cSphere mListenerSphere;

	bool mRemoved;
	bool mFadeOut;

	bool mEffectSound;

//	unsigned long mOwnerSceneNodeIdx;
	cDynamicSceneNode* mpOwnerSceneNode;
};

inline
const NiPoint3& cSoundSceneNode::GetCenter()
{
	return mSound->GetWorldTranslate();
}

inline
void cSoundSceneNode::SetRadius( float radius )
{
	mNeedUpdateTransform = true;
	mRadius = radius;
}

inline
float cSoundSceneNode::GetRadius()
{
	return mRadius;
}

inline
void cSoundSceneNode::SetAttenDistance( float dist )
{
	mAttenDistance = dist;
}

inline
float cSoundSceneNode::GetAttenDistance() const
{
	return mAttenDistance;
}

inline
void cSoundSceneNode::SetLoopCount( unsigned int count )
{
	mLoopCount = count;
}

inline
int cSoundSceneNode::GetLoopCount() const
{
	return mLoopCount;
}

inline
void cSoundSceneNode::SetLoopInterval( float interval )
{
	mLoopInterval = interval;
}

inline
float cSoundSceneNode::GetLoopInterval() const
{
	return mLoopInterval;
}

inline
void cSoundSceneNode::SetVolumeRatio( float ratio )
{
	mVolumeRatio = ratio;
}

inline
float cSoundSceneNode::GetVolumeRatio() const
{
	return mVolumeRatio;
}
