#include "StdAfx.h"
#include "SpinBox.h"
#include "UIManager.h"
#include "UISkinLexer.h"
#include "Token.h"
#include "Parser.h"

#include "UIImage.h"
#include "UIContainer.h"

#include "Button.h"
#include "Label.h"

cSpinBox::cSpinBox( eUINodeType type )
: cSpinCtrl( type )
, mpLabel(0)
, mpLeftButton(0)
, mpRightButton(0)
, mRotation(true)
{	
	mSelectedIdx = 0;
}

cSpinBox::~cSpinBox()
{	
	mpLabel = 0;
	mpLeftButton = 0;
	mpRightButton = 0;

	mSelectedIdx = 0;
}

/// ǻ : 
bool cSpinBox::OnCreate( cUINodeProperty* )
{
	mpLeftButton = new cButton;
	if( mpLeftButton->CreateBySkinName( mLeftButtonSkin, this, eSPINBOX_LEFTBTN ) == false )
	{
		return false;
	}

	mpRightButton = new cButton;
	if( mpRightButton->CreateBySkinName( mRightButtonSkin, this, eSPINBOX_RIGNTBTN ) == false )
	{
		return false;
	}

	mpLabel = new cLabel;
	if( mpLabel->CreateBySkinName( mLabelSkin, this, eSPINBOX_LABEL ) == false )
	{
		return false;
	}

	if( !mpLabel || !mpLeftButton || !mpRightButton )
	{
		assert( 0 && "failed to create spinbox child" );
		return false;
	}

	/// 󺧰  ̹ ߾ ĽŲ
	mpLabel->SetAlign( this, eALIGN_CENTER );

	/// left ư ġ 
	cUIPos leftpos;
	leftpos.mX = 0;
	leftpos.mY = ( GetRelativeRect().GetHeight() - mpLeftButton->GetRelativeRect().GetHeight() ) / 2;
	mpLeftButton->SetRelativePos( leftpos );

	/// right ư ġ 
	cUIPos rightpos;
	rightpos.mX = GetRelativeRect().GetWidth() - mpRightButton->GetRelativeRect().GetWidth();
	rightpos.mY = ( GetRelativeRect().GetHeight() - mpRightButton->GetRelativeRect().GetHeight() ) / 2;
	mpRightButton->SetRelativePos( rightpos );

	return true;
}


/// ǻ : 
bool cSpinBox::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_SPINBOX ) == false )
	{
		assert( 0 && "not spinbox skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	cSpinBoxSkin* p = (cSpinBoxSkin*)pskin;
	
	/// ڽ Ų   
	mLeftButtonSkin = p->mLeftButtonSkin;
	mRightButtonSkin = p->mRightButtonSkin;
	mLabelSkin = p->mLabelSkin;

	/// ɹڽ Ÿ  
	mRotation = p->mRotation;

	cUISkin* pUISkin = UIMAN->GetSkin();
	if( !pskin )
	{
		assert(0);
		return false;
	}

	/// Ų  ȿ ˻
	if( mLeftButtonSkin && pUISkin->GetNodeSkin( mLeftButtonSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}
	if( mRightButtonSkin && pUISkin->GetNodeSkin( mRightButtonSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}
	if( mLabelSkin && pUISkin->GetNodeSkin( mLabelSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}
	return true;
}

/// ǻ : 
bool cSpinBox::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false || mVisible == false )
	{
		return mpParent->HandleEvent( event );
	}

	if( event.mType == eUIEVENT_COMMAND )
	{
		CheckButtonEvent( event.mID );

		cUIEvent ev = event;
		ev.mpCaller = (cUINode*)this;
		mpParent->HandleEvent( ev );
	}
	return true;
}

void cSpinBox::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	if( mpLeftButton )
	{
		/// left ư ġ 
		cUIPos leftpos;
		leftpos.mX = 0;
		leftpos.mY = ( GetRelativeRect().GetHeight() - mpLeftButton->GetRelativeRect().GetHeight() ) / 2;
		mpLeftButton->SetRelativePos( leftpos );
	}

	if( mpRightButton )
	{
		/// right ư ġ 
		cUIPos rightpos;
		rightpos.mX = GetRelativeRect().GetWidth() - mpRightButton->GetRelativeRect().GetWidth();
		rightpos.mY = ( GetRelativeRect().GetHeight() - mpRightButton->GetRelativeRect().GetHeight() ) / 2;
		mpRightButton->SetRelativePos( rightpos );
	}

	if( mpLabel )
	{
		mpLabel->SetAlign( this, eALIGN_CENTER );
	}
}

/// ǻ : 
void cSpinBox::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUIWindow::OnLButtonDown( pos, ctrl, alt, shift );
}

/// ǻ : 
void cSpinBox::OnLButtonUp( const cUIPos& )
{
}

/// ǻ :  ư ȴ üũ 
void cSpinBox::CheckButtonEvent( unsigned int id )
{
	cString str;

	switch( id )
	{
	case eSPINBOX_LEFTBTN:
		{
			mSelectedIdx--;

			///    ɹڽ
			if( mRotation == true )
			{
				if( mSelectedIdx < 0 )
				{
					mSelectedIdx = GetSize() - 1;
				}
			}
			/// ѓ ۿ  ɹڽ 
			else
			{
				if( mpRightButton->IsVisible() == false )
					mpRightButton->Show();

				/// ó   ư  ʴ´
				if( mSelectedIdx <= 0 )
				{
					mpLeftButton->Hide();
				}
			}
		}
		break;

	case eSPINBOX_RIGNTBTN:
		{
			mSelectedIdx++;

			if( mRotation == true )
			{
				if( mSelectedIdx > GetSize()-1 )
				{
					mSelectedIdx = 0;
				}
			}
			else
			{
				if( mpLeftButton->IsVisible() == false )
					mpLeftButton->Show();

				///   ư  ʴ´
				if( mSelectedIdx == GetSize() - 1 )
				{
					mpRightButton->Hide();
				}
			}
		}	
		break;
	}

	///  
	if( mSelectedIdx < 0 )
		mSelectedIdx = 0;

	/// 󺧰  
	UpdateLabel();
}

void cSpinBox::AddData( LPCTSTR str, void* pExData )
{
	cSpinCtrl::AddData( str, pExData );
	UpdateLabel();

	if( mRotation == false )
	{
		///  õ  Ǹ ̾,
		/// ߰Ұ ؼ rightbutton  ش.
		if( GetSize() < 2 )
		{
			mpLeftButton->Hide();
			mpRightButton->Hide();
		}
		else if( mSelectedIdx <= 0 )
		{
			mpLeftButton->Hide();
			mpRightButton->Show();
		}	
		else 
		{
			mpLeftButton->Show();
			mpRightButton->Show();
		}	
	}
	else
	{
		mpLeftButton->Show();
		mpRightButton->Show();
	}
}

void cSpinBox::Clear()
{
	cSpinCtrl::Clear();
	mSelectedIdx = 0;

	mpLeftButton->Hide();
	mpRightButton->Hide();
}

void cSpinBox::UpdateLabel()
{
	if( mpLabel )
	{
		mpLabel->SetTextColor( mDefaultColor );
		mpLabel->SetAlign( this, eALIGN_CENTER );
		mpLabel->SetText( GetLabelData(mSelectedIdx) );
	}
}

void cSpinBox::SetSelectIdx( int idx )
{
	if( idx < 0 || idx > GetSize()-1 )
		return;

	mSelectedIdx = idx;
	UpdateLabel();
}

/////////////////////////////////////////////////////////////////////////////////
cSpinBoxSkin::cSpinBoxSkin( eUINodeType type )
: cUINodeSkin( type )
, mTextAlign( eALIGN_LEFT )
, mRotation( true )
{
}

cSpinBoxSkin::~cSpinBoxSkin()
{

}

/// ǻ : ũƮ  о鿩  Ѵ
bool cSpinBoxSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	/// ״ū  ˻
	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_ROTATION:
			{
				/// Rotation    о̱ 
				lexer->GetNextToken( &token );

				if( token.mType == eTOKEN_TRUE )
				{
					mRotation = true;
				}
				else if( token.mType == eTOKEN_FALSE )
				{
					mRotation = false;
				}
				else
				{
					assert( 0 && "invalid token" );
					return false;
				}
			}
			break;
		case eTOKEN_LEFTBUTTON:
			{
				mLeftButtonSkin = parser.ParseString();
			}
			break;
		case eTOKEN_RIGHTBUTTON:
			{
				mRightButtonSkin = parser.ParseString();
			}
			break;
		case eTOKEN_LABELSKIN:
			{
				mLabelSkin = parser.ParseString();
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}
