/* ==========================================================================
*      : SpinBox.h
*      :  Ʈ 
*    : 谡
*    : 2006-11-24
* ǻ :
*===========================================================================*/
#pragma once
#include "SpinCtrl.h"
#include "UINodeData.h"

class cButton;
class cLabel;
class cSpinBox : public cSpinCtrl
{
public:
	cSpinBox( eUINodeType type = eUINODE_SPINBOX );
	virtual ~cSpinBox();
    
	virtual void AddData( LPCTSTR str, void* pExData = 0 );
	virtual void Clear();

	inline int GetSelectedIdx() { return mSelectedIdx; }
	void SetSelectIdx( int idx );

protected:
	/// ̺Ʈ ó
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	virtual void OnLButtonUp( const cUIPos& pos );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateSkin();

	/// 
	bool OnCreate( cUINodeProperty* pproperty );
	/// ư üũ 
	void CheckButtonEvent( unsigned int id );

	void UpdateLabel();

private:
	//  ư Ų  
	cString mLeftButtonSkin;
	///  ư Ų 
	cString mRightButtonSkin;
	///  Ų 
	cString mLabelSkin;

	///   ư
	cButton* mpLeftButton;
	cButton* mpRightButton;

	/// ɹڽ 
	cLabel* mpLabel;

	///  ε
	int	mSelectedIdx;

	/// ɹڽ  Ÿ ( rotation true:   / false : ѹ⸸  )
	bool mRotation;
};


//////////////////////////////////////////////////////////////////////////
class cSpinBoxSkin : public cUINodeSkin
{
public:
	cSpinBoxSkin( eUINodeType type = eUINODE_SPINBOX );
	virtual ~cSpinBoxSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ؽƮ 
	int mTextAlign;

	/// ɹڽ Ÿ
	bool mRotation;

	///  ư Ų  
	cString mLeftButtonSkin;
	///  ư Ų 
	cString mRightButtonSkin;
	///  Ų 
	cString mLabelSkin;
};

