#include "stdafx.h"
#include "StageManager.h"
#include "IntroStage.h"
#include "LoginStage.h"
#include "ServerStage.h"

#include "SelectStage.h"
#include "MakeStage.h"
#include "LoadStage.h"
#include "MapChange.h"
#include "GameStage.h"

#include "SceneManager.h"
#include "ResourceManager.h"
#include "GameResourceManager.h"
#include "WorldManager.h"
#include "ObjectManager.h"
#include "SkillManager.h"
#include "DramaturgyManager.h"
#include "ShortcutManager.h"
#include "UIManager.h"
#include "ItemManager.h"
#include "TarotManager.h"
#include "FilterManager.h"
#include "Application.h"
#include "CoolTimeManager.h"
#include "QuickManager.h"
#include "PartyManager.h"
#include "CameraManager.h"
#include "QuestManager.h"
#include "TriggerManager.h"
#include "CheatManager.h"
#include "PVPManager.h"
#include "TitleManager.h"
#include "LightAgent.h"
#include "GuildManager.h"
#include "TipManager.h"
#include "ItemMixManager.h"

#include "InputSystem.h"
#include "SoundSystem.h"

#include "uicursor.h"

#ifdef _GMTOOL
#include "GMTool.h"
#endif


cStageManager* cStageManager::mpStageManager = NULL;

cStageManager::cStageManager()
{
	mpStageManager = this;

	for( int i = 0; i < eStage_Max; ++i )
		mpStage[i] = NULL;
	mCurStage = eStage_Intro;

    mUserIdx  = 0;
	mLoginIdx = 0;
	mChannelIdx = 0;
	mCurrentMapIdx = 0;

	///
	mpUIManager = NULL;
	mpWorldManager = NULL;
	mpObjectManager = NULL;
	mpGameResourceManager = NULL;
	mpSkillManager = NULL;
	mpDramaturgyManager = NULL;
	mpShortcutManager = NULL;
	mpItemManager = NULL;
	mpTarotManager = NULL;
	mpFilterManager = NULL;
	mpCoolManager = NULL;
	mpQuickManager = NULL;
	mpPartyManager = NULL;
	mpQuestManager = NULL;
	mpTriggerManager = NULL;
	mpCheatManager = NULL;
	mpPvpManager = NULL;
	mpTitleManager = NULL;
	mpGuildManager = NULL;
	mpTipManager = NULL;
	mpItemMixManager = NULL;
	mIOCPCLient = NULL;
}

cStageManager::~cStageManager()
{
	//Exit();
}

bool cStageManager::Init( HWND hWnd, unsigned int /*screenWidth*/, unsigned int /*screenHeight*/ )
{
//	XPG_SET( "Performance Test", 10 );

	///   Ʈũ   ڵ 
	/// Ʈũ   ʱȭ

	/// 070330 Ʈũ Ŭ
	mIOCPCLient = new cIOCPClient( hWnd, WM_SOCKEVENTMSG2 );
	if ( !mIOCPCLient || !mIOCPCLient->Initialize( ) )
		return false;
//	XPG_DO( "cIOCPClient" );

	mpDramaturgyManager = new cDramaturgyManager;
	if( !mpDramaturgyManager )
	{
		SAFE_DELETE(mpDramaturgyManager);
		assert( 0 && "failed to init dramaturgy manager" );
		return false;
	}
//	XPG_DO( "cDramaturgyManager" );

	/// Ͱ   ʱȭ
	mpFilterManager = new cFilterManager;
	if( mpFilterManager == 0 || mpFilterManager->Init() == false )
	{
		return false;
	}
//	XPG_DO( "cFilterManager" );

	mpUIManager = new cUIManager;
	if( !mpUIManager || !mpUIManager->InitSkin("./Script/Interface/List_SkinImage.txt") )
	{
		return false;
	}

	///  ҽ    ʱȭ
	mpGameResourceManager = new cGameResourceManager;
	if( !mpGameResourceManager || !mpGameResourceManager->Init() )
	{
		return false;
	}

//	XPG_DO( "cGameResourceManager" );

	/// UI    ʱȭ
//	XPG_DO( "InitSkin" );

	if( mpUIManager->InitImageFont() == false )
	{
		return false;
	}
//	XPG_DO( "InitImageFont" );

//	if( mpUIManager->InitIcon() == false )
//	{
//		return false;
//	}

	if( mpUIManager->InitNpc() == false )
	{
		return false;
	}
//	XPG_DO( "InitNpc" );

	mpCoolManager = new cCoolTimeManager;
	if( mpCoolManager == 0 || mpCoolManager->Init() == false )
	{
		return false;
	}
//	XPG_DO( "cCoolTimeManager" );

	///     ʱȭ
	mpItemManager = new cItemManager;
	if( mpItemManager == 0 )
	{
		return false;
	}
//	XPG_DO( "cItemManager" );

	///     ʱȭ 
	mpQuickManager = new cQuickManager;
	if( mpQuickManager == 0 )
	{
		return false;
	}
//	XPG_DO( "cQuickManager" );

	/// Ÿ    ʱȭ 
	mpTarotManager = new cTarotManager;
	if( mpTarotManager == 0 || mpTarotManager->Init() == false )
	{
		return false;
	}
//	XPG_DO( "cTarotManager" );

	/// 070201 , Ű  
	mpShortcutManager = new cShortcutManager;
	if( !mpShortcutManager )
	{
		return false;
	}
//	XPG_DO( "cShortcutManager" );

	/// Ƽ   ʱȭ
	mpPartyManager = new cPartyManager;
	if( mpPartyManager == 0 || mpPartyManager->Init() == false )
	{
		return false;
	}
//	XPG_DO( "cPartyManager" );

	mpTriggerManager = new cTriggerManager;
	if( mpTriggerManager == 0 || mpTriggerManager->Init() == false )
	{
		return false;
	}
//	XPG_DO( "cTriggerManager" );

	mpQuestManager = new cQuestManager;
	if( mpQuestManager == 0 || mpQuestManager->Init() == false )
	{
		return false;
	}
//	XPG_DO( "cQuestManager" );

	///     ʱȭ
	mpWorldManager = new cWorldManager;
	if( !mpWorldManager )//|| !mpWorldManager->Init() )
	{
		return false;
	}
//	XPG_DO( "cWorldManager" );

	/// Ʈ    ʱȭ
	mpObjectManager = new cObjectManager;
	if( !mpObjectManager || !mpObjectManager->Init() )
	{
		return false;
	}
//	XPG_DO( "cObjectManager" );

	/// ų ڸ   ʱȭ
	mpSkillManager = new cSkillManager;
	if( !mpSkillManager || !mpSkillManager->Init() )
	{
		return false;
	}
//	XPG_DO( "cSkillManager" );

	/// ġƮ ڸ 
	mpCheatManager = new cCheatManager;

//	XPG_DO( "cCheatManager" );

	/// PVP ڸ 
	mpPvpManager = new cPVPManager;
	if( !mpPvpManager || !mpPvpManager->Init() )
	{
		return false;
	}

	/// ȣĪ  
	mpTitleManager = new cTitleManager;
	if( !mpTitleManager )
	{
		return false;
	}

	///   
	mpGuildManager = new cGuildManager;
	if( !mpGuildManager )
	{
		return false;
	}

	///   
	mpTipManager = new cTipManager;
	if( !mpTipManager || !mpTipManager->Init() )
	{
		return false;
	}

	///   
	mpItemMixManager = new cItemMixManager;
	if( !mpItemMixManager )
	{
		return false;
	}

	///   
	mCurStage = eStage_Intro;
	mpStage[eStage_Intro] = new cIntroStage;
//	XPG_DO( "cIntroStage" );

	mpStage[eStage_Login] = new cLoginStage;
//	XPG_DO( "cLoginStage" );

  	mpStage[eStage_Server] = new cServerStage;
//	XPG_DO( "cServerStage" );

	mpStage[eStage_Select] = new cSelectStage;
//	XPG_DO( "cSelectStage" );

	mpStage[eStage_Make] = new cMakeStage;
//	XPG_DO( "cMakeStage" );

	mpStage[eStage_Load] = new cLoadStage;
//	XPG_DO( "cLoadStage" );

	mpStage[eStage_MapChange] = new cMapChangeStage;
//	XPG_DO( "cMapChangeStage" );

	mpStage[eStage_Game] = new cGameStage;
//	XPG_DO( "cGameStage" );

	///  ε
	SOUNDSYS->LoadBGMList();
//	XPG_DO( "LoadBGMList" );

	///  stage ʱȭ
	for( int i = 0; i < eStage_Max; ++i )
	{
		mpStage[i]->Init( this );

//		XPG_DO( "stageInit" );
	}

	/// stage open
	mpStage[mCurStage]->InitStage();
//	XPG_DO( "cur InitStage" );


	mpStage[mCurStage]->Open();
//	XPG_DO( "cur Open" );

	return true;
}

void cStageManager::Exit()
{
	///  ...
	if( mpStage[mCurStage] )
        mpStage[mCurStage]->Close();

	for( int i = 0; i < eStage_Max; ++i )
	{
		SAFE_EXIT_DELETE( mpStage[i] );
	}

	SAFE_DELETE( mpItemMixManager );
	SAFE_DELETE( mpTipManager );
	SAFE_DELETE( mpGuildManager );
	SAFE_DELETE( mpTitleManager );
	SAFE_DELETE( mpPvpManager );
	SAFE_DELETE( mpCheatManager );
	SAFE_DELETE( mpSkillManager );	
	SAFE_EXIT_DELETE( mpObjectManager );
	SAFE_EXIT_DELETE( mpWorldManager );
	SAFE_DELETE( mpQuestManager );
	SAFE_DELETE( mpTriggerManager );
	SAFE_DELETE( mpPartyManager );
	SAFE_DELETE( mpShortcutManager );
	SAFE_DELETE( mpTarotManager );
	SAFE_DELETE( mpQuickManager );
	SAFE_DELETE( mpItemManager );
	SAFE_DELETE( mpCoolManager );
	SAFE_DELETE( mpUIManager );
	SAFE_EXIT_DELETE( mpGameResourceManager );
	SAFE_DELETE( mpFilterManager );
	SAFE_DELETE( mpDramaturgyManager );
	SAFE_DELETE( mIOCPCLient );
}

static char buffer[256] = {0,};
void cStageManager::Process( unsigned long deltaTime, unsigned long accumTime )
{
	SOUNDSYS->ProcessStageBGM( accumTime );

	/// skill
	mpSkillManager->Process( deltaTime, accumTime );

	///  ü ȯ
    mpObjectManager->Process( deltaTime, accumTime );

	if( mCurStage == eStage_Login )
		mpStage[eStage_Intro]->Process( deltaTime, accumTime );

	///
	mpStage[mCurStage]->Process( deltaTime, accumTime );

	/// Ÿ 
	mpCoolManager->Process( accumTime );

	/// Ʈ
	mpQuestManager->Process( accumTime );

	mpPvpManager->Process( deltaTime, accumTime );

	///
	mpPartyManager->Process( accumTime );

	/// ui
	mpUIManager->Process( deltaTime, accumTime );
}

void cStageManager::ProcessWorld( unsigned long deltaTime, unsigned long accumTime )
{
	/// ٴڰ ī̵  ó (   Ǿ ü Ѵ. )
	if( mCurStage == eStage_Game )
		mpWorldManager->Process( deltaTime, accumTime );
}

void cStageManager::NetworkMsgParser( unsigned long connectionindex, char* pMsg, unsigned long length )
{
	mpStage[mCurStage]->NetworkMsgParser( connectionindex, pMsg, length );
}

void cStageManager::MsgBoxEventParser( unsigned int event, unsigned int result, void* exData )
{
	mpStage[mCurStage]->MsgBoxEventParser( event, result, exData );
}

void cStageManager::ProcessKeyPressed( cKeyboardAgent* pKeyboard )
{
	assert(pKeyboard);
	if( SHORTCUTMAN->ProcessKeyPressed( pKeyboard ) == false )
	{
		mpStage[mCurStage]->ProcessKeyPressed( pKeyboard );
	}
}

void cStageManager::ProcessKeyUpDown( unsigned long time, cKeyboardAgent* pKeyboard )
{
	assert(pKeyboard);
	if( SHORTCUTMAN->ProcessKeyUpDown( pKeyboard ) == false )
	{
		mpStage[mCurStage]->ProcessKeyUpDown( time, pKeyboard );
	}
}

void cStageManager::ProcessMouseEvent( unsigned long time, cMouseAgent* pMouse )
{
	assert(pMouse);
	if( pMouse->LButtonDoubleClick() )
	{
		/// LBtnDoubleClick ̺Ʈ ó
		mpStage[mCurStage]->ProcessLButtonDClick( pMouse );
	}
	else
	{
		if( pMouse->LButtonDown() )
		{
			/// LBtnClick ̺Ʈ ó
			mpStage[mCurStage]->ProcessLButtonClick( pMouse );
		}
		else if( pMouse->RButtonUp() )
		{
			mpStage[mCurStage]->ProcessRButtonUp( pMouse );
		}
		else if( pMouse->IsDrag() )
		{
			/// mouse over  ó
			mpStage[mCurStage]->ProcessMouseover( time, pMouse );
		}
		else
		{
			mpStage[mCurStage]->ProcessMouseover( time, pMouse );
		}
	}
}

void cStageManager::ChangeStage( eSTAGE stage )
{
	if( mCurStage == stage )	return;

	///    
	ManagedBGM( mCurStage, stage );

	mpStage[mCurStage]->Close();

	/// UI  ʱȭ
	mpUIManager->Reset();

	///     Ѵ.
	INPUTSYS->InputInfoClearAll();

	if( stage != eStage_Game )
	{
		LIGHTAGENT->Close();
		SOUNDSYS->Close();
	}

	if( mCurStage == eStage_Game || stage == eStage_Load )
	{
		WORLDMAN->ClearSkyDome();
		SCENEMAN->Clear();
		RESOURCEMAN->Close();
	}

	mpStage[stage]->InitStage();
	mpStage[stage]->Open();	

	ManagedStageMap( mCurStage, stage );

	mCurStage = stage;

#ifdef _GMTOOL
	if( mCurStage == eStage_Game )
	{
		GMTOOL->SetGMToolVisible( true );
	}
	else 
		GMTOOL->SetGMToolVisible( false );
#endif


	CURSOR->SetCursor( eCURSOR_DEFAULT );
}

void cStageManager::ManagedBGM( eSTAGE curStage, eSTAGE newStage )
{
	switch( newStage )
	{
	case eStage_Login:
		{
			if( curStage != eStage_Server && curStage != eStage_Select )
			{
				///   
				SOUNDSYS->PlayBGMSound(0);
			}
		}
		break;
	case eStage_Select:
		{
			if( curStage == eStage_Game )
			{
				///   
				SOUNDSYS->PlayBGMSound(0);
			}
		}
		break;
	case eStage_Load:
	case eStage_MapChange:
	case eStage_Game:
		{
			///    
			SOUNDSYS->PlayBGMSound( (unsigned int)-1 );
		}
		break;
	default:
		break;
	}
}

void cStageManager::ManagedStageMap( eSTAGE curStage, eSTAGE newStage )
{
	switch( newStage )
	{
	case eStage_Login:
		{
			CAMERAMAN->ChangeCamera( 1 );

			if( curStage != eStage_Select && curStage != eStage_Server )
			{
				SCENEMAN->Clear();
				cLoginStage* p = (cLoginStage*)mpStage[eStage_Login];
				if( p )
					p->CreateLoginMap();
			}
		}
		break;
	case eStage_Select:
		{
			CAMERAMAN->ChangeCamera( 1 );
			if( curStage == eStage_Game  )
			{
				SCENEMAN->Clear();
				cSelectStage* p = (cSelectStage*)mpStage[eStage_Select];
				if( p )
					p->CreateSelectMap( true );
			}
			else
			{
				cSelectStage* p = (cSelectStage*)mpStage[eStage_Select];
				if( p )
					p->CreateSelectMap( false );
			}
		}
		break;
	case eStage_Load:
		{
			CAMERAMAN->ChangeCamera( 0 );
			SCENEMAN->Clear();
			cSelectStage* p = (cSelectStage*)mpStage[eStage_Select];
			if( p )
				p->ClearSelectMap();
		}
		break;
	default:
		break;
	}
}
