#include "stdafx.h"
#include "StaticSceneNode.h"

#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"
#include "LightAgent.h"
#include "FogAgent.h"

#include "NifAnimationInfo.h"

cStaticSceneNode::cStaticSceneNode( eType type )
: cSceneNode( type )
, mVisibleLevel( 0 )
, mOccludeLevel( 1 )
, mPickedByCamera( false )
{
	mNifAniInfo = new cNifAnimationInfo;
}

cStaticSceneNode::~cStaticSceneNode()
{
	SAFE_DELETE( mNifAniInfo );
}

void cStaticSceneNode::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	ProcessVisibleLevel( deltaTime );
	if( mCheckFrustum == false )
		return;

	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdateTransform = true;
		mNifAniInfo->Update( deltaTime, accumTime );
	}
	else
		return;

	cSceneNode::OnProcess( deltaTime, accumTime );
}

void cStaticSceneNode::ProcessVisibleLevel( unsigned long deltaTime )
{
	if( mVisibleLevel < 3 )
	{
		///  Ÿŭ Ÿ üũ
		if( mVisibleLevel <  SCENEMAN->CalcVisibleLevel( this ) )
		{
			SetAlphaBlended( 0.0f );
			if( mAlpha == mTargetAlpha )
				/// no frustum check
				mCheckFrustum = false;
			else
				/// frustum check
				mCheckFrustum = true;
		}
		else
		{
			if( mOccludeLevel == 1 && mPickedByCamera )
			{
				mPickedByCamera = false;
				SetAlphaBlended( 0.4f );
			}
			else
			{
				SetAlphaBlended( 1.0f );
			}

			/// frustum check
			mCheckFrustum = true;
		}
	}

	/// ĸ ó
	ProcessAlpha( deltaTime );
}

bool cStaticSceneNode::Init( const cStaticSceneNodeParam& param )
{
	///  ε
	if( RESOURCEMAN->LoadMapNIF( param.mPathName.Cstr() ) == false )
	{
//		assert( 0 && "failed to load nif file" );
		return false;
	}

	/// ҽ ڷκ  带 
	NiNode* n = RESOURCEMAN->CloneObjectByName( param.mPathName.Cstr() );
	if( n == 0 )
	{
		assert( 0 && "failed to clone node from resource manager" );
		return false;
	}

	///  ʱȭ
	mSceneNiNode = n;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	///   
	mVisibleLevel = param.mVisibleLevel;

	///   
	mOccludeLevel = param.mOccludeLevel;

	///  Ӽ 
	NiAlphaProperty* alphaProp = (NiAlphaProperty*)n->GetProperty( NiProperty::ALPHA );
	if( alphaProp == 0 )
	{
		alphaProp = NiNew NiAlphaProperty;
		alphaProp->SetAlphaBlending( false );
		alphaProp->SetAlphaTesting( false );
		n->AttachProperty( alphaProp );
	}

//	if( alphaProp )
//	{
//		bool blendEnabled = alphaProp->GetAlphaBlending();
//		bool testEnabled = alphaProp->GetAlphaTesting();
//		NiAlphaProperty::TestFunction testFunc = alphaProp->GetTestMode();
//		unsigned char testRef = alphaProp->GetTestRef();
//		mAlphaDataList.PushBack( new cAlphaData( blendEnabled, testEnabled, testFunc, testRef, alphaProp ) );
//	}

	/// Ӽ 
	CollectProperties( n );

	///  
	if( param.mMaterialApplied )
		SetMaterial( param.mMaterial );

	/// Ȱ Ӽ 
	if( param.mFogApplied )
		n->AttachProperty( FOGAGENT->GetFogProperty() );

	if( param.mNoAttachLight == false )
	{
		///  
		n->AttachEffect( LIGHTAGENT->GetSceneAmbientLight( 0 ) );
		n->AttachEffect( LIGHTAGENT->GetSceneDirLight( 0 ) );
	}

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( n );

	if( mNifAniInfo->GetNumberOfControllers() )
	{
		mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
		mNifAniInfo->SetLooping( true );
	}
	else
	{
		/// ִ  ٸ ޸ 
		SAFE_DELETE(mNifAniInfo);
	}

	if( mNifAniInfo && param.mDisableAnimation == true )
		mNifAniInfo->Stop();

	///  带 
	bool selectiveUpdate = true;
	bool rigid = false;
	n->SetSelectiveUpdateFlags( selectiveUpdate, mNifAniInfo!=0, rigid );

	///  带 ó
	n->UpdateProperties();
	n->UpdateEffects();
	n->Update( 0.0f );
	n->UpdateNodeBound();
	return true;
}

void cStaticSceneNode::SetMaterial( const cMaterialData& material )
{
	cMatPropList::cIterator i = mMatPropList.Begin();
	cMatPropList::cIterator end = mMatPropList.End();

	for( ; i != end; ++i )
	{
		NiMaterialProperty* matProp = (NiMaterialProperty*)*i;

		matProp->SetAmbientColor( material.mAmbient );
		matProp->SetDiffuseColor( material.mDiffuse );
		matProp->SetSpecularColor( material.mSpecular );
		matProp->SetEmittance( material.mEmissive );
		matProp->SetShineness( material.mShininess );
		matProp->SetAlpha( material.mAlpha );
	}

	mMaterial = material;
}

//////////////////////////////////////////////////////////////////////////

cManagedStaticSceneNode::cManagedStaticSceneNode( eType type )
: cStaticSceneNode( type )
{
	mIsMouseOver = false;
}

cManagedStaticSceneNode::~cManagedStaticSceneNode()
{

}