/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"
#include "MaterialData.h"

class cNifAnimationInfo;
class cNifTimeManager;

///    
class cStaticSceneNodeParam : public cSceneNodeParam
{
public:
	cStaticSceneNodeParam();

public:
	/// Ȱ  
	bool mFogApplied;

	/// 
	bool mMaterialApplied;
	cMaterialData mMaterial;

	///  
	unsigned int mVisibleLevel;

	///  
	unsigned int mOccludeLevel;

	bool mNoAttachLight;

	bool mDisableAnimation;
};

inline
cStaticSceneNodeParam::cStaticSceneNodeParam()
: mFogApplied( true )
, mMaterialApplied( false )
, mVisibleLevel( 0 )
, mOccludeLevel( 1 )
, mDisableAnimation( false )
{
	mPickFrontOnly = false;
	mNoAttachLight = false;
}

///   
/// ó ǥ ϰ  ̵ ʴ´.
/// ڸ ݺ ִϸ̼   ִ.
/// ,  ,     .
class cStaticSceneNode : public cSceneNode
{
	friend class cSceneManager;

public:
	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void ProcessVisibleLevel( unsigned long delatime );

	///  
	unsigned int GetOccludeLevel() const;

protected:
	cStaticSceneNode( eType type = eSTATIC );
	virtual ~cStaticSceneNode();

	/// ʱȭ
	virtual bool Init( const cStaticSceneNodeParam& param );

	/// 
	void SetMaterial( const cMaterialData& material );

protected:
	/// ִ Ʈѷ 
	cNifAnimationInfo*	mNifAniInfo;

	/// 
	cMaterialData mMaterial;

	///  
	unsigned int mVisibleLevel;

	///  
	unsigned int mOccludeLevel;

	/// ī޶ ɸ 
	bool mPickedByCamera;
};

inline
unsigned int cStaticSceneNode::GetOccludeLevel() const
{
	return mOccludeLevel;
}


//////////////////////////////////////////////////////////////////////////
class cManagedStaticSceneNode : public cStaticSceneNode
{
	friend class cSceneManager;

public:
	void SetMouseOver( bool set ) { mIsMouseOver = set; }

protected:
	cManagedStaticSceneNode( eType type = eMANAGEDSTATIC );
	virtual ~cManagedStaticSceneNode();

protected:
	bool		mIsMouseOver;
};