#include "stdafx.h"
#include "ObjectManager.h"
#include "StatusCalc_Client.h"
#include "Hero.h"
#include "GameResourceManager.h"
#include "SkillScript.h"
#include "StatusScript.h"
#include "SkillManager.h"
#include "Skill_Common.h"
#include "item_Common.h"
#include "ItemManager.h"


cStatusCalc_Client* cStatusCalc_Client::mpStatusCalc = NULL;


cStatusCalc_Client::cStatusCalc_Client(void)
{
	if( !mpStatusCalc )
	{
		mpStatusCalc = this;
	}
}



cStatusCalc_Client::~cStatusCalc_Client(void)
{
}



void cStatusCalc_Client::CalcPlayerStatusItemSkillAddDetail( eSTATUS_PLUS statusType, float value, bool color )
{
	unsigned long arrayNum = 0;

	if( eSTATUSPLUS_STR_PLUS <= statusType && statusType < eSTATUSPLUS_BASE_MAX )
	{
		arrayNum = statusType - eSTATUSPLUS_STR_PLUS;
		mBaseStatusPlus[arrayNum] = mBaseStatusPlus[arrayNum] + value;
		/// ׸  Ѵ. 
		if( color == true )		/// нú ȯ 
			SetBaseStatusInfoType( (ePLAYER_STATUS)arrayNum, value, mBaseStatusPlus[arrayNum] );
	}

	else if( eSTATUSPLUS_ATK_PLUS <= statusType && statusType < eSTATUSPLUS_SKILL_HP_PLUS_PLUS )
	{
		arrayNum = statusType - eSTATUSPLUS_ATK_PLUS;
		mExtStatusPlus[arrayNum] = mExtStatusPlus[arrayNum] + value;
		if( color == true )
			SetExtStatusInfoType( (ePLAYER_STATUS_EXT)arrayNum, value, mExtStatusPlus[arrayNum] );
	}

	/// ݷ ü +
	else if( eSTATUSPLUS_ATKTOTAL_PLUS == statusType )
	{
		mExtStatusPlus[ePLAYER_STATUS_EXT_ATK] += value;
		mExtStatusPlus[ePLAYER_STATUS_EXT_RATK] += value;
		mExtStatusPlus[ePLAYER_STATUS_EXT_MATK] += value;			
		if( color == true )
		{
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_ATK, value, mExtStatusPlus[ePLAYER_STATUS_EXT_ATK] );
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_RATK, value, mExtStatusPlus[ePLAYER_STATUS_EXT_RATK] );
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_MATK, value, mExtStatusPlus[ePLAYER_STATUS_EXT_MATK] );
		}
	}

	///  ü +
	else if( eSTATUSPLUS_DEFTOTAL_PLUS == statusType )
	{
		mExtStatusPlus[ePLAYER_STATUS_EXT_DEF] += value;
		mExtStatusPlus[ePLAYER_STATUS_EXT_MDEF] += value;
		if( color == true )
		{
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_DEF, value, mExtStatusPlus[ePLAYER_STATUS_EXT_DEF] );
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_MDEF, value, mExtStatusPlus[ePLAYER_STATUS_EXT_MDEF] );
		}
	}

	else if( eSTATUSPLUS_ATK_PER <= statusType && statusType <= eSTATUSPLUS_SKILL_HP_PLUS_PER )
	{

		arrayNum = statusType - eSTATUSPLUS_ATK_PER;
		mExtStatusPer[arrayNum] = mExtStatusPer[arrayNum] + value;
		/// нú ȯ 
		if( color == true )
		{
			/// ׸  Ѵ. 
			SetExtStatusInfoType( (ePLAYER_STATUS_EXT)arrayNum, value, mExtStatusPer[arrayNum] );
		}

	}

	/// ݷ ü %
	else if( eSTATUSPLUS_ATKTOTAL_PER == statusType )
	{
		mExtStatusPer[ePLAYER_STATUS_EXT_ATK] += value;
		mExtStatusPer[ePLAYER_STATUS_EXT_RATK] += value;
		mExtStatusPer[ePLAYER_STATUS_EXT_MATK] += value;			
		if( color == true )
		{
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_ATK, value, mExtStatusPer[ePLAYER_STATUS_EXT_ATK] );
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_RATK, value, mExtStatusPer[ePLAYER_STATUS_EXT_RATK] );
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_MATK, value, mExtStatusPer[ePLAYER_STATUS_EXT_MATK] );
		}
	}

	///  ü %
	else if( eSTATUSPLUS_DEFTOTAL_PER == statusType )
	{
		mExtStatusPer[ePLAYER_STATUS_EXT_DEF] += value;
		mExtStatusPer[ePLAYER_STATUS_EXT_MDEF] += value;
		if( color == true )
		{
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_DEF, value, mExtStatusPer[ePLAYER_STATUS_EXT_DEF] );
			SetExtStatusInfoType( ePLAYER_STATUS_EXT_MDEF, value, mExtStatusPer[ePLAYER_STATUS_EXT_MDEF] );
		}
	}

	else if( eSTATUSPLUS_EXPADDPER <= statusType && statusType < eSTATUSPLUS_BUFF_ETC_MAX )
	{
		arrayNum = statusType - eSTATUSPLUS_EXPADDPER;
		mExtAddStatus[arrayNum] = mExtAddStatus[arrayNum] + value;
	}

}



void cStatusCalc_Client::SetBaseStatusInfoType( ePLAYER_STATUS pos, float value, float totalValue )
{

	if( !( ePLAYER_STATUS_STR <= pos && pos < ePLAYER_STATUS_LEVEL ) )
	{
		assert(NULL);
		return;
	}

	/// ÷̾  о
	cHero* pHero = OBJECTMANAGER->GetHero();

	///  ÷ Ÿ 
	eStateInfo_Type colorType;
	colorType = pHero->GetBaseStatusInfoType( pos );

	/// о ġ 0 ϰ 
	if( value == 0 ) { return; }

	///  ÷Ÿ  ¿ +  °
	else if( colorType == eSTATE_NORMAL && value > 0 )
	{
		/// ÷Ÿ + 
		pHero->SetBaseStatusInfoType( pos, eSTATE_PLUS );
	}
	///  ÷Ÿ  ¿ -  °
	else if( colorType == eSTATE_NORMAL && value < 0 )
	{
		/// ÷Ÿ - 
		pHero->SetBaseStatusInfoType( pos, eSTATE_MINUS );
	}
	///  ÷Ÿ +¿ -  ° Ǵ  ÷Ÿ -¿ +  °
	else if( ( colorType == eSTATE_PLUS && value < 0 ) || ( colorType == eSTATE_MINUS && value > 0 ))
	{
		if( totalValue > 0 )
		{
			/// ÷Ÿ + 
			pHero->SetBaseStatusInfoType( pos, eSTATE_OVERLAPPLUS );
		}
		else
		{
			/// ÷Ÿ + 
			pHero->SetBaseStatusInfoType( pos, eSTATE_OVERLAPMINUS );
		}
	}
}



void cStatusCalc_Client::SetExtStatusInfoType( ePLAYER_STATUS_EXT pos, float value, float totalValue )
{

	if( !( ePLAYER_STATUS_EXT_ATK <= pos && pos <= ePLAYER_STATUS_EXT_MAX ) )
	{
		assert(NULL);
		return;
	}

	///  ÷ Ÿ 
	eStateInfo_Type colorType;
	colorType = HERO->GetExtStatusInfoType( pos );

	/// о ġ 0 ϰ 
	if( value == 0 ) { return; }

	///  ÷Ÿ  ¿ +  °
	else if( colorType == eSTATE_NORMAL && value > 0 )
	{
		/// ÷Ÿ + 
		HERO->SetExtStatusInfoType( pos, eSTATE_PLUS );
	}
	///  ÷Ÿ  ¿ -  °
	else if( colorType == eSTATE_NORMAL && value < 0 )
	{
		/// ÷Ÿ - 
		HERO->SetExtStatusInfoType( pos, eSTATE_MINUS );
	}
	///  ÷Ÿ +¿ -  ° Ǵ  ÷Ÿ -¿ +  °
	else if( ( colorType == eSTATE_PLUS && value < 0 ) || ( colorType == eSTATE_MINUS && value > 0 ))
	{
		if( totalValue > 0 )
		{
			/// ÷Ÿ + 
			HERO->SetExtStatusInfoType( pos, eSTATE_OVERLAPPLUS );
		}
		else
		{
			/// ÷Ÿ + 
			HERO->SetExtStatusInfoType( pos, eSTATE_OVERLAPMINUS );
		}
	}
}


void cStatusCalc_Client::CalcPlayerBaseOnly()
{
	//HERO->InitStatusColor();

	/// ⺻  ʱȭ
	for( unsigned char i = ePLAYER_STATUS_STR ; ePLAYER_STATUS_LEVEL > i ; ++i )
	{
		mBaseStatus[i] = 0.0f;
	}

	/// ũƮ о  ⺻ ݰ 
	CalcPlayerStatus();
}



void cStatusCalc_Client::CalcPlayerExtensionOnly()
{
	HERO->InitStatusInfoType();

	/// 1 + ʱȭ
	for( unsigned char i = ePLAYER_STATUS_STR ; ePLAYER_STATUS_LEVEL > i ; ++i )
	{
		mBaseStatusPlus[i] = 0.0f;
	}

	/// 2 + ʱȭ
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mExtStatusPlus[i] = 0;
	}

	/// 2 % ʱȭ
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mExtStatusPer[i] = 0;
	}

	/// ݿ 
	for( int i = ePLAYER_STATUS_EXT_ADD_EXPADDPER ; ePLAYER_STATUS_EXT_ADD_MAX > i ; ++i )
	{
		mExtAddStatus[i] = 0;
	}

	/// ųȿ, ųнú,  Ÿ о  ġ 
	CalcPlayerStatusSkillInfluenceAdd();
	CalcPlayerStatusSkillPassiveAdd();
	CalcPlayerStatusItemAdd();
}



unsigned long cStatusCalc_Client::GetParantJob( unsigned long job, unsigned int jobPos )
{

	unsigned long jobCode;

	///   θ  迭 ޾ƿ´.
	tArray<unsigned long>* pParentJob;

	///   ڵ带 о
	pParentJob = GAMERESOURCEMAN->GetParentJob( job );

	/// Ͱ  -   ⺻  ̴.
	if( pParentJob == NULL )
	{
		return NULL;
	}

	///  ũ -    ̴.
	if( jobPos > pParentJob->GetSize() - 1 )
	{
		return NULL;
	}

	///   شϴ  ڵ带 о.
	pParentJob->GetAt( &jobCode, jobPos );

	return jobCode;
}



void cStatusCalc_Client::CalcPlayerStatusSkillInfluenceAdd()
{
	cPointerHashMap::cIterator iter;

	cInfluenceObject* pInfluenceObject = NULL;
	sInfluenceScript* pInfluenceScript = NULL;
	cPointerHashMap* influenceMap = HERO->GetBufMap();
	if( influenceMap != NULL )
	{
		iter = influenceMap->Begin();
		while( iter != influenceMap->End() )
		{
			pInfluenceObject = (cInfluenceObject*)((*iter).mSecond);
			++iter;

			pInfluenceScript = SKILLSCRIPT->GetInfluenceInfo( pInfluenceObject->GetInfluenceIdx() );
			///  ȿ ƴѰ츸()
			if( pInfluenceScript->mTime1 == 0 )
			{
				if( pInfluenceScript->mStatusPlusIdx1 != 0 )
				{
					CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx1),
						(float)(pInfluenceScript->mValue1), true );
				}
			}
			///  ȿ ƴѰ츸()
			if( pInfluenceScript->mTime2 == 0 )
			{
				if( pInfluenceScript->mStatusPlusIdx2 != 0 )
				{
					CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx2),
						(float)(pInfluenceScript->mValue2), true  );
				}
			}
			if( pInfluenceScript->mStatusPlusIdx3 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx3),
					(float)(pInfluenceScript->mValue3), true  );
			}
		}
	}

	influenceMap = HERO->GetDeBufMap();
	if( influenceMap != NULL )
	{
		iter = influenceMap->Begin();
		while( iter != influenceMap->End() )
		{
			pInfluenceObject = (cInfluenceObject*)((*iter).mSecond);
			++iter;

			pInfluenceScript = SKILLSCRIPT->GetInfluenceInfo( pInfluenceObject->GetInfluenceIdx() );
			///  ȿ ƴѰ츸()
			if( pInfluenceScript->mTime1 == 0 )
			{
				if( pInfluenceScript->mStatusPlusIdx1 != 0 )
				{
					CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx1),
						(float)(pInfluenceScript->mValue1), true );
				}
			}
			if( pInfluenceScript->mStatusPlusIdx2 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx2),
					(float)(pInfluenceScript->mValue2), true  );
			}
			if( pInfluenceScript->mStatusPlusIdx3 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx3),
					(float)(pInfluenceScript->mValue3), true  );
			}
		}
	}
}



void cStatusCalc_Client::CalcPlayerStatusSkillPassiveAdd()
{

	cPointerHashMap::cIterator iter;

	unsigned long skillIdx = 0;
	sKeepSkill* pKeepSkill = NULL;

	sPlayerSkillBaseInfo* pSkillInfo = NULL;
	sPlayerSkillStepInfo* pSkillStep = NULL;

	cPointerHashMap* keepSkillMap = SKILLMAN->GetKeepSkillMap();
	if( keepSkillMap != NULL )
	{
		iter = keepSkillMap->Begin();
		while( iter != keepSkillMap->End() )
		{
			skillIdx = (*iter).mFirst;
			pKeepSkill = (sKeepSkill*)((*iter).mSecond);
			if( pKeepSkill == NULL )
			{
				assert(NULL);
				return;
			}
			++iter;

			pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );

			/// нú길 ȿ 
			if( pSkillInfo->mType != eSKILLTYPE_PASSIVE )
			{
				continue;
			}

			if( pSkillInfo->mStepCount <= pKeepSkill->mStep )
			{
				assert(0);
			}

			pSkillStep = &pSkillInfo->mpSetpInfoArray[ pKeepSkill->mStep ];


			///   ´ üũ
			bool IsEquipment = true;
			if( pSkillInfo->mUseEquipment )
			{
				cItem rightWeapon = ITEMMAN->GetHeroRightWeapon();
				int rType = rightWeapon.GetDefine()? rightWeapon.GetDefine()->GetSubType() : -1;
				cItem leftWeapon = ITEMMAN->GetHeroLeftWeapon();
				int lType = leftWeapon.GetDefine()? leftWeapon.GetDefine()->GetSubType() : -1;

				///   üũ
				switch( pSkillInfo->mUseEquipment )
				{
				case eEQUIPTYPE_SWORD:
					if( rType != ITEM_WEAPON_SWORD )
						IsEquipment = false;
					break;
				case eEQUIPTYPE_LONGSWORD:
					if( rType != ITEM_WEAPON_BLADE )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_DOUBLESWORD:
					if( rType != ITEM_WEAPON_DUAL )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_SHORTSWORD:
					if( rType != ITEM_WEAPON_CUTTER )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_GUN:
					if( rType != ITEM_WEAPON_GUN )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_STAFF:
					if( rType != ITEM_WEAPON_STAFF )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_SHIELD:
					if( lType != ITEM_WEAPON_SHIELD )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_SWORD_LONGSWORD:
					if( rType != ITEM_WEAPON_SWORD &&
						rType != ITEM_WEAPON_BLADE )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_SWORD_DOUBLESWORD:
					if( rType != ITEM_WEAPON_SWORD &&
						rType != ITEM_WEAPON_DUAL )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_LONGSWORD_DOUBLESWORD:
					if( rType != ITEM_WEAPON_BLADE &&
						rType != ITEM_WEAPON_DUAL )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_SWORD_LONGSWORD_DOUBLESWORD:
					if( rType != ITEM_WEAPON_SWORD &&
						rType != ITEM_WEAPON_BLADE &&
						rType != ITEM_WEAPON_DUAL )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_SHORTSWORD_GUN:
					if( rType != ITEM_WEAPON_CUTTER &&
						rType != ITEM_WEAPON_GUN )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_CLOTH:
					if( HERO->GetArmorSets() != ARMOR_SETS_ROBES )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_LIGHTARMOR:
					if( HERO->GetArmorSets() != ARMOR_SETS_LIGHT_ARMOR )
						IsEquipment =  false;
					break;
				case eEQUIPTYPE_HEAVYARMOR:
					if( HERO->GetArmorSets() != ARMOR_SETS_HEAVY_ARMOR )
						IsEquipment =  false;
					break;
				}
			}

			if( IsEquipment == true )
			{
				if( pSkillStep->mApplyValueType1 != 0 )
				{
					CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pSkillStep->mApplyValueType1),
						(float)(pSkillStep->mApplyValue1), false );
				}
				if( pSkillStep->mApplyValueType2 != 0 )
				{
					CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pSkillStep->mApplyValueType2),
						(float)(pSkillStep->mApplyValue2), false );
				}
			}
		}
	}
}



void cStatusCalc_Client::CalcPlayerStatusItemAdd()
{
	bool colorChange = false;
	sEquipAbility* pEquipAbility = ITEMMAN->GetBasicAbil();
	if( pEquipAbility == NULL )
		return;

	pEquipAbility = ITEMMAN->GetBasicAbil();
	colorChange = true;

	if( pEquipAbility->mOptStr != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_STR_PLUS, (float)pEquipAbility->mOptStr, colorChange );
	}
	if( pEquipAbility->mOptDex != 0 )	/// :ø
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_DEX_PLUS, (float)pEquipAbility->mOptDex, colorChange );
	}
	if( pEquipAbility->mOptCon != 0 )	/// :ü
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_CON_PLUS, (float)pEquipAbility->mOptCon, colorChange );
	}
	if( pEquipAbility->mOptInt != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_INT_PLUS, (float)pEquipAbility->mOptInt, colorChange );
	}
	if( pEquipAbility->mOptWis != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_WIS_PLUS, (float)pEquipAbility->mOptWis, colorChange );
	}

	if( pEquipAbility->mOptPlusWei != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_WEIGHT_PLUS, (float)pEquipAbility->mOptPlusWei, colorChange );
	}
	//if( pEquipAbility->mOptPlusMov != 0 )	/// :̵ӵ
	//{
	//	CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_SPD_PLUS, (float)pEquipAbility->mOptPlusMov, colorChange );
	//}
	//if( pEquipAbility->mOptPlusMaxHp != 0 )	/// :ִHP 
	//{
	//	CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_HP_PLUS, (float)pEquipAbility->mOptPlusMaxHp, colorChange );
	//}
	//if( pEquipAbility->mOptPlusMaxMp != 0 )	/// :ִMP 
	//{
	//	CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_MP_PLUS, (float)pEquipAbility->mOptPlusMaxMp, colorChange );
	//}
}



void cStatusCalc_Client::CalcPlayerStatus()
{
	unsigned char level = HERO->GetLevel();
	ePLAYER_JOB job = HERO->GetJob();

	/// Ŭ1   
	unsigned char class1 = 30;
	/// Ŭ2  
	unsigned char class2 = 70;

	sStatusBaseScript* pStatusBase = NULL;

	/// ڱ ڽſ شϴ  statusbase  
	pStatusBase = STATUSSCRIPT->GetStatusBaseInfo( job );

	/// ڽſ شϴ     оͼ óѴ.
	if( pStatusBase == NULL )
	{
		///   迭 о´.
		tArray<unsigned long>* playerJobParent = GAMERESOURCEMAN->GetParentJob( job );
		if( playerJobParent == NULL )
		{
			/// ڽ  µ θ   
			assert(NULL);
			return; 
		}
		else
		{

			///    
			for( int i = playerJobParent->GetSize() - 1 ; 0 <= i  ; --i )
			{
				///  ڵ ũƮ  о
				pStatusBase = STATUSSCRIPT->GetStatusBaseInfo( (*playerJobParent)[i] );
				if( pStatusBase != NULL )
				{
					break;
				}
			}

			assert(NULL);
		}
	}

	/// Է  ⺻  ġ  
	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
	{
		mBaseStatus[i] = pStatusBase->mBaseStatus[i];
	}

	///       ޾ƾ ڵ
	unsigned long fixjob = job;

	sStatusMultiplScript* pStatusMultipl;

	///   1   ( 0 ⺻ 1 ġ )
	for( unsigned char j = 1 ; j <= level ; ++j )
	{

		/// 1 1(30) ⺻ ڵ  
		if( ( 1 <= j ) && ( j < class1 ) )
		{
			///   Ʈ 1  
			fixjob = GetParantJob( job, 0 );
			///     ⺻ ̶ θ  
			if( fixjob == NULL )
			{
				///      ڵ 
				fixjob = job;
			}
		}

		/// 1(30) 2(70) 1
		else if( ( class1 <= j ) && ( j < class2 ) )
		{
			///   Ʈ 1  
			fixjob = GetParantJob( job, 1 );
			///     1 
			if( fixjob == NULL )
			{
				fixjob = job;
			}
		}

		/// 2(30)  Ѱ 
		else if( class2 <= j )
		{
			///   Ʈ 2  
			fixjob = GetParantJob( job, 2 );
			///     2 
			if( fixjob == NULL )
			{
				fixjob = job;
			}
		}

		///   ´  ڵ  ġ 
		pStatusMultipl = STATUSSCRIPT->GetStatusMultiplInfo( fixjob );
		if( pStatusMultipl == NULL )
		{
			assert(NULL);
			return;
		}

		for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
		{
			/// Ŭؿ  ġ ŭ 
			mBaseStatus[i] = mBaseStatus[i] + pStatusMultipl->mBaseStatus[i];
		}
	}
}



void cStatusCalc_Client::CalcPlayerExtStatus( ePLAYER_STATUS_EXT statusExt )
{
	ePLAYER_JOB job = HERO->GetJob();

	/// ÷̾ 1  о + 
	float baseStatus[ePLAYER_STATUS_LEVEL_MAX];
	unsigned char i = ePLAYER_STATUS_STR;
	for( ; i < ePLAYER_STATUS_LEVEL ; ++i )
	{
		baseStatus[i] = mBaseStatus[i] + mBaseStatusPlus[i];
		if( baseStatus[i] < 0.0f )
			baseStatus[i] = 0.0f;
	}
	baseStatus[i] = HERO->GetLevel(); 

	///    
	float			statusValue = 0.0f;

	/// ڿȸHP/MP ⺻ [ĳͽȸġ]  ʰ ڿȸ Ѵ.
	if( statusExt == ePLAYER_STATUS_EXT_RECOVHP || statusExt == ePLAYER_STATUS_EXT_RECOVMP )
	{
		statusValue = 0.0f;
	}
	else
	{
		/// ڽ   ̶   ִ üũ
		statusValue = (float)STATUSSCRIPT->GetStatusExtBaseInfo( statusExt, job );
		//if( FloatToInt(statusValue) == 0 )
		//{
		//	if( playerJobParent != 0 )
		//	{
		//		///    
		//		for( int i = playerJobParent->GetSize() - 1 ; 0 <= i  ; --i )
		//		{
		//			///  ڵ ũƮ  о
		//			statusValue = (float)STATUSSCRIPT->GetStatusExtBaseInfo( statusExt, (*playerJobParent)[i] );

		//			if( FloatToInt(statusValue) != 0 )
		//			{
		//				break;
		//			}
		//		}
		//	}
		//	else
		//	{
		//		statusValue = 0.0f;
		//	}
		//}
	}

	/// ÷̾ ֻ(1)  
	tArray<unsigned long>* playerJobParent = GAMERESOURCEMAN->GetParentJob( job );
	unsigned long firstJob = HERO->GetJob();
	if( playerJobParent != NULL )
		firstJob = (*playerJobParent)[0];

	/// 1   ݷ  ġ о ׸ 
	unsigned long plusStatus = 0;
	switch( firstJob )
	{		
	case ePLAYER_FIGHTER:	/// 
	case ePLAYER_WARRIOR:	/// 
		plusStatus = 0;
		break;
	case ePLAYER_RANGER:	/// 
	case ePLAYER_ROGUE:		/// α
		plusStatus = 1;
		break;
	case ePLAYER_MAGE:		/// 
	case ePLAYER_SHAMAN:	/// 
		plusStatus = 2;
		break;
	}

	float importance = 0.0f;
	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL_MAX ; ++i )
	{
		eEXT_MULTIPL chgStatusExt = eEXT_MULTIPL_MAX;
		switch( statusExt )
		{
		case ePLAYER_STATUS_EXT_ATK:
			chgStatusExt = (eEXT_MULTIPL)( eEXT_MULTIPL_ATK_FIGHTER + plusStatus );		/// ٰŸ, Ÿ,    ݷ ׸ 
			break;
		case ePLAYER_STATUS_EXT_RATK:
			chgStatusExt = (eEXT_MULTIPL)( eEXT_MULTIPL_RATK_FIGHTER + plusStatus );
			break;
		case ePLAYER_STATUS_EXT_MATK:
			chgStatusExt = (eEXT_MULTIPL)( eEXT_MULTIPL_MATK_FIGHTER + plusStatus );
			break;
		case ePLAYER_STATUS_EXT_DEF:		chgStatusExt = eEXT_MULTIPL_DEF;		break;	///  
		case ePLAYER_STATUS_EXT_MDEF:		chgStatusExt = eEXT_MULTIPL_MDEF;		break;	///  
		case ePLAYER_STATUS_EXT_CRI:		chgStatusExt = eEXT_MULTIPL_CRI;		break;	///  ũƼ ġ
		case ePLAYER_STATUS_EXT_MCRI:		chgStatusExt = eEXT_MULTIPL_MCRI;		break;	///  ũƼ ġ
		case ePLAYER_STATUS_EXT_MAXHP:		chgStatusExt = eEXT_MULTIPL_MAXHP;		break;	/// HP 
		case ePLAYER_STATUS_EXT_MAXMP:		chgStatusExt = eEXT_MULTIPL_MAXMP;		break;	/// MP
		case ePLAYER_STATUS_EXT_RECOVHP:	chgStatusExt = eEXT_MULTIPL_RECOVHP;	break;	/// HP ȸ ӵ
		case ePLAYER_STATUS_EXT_RECOVMP:	chgStatusExt = eEXT_MULTIPL_RECOVMP;	break;	/// MP ȸ ӵ
		case ePLAYER_STATUS_EXT_HIT:		chgStatusExt = eEXT_MULTIPL_HIT;		break;	///  ġ
		case ePLAYER_STATUS_EXT_MHIT:		chgStatusExt = eEXT_MULTIPL_MHIT;		break;	///  
		case ePLAYER_STATUS_EXT_AVOID:		chgStatusExt = eEXT_MULTIPL_AVOID;		break;	/// ȸ ġ
		case ePLAYER_STATUS_EXT_WEIGHT:		chgStatusExt = eEXT_MULTIPL_WEIGHT;		break;	///  
		case ePLAYER_STATUS_EXT_RANGE:		chgStatusExt = eEXT_MULTIPL_RANGE;		break;	/// Ÿ
		case ePLAYER_STATUS_EXT_RRANGE:		chgStatusExt = eEXT_MULTIPL_RRANGE;		break;	/// Ÿ
		case ePLAYER_STATUS_EXT_COOLTIME:	chgStatusExt = eEXT_MULTIPL_COOLTIME;	break;	/// Ÿ
		case ePLAYER_STATUS_EXT_SPD:		chgStatusExt = eEXT_MULTIPL_SPD;		break;	/// ̵ӵ
		case ePLAYER_STATUS_EXT_ASPD:		chgStatusExt = eEXT_MULTIPL_ASPD;		break;	///  ӵ	
		}

		/// ̽  ߰ Ѵ.
		importance = STATUSSCRIPT->GetStatusExtMultiplInfo( chgStatusExt, (ePLAYER_STATUS)i );
		statusValue += baseStatus[i] * importance;
	}

	///   
	mExtStatus[statusExt] = mExtStatus[statusExt] + statusValue;
	if( mExtStatus[statusExt] < 0.0f ) 
		mExtStatus[statusExt] = 0.0f;

}



void cStatusCalc_Client::CalcPlayerInit()
{
	CalcPlayerBaseOnly();
	CalcPlayerExtensionOnly();
	CalcPlayerGlobal();
}



void cStatusCalc_Client::CalcPlayerBaseGlobal()
{
	CalcPlayerBaseOnly();
	CalcPlayerGlobal();
}



void cStatusCalc_Client::CalcPlayerExtensionGlobal()
{
	CalcPlayerExtensionOnly();
	CalcPlayerGlobal();
}



void  cStatusCalc_Client::CalcPlayerGlobal()
{

	/// Ȯ  ̽ ʱȭ
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mExtStatus[i] = 0;
	}

	/// Ȯ  
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mExtStatusLast[i] = 0;
	}

	float num1, num2, num3, num4;
	float valueA, valueB, valueC;

	sEquipAbility* pItem = ITEMMAN->GetBasicAbil();

	for( unsigned char i = ePLAYER_STATUS_EXT_ATK ; i < ePLAYER_STATUS_EXT_MAX ; ++i )
	{
		/// ũƮ о  Ȯ ݰ 
		CalcPlayerExtStatus( (ePLAYER_STATUS_EXT)i );

		///      ׸ 
		switch( (ePLAYER_STATUS_EXT)i )
		{
			/// ٰŸ  
		case ePLAYER_STATUS_EXT_ATK:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 301 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 302 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 303 );

				/// A =	ĳ  ٰŸ ݷ
				/// B =	  ݷ + ( [ĳ] Lv * {num301} )
				/// C =	(({num302} + (  ٰŸ ݷ[%] + ۿɼǰ[%] ) / {num303})
				///	((A + B ) * C) + (  ٰŸ ݷ[+-] + ۿɼǰ[+-] )
				valueA = mExtStatus[i];
				valueB = ( pItem->mPhysicMinAttack ) + ( HERO->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_ATKMin, mExtStatusLast[i] );

				valueB = pItem->mPhysicMaxAttack + ( HERO->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_ATKMax, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentPhysicAttack != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentPhysicAttack, mExtStatusLast[i] );
				if( pItem->mOptPlusPhysicAttack != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusPhysicAttack, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			/// Ÿ  
		case ePLAYER_STATUS_EXT_RATK:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 331 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 332 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 333 );

				/// A =	ĳ  Ÿ ݷ
				/// B =	  ݷ + ( [ĳ] Lv * {num331} )
				/// C =	(({num332} + (  ٰŸ ݷ[%] + ۿɼǰ[%] ) / {num333})
				///	((A + B ) * C) + (  ٰŸ ݷ[+-] + ۿɼǰ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mPhysicMinAttack + ( HERO->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_RATKMin, mExtStatusLast[i] );

				valueB = pItem->mPhysicMaxAttack + ( HERO->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_RATKMax, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentPhysicAttack != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentPhysicAttack, mExtStatusLast[i] );
				if( pItem->mOptPlusPhysicAttack != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusPhysicAttack, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			///  
		case ePLAYER_STATUS_EXT_DEF:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 401 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 402 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 403 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 404 );

				// A =	ĳ ȹ 
				// B =	  
				// C =	(( {num401} + (   [%] + ۿɼ[%] ) ) / {num402} )
				// D =	((A /{num403}  + B /{num404}) * C) + (   [+-] + ۿɼ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mPhysicDefense;
				valueC = ( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentPhysicDefense ) ) / num2 );
				mExtStatusLast[i] = ( ( valueA / num3 + valueB / num4 ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicDefense;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentPhysicDefense != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentPhysicDefense, mExtStatusLast[i] );
				if( pItem->mOptPlusPhysicDefense != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusPhysicDefense, mExtStatusLast[i] );
			}
			break;
			///  
		case ePLAYER_STATUS_EXT_MATK:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 361 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 362 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 363 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 364 );

				/// A =	ĳ   ݷ / {num361}
				/// B =	  ݷ + ( [ĳ] Lv * {num362} )
				/// C =	(({num363} + (   ݷ[%] + ۿɼ[%] ) ) / {num364})
				///	((A + B ) * C) + (   ݷ[+-] + ۿɼ[+-] )
				valueA = mExtStatus[i] / num1;
				valueB = pItem->mMagicMinAttack + ( HERO->GetLevel() * num2 );
				valueC = ( ( num3 + ( mExtStatusPer[i] + pItem->mOptPercentMagicAttack ) ) / num4 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusMagicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_MATKMin, mExtStatusLast[i] );

				valueB = pItem->mMagicMaxAttack + ( HERO->GetLevel() * num2 );
				valueC = ( ( num3 + ( mExtStatusPer[i] + pItem->mOptPercentMagicAttack ) ) / num4 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusMagicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_MATKMax, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentMagicAttack != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentMagicAttack, mExtStatusLast[i] );
				if( pItem->mOptPlusMagicAttack != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusMagicAttack, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			///  
		case ePLAYER_STATUS_EXT_MDEF:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 431 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 432 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 433 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 434 );

				// A =	ĳ ȸ 
				// B =	  
				// C =	(( {num431} + (   [%] + ۿɼ[%] ) ) / {num432} )
				// D =	((A /{num433}  + B /{num434}) * C) + (   [+-] + ۿɼ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mMagicDefense;
				valueC = ( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentMagicDefense ) ) / num2 );
				mExtStatusLast[i] = ( ( valueA / num3 + valueB / num4 ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusMagicDefense;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentMagicDefense != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentMagicDefense, mExtStatusLast[i] );
				if( pItem->mOptPlusMagicDefense != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusMagicDefense, mExtStatusLast[i] );

			}
			break;
			///   ũ
		case ePLAYER_STATUS_EXT_CRI:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 201 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 202 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 203 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 204 );

				/// A =	[] ĳ   ũƼ ġ +   ũƼ ġ
				///	( A * {num201} ) * (({num202} + (   ũƼ [%] + ۿɼ[%] ) ) /
				///	{num203}) + (   ũƼ ġ[+-] + ۿɼ[+-] ) * {num204} )
				valueA = mExtStatus[i] + pItem->mPhysicCritical;
				mExtStatusLast[i] = ( valueA * num1 ) * ( ( num2 + ( mExtStatusPer[i] + pItem->mOptPercentPhysicCritical ) ) / num3 ) +
					( ( mExtStatusPlus[i] + pItem->mOptPlusPhysicCritical ) * num4 );

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentPhysicCritical != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentPhysicCritical, mExtStatusLast[i] );
				if( pItem->mOptPlusPhysicCritical != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusPhysicCritical, mExtStatusLast[i] );
			}
			break;
			///	  ũ
		case ePLAYER_STATUS_EXT_MCRI:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 231 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 232 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 233 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 234 );

				/// A =	[] ĳ   ũƼ ġ +   ũƼ ġ
				///	( A * {num231} ) * (({num232} + (   ũƼ [%] + ۿɼ[%] ) ) / 
				/// {num233}) + ( (   ũƼ ġ[+-] + ۿɼ[+-] ) * {num234} )
				valueA = mExtStatus[i] + pItem->mMagicCritical;
				mExtStatusLast[i] = ( valueA * num1 ) * ( ( num2 + ( mExtStatusPer[i] + pItem->mOptPercentMagicCritical ) ) / num3 ) + 
					( ( mExtStatusPlus[i] + pItem->mOptPlusMagicCritical ) * num4 );

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentMagicCritical != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentMagicCritical, mExtStatusLast[i] );
				if( pItem->mOptPlusMagicCritical != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusMagicCritical, mExtStatusLast[i] );
			}break;
			/// ִ HP
		case ePLAYER_STATUS_EXT_MAXHP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 20 );

				/// ⺻ hp + (  * num1 )
				mExtStatus[i] = mExtStatus[i] + ( HERO->GetLevel() * num1 );    
				mExtStatusLast[i] = mExtStatus[i] * ( ( 100 + ( mExtStatusPer[i] + pItem->mOptPercentMaxHp ) ) / 100 )
					+ mExtStatusPlus[i] + pItem->mOptPlusMaxHp;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// ִ MP
		case ePLAYER_STATUS_EXT_MAXMP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 20 );

				mExtStatusLast[i] = mExtStatus[i] * ( ( 100 + ( mExtStatusPer[i] + pItem->mOptPercentMaxMp ) ) / 100 ) + 
					mExtStatusPlus[i] + pItem->mOptPlusMaxMp;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// HP ڿ ȸ
		case ePLAYER_STATUS_EXT_RECOVHP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1001 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1002 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1003 );

				float defaultValueHP = (float)STATUSSCRIPT->GetStatusExtBaseInfo( (ePLAYER_STATUS_EXT)i, HERO->GetJob() );

				/// A =	Ŭ ⺻
				///	B =	( ĳ  ȸ ġ * {num1001} ) * (( {num1002} +  HPȸ [%] + ۿɼ[%] ) / {num1003} ) + ۿ  HP ȸ ġ 
				///	A + B +  HPȸ [+-]
				valueA = defaultValueHP;
				valueB = ( mExtStatus[i] * num1 ) * ( ( num2 + ( mExtStatusPer[i] + pItem->mOptPercentHp ) ) / num3 ) + pItem->mOptPlusHp;
				mExtStatusLast[i] = valueA + valueB + mExtStatusPlus[i];

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				if( HERO->IsSitDownCalc() == true )
					mExtStatusLast[i] *= STATUSSCRIPT->GetDamageCalcNumericalInfo( 10 );

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentHp != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentHp, mExtStatusLast[i] );
				if( pItem->mOptPlusHp != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusHp, mExtStatusLast[i] );
			}
			break;
			/// MP ڿ ȸ
		case ePLAYER_STATUS_EXT_RECOVMP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1101 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1102 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1103 );

				float defaultValueMP = (float)STATUSSCRIPT->GetStatusExtBaseInfo( (ePLAYER_STATUS_EXT)i, HERO->GetJob() );

				/// A =	Ŭ ⺻
				///	B =	( ĳ  ȸ ġ * {num1101} ) * (( {num1102} + (  MPȸ [%] + ۿɼ[%] ) ) / {num1103} ) + ۿ  MP ȸ ġ 
				///	A + B +  MPȸ [+-]
				valueA = defaultValueMP;
				valueB = ( mExtStatus[i] * num1 ) * ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentMp ) / num3 ) + pItem->mOptPlusMp;
				mExtStatusLast[i] = valueA + valueB + mExtStatusPlus[i];

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				if( HERO->IsSitDownCalc() == true )
					mExtStatusLast[i] *= STATUSSCRIPT->GetDamageCalcNumericalInfo( 10 );

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentMp != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentMp, mExtStatusLast[i] );
				if( pItem->mOptPlusMp != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusMp, mExtStatusLast[i] );
			}
			break;
			///   
		case ePLAYER_STATUS_EXT_HIT:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 101 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 102 );

				/// ( [] ĳ   ġ +   ġ ) * (({num101} + (   ġ[%] + + ۿɼ[%] ) ) / {num102}) + 
				///   ġ[+-] + ۿɼ[+-] 
				mExtStatusLast[i] = ( mExtStatus[i] + pItem->mPhysicAttackRate ) * 
					( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentPhysicAttackRate ) ) / num2 ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttackRate;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentPhysicAttackRate != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentPhysicAttackRate, mExtStatusLast[i] );
				if( pItem->mOptPlusPhysicAttackRate != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusPhysicAttackRate, mExtStatusLast[i] );
			}
			break;
			///   
		case ePLAYER_STATUS_EXT_MHIT:
			{
				///  ݻ 
				mExtStatusLast[i] = 0.0f;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// ȸ
		case  ePLAYER_STATUS_EXT_AVOID:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 105 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 106 );

				///	( [] ĳ  ȸ ġ +  ȸ ġ ) * (({num105} + (  ȸ ġ[%] + ۿɼ[%] ) ) / {num106}) + 
				///  ȸ ġ[+-] + ۿɼ[+-] )
				mExtStatusLast[i] = ( mExtStatus[i] + pItem->mOptPlusDod ) *
					( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentDod ) ) / num2 ) + mExtStatusPlus[i] + pItem->mOptPlusDod;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );

				/// Ȯ׸ ġ ִ° ȯ
				if( pItem->mOptPercentDod != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPercentDod, mExtStatusLast[i] );
				if( pItem->mOptPlusDod != 0 )
					SetExtStatusInfoType( (ePLAYER_STATUS_EXT)i, pItem->mOptPlusDod, mExtStatusLast[i] );
			}
			break;
			/// Ϲݰ ӵ
		case ePLAYER_STATUS_EXT_ASPD:
			{
				mExtStatusLast[i] = ( 100 + pItem->mAttackSpeed + mExtStatusPer[i] ) / 100;

				if( mExtStatusLast[i] < 0.1f )
					mExtStatusLast[i] = 0.1f;

				if( mExtStatusLast[i] > 2.0f )
					mExtStatusLast[i] = 2.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );                  
			}break;
			///  ȸ
		case ePLAYER_STATUS_EXT_HEAL:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1203 );

				///	( ĳ   ݷ * 0.5 ) + ۿ  ųȸ  ġ 
				mExtStatusLast[i] = HERO->GetStatus2()->mMagicMinAttack * num1;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_HEALMin, mExtStatusLast[i] );

				mExtStatusLast[i] = HERO->GetStatus2()->mMagicMaxAttack * num1;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( ePLAYER_STATUS_EXT_HEALMax, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			/// 
		case ePLAYER_STATUS_EXT_WEIGHT:
			{
				mExtStatusLast[i] = mExtStatus[i] * ( ( 100.0f + ( mExtStatusPer[i] + pItem->mOptPercentWei ) ) / 100.0f ) + 
					mExtStatusPlus[i] + pItem->mOptPlusWei;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
		default:
			{
				mExtStatusLast[i] = mExtStatus[i] * ( ( 100.0f + mExtStatusPer[i] ) / 100.0f ) + mExtStatusPlus[i];

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				HERO->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
		}
	}

	///   ÷̾ 
	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
	{
		HERO->SetStatus1( (ePLAYER_STATUS)i, mBaseStatus[i] );
		HERO->SetStatus1Plus( (ePLAYER_STATUS)i, mBaseStatusPlus[i] );
	}

	for( unsigned char i = ePLAYER_STATUS_EXT_ADD_EXPADDPER ; i < ePLAYER_STATUS_EXT_ADD_MAX ; ++i )
	{
		HERO->SetStatusEtc( (ePLAYER_STATUS_EXT_ADD)i, mExtAddStatus[i] );
	}

}



float cStatusCalc_Client::GetStatus2Plus( ePLAYER_STATUS_EXT status2 )
{ 
	if( status2 >= ePLAYER_STATUS_EXT_MAX )
	{
		assert(NULL);
		return 0.0f;
	}

	return mExtStatusPlus[status2];
}


float cStatusCalc_Client::GetStatus2Per( ePLAYER_STATUS_EXT status2 )
{ 
	if( status2 >= ePLAYER_STATUS_EXT_MAX )
	{
		assert(NULL);
		return 0.0f;
	}

	return mExtStatusPer[status2];
}
