/* ==========================================================================
*      : TargetWindow.h
*      : 
*    : 谡
*    : 2006-11-28
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

class cLabel;
class cGauge;
class cEffectSceneNode;
class cBaseObject;
class cTargetBuff;
class cUIImage;

class cTargetWindow : public cUIWindow
{
public:
	cTargetWindow();
	virtual ~cTargetWindow();

	void UIStageIn();
	void UpdateWindow();
	void ClearBuff();
	
	///   ӵ 
	void SetHPGaugeSpeed( float s );

	/// Ÿ   
	void AddBuff( unsigned long uniqueIdx, unsigned long influenceIdx );
	void DelBuff( unsigned long uniqueIdx );
	void DelDeBuff( unsigned long uniqueIdx );

	///   
	void UpdateSize();

protected:
	/// ó
	virtual bool OnCreate( cUINodeProperty* pproperty );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender(cUIFontItemKeeper* pKeeper );
	virtual void OnRButtonUp( const cUIPos& pos );
	virtual void OnShow();
	virtual void OnHide();
	virtual void UpdateRect();
	virtual void UpdateSkin();

	/// Ÿ   
	void SetTargetInfo( char level, LPCTSTR name );
	void SetTargetEffect( cBaseObject* pObj );

protected:
	/// Ÿ ̸
	cLabel* mpTargetNameLabel;

	/// Ÿ 
	cLabel* mpTargetLevelLabel;

	/// Ÿ hp  Ʋ
	cGauge*	 mpHPGauge;

	bool		mShowHPImage;

	/// Ÿ Ʈ
	unsigned long		mTargetEffectIdx;
	cEffectSceneNode*	mpTargetEffect;

	/// Ÿ 
	cUINodeSkin*	mpNodeSkin;
	cUIImage*		mpBack;
	cTargetBuff*	mpTargetBuff;
	cUIRect			mpBuffRc;
};


////////////////////////////////////////////////////
/// Ÿ 
#include "PartyBuff.h"
#include "UITransformImage.h"

/// Ƽ  
class cTargetBuff : public cPartyBuff
{
public:
	cTargetBuff();
	virtual ~cTargetBuff();

protected:
	bool SetSkin(const cUINodeSkin* pskin );
	void UpdateSkin();
	void UpdateRect();
	void UpdateWindowSize();
};
