#include "stdafx.h"
#include "TarotCheckWindow.h"

#include "Tarot_Common.h"
#include "TarotWindow.h"
#include "Tarotmanager.h"
#include "NumberEditBox.h"

#include "Label.h"
#include "UIMsgboxEvent.h"

cTarotCheckWindow::cTarotCheckWindow()
: mpShopName(0)
, mpPrice(0)
, mpTotal(0)
, mpMain(0)
{
}

cTarotCheckWindow::~cTarotCheckWindow()
{
}

///
bool cTarotCheckWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMain = (cTarotWindow*)mpParent;

	mpShopName = (cLabel*)GetChild( eUIID_GAME_TAROTCHECK_SHOPNAME );
	mpPrice = (cLabel*)GetChild( eUIID_GAME_TAROTCHECK_PAY );
	mpTotal = (cLabel*)GetChild( eUIID_GAME_TAROTCHECK_TOTAL );

	cLabel* nameBack = (cLabel*)GetChild( eUIID_GAME_TAROTCHECK_NAMEBACKIMG );
	if( nameBack )
		nameBack->SetEnabled( false );

	cLabel* payBack = (cLabel*)GetChild( eUIID_GAME_TAROTCHECK_PAYIMG );
	if( payBack )
		payBack->SetEnabled( false );
	return true;
}

///
void cTarotCheckWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_TAROTCHECK_CANCEL:
		{
			/// 
			MSG_REQ_TAROT_SEEKER_CLOSE msg;
			msg.Category = NM_TAROT;
			msg.Protocol = NM_TAROT_SEEKER_CLOSE_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			if( mpMain )
				mpMain->NetLock( ePAGE_VIEW );
		}
		break;
	case eUIID_GAME_TAROTCHECK_START:
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_TAROTSEEKER_START, 
								GAMERESOURCEMAN->GetGameText( 314 ), // Ȯ ޼
								GAMERESOURCEMAN->GetGameText( 301 ), // ˸
								eSKIN_YESNO
								);
		}
		break;
	}
}

void cTarotCheckWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mpShopName )
		mpShopName->SetText( mpMain->GetTitle() );

	if( mpPrice )
	{
		LPCTSTR price = cNumberEditBox::FormatNumber( mpMain->GetPrice() );
		mpPrice->SetText( price );
	}

	if( mpTotal )
		mpTotal->SetValue( mpMain->GetCardTotalPoint() );
}

///
void cTarotCheckWindow::OnHide()
{
	cUIWindow::OnHide();

	if( mpShopName )
		mpShopName->Clear();
	if( mpPrice )
		mpPrice->SetValue(0);
}