#include "stdafx.h"
#include "TarotControlWindow.h"
#include "Label.h"
#include "TarotManager.h"
#include "NumberEditBox.h"
#include "UIMsgboxEvent.h"

cTarotControlWindow::cTarotControlWindow()
: mpShopName(0)
, mpPay(0)
, mpTarotCount(0)
, mpStuffNum(0)
, mpStatus(0)
, mpUserNum(0)
, mpMoney(0)
, mpPoint(0)
{
	mPrice = 0;
}

cTarotControlWindow::~cTarotControlWindow()
{
}

void cTarotControlWindow::Clear()
{
	if( mpShopName )
		mpShopName->Clear();
	if( mpPay )
		mpPay->SetValue(0);
	if( mpTarotCount )
		mpTarotCount->Clear();
	if( mpStuffNum )
		mpStuffNum->Clear();
	if( mpStatus )
		mpStatus->Clear();
	if( mpUserNum )
		mpUserNum->Clear();
	if( mpMoney )
		mpMoney->SetValue(0);
	if( mpPoint )
		mpPoint->Clear();

	mUserName.Clear();
}

void cTarotControlWindow::OnShow()
{
	cUIWindow::OnShow();
}

void cTarotControlWindow::OnHide()
{
	cUIWindow::OnHide();

	Clear();
}

///
bool cTarotControlWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpShopName = (cLabel*)GetChild( eUIID_GAME_TAROTCONTROL_SHOPNAME );
	mpPay = (cNumberEditBox*)GetChild( eUIID_GAME_TAROTCONTROL_PAY );
	mpTarotCount = (cLabel*)GetChild( eUIID_GAME_TAROTCONTROL_TAROTCOUNT );
	mpStuffNum = (cLabel*)GetChild( eUIID_GAME_TAROTCONTROL_STUFFNUM );
	mpStatus = (cLabel*)GetChild( eUIID_GAME_TAROTCONTROL_STATUS );
	mpUserNum = (cLabel*)GetChild( eUIID_GAME_TAROTCONTROL_USERNUM );
	mpMoney = (cNumberEditBox*)GetChild( eUIID_GAME_TAROTCONTROL_MONEY );
	mpPoint = (cLabel*)GetChild( eUIID_GAME_TAROTCONTROL_POINT );
	return true;
}

///
void cTarotControlWindow::OnCommand( cUINode*, unsigned int id )
{
	switch(id)
	{
	case eUIID_GAME_TAROTCONTROL_CLOSE:
	case eUIID_GAME_TAROTCONTROL_CLOSE2:
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_TAROTLEADER_EXIT, 
								GAMERESOURCEMAN->GetGameText( 313 ), // Ȯ ޼
								GAMERESOURCEMAN->GetGameText( 301 ), // 
								eSKIN_YESNO
								);
		}
		break;
	default:
		assert(0);
		break;
	}
}

///
void cTarotControlWindow::SetShopName( LPCTSTR name )
{
	if( mpShopName )
	{
		mpShopName->SetText( name );
	}
	else
	{
		assert(0);
	}
}

///
void cTarotControlWindow::SetPay( unsigned int pay )
{
	if( mpPay )
	{
		mpPay->SetValue( pay );
	}
	else
	{
		assert(0);
	}

	mPrice = pay;
}

///
void cTarotControlWindow::SetTarotCount( unsigned int count )
{
	/// ڿ  
	if( mpTarotCount )
	{
		mpTarotCount->SetValue( count );
	}
	else
	{
		assert(0);
	}
}

///
void cTarotControlWindow::SetStuffNum( unsigned int num )
{
	if( mpStuffNum )
	{
		mpStuffNum->SetValue( num );
	}
	else
	{
		assert(0);
	}
}

///
void cTarotControlWindow::SetStatus( LPCTSTR name )
{
	if( mpStatus == 0 )
	{
		assert(0);
		return;
	}

	mUserName = name;

	cStringT str;
	str.Format( GAMERESOURCEMAN->GetGameText( 317 ), name );
	mpStatus->SetText( (LPCTSTR)str.Cstr() );
}

///
void cTarotControlWindow::ReleaseStatus( LPCTSTR name )
{
	if( mpStatus )
        mpStatus->Clear();
}

///
void cTarotControlWindow::SetUserNum( unsigned int num )
{
	if( mpUserNum )
	{
		mpUserNum->SetValue( num );
	}
	else
	{
		assert(0);
	}

	SetMoney( mPrice * num );
}

///
void cTarotControlWindow::SetMoney( unsigned int money )
{
	if( mpMoney )
	{
		mpMoney->SetValue( money );
	}
	else
	{
		assert(0);
	}
}

///
void cTarotControlWindow::SetPoint( unsigned int point )
{
	if( mpPoint )
	{
		mpPoint->SetValue( point );
	}
	else
	{
		assert(0);
	}
}
