#include "stdafx.h"
#include "TarotManager.h"
#include "ItemManager.h"
#include "GameUIManager.h"
#include "UIImage.h"
#include "CardImage.h"
#include "TarotWindow.h"
#include "TarotControlWindow.h"
#include "UIMsgboxEvent.h"
#include "GameResourceManager.h"
#include "ChatManager.h"

#include "UIManager.h"

#include "ObjectManager.h"
#include "Hero.h"

#define TAROT_PARAMS_FILENAME		"./Script/Interface/Path_Tarot.txt"
#define NPCTAROT_SPREAD_FILE		"./Script/Resource/NpcTarot_Spread.txt"
#define NPCTAROT_CARD_FILE			"./Script/Resource/NpcTarot_Card.txt"
#define NPCTAROT_COMMENT_FILE		"./Script/Resource/NpcTarot_Comment.txt"

cTarotManager*	cTarotManager::mSingleton = 0;

cTarotManager::cTarotManager()
{	
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;

	mCurrentPage = ePAGE_NONE;
}

cTarotManager::~cTarotManager()
{
	mSingleton = 0;

	/// Ÿ ̹ Ķ
	{
		cTarotParamMap::cIterator i = mTarotParamMap.Begin();
		cTarotParamMap::cIterator end = mTarotParamMap.End();

		for( ; i != end; ++i )
		{
			delete (cCardParam*)(i->mSecond);
		}
		mTarotParamMap.Clear();
	}
	/// 
	{
		cNpcSpreadMap::cIterator i = mNpcSpreadMap.Begin();
		cNpcSpreadMap::cIterator end = mNpcSpreadMap.End();
		for( ; i != end; ++i )
		{
			sNpcSpread* p = (sNpcSpread*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcSpreadMap.Clear();
	}
	/// npc ī 
	{
		cNpcDeckMap::cIterator i = mNpcDeckMap.Begin();
		cNpcDeckMap::cIterator end = mNpcDeckMap.End();
		for( ; i != end; ++i )
		{
			sNpcTarotDeck* p = (sNpcTarotDeck*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcDeckMap.Clear();
	}

	/// npc ī
	{
		cNpcTarotMap::cIterator i = mNpcTarotMap.Begin();
		cNpcTarotMap::cIterator end = mNpcTarotMap.End();
		for( ; i != end; ++i )
		{
			sNpcTarotCard* p = (sNpcTarotCard*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcTarotMap.Clear();
	}

	/// ؼ 
	{
		cNpcCommentMap::cIterator i = mNpcCommentMap.Begin();
		cNpcCommentMap::cIterator end = mNpcCommentMap.End();
		for( ; i != end; ++i )
		{
			sNpcTarotComment* p = (sNpcTarotComment*)(i->mSecond);
			SAFE_DELETE( p );
		}
		mNpcCommentMap.Clear();
	}

	///  Ÿ ε
	ClearCardinfo();

	/// Ÿ ε 
	mIndexArr.Clear();
}

///
void cTarotManager::Clear()
{
	/// ο  ۵Ǳ  Ŭ 
	///  Ÿ ε
	ClearCardinfo();

	/// Ÿ ε 
	mIndexArr.Clear();
}

///
bool cTarotManager::Init()
{
	/// Ÿ ̹ ũƮ ε
	if( LoadTarotParams( TAROT_PARAMS_FILENAME) == false )
	{
		assert( 0 && "failed to load tarot params file" );
		return false;
	}
	///   ε
	if( LoadNpcSpread( NPCTAROT_SPREAD_FILE ) == false )
	{
		assert( 0 && "failed to load npc spread" );
		return false;
	}

	/// ī   ε
	if( LoadTarotDeck( NPCTAROT_CARD_FILE ) == false )
	{
		assert( 0 && "failed to load tarot deck" );
		return false;
	}

	/// ؼ  ε
	if( LoadComment( NPCTAROT_COMMENT_FILE ) == false )
	{
		assert( 0 && "failed to load tarot comment" );
		return false;
	}
	return true;
}

void cTarotManager::ReadyReaderTarotNet()
{
	/// ̹ Ÿ԰â  
	if( IsUsingTarot() )
		return;

	unsigned int error = TAROTMAN->CheckingOpenTarot();
	if( error != ERROR_NONE )
	{
		TAROTMAN->ShowErrorMsg( error );
		return;
	}

	if( HERO->IsRideVehicle() == true )
	{
		MSGROOT msg;
		::memset( &msg, 0, sizeof(msg) );
		msg.Category = NM_PLAYER;
		msg.Protocol = NM_PLAYER_VEHICLE_END_REQ;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		HERO->AlightVehicle();
	}

	/// tarot غ ˸
	MSG_REQ_TAROT_READER_READY msg;
	msg.Category = NM_TAROT;
	msg.Protocol = NM_TAROT_READER_READY_REQ;
	NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
}

unsigned int cTarotManager::CheckingOpenTarot()
{
	///  üũ
	unsigned int count = ITEMMAN->GetItemCount( TAROT_MATERIAL_ITEM );
	if( count == 0 )
		return ERROR_STUFF;

	///  üũ
	unsigned int spreadCount = 0;
	for( unsigned int i = 0; i<5; i++ )
	{
		cItem& item = ITEMMAN->GetItem( INVENTORY_SPREAD_BEGIN + i );
		unsigned int spreadIdx = item.GetIndex();
		if( spreadIdx == 0 )
			continue;	

		cItemDefine* spreadDefine = ITEMMAN->GetItemDefine( spreadIdx );
		if( !spreadDefine )
		{
			assert(0);
			continue;
		}

		unsigned char type = spreadDefine->GetType();
		if( type != ITEM_SPREAD )
			continue;

		spreadCount++;
	}
	if( spreadCount == 0 )
		return ERROR_SPREAD;

	/// ī üũ
	for( unsigned int i=0; i<22; i++ )
	{
		/// ŸԽԿ ִ  ε ȹ
		cItem& item = ITEMMAN->GetItem( INVENTORY_TAROT_BEGIN + i );
		unsigned int itemIdx = item.GetIndex();
		if( itemIdx == 0 )
			return ERROR_CARD;

		unsigned char subType = item.GetDefine()->GetSubType();
		if( subType != ITEM_CARD_TAROT )
			return ERROR_CARD;

		cItemTarot* pTarot = item.GetDefine()->GetTarotDefine();
		if( pTarot == 0 )
			return ERROR_CARD;

		if( pTarot->GetUniqueNumber() != i )
			return ERROR_CARD;
	}

	return ERROR_NONE;
}

///
void cTarotManager::ClearCardinfo()
{
	for( unsigned int i = 0; i < mSelectInfoArr.GetSize(); ++i )
	{
		sResultInfo* info = (sResultInfo*)mSelectInfoArr[i];
		SAFE_DELETE( info );
	}
	mSelectInfoArr.Clear();
}

///
void cTarotManager::NetworkMsgParser( char* msg )
{
	MSGROOT* tempMsg = (MSGROOT*)msg;

	switch( tempMsg->Protocol )
	{
	case NM_TAROT_READER_READY_RES:
		{
			/// Ÿī غ  û 
			MSG_RES_TAROT_READER_READY* pMsg = (MSG_RES_TAROT_READER_READY*)msg;

			switch( pMsg->ErrorCode )
			{
			case ERROR_TAROT_READER_READY_SUCCESS:
				{
					if( mCurrentPage == ePAGE_NONE )
					{
						HERO->SetStopFlag( eSTOP_READYTAROT );
						ChangePage( ePAGE_OPEN );
					}
					else
					{
						assert(0);
					}
				}
				break;
			case ERROR_TAROT_READER_READY_FAIL:
				{
					/// 
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_NONE, 
										GAMERESOURCEMAN->GetGameText( 308 ),	//  ޼
										GAMERESOURCEMAN->GetGameText( 301 ),	// 
										eSKIN_OK
										);
//					ChangePage( ePAGE_NONE );
				}
				break;
			}
		}
		break;
	case NM_TAROT_READER_READY_SYN:
		{	
			/// ٸ Ÿī غ 
			MSG_SYN_TAROT_READER_READY* pMsg = (MSG_SYN_TAROT_READER_READY*)msg;

			cPlayer* p = OBJECTMAN->GetPlayer( pMsg->mCharacterIdx );
			if( p )
			{
				p->SetStopFlag( eSTOP_READYTAROT );
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_TAROT_READER_OPEN_RES:
		{
			///   
			MSG_RES_TAROT_READER_OPEN* msgData = (MSG_RES_TAROT_READER_OPEN*)msg;

			switch( msgData->ErrorCode )
			{
			case ERROR_TAROT_READER_OPEN_SUCCESS:
				{
					cTarotControlWindow* win = GAMEUI->GetTarotControlWindow();
					if( win)
					{
						win->SetPay( msgData->Price );
						win->SetPoint( msgData->Point );
						win->SetShopName( msgData->strTitle );
						win->SetMoney( 0 );
						win->SetUserNum( 0 );
						win->SetStuffNum( ITEMMAN->GetItemCount( TAROT_MATERIAL_ITEM ) );
					}
					else
					{
						assert(0);
					}

					HERO->SetStopFlag( eSTOP_OPENTAROT );
					ChangePage( ePAGE_MANAGED );

//					/// hero ǳ ٲֱ
					HERO->ActiveTarotBubble( (LPTSTR)msgData->strTitle, eCOLOR_SKYBLUE );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 319 ) );
				}
				break;;
			case ERROR_TAROT_READER_OPEN_CARD:
				{
					/// ī 
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_NONE, 
										GAMERESOURCEMAN->GetGameText( 302 ),	// ī ޼
										GAMERESOURCEMAN->GetGameText( 301 ), // 
										eSKIN_OK
										);
				}
				break;
			case ERROR_TAROT_READER_OPEN_SPREAD:
				{
					///  
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_NONE, 
										GAMERESOURCEMAN->GetGameText( 303 ),	//  ޼
										GAMERESOURCEMAN->GetGameText( 301 ), // 
										eSKIN_OK
										);
				}
				break;
			case ERROR_TAROT_READER_OPEN_ITEM:
				{
					///  
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_NONE, 
										GAMERESOURCEMAN->GetGameText( 307 ),	//  ޼
										GAMERESOURCEMAN->GetGameText( 301 ), // 
										eSKIN_OK
										);
				}
				break;
			case ERROR_TAROT_READER_OPEN_FAIL:
				{
					///  
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_NONE, 
										GAMERESOURCEMAN->GetGameText( 308 ),	//  ޼
										GAMERESOURCEMAN->GetGameText( 301 ), // 
										eSKIN_OK
										);
				}
				break;
			}
		}
		break;
	case NM_TAROT_READER_OPEN_SYN:
		{
			///   /   Ŭ 
			MSG_SYN_TAROT_READER_OPEN* msgData = (MSG_SYN_TAROT_READER_OPEN*)msg;

			cPlayer* p = OBJECTMAN->GetPlayer( msgData->mCharacterIdx );
			if( p )
			{
				p->SetState( eOBJECT_STATE_STOP );
				p->SetStopFlag( eSTOP_OPENTAROT );
				p->ActiveTarotBubble( msgData->mTitle, eCOLOR_SKYBLUE );
			}
		}
		break;
	case NM_TAROT_READER_CLOSE_RES:
		{
			///  -  ݱ 
			MSG_RES_TAROT_READER_CLOSE* msgData = (MSG_RES_TAROT_READER_CLOSE*)msg;

			switch( msgData->ErrorCode )
			{
			case ERROR_TAROT_READER_CLOSE_SUCCESS:
				{
					ChangePage( ePAGE_NONE );

					/// ̸ â ݱ
					GAMEUI->HideTarotControlWindow();

					///
					HERO->DeActiveTarotBubble();
					HERO->StandUp();

					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 320 ) );
				}
				break;
			case ERROR_TAROT_READER_CLOSE_FAIL:
				{
					///  
					UIMAN->CreateModal(	eStage_Game,
										eMBEVENT_NONE, 
										GAMERESOURCEMAN->GetGameText( 309 ),	//  ޼
										GAMERESOURCEMAN->GetGameText( 301 ), // 
										eSKIN_OK
										);
				}
				break;
			case 2:
				{
					ChangePage( ePAGE_NONE );

					/// ̸ â ݱ
					GAMEUI->HideTarotControlWindow();

					///
					HERO->DeActiveTarotBubble();
					HERO->StandUp();

					///  ó ؾߵ.
					/// CHATMANAGER->AddSystemMsg( GAMERESOURCEMAN->GetGameText( 320 ) );
				}
			}

			cTarotControlWindow* win = GAMEUI->GetTarotControlWindow();
			if( win )
				win->NetUnLock();
		}
		break;
	case NM_TAROT_SEEKER_OPEN_RES:
		{
			/// ʱȭ
			Clear();

			/// Ÿ̿ - ̿ Ұ
			if( mCurrentPage != ePAGE_NONE )
			{
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 310 ),	//  ޼
					GAMERESOURCEMAN->GetGameText( 301 ),	// 
					eSKIN_OK
					);

				return;
			}

			cTarotWindow* win = GAMEUI->GetTarotWindow();
			if( win == 0 )
			{
				assert(0);
				return;
			}

			/// Ÿ   ޱ 
			MSG_RES_TAROT_SEEKER_OPEN* msgData = (MSG_RES_TAROT_SEEKER_OPEN*)msg;
			if( msgData->ErrorCode != ERROR_TAROT_SEEKER_OPEN_SUCCESS )
			{
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 310 ),	//  ޼
					GAMERESOURCEMAN->GetGameText( 301 ),	// 
					eSKIN_OK
					);
				return;
			}

			win->SetTitle( msgData->Title );
			win->SetPrice( msgData->Price );

			///  ī ε  
			for( int i = 0; i < 22; ++i )
			{
				unsigned int cardIndex = msgData->TarotCardIndex[i];
				if( cardIndex )
				{
					/// 쿡 ī  
					mIndexArr.PushBack( cardIndex );
					win->SetCardInfo( i, cardIndex, (i == 0) );
				}
				else
				{
					assert(0);
				}
			}

			///  ε  
			for( int i = 0; i < 5; ++i )
			{
				unsigned int spreadIndex = msgData->SpreadIndex[i];
				if( spreadIndex )
					win->SetSpreadInfo( i, spreadIndex );
			}

			HERO->SetStopFlag( eSTOP_ENTERTAROT );
			ChangePage( ePAGE_VIEW );
		}
		break;
	case NM_TAROT_SEEKER_CLOSE_RES:
		{
			///   
			MSG_RES_TAROT_SEEKER_CLOSE* msgData = (MSG_RES_TAROT_SEEKER_CLOSE*)msg;

			/// tarot state
			if( msgData->ErrorCode == ERROR_TAROT_SEEKER_CLOSE_SUCCESS )
			{
				HERO->SetState( eOBJECT_STATE_IDLE );
				ChangePage( ePAGE_NONE );
			}
			else if( msgData->ErrorCode == ERROR_TAROT_SEEKER_CLOSE_READER )
			{
				///  Ͽ   
				HERO->SetState( eOBJECT_STATE_IDLE );
				ChangePage( ePAGE_NONE );

				UIMAN->CreateModal(	eStage_Game,
									eMBEVENT_NONE, 
									GAMERESOURCEMAN->GetGameText( 318 ), //    ˸
									GAMERESOURCEMAN->GetGameText( 301 ), // 
									eSKIN_OK );
			}
			else if( msgData->ErrorCode == ERROR_TAROT_SEEKER_CLOSE_FAIL )
			{
				/// 
				UIMAN->CreateModal(	eStage_Game,
									eMBEVENT_NONE, 
									GAMERESOURCEMAN->GetGameText( 309 ), //  ޼
									GAMERESOURCEMAN->GetGameText( 301 ), // 
									eSKIN_OK );

				cTarotWindow* win = GAMEUI->GetTarotWindow();
				if( win )
				{
					win->NetUnLock(ePAGE_VIEW);
					win->NetUnLock(ePAGE_SELECT);
					win->NetUnLock(ePAGE_RESULT);
				}
			}
		}
		break;
	case NM_TAROT_SEEKER_JOIN_RES:
		{
			ClearCardinfo();

/// tarot state

			///   û   
			MSG_RES_TAROT_SEEKER_JOIN* msgData = (MSG_RES_TAROT_SEEKER_JOIN*)msg;

			if ( msgData->ErrorCode == ERROR_TAROT_SEEKER_JOIN_SUCCESS )
			{
				HERO->SetStopFlag( eSTOP_USETAROT );
				ChangePage( ePAGE_SELECT );

				///   û 
				for( int i = 0; i < 10; ++i )
				{
					unsigned int cardIndex = msgData->TarotCardIndex[i];

					sResultInfo* result = new sResultInfo;
					result->TarotCardIndex = cardIndex;
					result->Dir = TAROT_SEEKER_RESULT_STRAIGHT;
					result->Value = 0;
					result->Apply = false;
					mSelectInfoArr.PushBack( result );
				}
			}
			else
			{
				//---   óؾ
				/// ̿ݺ
				/// ̿Ҽ  
				/// ٸĳͰ ̿

				///   û 
				UIMAN->CreateModal(	eStage_Game,
					eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 310 ), //  ޼
					GAMERESOURCEMAN->GetGameText( 301 ), // 
					eSKIN_OK );

				cTarotWindow* win = GAMEUI->GetTarotWindow();
				assert(win);
				win->NetUnLock(ePAGE_VIEW);
			}
		}
		break;
	case NM_TAROT_SEEKER_RESULT_RES:
		{
			///  ÿϷῡ  
			MSG_RES_TAROT_SEEKER_RESULT* msgData = (MSG_RES_TAROT_SEEKER_RESULT*)msg;
			cTarotWindow* win = GAMEUI->GetTarotWindow();
			assert(win);

			win->NetUnLock( ePAGE_SELECT );
			win->SetSelectedSpread( msgData->SpreadIndex );

			cItemSpread* spread = win->GetCurrentSpreadInfo();
			if( spread == 0 )
			{
				assert(0);
				return;
			}

			for( int i = 0; i < 10; ++i )
			{
				sResultInfo* result = GetSelectCardInfo( i );
				assert( result );

				result->Dir = msgData->Result[i].Dir;
				result->Value = msgData->Result[i].Value;
				result->Apply = false;

				if( ( spread->mParam[i].mDir == eSPREAD_STR && result->Dir == TAROT_SEEKER_RESULT_STRAIGHT ) ||
					( spread->mParam[i].mDir == eSPREAD_INV && result->Dir == TAROT_SEEKER_RESULT_INVERSE ) || 
					( spread->mParam[i].mDir == eSPREAD_ALL ) )
				{
					result->Apply = true;
				}
			}

			msgData->ResultValue;
			ChangePage( ePAGE_RESULT );
		}
		break;
	case NM_TAROT_SEEKER_ACCEPT_RES:
		{
			/// tarot state
			HERO->SetState( eOBJECT_STATE_IDLE );
			ChangePage( ePAGE_NONE );
		}
		break;
	case NM_TAROT_READER_CLOSE_SYN:
		{
			/// ٸ ŸԻ .
			MSG_SYN_TAROT_READER_CLOSE* msgData = (MSG_SYN_TAROT_READER_CLOSE*)msg;
			cPlayer* p = OBJECTMAN->GetPlayer( msgData->mCharacterIdx );
			if( p )
			{
				///  üũ
				if( p->GetState() != eOBJECT_STATE_STOP )
				{
					assert(0);
				}
				if( p->GetStopFlag() != eSTOP_READYTAROT && 
					p->GetStopFlag() != eSTOP_OPENTAROT )
				{
					assert(0);
				}

				p->SetStopFlag( eSTOP_NONE );
				p->DeActiveTarotBubble();
				p->StandUp();
			}
		}
		break;
	case NM_TAROT_READER_JOIN_RES:
		{
			/// ̿ .
			MSG_RES_TAROT_READER_JOIN* msgData = (MSG_RES_TAROT_READER_JOIN*)msg;

			cTarotControlWindow* pCotrol = GAMEUI->GetTarotControlWindow();
			if( pCotrol )
			{
				pCotrol->SetStatus( msgData->seekerName );
				pCotrol->SetPoint( msgData->point );
				pCotrol->SetUserNum( msgData->userCount );
				pCotrol->SetStuffNum( ITEMMAN->GetItemCount( TAROT_MATERIAL_ITEM ) );
			}
			else
			{
				assert(0);
			}
		}
		break;
	case NM_TAROT_READER_LEAVE_RES:
		{
			///̿ 
			MSG_RES_TAROT_READER_LEAVE* msgData = (MSG_RES_TAROT_READER_LEAVE*)msg;

			cTarotControlWindow* pCotrol = GAMEUI->GetTarotControlWindow();
			if( pCotrol )
				pCotrol->ReleaseStatus( msgData->seekerName );
			else
			{
				assert(0);
			}
		}
		break;
	default:
		assert( 0 && "error network message" );
		break;
	}
}

void cTarotManager::ChangePage( eTarotPage page )
{
	if( mCurrentPage == page)
		return;

	switch( page )
	{
	case ePAGE_NONE:
	case ePAGE_OPEN:
	case ePAGE_VIEW:
	case ePAGE_SELECT:
	case ePAGE_RESULT:
	case ePAGE_NPCVIEW:
	case ePAGE_NPCSELECT:
	case ePAGE_NPCRESULT:
		{
			GAMEUI->ShowTarotWindow( page );
		}
		break;
	case ePAGE_MANAGED:
		{
			/// Ÿ   
			GAMEUI->ShowTarotControlWindow();
		}
		break;
	}

	mCurrentPage = page;
}

void cTarotManager::ShowErrorMsg( int error )
{
	switch( error )
	{
	case ERROR_CARD:
		{
			/// ī尡 .
			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 302 ),	// Ÿī  ޼
				GAMERESOURCEMAN->GetGameText( 301 ),	// 
				eSKIN_OK
				);
		}
		break;
	case ERROR_SPREAD:
		{
			/// 尡 
			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 303 ),	//   ޼
				GAMERESOURCEMAN->GetGameText( 301 ),	// 
				eSKIN_OK
				);
		}
		break;
	case ERROR_PRICE:
		{
			/// ݼ
			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 304 ),	// ݼ ޼
				GAMERESOURCEMAN->GetGameText( 301 ),	// 
				eSKIN_OK
				);
		}
		break;
	case ERROR_TITLE:
		{
			/// 
			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 305 ),	//  ޼
				GAMERESOURCEMAN->GetGameText( 301 ),	// 
				eSKIN_OK
				);
		}
		break;
	case ERROR_STUFF:
		{
			/// ݼ
			UIMAN->CreateModal(	eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 308 ),	//  ޼
				GAMERESOURCEMAN->GetGameText( 301 ),	// 
				eSKIN_OK
				);
		}
		break;
	}
}
