/* ==========================================================================
*      : TarotManager.h
*      : 
*    : 谡
*    : 2007-07-30
* ǻ :
*===========================================================================*/
#pragma once
#include "Tarot_Common.h"

enum eTarotPage
{
	ePAGE_NONE = 0,
	ePAGE_OPEN,
	ePAGE_MANAGED,
	ePAGE_VIEW,
	ePAGE_SELECT,
	ePAGE_RESULT,

	ePAGE_NPCVIEW,		/// NPC  
	ePAGE_NPCSELECT,	/// NPC  ī 
	ePAGE_NPCRESULT,	/// NPC  
};

enum
{
	ERROR_NONE = 0, 

	ERROR_CARD,		/// ī 
	ERROR_SPREAD,	///  
	ERROR_PRICE,	///  
	ERROR_TITLE,	/// 
	ERROR_STUFF, 
};

enum
{
	eSPREAD_ALL = 0,
	eSPREAD_STR,
	eSPREAD_INV,
};


///
struct sResultInfo
{
	TAROT_SEEKER_RESULT_DIRECTION	Dir;			// Ÿī 
	unsigned long					TarotCardIndex;	//   ε
	unsigned long                   Value;			// Ÿī ( )
	bool							Apply;			//
};

///  
enum eNpcTarotPage
{
	eNPCPAGE_NONE = 0,
	eNPCPAGE_CHECK,
	eNPCPAGE_SELECT,
	eNPCPAGE_RESULT,
};

// Ӽ
enum eFortuneProp
{
	eFORTUNE_LOVE,	// 
	eFORTUNE_HEALTH,// ǰ
	eFORTUNE_WORK,	// 
	eFORTUNE_MONEY,	// 繰
	eFORTUNE_LUCK,	// 

	eFORTUNE_NONE,
};

// ġ Ӽ
enum ePositionProp
{
	ePOS_FIRST,		// ù°
	ePOS_SECOND,	// ι°
	ePOS_THIRD,		// °

	ePOS_NONE,
};

struct sNpcSpreadParam
{
	short mX, mY;			/// ǥ
	short mPositionProp;	/// ġ Ӽ
	long mQuestionIdx;		///  ε
};

// npc  Ӽ
struct sNpcSpread
{
	sNpcSpreadParam		mParam[MAX_NPCSPREAD_COUNT];	
	unsigned int		mCount;					/// ִ   
	short				mFortuneProp;			///  Ӽ

	sNpcSpread()
	{
		memset( mParam, 0, sizeof(mParam) );
		mCount = 0;
	}
};

/// npc Ÿī
struct sNpcTarotCard
{
	unsigned int	mImageIndex;
	short			mNumber;			/// ȣ( 0 ~ 21 )
	unsigned long	mStraightIdx;		///   ε 
	unsigned long	mInverseIdx;		///   ε	
	unsigned long	mCommnetIndex;		/// ؼ ε
};

// npc Ÿī 
struct sNpcTarotDeck
{
	unsigned long mCard[MAX_TAROT_CARDS];	/// ī ε

	sNpcTarotDeck()
	{
		memset( mCard, 0, sizeof(mCard) );
	}
};

// Ÿī ؼ
struct sNpcTarotComment
{
	unsigned long mComment[5][3][2][3]; /// [Ӽ][ġӼ][][ؼ] = ؼȣ

	sNpcTarotComment()
	{
		memset( mComment, 0, sizeof(mComment) );
	}
};

/// Ÿī  ִ ִ +ī ġ
const int MAX_TAROTVALUE = 200;

class cUIImage;
class cCardParam;
class cTarotManager
{
public:
	static cTarotManager*	mSingleton;
    
public:
	cTarotManager();
	~cTarotManager();

	/// ʱȭ
	bool Init();
	void Clear();

	void ChangePage( eTarotPage page );

	bool IsUsingTarot();
	void ReadyReaderTarotNet();
	unsigned int CheckingOpenTarot();

	void ShowErrorMsg( int error );

	/// Ʈũ ޽
	void NetworkMsgParser( char* msg );

	///   Ÿ  ε ȹ (  : 迭ε, :  ε )
	unsigned int GetTarotIndex( unsigned int arrayidx );

	/// ̿ڰ  ī ε ȹ(  : 迭ε,  : īε, ī )
	sResultInfo* GetSelectCardInfo( unsigned int arrayidx );

	/// Ÿ̹Ķ (ش   ̹ ȹ)
	cCardParam* GetTarotParam( unsigned int itemIdx );

	/// ũƮ ε Ÿ ̹ Ķ ȹ
	cCardParam* GetImageParam( unsigned int imgIndex );

	inline eTarotPage	GetCurrentPage() { return mCurrentPage; }

	sNpcSpread* GetNpcSpread( unsigned long spreadIdx );
	sNpcTarotDeck* GetNpcTarotDeck( unsigned long deckIdx );
	sNpcTarotCard* GetNpcTarot( unsigned long cardIdx );
	sNpcTarotComment* GetNpcTarotComment( unsigned long commentIdx );

protected:
	/// ũƮ ε
    bool LoadTarotParams( const cString& pathName );
	bool LoadNpcSpread( const cString& path );
	bool LoadTarotDeck( const cString& path );
	bool LoadComment( const cString& path );
	void ClearCardinfo();

public:
	static cTarotManager* GetSingleton();

protected:
	///   (sNpcSpread)
	typedef tPointerHashMap<unsigned long, void*> cNpcSpreadMap;
	cNpcSpreadMap	mNpcSpreadMap;

	/// ī   (sNpcTarotDeck)
	typedef tPointerHashMap<unsigned long, void*> cNpcDeckMap;
	cNpcDeckMap		mNpcDeckMap;

	/// Ÿ ī  (sNpcTarotCard)
	typedef tPointerHashMap<unsigned long, void*> cNpcTarotMap;
	cNpcTarotMap	mNpcTarotMap;

	/// ؼ  (sNpcTarotComment)
	typedef tPointerHashMap<unsigned long, void*> cNpcCommentMap;
	cNpcCommentMap		mNpcCommentMap;

protected:
	/// Ÿī ؽ
	typedef tHashMap<unsigned int, void*> cTextureMap;
	cTextureMap mTarotTextureMap;

	/// Ÿī ̹ Ķ
	typedef tHashMap<unsigned int, void*> cTarotParamMap;
	cTarotParamMap mTarotParamMap;

	///  Ÿ   ()
	typedef tArray<unsigned int> cIndexArr;
	cIndexArr mIndexArr;

	/// õ Ÿī ε (̿) (sTarotResult)
	typedef tArray<void*> cSelectInfoArr;
	cSelectInfoArr mSelectInfoArr;
	
	///
	eTarotPage			mCurrentPage;
};

inline unsigned int cTarotManager::GetTarotIndex( unsigned int arrayidx )
{
	if( arrayidx >= mIndexArr.GetSize() )
	{
		return 0;
	}

	return mIndexArr[arrayidx];
}

inline sResultInfo* cTarotManager::GetSelectCardInfo( unsigned int arrayidx )
{
	if( arrayidx >= mSelectInfoArr.GetSize() )
	{
		return 0;
	}

	return (sResultInfo*)mSelectInfoArr[arrayidx];
}

inline bool cTarotManager::IsUsingTarot()
{
	return (mCurrentPage != ePAGE_NONE);
}


inline cTarotManager* cTarotManager::GetSingleton()
{
	return mSingleton;
}

#define TAROTMAN cTarotManager::GetSingleton()