#include "stdafx.h"
#include "TarotOpenWindow.h"

#include "Tarot_Common.h"
#include "TarotWindow.h"

#include "Label.h"
#include "NumberEditBox.h"
#include "MultiEditBox.h"
#include "TarotManager.h"

#include "ItemManager.h"

#include "ObjectManager.h"
#include "Hero.h"

cTarotOpenWindow::cTarotOpenWindow()
: mpTotal(0)
, mpTarotCount(0)
, mpStuffNum(0)
, mpPrice(0)
, mpName(0)
, mpMain(0)
{
}

cTarotOpenWindow::~cTarotOpenWindow()
{
}

///
bool cTarotOpenWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMain = (cTarotWindow*)mpParent;

	mpTotal = (cLabel*)GetChild( eUIID_GAME_TAROTOPEN_TOTAL );
	mpTarotCount = (cLabel*)GetChild( eUIID_GAME_TAROTOPEN_TAROTCOUNT );
	mpStuffNum = (cLabel*)GetChild( eUIID_GAME_TAROTOPEN_STUFFNUM );
	mpPrice = (cNumberEditBox*)GetChild( eUIID_GAME_TAROTOPEN_PRICE );
	mpName = (cMultiEditBox*)GetChild( eUIID_GAME_TAROTOPEN_NAME );
	return true;
}

///
void cTarotOpenWindow::OnCommand( cUINode*, unsigned int id )
{
	if( !mpPrice || !mpName )
		return;

	switch( id )
	{
	case eUIID_GAME_TAROTOPEN_CANCEL:
		{
			MSG_REQ_TAROT_READER_CLOSE msg;
			msg.Category = NM_TAROT;
			msg.Protocol = NM_TAROT_READER_CLOSE_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			if( mpMain )
				mpMain->NetLock( ePAGE_OPEN );
		}
		break;
	case eUIID_GAME_TAROTOPEN_OPEN:
		{
			///   û ޼
			if( mpPrice->GetValue() == 0 )
			{	
				TAROTMAN->ShowErrorMsg( ERROR_PRICE );
				return;
			}

			if( mpName->GetLength() == 0 )
			{
				TAROTMAN->ShowErrorMsg( ERROR_TITLE );
				return;
			}

			///   ִ  üũ..
			unsigned int error = TAROTMAN->CheckingOpenTarot();
			if( error != ERROR_NONE )
			{
				TAROTMAN->ShowErrorMsg( error );
				return;
			}

			///   
			MSG_REQ_TAROT_READER_OPEN msg;
			msg.Category = NM_TAROT;
			msg.Protocol = NM_TAROT_READER_OPEN_REQ;

			assert(mpName->GetLength() < MAX_TEXT_LENGTH);
			Sstrncpy( msg.strTitle, MAX_TEXT_LENGTH, mpName->GetText(), mpName->GetLength() );
			msg.Price = mpPrice->GetValue();
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	}
}

void cTarotOpenWindow::OnHide()
{
	cUIWindow::OnHide();
	
	if( mpTotal )
		mpTotal->Clear();
	if( mpTarotCount )
		mpTarotCount->Clear();
	if( mpStuffNum )
		mpStuffNum->Clear();
	if( mpPrice )
		mpPrice->Clear();
	if( mpName )
		mpName->Clear();
}

///
void cTarotOpenWindow::OnShow()
{
	cUIWindow::OnShow();

	SetEnabled( true );


	SetTotalValue( mpMain->GetCardTotalPoint() );
	SetStuffNum( ITEMMAN->GetItemCount( TAROT_MATERIAL_ITEM ) );

	/// ŸƲ Ŀ
	if( mpName )
		mpName->SetFocus();

	if( mpPrice )
		mpPrice->SetAllSelect();
}

///
void cTarotOpenWindow::SetTarotCount( unsigned int count, unsigned int total )
{
	if( mpTarotCount )
	{
		/// ڿ  
		cStringT str;
		str.Format( _T("%d / %d"), count, total );
		mpTarotCount->SetText( (LPCTSTR)str.Cstr() );
	}
	else
		assert( 0 );
}

///
void cTarotOpenWindow::SetStuffNum( unsigned int num )
{
	if( mpStuffNum )
	{
		mpStuffNum->SetValue( num );
	}
	else
	{
		assert(0);
	}
}

///
void cTarotOpenWindow::SetTotalValue( unsigned int total )
{
	if( mpTotal )
	{
		mpTotal->SetValue( total );
	}
	else
	{
		assert(0);
	}
}