#include "stdafx.h"
#include "TarotResultWindow.h"
#include "TarotWindow.h"
#include "TarotManager.h"
#include "UIImage.h"
#include "UIImageFont.h"
#include "Label.h"
#include "Button.h"
#include "Gauge.h"
#include "ItemDefine.h"

cTarotResultWindow::cTarotResultWindow()
: mpDescription(0)
, mpOpenTotal(0)
, mpResultGauge(0)
, mpRightBtn(0)
, mpUpBtn(0)
, mpResult(0)
, mpMain(0)
{
	for( unsigned int i=0; i<10; i++ )
		mpOpenValue[i] = 0;
}

cTarotResultWindow::~cTarotResultWindow()
{
}

///
bool cTarotResultWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMain = (cTarotWindow*)mpParent;

	for( unsigned int i = 0; i < 10; i++ )
		mpOpenValue[i] = (cLabel*)GetChild( eUIID_TAROTRESULT_OPENTXT1 + i );

	mpResultGauge = (cGauge*)GetChild( eUIID_TAROTRESULT_GAUGE );
	mpDescription = (cLabel*)GetChild( eUIID_GAME_TAROTRESULT_DESCRIPTION );
	mpOpenTotal = (cLabel*)GetChild( eUIID_GAME_TAROTRESULT_OPENTOTAL );
	mpRightBtn = (cButton*)GetChild( eUIID_GAME_TAROTRESULT_RIGHT );
	mpUpBtn = (cButton*)GetChild( eUIID_GAME_TAROTRESULT_UP );
	mpResult = (cButton*)GetChild( eUIID_GAME_TAROTRESULT_RESULT );

	if( mpResult )
		mpResult->SetEnabled( false );

	cLabel* descBack = (cLabel*)GetChild( eUIID_TAROTRESULT_DESCBACKIMG );
	if( descBack )
		descBack->SetEnabled( false );
	return true;
}

///
void cTarotResultWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();
	UpdateButton();
}

///
void cTarotResultWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	///
	cUIWindow::OnRender( pKeeper );

	if( mpMain == 0 )
		return;

	cItemSpread* spread = mpMain->GetCurrentSpreadInfo();
	if( spread  )
	{
		for( unsigned int i=0; i<10; i++ )
		{
			unsigned int x = spread->mParam[i].mX + mpMain->GetAbsoluteRect().mLeft;
			unsigned int y = spread->mParam[i].mY + mpMain->GetAbsoluteRect().mTop;

			cString IndexStr;
			IndexStr.Format( "%d", i + 1 );
			cUIImageFont* pImageFont = UIMAN->GetImageFont( 0 );
			if( pImageFont )
			{
				pImageFont->DrawText( x + 8, y + 8, IndexStr.Cstr() );
			}
			else
			{
				assert(0);
			}

			unsigned int value = spread->mParam[i].mValue;
			if( value <= 0 )
				continue;
			if( mpMain == 0 )
				continue;

			/// calculate value render
			bool render = true;
			if( value > 0 )
			{
				cString ValueStr;
				ValueStr.Format( "%d", value );

				unsigned int openIndex = mpMain->GetSelectedCount();
				if( openIndex > 0 && i < openIndex )
				{
					sResultInfo* info = TAROTMAN->GetSelectCardInfo(i);
					if( info )
						render = info->Apply;
				}

				if( render == true )
				{
					///   ( 0 : 븻, 1 : *, 2 : /, 3 : + )
					unsigned int Calc = spread->mParam[i].mCalc;
					if( Calc > 0 )
					{
						cString CalcStr;
						CalcStr.Format( "%d", Calc-1 );

						cUIImageFont* pCalcFont = UIMAN->GetImageFont( 2 );
						if( pCalcFont )
						{
							pCalcFont->DrawText( x + 2, y + 50, CalcStr.Cstr() );
						}
						else
						{
							assert(0);
						}
					}

					/// Ÿ ⿡     
					unsigned int ii = 4;
					unsigned int dir = spread->mParam[i].mDir;
					if( dir == eSPREAD_STR )
					{
						/// 
						ii = 1;
					}
					else if( dir == eSPREAD_INV )
					{
						/// 
						ii = 3;
					}

					cUIImageFont* pValueFont = UIMAN->GetImageFont( ii );
					if( pValueFont )
					{
						pValueFont->DrawText( x + 30, y + 50, ValueStr.Cstr() );
					}
					else
					{
						assert(0);
					}

					render = false;
				}

			}
		}
	}
}

///
void cTarotResultWindow::OnCommand( cUINode*, unsigned int id )
{
	switch(id)
	{
	case eUIID_GAME_TAROTRESULT_RESULT:
		{
			if( mpMain->GetSelectedCount() >= 10 )
			{
				/// ȿޱ  Ҹ, , Ʈ ȹ 
				MSG_REQ_TAROT_SEEKER_ACCEPT msg;
				msg.Category = NM_TAROT;
				msg.Protocol = NM_TAROT_SEEKER_ACCEPT_REQ;
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				if( mpMain )
					mpMain->NetLock( ePAGE_RESULT );
			}
		}
		break;
	case eUIID_GAME_TAROTRESULT_RANDOM:
	case eUIID_GAME_TAROTRESULT_ALLSTR:
	case eUIID_GAME_TAROTRESULT_ALLINV:
		{
			for( ;; )
			{
				if( mpMain->GetSelectedCount() >= 10 )
					break;

				if( mpMain->OpenResultCard() == true )
				{
					UpdateButton();
					SetTotalValue();

					if( mpMain->GetSelectedCount() >= 10 )
					{
						/// ư Ȱȭ
						if( mpResult )
							mpResult->SetEnabled( true );

						/// ư 
						ShowButton( false );
					}
				}
			}
		}
		break;
	case eUIID_GAME_TAROTRESULT_ONESTR:
	case eUIID_GAME_TAROTRESULT_ONEINV:
	case eUIID_GAME_TAROTRESULT_RIGHT:
	case eUIID_GAME_TAROTRESULT_UP:
		if( mpMain->OpenResultCard() == true )
		{
			UpdateButton();
			SetTotalValue();

			if( mpMain->GetSelectedCount() >= 10 )
			{
				/// ư Ȱȭ
				if( mpResult )
					mpResult->SetEnabled( true );

				/// ư 
				ShowButton( false );
			}
		}
		break;
	}
}

///
void cTarotResultWindow::OnShow()
{
	///
	cUIWindow::OnShow();

	ShowButton( true );
	SetTotalValue();
	UpdateButton();

	for( unsigned int i=0; i<10; i++ )
	{
		if( mpOpenValue[i] )
			mpOpenValue[i]->Clear();
	}

	SetMaxScore( MAX_TAROTVALUE );
}

///
void cTarotResultWindow::OnHide()
{
	cUIWindow::OnHide();

	/// ʱȭ
	SetTotalValue();

	if( mpDescription )
		mpDescription->Clear();
	if( mpResult )
		mpResult->SetEnabled( false );
	if( mpResultGauge )
		mpResultGauge->SetMaxValue( 0 );
	if( mpResultGauge )
		mpResultGauge->SetGaugeNoAni( 0 );
}

///
void cTarotResultWindow::SetDescription( LPCTSTR desc )
{
	if( mpDescription )
	{
		mpDescription->SetText( desc );
	}
	else
	{
		assert(0);
	}
}

///
void cTarotResultWindow::SetTotalValue()
{
	unsigned long result = mpMain->GetCurrentResult();
	unsigned long total = mpMain->GetCardTotalPoint();

	if( mpOpenTotal )
		mpOpenTotal->SetValue( total );

	long idx = mpMain->GetSelectedCount() - 1;
	if( mpOpenValue[idx] && idx >= 0 )
		mpOpenValue[idx]->SetValue( result );

	if( mpResultGauge )
		mpResultGauge->SetGaugeNoAni( (float)total );
}

///
void cTarotResultWindow::ShowButton( bool show )
{
	if( mpRightBtn  && mpUpBtn )
	{
		if( show == true )
		{
			mpRightBtn->Show();
			mpUpBtn->Show();
		}
		else
		{
			mpRightBtn->Hide();
			mpUpBtn->Hide();
		}
	}
	else
	{
		assert(0);
	}
}

///
void cTarotResultWindow::UpdateButton()
{
	if( mpMain && mpUpBtn && mpRightBtn )
	{
		cItemSpread* spread = mpMain->GetCurrentSpreadInfo();
		unsigned int index = mpMain->GetSelectedCount();
		if( spread )
		{
			///  ī ġ  ư ̵
			unsigned int x = spread->mParam[index].mX;
			unsigned int y = spread->mParam[index].mY;

			unsigned int cardHW = mpMain->GetCardHalfWidth();
			unsigned int cardHH = mpMain->GetCardHalfHeight();

			x = spread->mParam[index].mX + cardHW - mpUpBtn->GetRelativeRect().GetWidth()/2;
			y = spread->mParam[index].mY - mRelativeRect.mTop - mpUpBtn->GetRelativeRect().GetHeight() - 5;
			cUIPos upPos(x, y);
			mpUpBtn->SetRelativePos( upPos );

			x = spread->mParam[index].mX + cardHW*2 + 5;
			y = spread->mParam[index].mY - mRelativeRect.mTop + cardHH - mpRightBtn->GetRelativeRect().GetHeight()/2;

			cUIPos rightPos(x, y);
			mpRightBtn->SetRelativePos( rightPos );

			/// ư ̵ߴµ ĸĳ ȣ Ƿ  
			UIMAN->ReleaseEventNode();	
		}
	}
	else
	{
		assert(0);
	}
}

/// Ÿ ִ ġ 
void cTarotResultWindow::SetMaxScore(unsigned int score )
{
	if( mpResultGauge )
	{
		mpResultGauge->SetMaxValue( (float)score );
	}
	else
	{
		assert(0);
	}
}