#include "stdafx.h"
#include "TarotSelectWindow.h"
#include "TarotManager.h"
#include "TarotWindow.h"
#include "Label.h"
#include "UIMsgboxEvent.h"

cTarotSelectWindow::cTarotSelectWindow()
: mpCount(0)
, mpShopName(0)
, mpMain(0)
{
}

cTarotSelectWindow::~cTarotSelectWindow()
{
}

bool cTarotSelectWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpMain = (cTarotWindow*)mpParent;

	mpCount = (cLabel*)GetChild( eUIID_GAME_TAROTSELECT_COUNT );
	mpShopName = (cLabel*)GetChild( eUIID_GAME_TAROTSELECT_SHOPNAME );
	
	cLabel* nameBack = (cLabel*)GetChild( eUIID_GAME_TAROTSELECT_NAMEBACKIMG );
	if( nameBack )
		nameBack->SetEnabled( false );
	return true;
}

///
void cTarotSelectWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_TAROTSELECT_CANCEL:
		{
			UIMAN->CreateModal( eStage_Game, eMBEVENT_TAROTSELECT_EXIT, 
								GAMERESOURCEMAN->GetGameText( 312 ), //   ޽
								GAMERESOURCEMAN->GetGameText( 301 ), // ˸
								eSKIN_YESNO );
		}
		break;
	case eUIID_GAME_TAROTSELECT_COMPLETE:
		{
			if( mpMain->GetSelectedCount() >= 10 )
			{
				///       
				MSG_REQ_TAROT_SEEKER_RESULT msg;
				msg.Category = NM_TAROT;
				msg.Protocol = NM_TAROT_SEEKER_RESULT_REQ;
				msg.SpreadIndex = mpMain->GetSelectedSpreadIndex();
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				if( mpMain )
					mpMain->NetLock( ePAGE_SELECT );
			}
			else
			{
				/// Ÿī 10  ȵ
				UIMAN->CreateModal( eStage_Game, eMBEVENT_NONE, 
					GAMERESOURCEMAN->GetGameText( 311 ), // 10  ޽
					GAMERESOURCEMAN->GetGameText( 301 ), // ˸
					eSKIN_OK );
			}
		}
		break;
	case eUIID_GAME_TAROTSELECT_RANDOM:
		{
			for(;;)
			{
				if( mpMain->GetSelectedCount() >= 10 )
					break;

				mpMain->OpenSelectCard( 0 );
			}
			//SetSelectCardCount( mpMain->GetSelectedCount() );
		}
		break;
	}
}

///
void cTarotSelectWindow::OnShow()
{
	///
	cUIWindow::OnShow();

	mpShopName->SetText( mpMain->GetTitle() );
	SetSelectCardCount( mpMain->GetSelectedCount() );
}

///
void cTarotSelectWindow::OnHide()
{
	cUIWindow::OnHide();

	if( mpShopName )
		mpShopName->Clear();
}

///
void cTarotSelectWindow::SetSelectCardCount( unsigned int count )
{
	/// ڿ  
	if( mpCount )
	{
		cStringT str;
		str.Format( _T("%d / 10"), count );
		mpCount->SetText( (LPCTSTR)str.Cstr() );
	}
	else
	{
		assert(0);
	}
}