#include "StdAfx.h"
#include "TarotSheetWindow.h"
#include "UIImage.h"
#include "PlaneObject.h"
#include "ItemManager.h"
#include "FontAgent.h"
#include "TextBox.h"
#include "GameResourceManager.h"
#include "TarotManager.h"
#include "CardImage.h"
#include "Label.h"
#include "ItemManager.h"

cTarotSheetWindow::cTarotSheetWindow( eUINodeType type )
: cUIWindow( type )
, mpCardImage(0)
, mpLineImage(0)
, mpCardSkin(0)
, mpLineSkin(0)
, mpSelectImg(0)
, mSelectIndex(-1)
, mpDescBox(0)
, mpName(0)
, mpValue(0)
, mpBackImage(0)
, mpBackSkin(0)
{
	
}

cTarotSheetWindow::~cTarotSheetWindow()
{
	SAFE_DELETE( mpBackImage );
	SAFE_DELETE( mpSelectImg );
	SAFE_DELETE( mpCardImage );
	SAFE_DELETE( mpLineImage );
}

void cTarotSheetWindow::Clear()
{
	/// ī  ̹ ʱȭ
	unsigned int slotIndex = INVENTORY_TAROT_BEGIN;
	for( int i = 0; i < ICON_MAX; ++i, ++slotIndex )
	{
		sCardBookData& data = mData[i];
		cItemIcon* icon = data.mIcon;
		if( icon )
		{	
			icon->ChangeImage( &data.mIconParam );
			icon->SetTipType( eTOOLTIP_NONE );
			icon->SetItemIndex( 0 );
			icon->SetUsedFlag( false, false );
		}

		data.mName.Clear();
	}

	mSelectIndex = -1;

	/// ū ī ̹ ʱȭ
	if( mpCardSkin && mpCardImage )
	{
		unsigned int tx = mpCardSkin->mSkinInfo->mTexX;
		unsigned int ty = mpCardSkin->mSkinInfo->mTexY;
		unsigned int w = mpCardSkin->mSkinInfo->mWidth;
		unsigned int h = mpCardSkin->mSkinInfo->mHeight;
		mpCardImage->SetTexture( mpCardSkin->mpTexture );
		mpCardImage->SetTextureRect( cUIRect( tx, ty, tx+w, ty+h ) );
	}

	if( mpName )
		mpName->Clear();

	if( mpDescBox )
		mpDescBox->Clear();

	if( mpValue )
		mpValue->Hide();
}

/// ν ȣ
void cTarotSheetWindow::UIStageIn()
{
	///
	Clear();

	///  
	for( int i = 0; i < ICON_MAX; ++i )
		UpdateData(i);
}

bool cTarotSheetWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpDescBox = (cTextBox*)GetChild( eUIID_GAME_CARDBOOK_TAROTDESCBOX );
	mpName = (cLabel*)GetChild( eUIID_GAME_CARDBOOK_TAROTNAME );
	mpValue = (cLabel*)GetChild( eUIID_GAME_CARDBOOK_TAROTVALUE );

	if( mpDescBox )
		mpDescBox->SetDrawTextBottom( false );

	if( mpName )
		mpName->SetTextColor( eCOLOR_WHITE );

	if( mpValue )
		mpValue->SetTextColor( eCOLOR_WHITE );

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
		return false;

	/// ū ī ̹ 
	mpCardSkin = pSkin->GetNodeSkin( "TarotSheet_Card" );
	if( mpCardSkin )
	{
		mpCardImage = new cUIImage( mpCardSkin->mpTexture );
		unsigned int tx = mpCardSkin->mSkinInfo->mTexX;
		unsigned int ty = mpCardSkin->mSkinInfo->mTexY;
		unsigned int tw = mpCardSkin->mSkinInfo->mWidth;
		unsigned int th = mpCardSkin->mSkinInfo->mHeight;
		unsigned int x = mpCardSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpCardSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;

		mpCardImage->SetTextureRect( tx, ty, tx + tw, ty + th );
		mpCardImage->SetScreenRect( cUIRect( x, y, x + tw, y + th ) );
	}

	/// ū ī  ̹ 
	mpBackSkin = pSkin->GetNodeSkin( "TarotSheet_CardBack" );
	if( mpBackSkin )
	{
		mpBackImage = new cUIImage( mpBackSkin->mpTexture );
		unsigned int tx = mpBackSkin->mSkinInfo->mTexX;
		unsigned int ty = mpBackSkin->mSkinInfo->mTexY;
		unsigned int tw = mpBackSkin->mSkinInfo->mWidth;
		unsigned int th = mpBackSkin->mSkinInfo->mHeight;
		unsigned int x = mpBackSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpBackSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;

		mpBackImage->SetTextureRect( tx, ty, tx + tw, ty + th );
		mpBackImage->SetScreenRect( cUIRect( x, y, x + tw, y + th ) );
	}

	///  ̹ 
	mpLineSkin = pSkin->GetNodeSkin( "TarotSheet_Line" );
	if( mpLineSkin )
	{
		mpLineImage = new cUIImage( mpLineSkin->mpTexture );
		unsigned int tx = mpLineSkin->mSkinInfo->mTexX;
		unsigned int ty = mpLineSkin->mSkinInfo->mTexY;
		unsigned int tw = mpLineSkin->mSkinInfo->mWidth;
		unsigned int th = mpLineSkin->mSkinInfo->mHeight;
		unsigned int x = mpLineSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpLineSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;

		mpLineImage->SetTextureRect( tx, ty, tx + tw, ty + th );
		mpLineImage->SetScreenRect( cUIRect( x, y, x + tw, y + th ) );
	}

	/// ī  &   
	cString str;
	unsigned int slotIndex = INVENTORY_TAROT_BEGIN;
	for( unsigned int i = 0; i < ICON_MAX; ++i, ++slotIndex )
	{
		str.Format( "TarotSheet_Icon%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, 1 ) == false )
			return false;

		///  Ŵ ε
		ITEMMAN->BindIcon( slotIndex, icon );
		icon->SetUsedFlag( false, false );

		///
		sCardBookData& data = mData[i];
		cUINodeSkin* iconSkin = pSkin->GetNodeSkin( str );
		if( iconSkin )
		{
			cIconParam& iconParam = data.mIconParam;
			iconParam.mpTexture = iconSkin->mpTexture;
			iconParam.mTexPos.mX = iconSkin->mSkinInfo->mTexX;
			iconParam.mTexPos.mY = iconSkin->mSkinInfo->mTexY;
		}

		/// 켱 ⺻̹ 
		icon->ChangeImage( &data.mIconParam );
		mData[i].mIcon = icon;
	}

	///  ̹ 
	cUINodeSkin* pSelectSkin = pSkin->GetNodeSkin( "TarotSheet_Select" );
	if( !pSelectSkin )
		return false;

	if( pSelectSkin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)pSelectSkin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)pSelectSkin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)pSelectSkin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)pSelectSkin->mSkinInfo->mTexHeight;

		mpSelectImg = new cPlaneObject;
		if( mpSelectImg->Create( pSelectSkin->mpTexture, 0, 0, tw, th,
								 tx, ty, tx + tw, ty + th ) == false )
		{
			assert( 0 && "failed to create select image");
			return false;
		}
	}
	return true;
}

void cTarotSheetWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpCardSkin && mpCardImage )
	{
		unsigned int x = mpCardSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpCardSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpCardImage->SetPos( x, y );
	}

	if( mpBackSkin && mpBackImage )
	{
		unsigned int x = mpBackSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpBackSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpBackImage->SetPos( x, y );
	}

	if( mpLineSkin && mpLineImage )
	{
		unsigned int x = mpLineSkin->mSkinInfo->mX + GetAbsoluteRect().mLeft;
		unsigned int y = mpLineSkin->mSkinInfo->mY + GetAbsoluteRect().mTop;
		mpLineImage->SetPos( x, y );
	}

	UpdateSelectImage();
}

void cTarotSheetWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	///  ̸ 
	for( unsigned int i = 0; i < ICON_MAX; ++i )
	{
		sCardBookData& data = mData[i];
		cItemIcon* icon = data.mIcon;
		if( icon )
		{
			cUIRect rc = icon->GetAbsoluteRect();
			int x = rc.mRight + 3;
			int y = rc.mTop + int(( rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_UI) ) * 0.5);
			pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPCTSTR)data.mName.Cstr(), x, y, eCOLOR_WHITE );
		}
	}

	if( mpLineImage )
		mpLineImage->Draw();

	if( mpBackImage )
		mpBackImage->Draw();

	if( mpCardImage )
		mpCardImage->Draw();

	if( mpSelectImg && mSelectIndex > -1 )
		mpSelectImg->Draw();

	cUIWindow::OnRender( pKeeper );
}

void cTarotSheetWindow::OnLButtonDoubleClick( const cUIPos& pos )
{
	OnLButtonDown( pos, false, false, false );
}

///
void cTarotSheetWindow::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool )
{
	sCardBookData& data = mData[0];
	cItemIcon* dataIcon = data.mIcon;
	if( !dataIcon )
		return;

	cUIRect iconRect;
	iconRect.mLeft = dataIcon->GetAbsoluteRect().mLeft;
	iconRect.mTop = dataIcon->GetAbsoluteRect().mTop;
	iconRect.mRight = iconRect.mLeft + (ROW_WIDTH*2);
	iconRect.mBottom = iconRect.mTop + (ROW_HEIGHT*ICON_MAX);

	///  üũ
	if( iconRect.ContainPoint( pos ) == false )
		return;

	/// ִ  ã
	for( unsigned int i = 0; i < ICON_MAX; ++i )
	{
		sCardBookData& data = mData[i];
		if( !data.mIcon )
		{
			assert(0);
			continue;
		}

		///   ˻
		if( data.mIcon->GetItemIndex() == 0 )
			continue;

		cUIRect rc = data.mIcon->GetAbsoluteRect();
		rc.mRight = rc.mLeft + ROW_WIDTH;
		rc.mBottom = rc.mTop + ROW_HEIGHT;

		///  üũ
		if( rc.ContainPoint( pos ) == true )
		{
			if( mSelectIndex != i )
			{
				mSelectIndex = i;
				UpdateText();
				UpdateSelectImage();
			}
			break;
		}
	}
}

/// Ÿ 
void cTarotSheetWindow::UpdateText()
{
	if( !mpDescBox || !mpName || !mpValue )
	{
		assert(0);
		return;
	}
		
	///   
	mpDescBox->Clear();
	mpValue->Hide();

	/// ī 
	cItemIcon* icon = mData[mSelectIndex].mIcon;
	if( !icon )
		return;

	unsigned long itemIndex = icon->GetItemIndex();
	cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
	if( define )
	{
		/// ̸
		mpName->SetText( define->GetName() );

		/// Ÿī
		if( define->GetType() == ITEM_CARD && define->GetSubType() == ITEM_CARD_TAROT )
		{
			cItemTarot* tarot = define->GetTarotDefine();
			if( tarot )
			{
				/// ī ؼ 
				TCHAR temp[256] = {0,};
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 343 ), tarot->GetStraightValue(), tarot->GetInverseValue() );
				mpValue->SetText( temp );

				/// ī 
				mpDescBox->AddNewRow( GAMERESOURCEMAN->GetCardBookText( itemIndex ), eCOLOR_WHITE );

				// ī ̹ 
				cCardParam* param = TAROTMAN->GetImageParam( tarot->GetImageIndex() );
				if( param )
				{
					int x = param->mTexPos.mX;
					int y = param->mTexPos.mY;
					int w = mpCardSkin->mSkinInfo->mWidth;
					int h = mpCardSkin->mSkinInfo->mHeight;
					mpCardImage->SetTexture( param->mpTexture );
					mpCardImage->SetTextureRect( cUIRect( x, y, x+w, y+h ) );
				}

				mpValue->Show();
			}
		}
		/// 
		else if( define->GetType() == ITEM_SPREAD )
		{
			///   
			mpDescBox->AddNewRow( GAMERESOURCEMAN->GetCardBookText( itemIndex ), eCOLOR_WHITE );

			///  ̹ 
			cItemSpread* spread = define->GetSpreadDefine();
			if( spread )
			{
				cCardParam* param = TAROTMAN->GetImageParam( spread->mParam[0].mImageIndex );
				if( param )
				{
					int x = param->mTexPos.mX;
					int y = param->mTexPos.mY;
					int w = mpCardSkin->mSkinInfo->mWidth;
					int h = mpCardSkin->mSkinInfo->mHeight;
					mpCardImage->SetTexture( param->mpTexture );
					mpCardImage->SetTextureRect( cUIRect( x, y, x+w, y+h ) );
				}
			}
		}
	}
}

///
void cTarotSheetWindow::UpdateSelectImage()
{
	if( mSelectIndex == -1 )
		return;

	if( mSelectIndex >= ICON_MAX )
	{
		assert(0);
		return;
	}

	if( mpSelectImg )
	{
		sCardBookData& data = mData[mSelectIndex];
		if( data.mIcon )
		{
			cUIRect iconRc = data.mIcon->GetAbsoluteRect();
			mpSelectImg->SetScreenRect( iconRc.mLeft-1, iconRc.mTop-1, ROW_WIDTH, ROW_HEIGHT );
		}
	}
}

void cTarotSheetWindow::UpdateData( int i )
{
	if( i < 0 || i >= ICON_MAX )
	{
		assert(0);
		return;
	}

	cItemIcon* icon = mData[i].mIcon;
	if( icon )
	{
		unsigned int slotIndex = icon->GetSlotIndex();
		unsigned long itemIndex = icon->GetItemIndex();
		cItem& item = ITEMMAN->GetItem( slotIndex );
		cItemDefine* define = item.GetDefine();
		if( define )
		{
			icon->SetItemIndex( item.GetIndex() );
			icon->ChangeImage( define->GetIconParam() );
			icon->SetTipType( define->GetTipType() );

			/// 
			/// ̸  
			TCHAR name[ITENNAME_LEN] = {0,};
			bool ret = ITEMMAN->ModifyItemName( define->GetName(), name );
			mData[i].mName = ( ret == true ) ? name : define->GetName();
		}
	}
}

/// ī峪 尡 ̹ ϵǾִ 
unsigned long cTarotSheetWindow::IsRegistItem( int i )
{
	if( i < 0 || i >= ICON_MAX )
	{
		assert(0);
		return ULONG_MAX;
	}

	sCardBookData& data = mData[i];
	cItemIcon* icon = data.mIcon;
	if( !icon )
	{
		assert(0);
		return ULONG_MAX;
	}

	return ( icon->GetItemIndex() == 0 ) ? 0 : icon->GetItemIndex();
}

unsigned int cTarotSheetWindow::GetSlotIndex( int i )
{
	if( i < 0 || i >= ICON_MAX )
	{
		assert(0);
		return ULONG_MAX;
	}

	sCardBookData& data = mData[i];
	cItemIcon* icon = data.mIcon;
	if( !icon )
	{
		assert(0);
		return ULONG_MAX;
	}
	return icon->GetSlotIndex();
}

unsigned int cTarotSheetWindow::GetEmptySlotIndex()
{
	/// 󽽷 ã
	for( int i = TAROT_COUNT; i < ICON_MAX; ++i )
	{
		sCardBookData& data = mData[i];
		cItemIcon* icon = data.mIcon;
		if( !icon )
		{
			assert(0);
			return 0;
		}

		if( icon->GetItemIndex() == 0 )
			return icon->GetSlotIndex();
	}

	///  ù°  
	return ( mData[TAROT_COUNT].mIcon) ? mData[TAROT_COUNT].mIcon->GetSlotIndex() : 0;
}