/* ==========================================================================
*      : TarotSheetWindow.h
*      : 
*    : 谡
*    : 2008-06-10
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "ItemIcon.h"

const int TAROT_COUNT = 22;
const int SPREAD_COUNT = 5;
const int ICON_MAX = TAROT_COUNT + SPREAD_COUNT;
const int ROW_WIDTH = 143;
const int ROW_HEIGHT = 32;

class cUIImage;
class cPlaneObject;
class cTextBox;
class cLabel;
class cTarotSheetWindow : public cUIWindow
{
public:
	cTarotSheetWindow( eUINodeType type = eUINODE_TABSHEET );
	virtual ~cTarotSheetWindow();

	/// Ŭ
	void Clear();
	void UIStageIn();

	///  Ʈ
	void UpdateData( int i );

	/// Ͽ ˻
	unsigned long IsRegistItem( int i );
	unsigned int GetSlotIndex( int i );

	/// 󽽷 ã
	unsigned int GetEmptySlotIndex();

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool );
	void OnLButtonDoubleClick( const cUIPos& pos );
	void UpdateRect();
	
	/// ̹ 
	void UpdateText();
	void UpdateSelectImage();

public:
	struct sCardBookData
	{
		cItemIcon*		mIcon;
		cIconParam		mIconParam;
		cStringT		mName;

		sCardBookData()
		{
			mIcon = 0;
		}
	};

private:
	/// Ŀٶ ī̹
	cUINodeSkin*	mpCardSkin;
	cUINodeSkin*	mpLineSkin;
	cUINodeSkin*	mpBackSkin;
	cUIImage*		mpCardImage;
	cUIImage*		mpLineImage;
	cUIImage*		mpBackImage;

	/// ī  
	sCardBookData	mData[ICON_MAX];

	/// ÿ ̹
	cPlaneObject*	mpSelectImg;
	int				mSelectIndex;

	///  ڽ
	cTextBox*		mpDescBox;
	cLabel*			mpName;
	cLabel*			mpValue;
};
