#pragma once
#include "UIWindow.h"
#include "Tarot_Common.h"

struct sNpcTarotDeck;

/// child window
class cTarotOpenWindow;
class cTarotCheckWindow;
class cTarotSelectWindow;
class cTarotResultWindow;
class cNpcTarotCheckWindow;
class cNpcTarotSelectWindow;
class cNpcTarotResultWindow;

class cLabel;
class cButton;
class cItemIcon;
class cCardImage;
class cItemSpread;
class cPlaneObject;
class cUIImage;

const int SPREAD_GAPY = 9;
const int TAROT_GAPX = 7;
const int TAROT_GAPY = 4;
const int TAROTNUMBER_TEXTSTART = 1000001;

struct sStringData
{
	cStringT spreadName;
	unsigned long color;

	sStringData()
	{
		color = 0;
	}
};

class cTarotWindow : public cUIWindow
{
public:
	cTarotWindow();
	virtual ~cTarotWindow();

	enum 
	{
		eCardDrama_Appear1 = 0,
		eCardDrama_Appear2,

		eCardDrama_Max,
	};

	void ChangeTarotPage( unsigned char page );
	void OpenSelectCard( cCardImage* image = 0 );
	bool OpenResultCard();

	bool OpenNpcResultCard();								///  ī & ؼ 
	bool OpenNpcResultReview( unsigned int selectIndex );	///  ؼ  

	void SetFortuneData( unsigned long data );				/// κ   npc  ޴´
	inline unsigned long GetFortuneData() { return mFortuneData; }

	void SetPrice( unsigned long price );
	void SetTitle( LPCTSTR str );
	void SetCardInfo( unsigned int index, unsigned int itemIndx, bool InitPoint = false );
	void SetSpreadInfo( unsigned int index, unsigned int itemIndex );
	void SetSelectedSpread( unsigned int index );
	//	void SetStatus( unsigned char status );
	//	void SetUserCount( unsigned long count );

	inline cItemSpread* GetCurrentSpreadInfo() { return mpSpreadInfo;} 
	inline unsigned int GetSelectedSpreadIndex() { return mSelectSpreadIndex; }
	inline unsigned int GetSelectedCount() { return mSelectCardCount; }
	inline unsigned int GetShowReviewIndex() { return mShowReviewIndex; }
	inline unsigned int GetMaxCount() { return mMaxSelect; }
	inline unsigned long GetPrice() { return mPrice; }
	inline unsigned long GetCardTotalPoint() { return mCardTotalPoint; }
	inline unsigned long GetCurrentResult() { return mCurrentResult; }
	inline unsigned int GetCardHalfWidth() { return mCardHalfWidth; }
	inline unsigned int GetCardHalfHeight() { return mCardHalfHeight; }
	inline LPCTSTR GetTitle() { return mTitle.Cstr(); }

public:
	/// NPC   
	void SetNpcTarotDeck( sNpcTarotDeck* deck );
	void SetNpcSpread( unsigned long* spreadArr, short size );

	void OpenSelectNpcCard( cCardImage* image = 0 );
	void SetSelectedNpcSpread( unsigned int index );

	/// NPC   
	void MakeNpcTarotResult();
	unsigned int GetNpcHaveSpreadCount() { return mNpcSpreadCount; }

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* pnode, unsigned int id );
	void OnImageHovered( cUINode* caller, unsigned int id, const cUIPos& pos );
	void OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool );
	void OnLButtonDoubleClick( const cUIPos& pos );
	
	void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	void OnRender( cUIFontItemKeeper* pKeeper );

	void OnIconClicked( cUINode* pcaller, unsigned int id );
	void OnImageClicked( cUINode* pcaller, unsigned int id );

	void OnHide();
	void OnShow();

	void UpdateSkin();
	void UpdateRect();

	void ShowHeroTarotCard();

	void OnNetLock( int lockTry );
	void OnNetUnLock( int lockTry );

protected:
	cTarotOpenWindow*		mpOpenWindow;
	cTarotCheckWindow*		mpCheckWindow;
	cTarotSelectWindow*		mpSelectWindow;
	cTarotResultWindow*		mpResultWindow;
	cNpcTarotCheckWindow*	mpNpcCheckWindow;
	cNpcTarotSelectWindow*	mpNpcSelectWindow;
	cNpcTarotResultWindow*	mpNpcResultWindow;

	///
	cUINodeSkin* mpTarotSkin;
	unsigned int mCardHalfWidth;
	unsigned int mCardHalfHeight;

	///  ̹ Ų
	cUIImage*		mpSpreadBackImg;
	cUINodeSkin*	mpSpreadBackSkin;
	bool			mShowSpreadBack;

	///  ̹
	cPlaneObject*	mpSelectImage;
	int				mSelectArrIndex;	/// õ  ε
	cUIRect			mSelectRect[MAX_SPREAD];		///  

	/// Ÿ  
	unsigned long mPrice;					/// ̿ ݾ
	unsigned int mMaxSelect;				/// ִ   ִ 
	cStringT mTitle;

	unsigned long mCardTotalPoint;
	unsigned long mCurrentResult;

	unsigned int mSelectCardCount;
	
	unsigned int mSelectSpreadIndex;
	cItemSpread* mpSpreadInfo;

	/// ī
	typedef tPointerArray<void*> cTarotCardArr;
	cTarotCardArr	mCardArr;
	cUIRect mDefaultCardRect;

	///  
	sStringData		mStringData[MAX_SPREAD];
	cItemIcon*		mpIcon[MAX_SPREAD];

	struct sDramaInfo
	{
		unsigned int mIndex;
		unsigned long mStartTime;
	};

	bool mEnalbeOpenDrama;
	unsigned long mStartTime;
	unsigned long* mCurrentPattern;
	bool mTarotFront;
	unsigned char mTarotFadeState;

protected:
	/// NPC Ÿ  
	sNpcTarotDeck* mDeck;			/// Ÿ 
	unsigned int mNpcSpreadCount;
	unsigned long mNpcSpreadIndex[MAX_SPREAD];

	/// NPC Ÿ  
	sTarotResult	mNpcTarotResult[13];

	/// ִ review ε 
	unsigned int mShowReviewIndex;

	/// ̿밡  
	unsigned long mFortuneData;
};

inline void cTarotWindow::SetPrice( unsigned long price )
{
	mPrice = price;
}

inline void cTarotWindow::SetTitle( LPCTSTR str )
{
	mTitle = str;
}

inline void cTarotWindow::SetNpcTarotDeck( sNpcTarotDeck* deck )
{
	mDeck = deck;
}

inline void cTarotWindow::SetNpcSpread( unsigned long* spreadArr, short size )
{
	mNpcSpreadCount = size;

	for( int i = 0; i < size; ++i, ++spreadArr )
		mNpcSpreadIndex[i] = *spreadArr;
}

inline void cTarotWindow::SetFortuneData( unsigned long data )
{
	mFortuneData = data;
}

//inline 
//void cTarotWindow::SetStatus( unsigned char status )
//{
//	mStatus = status;
//}

//inline 
//void cTarotWindow::SetUserCount( unsigned long count )
//{
//	mUserCount = count;
//	mAccumMoney = mUserCount * mPrice;
//}