/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Shader.h"

class cBox;
class cSphere;
class cTerrainNode;
class cTerrainBranchNode;
class cTerrainLeafNode;

///  
const unsigned int TERRAIN_DEFAULT_RESOLUTION = 512;
const unsigned int TERRAIN_BUFF_CELL_COUNT = 128;
const unsigned int TERRAIN_BUFF_LINE_COUNT = TERRAIN_BUFF_CELL_COUNT + 1;
const unsigned int TERRAIN_BUFF_VERT_COUNT = TERRAIN_BUFF_LINE_COUNT * TERRAIN_BUFF_LINE_COUNT;
const unsigned int TERRAIN_LEAF_CELL_COUNT = 8;
const unsigned int TERRAIN_LEAF_LINE_COUNT = TERRAIN_LEAF_CELL_COUNT + 1;
const unsigned int TERRAIN_LEAF_LINE_COUNT_X2 = TERRAIN_LEAF_LINE_COUNT * 2;
const unsigned int TERRAIN_LEAF_VERT_COUNT = TERRAIN_LEAF_LINE_COUNT * TERRAIN_LEAF_LINE_COUNT;

const unsigned int TERRAIN_RENDER_PRIME_COUNT = TERRAIN_LEAF_CELL_COUNT*TERRAIN_LEAF_CELL_COUNT * 2;


///  ؽó 
const unsigned int TERRAIN_TEXTURE_COUNT = 21;
const unsigned int TERRAIN_TEXTURE_COUNT_VER2 = 16;

///  Lod
enum eTerrainLod
{
	TERRAIN_LOD_0 = 0,
	TERRAIN_LOD_1,
	TERRAIN_LOD_2,
	TERRAIN_LOD_COUNT
};

///   
#pragma pack( push, 1 )
class cTerrainFileHeader
{
public:
	/// ĺ ڵ
	char mCode[12];

	/// 
	unsigned int mVersion;

	/// ׸ ũ ( )
	unsigned int mCellCount;

	///   
	float mMetersPerVertex;

	/// ʹ  
	unsigned int mUnitsPerMeter;

	/// ؽó 
	unsigned int mNumTextures;
};
#pragma pack( pop )

///  ؽó
class cTerrainTexture
{
	friend class cTerrain;
	friend class cTerrainLeafNode;

public:
	cTerrainTexture( unsigned int index, LPDIRECT3DTEXTURE9 tex );
	~cTerrainTexture();

	void Grab();
	void Drop();

private:
	///     ε
	unsigned int mIndexByTerrain;

	///  īƮ
	unsigned int mRefCount;

	/// DX9
	LPDIRECT3DTEXTURE9 mTexture;
};

///  
class cTerrainBuffer
{
	friend class cTerrain;
	friend class cTerrainLeafNode;

public:
	cTerrainBuffer();
	~cTerrainBuffer();

	bool Init( cTerrain* terrain, unsigned int xi, unsigned int yi );

protected:
	void UpdatePosCoord( cTerrain* terrain, unsigned int xstart, unsigned int ystart, unsigned int count );
	void UpdateColor( cTerrain* terrain, unsigned int xstart, unsigned int ystart, unsigned int count );
	void UpdateAlpha( cTerrain* terrain, unsigned int xstart, unsigned int ystart, unsigned int count );

private:
	unsigned int mXIndex;
	unsigned int mYIndex;

	/// DX9
	LPDIRECT3DVERTEXBUFFER9 mPosCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 mNormalBuffer;
	LPDIRECT3DVERTEXBUFFER9 mColorBuffer;
	LPDIRECT3DVERTEXBUFFER9 mAlphaBuffer;
};

/// 
class cTerrain
{
	static cTerrain* mSingleton;
	friend class cTerrainLeafNode;
	friend class cTerrainTexture;
	friend class cTerrainBuffer;

public:
	static const unsigned int MAX_NODES = 21845;

public:
	cTerrain();
	~cTerrain();

	/// 
	void Clear();

	/// ε
	bool LoadHeader( unsigned int mapIndex, const cString& pathName );
	int LoadNodes( unsigned int count );

	/// ó
	void Process();

	/// 
	void Render();

	///  浹ϴ  
	/// ٿ ڽ ˻Ѵ.
	bool CollideSphere( tArray<void*>* pickedArray, const cSphere& sphere );

	/// 
	float GetUnitsPerVertex() const;
	float GetUnitsPerLeafNode() const;

	/// ̴   
	unsigned int GetNumVisibleNodes() const;

	///  
	const cBox& GetBoundBox() const;

	///   
	float GetSegmentLength() const;

protected:
	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

	/// ؽó
	bool LoadTexture( unsigned int index, const cString& pathName );
	cTerrainTexture* GetTexture( unsigned int index );
	void AddTexture( unsigned int index, cTerrainTexture* tex );
	void RemoveTexture( unsigned int index );

	/// 
	cTerrainBuffer* GetBuffer( unsigned int xi, unsigned int yi );

	///  
	void SetLeafNode( unsigned int xi, unsigned int yi, cTerrainLeafNode* node );
	cTerrainLeafNode* GetLeafNode( float x, float y ) const;

	/// ̰
	void SetHeight( unsigned int xi, unsigned int yi, float height );
	bool GetHeight( float* height, unsigned int xi, unsigned int yi );
	float GetHeightFast( unsigned int xi, unsigned int yi ) const;

	/// 
	void ComputeNormals( unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend );
	const NiPoint3& GetNormalFast( unsigned int xi, unsigned int yi ) const;

	/// 
	void SetColor( unsigned int xi, unsigned int yi, const NiColor& color );
	const NiColor& GetColorFast( unsigned int xi, unsigned int yi ) const;

	/// İ
	void SetAlpha( unsigned int xi, unsigned int yi, const NiPoint3& alpha );
	const NiPoint3& GetAlphaFast( unsigned int xi, unsigned int yi ) const;

	///  
	NiAmbientLight* GetAmbientLight() const;

public:
	/// ü 
	static cTerrain* GetSingleton();

protected:
	/// ׸ ũ ( 512  + 1 )
	unsigned int mCellCount;
	unsigned int mLineCount;

	/// 
	float mMetersPerVertex;
	unsigned int mUnitsPerMeter;
	float mUnitsPerVertex;
	float mUnitsPerLeafNode;

	///   
	float mSegmentLength;

	/// Ʈ 
	cTerrainBranchNode* mRootNode;

	///   迭
	typedef tArray<void*> cLeafNodeArray;
	cLeafNodeArray mNodeArray;

	///  迭
	cLeafNodeArray mVisibleArray;

	///  迭
	float* mHeights;

	///  迭
	NiPoint3* mNormals;

	///  迭
	NiColor* mColors;

	///  迭
	NiPoint3* mAlphas;

	/// Level of detail
//	float mSquaredDistanceLod[TERRAIN_LOD_COUNT];

	/// ؽó 迭
	cTerrainTexture* mTextures[TERRAIN_TEXTURE_COUNT];

	/// ̴
	cTerrainShader mShader;

	/// 
	cTerrainBuffer** mBuffer;

	/// DX9
	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration;
	LPDIRECT3DINDEXBUFFER9 mIndexBuffer;

	/// ε
	cFileLoader mLoader;
	cTerrainNode** mLoadArray;
	unsigned int mLoadCount;
	unsigned int mLoadIndex;
};

inline
cTerrainTexture* cTerrain::GetTexture( unsigned int i )
{
	assert( i < TERRAIN_TEXTURE_COUNT && "index out of range" );

	return mTextures[i];
}

inline
cTerrainBuffer* cTerrain::GetBuffer( unsigned int xi, unsigned int yi )
{
	return &(mBuffer[yi / TERRAIN_BUFF_CELL_COUNT][xi / TERRAIN_BUFF_CELL_COUNT]);
}

inline
void cTerrain::SetHeight( unsigned int xi, unsigned int yi, float height )
{
	mHeights[yi * mLineCount + xi] = height;
}

inline
float cTerrain::GetHeightFast( unsigned int xi, unsigned int yi ) const
{
	return mHeights[yi * mLineCount + xi];
}

inline
const NiPoint3& cTerrain::GetNormalFast( unsigned int xi, unsigned int yi ) const
{
	return mNormals[yi * mLineCount + xi];
}

inline
void cTerrain::SetAlpha( unsigned int xi, unsigned int yi, const NiPoint3& alpha )
{
	mAlphas[yi * mLineCount + xi] = alpha;
}

inline
const NiPoint3& cTerrain::GetAlphaFast( unsigned int xi, unsigned int yi ) const
{
	return mAlphas[yi * mLineCount + xi];
}

inline
void cTerrain::SetColor( unsigned int xi, unsigned int yi, const NiColor& color )
{
	mColors[yi * mLineCount + xi] = color;
}

inline
const NiColor& cTerrain::GetColorFast( unsigned int xi, unsigned int yi ) const
{
	return mColors[yi * mLineCount + xi];
}

inline
float cTerrain::GetUnitsPerVertex() const
{
	return mUnitsPerVertex;
}

inline
float cTerrain::GetUnitsPerLeafNode() const
{
	return mUnitsPerLeafNode;
}

inline
float cTerrain::GetSegmentLength() const
{
	return mSegmentLength;
}

inline
unsigned int cTerrain::GetNumVisibleNodes() const
{
	return mVisibleArray.GetSize();
}

inline
cTerrain* cTerrain::GetSingleton()
{
	return mSingleton;
}

#define TERRAIN	cTerrain::GetSingleton()
