/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Box.h"
#include "Terrain.h"

class cLightSceneNode;
class cTerrainBranchNode;
class cTerrainLeafNode;
class cTerrainTexture;
class cTerrainBuffer;

///  
class cTerrainNode
{
public:
	cTerrainNode( unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cTerrainNode();

	/// ε
	virtual bool Load( cFileLoader& loader ) = 0;
	virtual void AddToLoadArray( cTerrainNode** loadArray, unsigned int& count ) = 0;

	/// ø
	virtual void Cull() = 0;
	virtual void AddToVisibleArray() = 0;

	/// 浹 ˻
	virtual bool CollideSphere() = 0;

	///  
	const cBox& GetBoundBox() const;

	/// 
	const NiPoint3& GetCenter() const;

public:
	/// 
	cBox mBoundBox;
	NiPoint3 mCenter;
	float mRadius;

protected:
	/// ø
	static NiFrustumPlanes* mFrustum;
	static tArray<void*>* mVisibleArray;

	/// 浹 ˻
	static const cSphere* mSphere;
	static tArray<void*>* mPickedArray;
};

inline
const cBox& cTerrainNode::GetBoundBox() const
{
	return mBoundBox;
}

inline
const NiPoint3& cTerrainNode::GetCenter() const
{
	return mCenter;
}

///   
class cTerrainBranchNode : public cTerrainNode
{
public:
	cTerrainBranchNode( unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cTerrainBranchNode();

	/// ε
	bool Load( cFileLoader& loader );
	void AddToLoadArray( cTerrainNode** loadArray, unsigned int& count );

	/// ø
	void Cull();
	void AddToVisibleArray();

	/// 浹 ˻
	bool CollideSphere();

public:
	/// ڽ 迭
	cTerrainNode* mChild[4];
};

///   
class cTerrainLeafNode : public cTerrainNode
{
	friend class cTerrain;
	friend class cTerrainBranchNode;
	friend class cTerrainNodeCompareForRendering;
	friend class cLightSceneNode;

public:
	cTerrainLeafNode( unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cTerrainLeafNode();

	/// 
	void Clear();

	/// ε
	bool Load( cFileLoader& loader );
	void AddToLoadArray( cTerrainNode** loadArray, unsigned int& count );

	/// ø
	void Cull();
	void AddToVisibleArray();

	/// 浹 ˻
	bool CollideSphere();

	/// 
	void SetLight( cLightSceneNode* light, unsigned int indexByLight );
	const cLightSceneNode* GetLight() const;

private:
	/// ؽó
	void SetTextures( cTerrainTexture* tex0, cTerrainTexture* tex1, cTerrainTexture* tex2 );
	void CalcTextureValue();

private:
	/// ǥ ( ׸  ġ)
	unsigned int mXIndex;
	unsigned int mYIndex;

	///  
	bool mVisible;

	/// 
	cTerrainBuffer* mBuffer;

	///  ؽó
	cTerrainTexture* mTexture0;
	cTerrainTexture* mTexture1;
	cTerrainTexture* mTexture2;
	unsigned int mTextureValue0;
	unsigned int mTextureValue1;

	/// 
	cLightSceneNode* mLight;
	unsigned int mIndexByLight;

	/// Level of detail
//	int mLod;

private:
	/// 
	static unsigned int mVersion;

	///   ׸ ũ
//	static unsigned int mCellCount[TERRAIN_LOD_COUNT];
//	static unsigned int mLineCount[TERRAIN_LOD_COUNT];
};

inline
const cLightSceneNode* cTerrainLeafNode::GetLight() const
{
	return mLight;
}

///    Լ
class cTerrainNodeCompareForRendering
{
public:
	bool operator () ( const void* left, const void* right ) const
	{
		cTerrainLeafNode* lnode = (cTerrainLeafNode*)left;
		cTerrainLeafNode* rnode = (cTerrainLeafNode*)right;
		cTerrainBuffer* lbuff = lnode->mBuffer;
		cTerrainBuffer* rbuff = rnode->mBuffer;

		if( lbuff == rbuff )
		{
			unsigned int ltex = lnode->mTextureValue0;
			unsigned int rtex = rnode->mTextureValue0;

			if( ltex == rtex )
			{
				ltex = lnode->mTextureValue1;
				rtex = rnode->mTextureValue1;

				if( ltex == rtex )
				{
					if( lnode->mYIndex == rnode->mYIndex )
					{
						return lnode->mXIndex < rnode->mXIndex;
					}
					return lnode->mYIndex < rnode->mYIndex;
				}
				return ltex < rtex;
			}
			return ltex < rtex;
		}
		return lbuff < rbuff;
	};
};
