#include "StdAfx.h"
#include "TextBox.h"
#include "Token.h"
#include "UISkinLexer.h"
#include "Parser.h"

#include "UIContainer.h"
#include "UIImage.h"
#include "UIText.h"
#include "UIFuncText.h"
#include "Token.h"
#include "FontAgent.h"
#include "ChatManager.h"
#include "ScrollBar.h"
#include "TipWindow.h"
#include "GameUIManager.h"
#include "Item_Common.h"

cTextBox::cTextBox( eUINodeType type )
: cTextCtrl( type )
, mTextPosX(0)
, mTextPosY(0)
, mNextPosY(0)
, mTopRowIdx(0)
, mMaxRowInPage(0)
, mRowHeight(0)
, mpScrollBar(0)
, mFixScrollH(0)
, mDrawTextBottom( true )
, mScrollBottom( false )
{
	mScrollbarPosType = eRIGHT_SCROLLBAR;
	mTextColor = mDefaultColor;
}

cTextBox::~cTextBox()
{
	/// ũѹ Ҹ( θܿ  )
	mpScrollBar = 0;
}

///
void cTextBox::Clear()
{
	cTextCtrl::Clear();

	///   ʱȭ 
	mTopRowIdx = 0;

	/// ũѹ ʱȭ 
	UpdateScrollBarButton();

	/// ũѹ ġ ʱȭ 
	UpdateScrollBarPos();
}

/// ǻ :
bool cTextBox::OnCreate( cUINodeProperty* property )
{
	/// ߰  ̰ 
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	/// Ʈ  ִ  ִ  
	mMaxRowInPage = GetAbsoluteRect().GetHeight() / mRowHeight;

	/// ũѹ 
	if( mScrollSkin )
	{
		mpScrollBar = new cScrollBar;
		if( mpScrollBar->CreateBySkinName( mScrollSkin, this, eTEXTBOX_SCROLL ) == false )
		{
			return false;
		}

		/// ũѹ   
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() - mFixScrollH );

		///  ư   
		UpdateScrollBarButton();

		///
		UpdateScrollBarPos();

		/// ũѹ ġɼ  ġ 
		if( mScrollbarPosType == eRIGHT_SCROLLBAR )
		{
			mpScrollBar->SetPosX( GetRelativeRect().mRight - GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth());
		}
		else 
		{
			mpScrollBar->SetPosX( GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth());
		}

		mpScrollBar->Hide();
	}

	/// ʺ  
	if( mpScrollBar )
	{
		mMaxTextWidth = GetAbsoluteRect().GetWidth() - mpScrollBar->GetAbsoluteRect().GetWidth();
	}
	else
	{
		mMaxTextWidth = GetAbsoluteRect().GetWidth();
	}

	return true;
}

/// ǻ : 
bool cTextBox::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_TEXTBOX ) == false )
	{
		assert( 0 && "not list skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	/// ũƮ  Ӽ 
	cTextBoxSkin* p = (cTextBoxSkin*)pskin;

	cUISkin* pUISkin = UIMAN->GetSkin();
	if( !pskin )
	{
		assert(0);
		return false;
	}

	/// ڽ Ų  
	mScrollSkin = p->mScrollSkin;

	/// Ų  ȿ ˻
	if( mScrollSkin && pUISkin->GetNodeSkin( p->mScrollSkin ) == 0 )
	{
		assert( 0 && "error skin name" );
		return false;
	}

	/// Ʈ ִ  ִ  
	mTotalMaxNum = p->mTotalMaxNum;

	///    
	mRowHeight = p->mRowHeight;
	if( mRowHeight < 0 )
	{
		assert(0);
		return false;
	}

	/// ũѹ ġ  ɼ
	if( p->mScrollBarRightPos == true )
	{
		mScrollbarPosType = eRIGHT_SCROLLBAR;
	}
	else
	{
		mScrollbarPosType = eLEFT_SCROLLBAR;
	}
	return true;
}

///
void cTextBox::UpdateRect()
{
	cUIWindow::UpdateRect();
	UpdateText();
}

/// ǻ : ػ 濡  
void cTextBox::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// Ʈ  ִ  ִ  
	mMaxRowInPage = GetAbsoluteRect().GetHeight() / mRowHeight;

	/// ũѹٰ  ũѹٵ 缼
	if( mpScrollBar )
	{
        /// ũѹ   
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() - mFixScrollH );

		///  ư   
		UpdateScrollBarButton();

		/// žε 
		if( mScrollBottom && mLine - mDelCount >= mMaxRowInPage )
		{
			mTopRowIdx = mLine - mDelCount - mMaxRowInPage;
		}

		/// ũѹ y ġ  
		UpdateScrollBarPos();

		/// ũѹ ġɼ  ġ 
		if( mScrollbarPosType == eRIGHT_SCROLLBAR )
		{
			mpScrollBar->SetPosX( GetRelativeRect().mRight - GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth());
		}
		else 
		{
			mpScrollBar->SetPosX( GetRelativeRect().mLeft - mpScrollBar->GetAbsoluteRect().GetWidth());
		}

		UpdateText();
	}
}

/// ǻ : 
bool cTextBox::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false || mVisible == false )
	{
		return mpParent->HandleEvent( event );
	}

	switch( event.mType )
	{
	case eUIEVENT_COMMAND:
	case eUIEVENT_BUTTON_DOWNED:
		{
			if( event.mID == eSCROOLBAR_UP || event.mID == eSCROOLBAR_DOWN )
				CheckButtonEvent( event.mID );
			else
				mpParent->HandleEvent( event );
		}
		break;
	case eUIEVENT_SCROLLBAR_MOVE:
		OnScrollbarMoved( event.mPos );
		break;
	case eUIEVENT_MOUSE_WHEEL:
		OnMouseWheel( event.mPos, event.mWheel );
		break;
	case eUIEVENT_LBUTTON_DOWN:
	case eUIEVENT_LBUTTON_UP:
		mpParent->HandleEvent( event );
		OnLButtonDown( event.mPos, false, false, false );
		break;
	default:
		return cUINode::HandleEvent( event );
	}
	return true;
}

/// ǻ: ؽƮ ǥ Ʈ
void cTextBox::UpdateText()
{
	/// Ʈ ڽ ǥ ޾ƿ
	cUIRect rc = GetAbsoluteRect();

	mTextPosX = rc.mLeft + 2;
	mTextPosY = rc.mTop + 1;

	/// ؽƮڽ ؽƮ Ѹ ġ  
	if( mpScrollBar && mScrollbarPosType == eLEFT_SCROLLBAR )
	{
		/// ũѹٸ ؽƮڽ  ʿ ηѴٸ 
		/// ũѹ ̸ŭ  ġ Ѵ 
		unsigned int width = mpScrollBar->GetAbsoluteRect().GetWidth();
		mTextPosX = rc.mLeft + width + 2;
	}		

	///   ִ ټ ʰϸ ؽƮâ ó ġ ϳ Ѹ.
	mNextPosY = mTextPosY;

	/// ؽƮ  ġ 
	if( mDrawTextBottom && mLine - mDelCount <= mMaxRowInPage )
	{
		mNextPosY = mTextPosY + rc.GetHeight() - ( (mLine - mDelCount) * mRowHeight );
	}
}

/// ǻ : 
void cTextBox::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
		{
			((cUINode*)(*i))->OnRender(pKeeper);
		}
	}

	if( GetRowCount() > 0 )
	{
		unsigned int rowCount = ( mMaxRowInPage > GetRowCount() )? GetRowCount() : mMaxRowInPage;
		for( unsigned int row = mTopRowIdx; row < mTopRowIdx + rowCount; ++row )
		{
			sRowTextData* rowData = GetRowData( row );
			if( !rowData )
				continue;

			int addX = 0;
			unsigned int colCount = rowData->mColumes.GetSize();

			///  ,  ÷  ٿ鼭 Ѵ. 
			for( unsigned int col = 0; col < colCount; ++col )
			{
				sTextData* colData = rowData->mColumes[col];
				if( colData )
				{
					int addY = ( colData->mLine - mDelCount - mTopRowIdx ) * mRowHeight;
					pKeeper->AddFontItem( cFontAgent::eFont_Chat, (LPTSTR)(colData->mText).Cstr(), mTextPosX + addX, mNextPosY + addY, (unsigned long)(colData->mColor) );

					addX += FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, (LPTSTR)(colData->mText).Cstr(), colData->mText.GetSize() );
				}
			}
		}
	}

	pKeeper->DrawAll();
}

/// 콺 
void cTextBox::OnMouseMove( const cUIPos& /*pos*/ )
{
}

/// ׽Ʈ -  ΰ ģ ؽƮ ã´.
void cTextBox::OnLButtonDown( const cUIPos& pos, bool /*ctrl*/, bool /*alt*/, bool )
{
	///   
	if( GetRowCount() <= 0 )
		return;
	
	/// ؽƮڽȿ 콺 ǥ 
	unsigned int mouseX = pos.mX - mTextPosX;
	unsigned int mouseY = pos.mY - mTextPosY;

	///  ϱ
	int row = 0;
	unsigned int lineNum = mouseY / mRowHeight;
	if( GetRowCount() >= mMaxRowInPage )
	{
		/// 
		row = mTopRowIdx + lineNum;
	}
	else
	{
		///    
		row = lineNum - ( mMaxRowInPage - GetRowCount() );
	}

	if( row < 0 )
		return;

	/// شο x ġ ؼ ؽƮ  ã
	sRowTextData* rowData = GetRowData( row );
	if( !rowData )
		return;

	///  ,  ÷ ˻
	unsigned int addX = 0;
	unsigned int colWidth = 0;
	unsigned int colCount = rowData->mColumes.GetSize();
	
	bool search = false;
	for( unsigned int col = 0; col < colCount; ++col )
	{
		sTextData* colData = rowData->mColumes[col];
		if( !colData )
		{
			assert(0);
			continue;
		}

		colWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, (LPTSTR)(colData->mText).Cstr(), colData->mText.GetSize() );

		/// ʺȿ ϴ  ã
		if( mouseX >= addX && mouseX < addX + colWidth )
		{
			///  ε ã 
			if( colData->mItemIndex > 0 )
			{
				UIMAN->ShowChatItemTip( pos, colData->mItemIndex, colData->mSlotIndex );
				search = true;
				break;
			}
			else if( colData->mUseInven )
			{
				sInvenData* inven = (sInvenData*)colData;
				if( inven )
				{
					UIMAN->ShowChatItemTip( pos, inven->mInventory );
					search = true;
					break;
				}
				else
				{
					assert(0);
				}
			}
		}

		///  ʺ ϱ
		addX += colWidth;
	}

	if( search == false )
		UIMAN->HideTip();
}

///
void cTextBox::OnMouseWheel( const cUIPos&, int wheel )
{
	if( !mpScrollBar || mpScrollBar->IsVisible() == false )
		return;
	
	assert( mLine >= mMaxRowInPage);

	/// ũѹ    
	if( wheel > 0 )
	{
		if( mTopRowIdx > 0 )
		{
			mTopRowIdx--;
		}
	}
	/// Ʒ   
	else if ( wheel < 0 )
	{
		///   Բ ũ
		if( mLine - mDelCount - mTopRowIdx > mMaxRowInPage )
		{
			mTopRowIdx++;
		}		
	}
	else
	{
		assert( 0 && "error mouse wheel message" );
		return;
	}

	/// ũѹ Ʈ 
	UpdateScrollBarPos();
}

/// ǻ : ũѹٰ ̸, ؽƮ ڽ    
void cTextBox::OnScrollbarMoved( const cUIPos& )
{
	if( mpScrollBar )
	{
		assert( mLine > mMaxRowInPage );

		///  ư ġ .
		unsigned int barbuttonPos = mpScrollBar->GetBarButtonPosY();
		double h = mpScrollBar->GetScrollMarginHeight() / (double)( mLine - mDelCount - mMaxRowInPage );

		///   ư ġ شϴ  ε ϱ
		double x = ((double)barbuttonPos / h);

		mTopRowIdx = (int)x;
	}	
}

/// ũѹ ġ, ̸ Ѵ
void cTextBox::SetScrollbar( unsigned int addh )
{
	///   
	mFixScrollH = addh;

	if( mpScrollBar )
	{
		mpScrollBar->SetPosY( mFixScrollH );

		/// ũѹ   
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() - mFixScrollH );

		////  ư   
		UpdateScrollBarButton();

		/// ũ "" y ġ  
		UpdateScrollBarPos();
	}	
}

/// ǻ :    ߰ (  Է ȿ )
void cTextBox::AddEmptyRow( unsigned int line )
{
	cTextCtrl::AddEmptyRow( line );

	if( mLine - mDelCount  > mMaxRowInPage )
	{
		/// ũѹ ư  Ʈ 
		UpdateScrollBarButton();

		///    ϰ,
		if( mScrollBottom )
		{
			/// Ǹġ 
			mTopRowIdx = mLine - mDelCount - mMaxRowInPage;
		}

		/// ũ "" y ġ 
		UpdateScrollBarPos();
	}

	UpdateText();
}

///   ãƼ ؽƮ 
void cTextBox::UpdateRowText( int line, LPCTSTR text )
{
	if( GetRowCount() <= 0 )
		return;

	unsigned int rowCount = GetRowCount();
	for( unsigned int row = 0; row < rowCount; ++row )
	{
		sRowTextData* rowData = GetRowData( row );
		if( !rowData )
			continue;

		unsigned int colCount = rowData->mColumes.GetSize();
		for( unsigned int col = 0; col < colCount; ++col )
		{
			sTextData* colData = rowData->mColumes[col];
			if( colData && line == colData->mLine )
			{
				colData->mText = text;
				break;
			}
		}
	}
}

/// ǻ : ο  ؽƮ Է
int cTextBox::AddNewRow( LPCTSTR text, unsigned long textcolor )
{
	///  
	cTextCtrl::AddNewRow( text, textcolor );

	///
	if( mLine - mDelCount > mMaxRowInPage )
	{
		/// ũѹ ư  Ʈ 
		UpdateScrollBarButton();

		///    ϰ,
		if( mScrollBottom )
		{
			/// Ǹġ 
			mTopRowIdx = mLine - mDelCount - mMaxRowInPage;
		}

		/// ũ "" y ġ 
		UpdateScrollBarPos();
	}

	UpdateText();

	return ( mLine > 1 ) ? mLine - 1 : 0;
}

void cTextBox::AddPasteRow( LPCTSTR text, unsigned long textcolor, bool autoNewline )
{
	cTextCtrl::AddPasteRow( autoNewline, text, textcolor );

	if( mLine - mDelCount > mMaxRowInPage )
	{
		/// ũѹ ư  Ʈ 
		UpdateScrollBarButton();

		///    ϰ,
		if( mScrollBottom )
		{
			/// Ǹġ 
			mTopRowIdx = mLine - mDelCount - mMaxRowInPage;
		}

		/// ũ "" y ġ 
		UpdateScrollBarPos();
	}

	UpdateText();
}

///    
void cTextBox::AddItemRow( bool newrow, unsigned long itemIndex, unsigned int slotIndex, LPCTSTR name, unsigned long nameColor )
{
	///   
	if( newrow == true )
	{
		cTextCtrl::AddNewRow( name, nameColor, itemIndex, slotIndex );
	}
	///  
	else
	{
		cTextCtrl::AddPasteRow( false, name, nameColor, itemIndex, slotIndex );
	}

	/// 
	if( mLine - mDelCount > mMaxRowInPage )
	{
		/// ũѹ ư  Ʈ 
		UpdateScrollBarButton();

		///    ϰ,
		if( mScrollBottom )
		{
			/// Ǹġ 
			mTopRowIdx = mLine - mDelCount - mMaxRowInPage;
		}

		/// ũ "" y ġ 
		UpdateScrollBarPos();
	}

	UpdateText();
}

void cTextBox::AddItemRow( sInventory inventory, LPCTSTR name, unsigned long nameColor )
{
	cTextCtrl::AddPasteRowInven( name, nameColor, inventory );

	/// 
	if( mLine - mDelCount > mMaxRowInPage )
	{
		/// ũѹ ư  Ʈ 
		UpdateScrollBarButton();

		///    ϰ,
		if( mScrollBottom )
		{
			/// Ǹġ 
			mTopRowIdx = mLine - mDelCount - mMaxRowInPage;
		}

		/// ũ "" y ġ 
		UpdateScrollBarPos();
	}

	UpdateText();
}

///
bool cTextBox::AddFucnText( const cUIFuncTextNode* node, cUIFuncTextParam* param )
{
	assert( node );
	mTextColor = mDefaultColor;

	for( ; node; node = node->GetNext() )
	{
		switch( node->mType )
		{
		case eTEXTNODE_STRING:
			{
				AddPasteRow( node->mpString, mTextColor, true );
			}
			break;
		case eTEXTNODE_COLOR:
			{
				mTextColor = node->mColor;
			}
			break;
		case eTEXTNODE_VARNAME: 
			{
				if( param )
				{
					AddPasteRow( param->mName.Cstr(), mTextColor, true );
				}
				else
				{
					assert(0);
				}
			}
			break;
		case eTEXTNODE_NEWLINE:
			{
				AddEmptyRow( 1 );
			}
			break;
		default:
			{
				assert( 0 && "invalid npc text node type" );
			}
			return false;
		}
	}
	return true;
}

/// ǻ : ؽƮڽ  ȭ     
void cTextBox::UpdateTextBox( bool add )
{
	/// Ʈ  ִ  ִ  
	mMaxRowInPage = GetAbsoluteRect().GetHeight() / mRowHeight;

	/// ؽƮڽ Ȯ
	if( add == true )
	{
		///   ϱ 
		if( mMaxRowInPage <= mLine - mDelCount )
		{
			/// tapIdx  Ѱ Ѿ ʵ Ѵ 
			if( mTopRowIdx > 0 )
			{
				mTopRowIdx--;
			}
		}
	}
	/// ؽƮڽ 
	else 
	{
		///   ϱ 
		if( mMaxRowInPage < mLine - mDelCount )
		{
			/// tapIdx  Ѱ Ѿ ʵ Ѵ 
			if( mLine - mDelCount - mTopRowIdx > mMaxRowInPage )
			{
				mTopRowIdx++;
			}	
		}
	}

	if( mpScrollBar )
	{
		/// ũѹ   
		mpScrollBar->SetHeight( GetAbsoluteRect().GetHeight() - mFixScrollH );

		///  ư   
		UpdateScrollBarButton();

		/// ũ "" y ġ 
		UpdateScrollBarPos();
	}

	UpdateText();
}

/// ǻ : ư  üũ 
void cTextBox::CheckButtonEvent( unsigned int id )
{
	if( !mpScrollBar )
	{
		///  ´ٸ ߸ κδ.
		assert(0);
		return;
	}
	/// ũѹٰ ׷ ʴ ¸ 
	if( mpScrollBar->IsVisible() == false )
	{
		///  ´ٸ ߸ κδ.
		assert(0);
		return;
	}
	
	assert( mLine >= mMaxRowInPage );

	switch( id )
	{
	case eSCROOLBAR_UP:
		if( mTopRowIdx > 0 )
		{
			mTopRowIdx--;
		}
		break;

	case eSCROOLBAR_DOWN:
		///  mLine Բ ũ
		if( mLine - mDelCount - mTopRowIdx > mMaxRowInPage )
		{
			mTopRowIdx++;
		}		
		break;
	}

	/// ũ "" y ġ 
	UpdateScrollBarPos();
}

/// ũѹ ġ Ʈ 
void cTextBox::UpdateScrollBarPos()
{
	if( !mpScrollBar )
		return;

	/// ũѹٰ ׷ ʴ ¸ 
	if( mpScrollBar->IsVisible() == false )
		return;

	///  ۴ ũѹٰ ̴ Ÿ ϱ 
	double h = mpScrollBar->GetScrollMarginHeight() / (double)( mLine - mDelCount - mMaxRowInPage );

	///  žε * Ѱ = ο ũѹ ġ 
	double newposY = h * mTopRowIdx;
	double oldY = mpScrollBar->GetBarButtonPosY();

	///  ġ ؼ ũѹ ġ Ѵ. 
	int value = (int)(newposY-oldY);

	if( newposY > oldY )
	{
		mpScrollBar->MoveScrollDown( value );
	}
	else
	{
		mpScrollBar->MoveScrollUp( -value );
	}
}

/// ǻ : ũѹ  
void cTextBox::UpdateScrollBarButton()
{
	if( !mpScrollBar )
		return;

	/// ؽƮڽ ʹ ũѹ ư ׸ ʴ´.
	if( mpScrollBar->GetScrollBarHeight() < mpScrollBar->GetMinimumHeight() )
	{
		/// ũѹ  ư ׸ ʴ´.
		mpScrollBar->Show();
		mpScrollBar->SetVisibleBarButton( false );
		return;
	}

	/// ѿ   ִ   ۼ ,
	if( mLine - mDelCount > mMaxRowInPage )
	{
		/// ũѹ ü ׸
		mpScrollBar->Show();
		mpScrollBar->SetVisibleBarButton( true );
	}
	else
	{
		/// ũѹ  ư ׸ ʴ´.
		mpScrollBar->Hide();
	}
}


//////////////////////////////////////////////////////////////////////////////
cTextBoxSkin::cTextBoxSkin( eUINodeType type )
: cUINodeSkin( type )
, mRowHeight( 0 )
, mTotalMaxNum( 0 )
, mScrollBarRightPos(true)
{
}

cTextBoxSkin::~cTextBoxSkin()
{

}

/// ǻ : ũƮ  о鿩  Ѵ
bool cTextBoxSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	/// ״ū  ˻
	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_ROWHEIGHT:
			{
				mRowHeight = parser.ParseInt();
			}
			break;
		case eTOKEN_SCROLLBAR_RIGHTPOS:
			{
				lexer->GetNextToken( &token );

				if( token.mType == eTOKEN_TRUE )
				{
					mScrollBarRightPos = true;
				}
				else if( token.mType == eTOKEN_FALSE )
				{
					mScrollBarRightPos = false;
				}
				else
				{
					assert( 0 && "invalid token" );
					return false;
				}
			}
			break;
		case eTOKEN_SCROLLSKIN:
			{
				mScrollSkin = parser.ParseString();
			}
			break;
		case eTOKEN_MAXITEMNUM:
			{
				mTotalMaxNum = parser.ParseInt();
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}
